/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.jl5.ast;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import polyglot.ast.Block;
import polyglot.ast.CanonicalTypeNode;
import polyglot.ast.ClassBody;
import polyglot.ast.ClassDecl;
import polyglot.ast.ClassDecl_c;
import polyglot.ast.ClassMember;
import polyglot.ast.ConstructorDecl;
import polyglot.ast.Expr;
import polyglot.ast.FlagsNode;
import polyglot.ast.Formal;
import polyglot.ast.Id;
import polyglot.ast.MethodDecl;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.Stmt;
import polyglot.ast.TypeNode;
import polyglot.ext.jl5.ast.AnnotationElem;
import polyglot.ext.jl5.ast.JL5ClassBody;
import polyglot.ext.jl5.ast.JL5ClassDecl;
import polyglot.ext.jl5.ast.JL5Formal;
import polyglot.ext.jl5.ast.JL5MethodDecl;
import polyglot.ext.jl5.ast.JL5NodeFactory;
import polyglot.ext.jl5.ast.ParamTypeNode;
import polyglot.ext.jl5.types.AnnotationElemInstance;
import polyglot.ext.jl5.types.FlagAnnotations;
import polyglot.ext.jl5.types.JL5ClassDef;
import polyglot.ext.jl5.types.JL5Context;
import polyglot.ext.jl5.types.JL5Flags;
import polyglot.ext.jl5.types.JL5ParsedClassType;
import polyglot.ext.jl5.types.JL5TypeSystem;
import polyglot.ext.jl5.types.ParameterizedType;
import polyglot.ext.jl5.visit.ApplicationCheck;
import polyglot.ext.jl5.visit.ApplicationChecker;
import polyglot.types.ClassDef;
import polyglot.types.ClassType;
import polyglot.types.Context;
import polyglot.types.Flags;
import polyglot.types.LocalDef;
import polyglot.types.MethodDef;
import polyglot.types.Name;
import polyglot.types.Ref;
import polyglot.types.SemanticException;
import polyglot.types.StructType;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.types.Types;
import polyglot.util.CodeWriter;
import polyglot.util.CollectionUtil;
import polyglot.util.Position;
import polyglot.util.TypedList;
import polyglot.visit.ContextVisitor;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.TypeBuilder;
import polyglot.visit.TypeChecker;

public class JL5ClassDecl_c
extends ClassDecl_c
implements JL5ClassDecl,
ApplicationCheck {
    protected List<AnnotationElem> annotations;
    protected List runtimeAnnotations;
    protected List classAnnotations;
    protected List sourceAnnotations;
    protected List<ParamTypeNode> paramTypes = Collections.EMPTY_LIST;

    public JL5ClassDecl_c(Position pos, FlagAnnotations flags, Id name, TypeNode superClass, List interfaces, ClassBody body) {
        super(pos, flags.classicFlags(), name, superClass, interfaces, body);
        this.annotations = flags.annotations() != null ? flags.annotations() : Collections.EMPTY_LIST;
    }

    public JL5ClassDecl_c(Position pos, FlagAnnotations fl, Id name, TypeNode superType, List interfaces, ClassBody body, List<ParamTypeNode> paramTypes) {
        this(pos, fl, name, superType, interfaces, body);
        assert (paramTypes != null);
        this.paramTypes = paramTypes;
    }

    @Override
    public List<AnnotationElem> annotations() {
        return this.annotations;
    }

    @Override
    public JL5ClassDecl annotations(List<AnnotationElem> annotations) {
        if (annotations != null) {
            JL5ClassDecl_c n = (JL5ClassDecl_c)this.copy();
            n.annotations = annotations;
            return n;
        }
        return this;
    }

    @Override
    public List<ParamTypeNode> paramTypes() {
        return this.paramTypes;
    }

    public JL5ClassDecl paramTypes(List<ParamTypeNode> types) {
        JL5ClassDecl_c n = (JL5ClassDecl_c)this.copy();
        n.paramTypes = types;
        return n;
    }

    protected ClassDecl reconstruct(FlagsNode flags, Id name, TypeNode superClass, List<TypeNode> interfaces, ClassBody body, List annotations, List paramTypes) {
        ClassDecl_c superCopy = super.reconstruct(flags, name, superClass, interfaces, body);
        if (!CollectionUtil.allEqual((Collection)annotations, this.annotations) || !CollectionUtil.allEqual((Collection)paramTypes, this.paramTypes)) {
            JL5ClassDecl_c n = (JL5ClassDecl_c)superCopy.copy();
            n.annotations = TypedList.copyAndCheck((List)annotations, AnnotationElem.class, (boolean)false);
            n.paramTypes = TypedList.copyAndCheck((List)paramTypes, ParamTypeNode.class, (boolean)false);
            return n;
        }
        return superCopy;
    }

    public Node typeCheckSupers(ContextVisitor tc, TypeChecker childtc) throws SemanticException {
        JL5ClassDecl_c n = (JL5ClassDecl_c)super.typeCheckSupers(tc, childtc);
        List paramTypes = this.visitList(n.paramTypes, (NodeVisitor)childtc);
        return n.reconstruct(n.flags, n.name, n.superClass, n.interfaces, n.body, n.annotations, paramTypes);
    }

    public Node visitChildren(NodeVisitor v) {
        List annots = this.visitList(this.annotations, v);
        List paramTypes = this.visitList(this.paramTypes, v);
        JL5ClassDecl_c cd = (JL5ClassDecl_c)super.visitChildren(v);
        return cd.reconstruct(cd.flags(), cd.name(), cd.superClass(), cd.interfaces(), cd.body(), annots, paramTypes);
    }

    public Context enterChildScope(Node child, Context c) {
        for (ParamTypeNode tn : this.paramTypes) {
            c = ((JL5Context)c).addTypeVariable(Name.make((String)tn.id()), (Ref<? extends Type>)tn.typeRef());
        }
        return super.enterChildScope(child, c);
    }

    public Node conformanceCheck(ContextVisitor tc) throws SemanticException {
        Context ctx = tc.context();
        JL5TypeSystem ts = (JL5TypeSystem)tc.typeSystem();
        JL5ParsedClassType type = (JL5ParsedClassType)this.type.asType();
        ClassType superType = (ClassType)type.superClass();
        Flags flags = this.flags().flags();
        if (JL5Flags.isAnnotationModifier(flags) && flags.isPrivate()) {
            throw new SemanticException("Annotation types cannot have explicit private modifier", this.position());
        }
        if (ts.typeEquals(ts.Object(), (Type)type, ctx) && !this.paramTypes.isEmpty()) {
            throw new SemanticException("Type: " + type + " cannot declare type variables.", this.position());
        }
        if (!this.paramTypes.isEmpty()) {
            if (superType != null && ts.isSubtype((Type)superType, ts.Throwable(), ctx)) {
                throw new SemanticException("Cannot subclass java.lang.Throwable or any of its subtypes with a generic class", this.superClass().position());
            }
            for (int i = 0; i < this.paramTypes.size(); ++i) {
                TypeNode ti = this.paramTypes.get(i);
                for (int j = i + 1; j < this.paramTypes.size(); ++j) {
                    TypeNode tj = this.paramTypes.get(j);
                    if (!ts.typeEquals(ti.type(), tj.type(), ctx)) continue;
                    throw new SemanticException("Duplicate type variable declaration.", tj.position());
                }
            }
        }
        if (type.isGeneric()) {
            ts.checkTVForwardReference(type.typeVariables());
        }
        ts.checkDuplicateAnnotations(this.annotations);
        type.annotations(this.annotations);
        if (this.superClass() != null && !ts.typeEquals((Type)superType, ts.capture((Type)superType), ctx)) {
            throw new SemanticException("Wildcards not allowed here.", this.superClass().position());
        }
        for (TypeNode itNode : this.interfaces()) {
            Type ittype = itNode.type();
            if (ts.typeEquals(ittype, ts.capture(ittype), ctx)) continue;
            throw new SemanticException("Wildcards not allowed here.", itNode.position());
        }
        this.checkSuperTypeTypeArgs(tc);
        return super.conformanceCheck(tc);
    }

    private void checkSuperTypeTypeArgs(ContextVisitor tc) throws SemanticException {
        TypeSystem ts = tc.typeSystem();
        Context ctx = tc.context();
        ClassType type = this.type.asType();
        ClassType superType = (ClassType)type.superClass();
        ArrayList allInterfaces = new ArrayList();
        allInterfaces.addAll(type.interfaces());
        if (superType != null) {
            allInterfaces.addAll(superType.interfaces());
        }
        for (int i = 0; i < allInterfaces.size(); ++i) {
            Type next = (Type)allInterfaces.get(i);
            for (int j = i + 1; j < allInterfaces.size(); ++j) {
                Type other = (Type)allInterfaces.get(j);
                if (next instanceof ParameterizedType && other instanceof ParameterizedType) {
                    if (!ts.typeEquals((Type)((ParameterizedType)next).baseType(), (Type)((ParameterizedType)other).baseType(), ctx) || ts.typeEquals(next, other, ctx)) continue;
                    throw new SemanticException(((ParameterizedType)next).baseType() + " cannot be inherited with different type arguments.", this.position());
                }
                if (next instanceof ParameterizedType) {
                    if (!ts.typeEquals((Type)((ParameterizedType)next).baseType(), other, ctx)) continue;
                    throw new SemanticException(((ParameterizedType)next).baseType() + " cannot be inherited with different type arguments.", this.position());
                }
                if (!(other instanceof ParameterizedType) || !ts.typeEquals((Type)((ParameterizedType)other).baseType(), next, ctx)) continue;
                throw new SemanticException(((ParameterizedType)other).baseType() + " cannot be inherited with different type arguments.", this.position());
            }
        }
    }

    @Override
    public Node applicationCheck(ApplicationChecker appCheck, Context ctx) throws SemanticException {
        JL5TypeSystem ts = (JL5TypeSystem)appCheck.typeSystem();
        for (AnnotationElem ae : this.annotations) {
            ts.checkAnnotationApplicability(ae, (Node)this);
        }
        if (JL5Flags.isAnnotationModifier(this.flags().flags())) {
            JL5ParsedClassType ct = (JL5ParsedClassType)this.type;
            for (AnnotationElemInstance ai : ct.annotationElems()) {
                if (!ts.isTypeExtendsAnnotation(ai.type())) continue;
                JL5ParsedClassType other = (JL5ParsedClassType)ai.type();
                for (AnnotationElemInstance aj : other.annotationElems()) {
                    if (!ts.typeEquals(aj.type(), (Type)ct, ctx)) continue;
                    throw new SemanticException("cyclic annotation element type", aj.position());
                }
            }
        }
        return this;
    }

    public ClassDecl_c preBuildTypes(TypeBuilder tb) throws SemanticException {
        JL5ClassDecl_c cd = (JL5ClassDecl_c)super.preBuildTypes(tb);
        List paramTypes = cd.visitList(cd.paramTypes, (NodeVisitor)tb);
        List annotations = cd.visitList(cd.annotations, (NodeVisitor)tb);
        cd = (JL5ClassDecl_c)cd.reconstruct(cd.flags, cd.name, cd.superClass, cd.interfaces, cd.body, annotations, paramTypes);
        cd.addTypeParameters(tb);
        return cd;
    }

    public ClassDecl_c postBuildTypes(TypeBuilder tb) throws SemanticException {
        JL5ClassDecl_c cd = (JL5ClassDecl_c)super.postBuildTypes(tb);
        if (JL5Flags.isAnnotationModifier(this.flags().flags())) {
            this.type.superType(Types.ref((Object)((JL5TypeSystem)tb.typeSystem()).Annotation()));
        }
        if (JL5Flags.isEnumModifier(this.type.flags())) {
            cd = (JL5ClassDecl_c)cd.addGenEnumMethods(tb);
        }
        return cd;
    }

    protected void addTypeParameters(TypeBuilder tb) {
        if (!this.paramTypes.isEmpty()) {
            for (ParamTypeNode ptn : this.paramTypes) {
                assert (ptn.typeRef() != null);
                ((JL5ClassDef)this.type).addTypeVariable((Ref<? extends Type>)ptn.typeRef());
            }
        }
    }

    protected Node addGenEnumMethods(TypeBuilder tb) {
        JL5ClassBody newBody = (JL5ClassBody)this.body();
        JL5MethodDecl valuesMeth = this.addEnumMethodValues(tb);
        JL5MethodDecl valueOfMeth = this.addEnumMethodValueOf(tb);
        newBody = (JL5ClassBody)newBody.addMember((ClassMember)valuesMeth);
        newBody = (JL5ClassBody)newBody.addMember((ClassMember)valueOfMeth);
        this.type.addMethod(valuesMeth.methodDef());
        this.type.addMethod(valueOfMeth.methodDef());
        return this.body(newBody);
    }

    protected JL5MethodDecl addEnumMethodValues(TypeBuilder tb) {
        JL5TypeSystem ts = (JL5TypeSystem)tb.typeSystem();
        NodeFactory nf = tb.nodeFactory();
        Position pos = this.position();
        assert (false);
        Block valuesBlock = nf.Block(pos);
        valuesBlock = valuesBlock.append((Stmt)nf.Return(pos, (Expr)nf.NullLit(pos)));
        FlagAnnotations vmFlags = new FlagAnnotations();
        FlagsNode vmFlagsNode = nf.FlagsNode(pos, Flags.PUBLIC.Static().Final());
        vmFlags.classicFlags(vmFlagsNode);
        CanonicalTypeNode returnType = nf.CanonicalTypeNode(pos, ts.arrayOf((Type)this.type.asType()));
        Id name = nf.Id(pos, "values");
        MethodDecl valuesMeth = ((JL5NodeFactory)nf).MethodDecl(pos, vmFlags, (TypeNode)returnType, name, Collections.EMPTY_LIST, Collections.EMPTY_LIST, valuesBlock, null);
        MethodDef md = ts.methodDef(pos, (Ref<? extends StructType>)Types.ref((Object)this.classDef().asType()), vmFlagsNode.flags(), (Ref<? extends Type>)Types.ref((Object)returnType.type()), Name.make((String)"values"), Collections.EMPTY_LIST, Collections.EMPTY_LIST, Collections.EMPTY_LIST, true);
        return (JL5MethodDecl)valuesMeth.methodDef(md);
    }

    protected JL5MethodDecl addEnumMethodValueOf(TypeBuilder tb) {
        JL5TypeSystem ts = (JL5TypeSystem)tb.typeSystem();
        JL5NodeFactory nf = (JL5NodeFactory)tb.nodeFactory();
        Position pos = this.position();
        FlagsNode flags = nf.FlagsNode(pos, Flags.NONE);
        FlagAnnotations fl = new FlagAnnotations(flags);
        LocalDef ld = ts.localDef(pos, flags.flags(), Types.ref((Object)ts.String()), Name.make((String)"arg1"));
        Formal formal = nf.Formal(pos, fl, (TypeNode)nf.CanonicalTypeNode(pos, ts.String()), nf.Id(pos, "arg1"));
        formal = (JL5Formal)formal.localDef(ld);
        List<Formal> formals = Collections.singletonList(formal);
        assert (false);
        Block valueOfBody = nf.Block(pos);
        valueOfBody = valueOfBody.append((Stmt)nf.Return(pos, (Expr)nf.NullLit(pos)));
        FlagAnnotations voFlags = new FlagAnnotations();
        voFlags.classicFlags(nf.FlagsNode(pos, Flags.PUBLIC.Static()));
        CanonicalTypeNode returnType = nf.CanonicalTypeNode(pos, (Type)this.type.asType());
        MethodDecl valueOfMeth = nf.MethodDecl(pos, voFlags, (TypeNode)returnType, nf.Id(pos, "valueOf"), formals, Collections.EMPTY_LIST, valueOfBody, null);
        Flags mthFlags = JL5Flags.PUBLIC.set(JL5Flags.STATIC);
        List<Ref<? extends Type>> formalTypes = Collections.singletonList(Types.ref((Object)ts.String()));
        MethodDef md = ts.methodDef(pos, (Ref<? extends StructType>)Types.ref((Object)this.classDef().asType()), mthFlags, (Ref<? extends Type>)Types.ref((Object)returnType.type()), Name.make((String)"valueOf"), formalTypes, Collections.EMPTY_LIST, Collections.EMPTY_LIST, true);
        return (JL5MethodDecl)valueOfMeth.methodDef(md);
    }

    protected ConstructorDecl createDefaultConstructor(ClassDef thisType, TypeSystem ts, NodeFactory nf) throws SemanticException {
        Ref superType = thisType.superType();
        assert (superType != null && !JL5Flags.isEnumModifier(this.flags().flags()));
        ConstructorDecl decl = super.createDefaultConstructor(thisType, ts, nf);
        if (JL5Flags.isEnumModifier(this.flags().flags())) {
            FlagsNode newFlags = nf.FlagsNode(this.position(), Flags.PRIVATE);
            decl = decl.flags(newFlags);
        }
        return decl;
    }

    public void prettyPrintModifiers(CodeWriter w, PrettyPrinter tr) {
        for (AnnotationElem ae : this.annotations()) {
            this.print((Node)ae, w, tr);
        }
        if (this.flags.flags().isInterface()) {
            if (JL5Flags.isAnnotationModifier(this.flags.flags())) {
                w.write(JL5Flags.clearAnnotationModifier(this.flags.flags()).clearInterface().clearAbstract().translate());
                w.write("@");
            } else {
                w.write(this.flags.flags().clearInterface().clearAbstract().translate());
            }
        } else {
            w.write(this.flags.flags().translate());
        }
        if (this.flags.flags().isInterface()) {
            w.write("interface ");
        } else if (!JL5Flags.isEnumModifier(this.flags.flags())) {
            w.write("class ");
        }
    }

    public void prettyPrintHeaderRest(CodeWriter w, PrettyPrinter tr) {
        if (this.superClass() != null && !JL5Flags.isEnumModifier(this.type.flags())) {
            w.write(" extends ");
            this.print((Node)this.superClass(), w, tr);
        }
        if (!this.interfaces.isEmpty() && !JL5Flags.isAnnotationModifier(this.type.flags())) {
            if (this.flags.flags().isInterface()) {
                w.write(" extends ");
            } else {
                w.write(" implements ");
            }
            Iterator i = this.interfaces().iterator();
            while (i.hasNext()) {
                TypeNode tn = (TypeNode)i.next();
                this.print((Node)tn, w, tr);
                if (!i.hasNext()) continue;
                w.write(", ");
            }
        }
        w.write(" {");
    }

    public void prettyPrintHeader(CodeWriter w, PrettyPrinter tr) {
        this.prettyPrintModifiers(w, tr);
        tr.print((Node)this, (Node)this.name, w);
        if (this.paramTypes != null && !this.paramTypes.isEmpty()) {
            w.write("<");
            Iterator<ParamTypeNode> it = this.paramTypes.iterator();
            while (it.hasNext()) {
                ParamTypeNode next = it.next();
                this.print((Node)next, w, tr);
                if (!it.hasNext()) continue;
                w.write(", ");
            }
            w.write("> ");
        }
        this.prettyPrintHeaderRest(w, tr);
    }

    @Override
    public List runtimeAnnotations() {
        return this.runtimeAnnotations;
    }

    @Override
    public List classAnnotations() {
        return this.classAnnotations;
    }

    @Override
    public List sourceAnnotations() {
        return this.sourceAnnotations;
    }
}

