/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.jl5.ast;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import polyglot.ast.Block;
import polyglot.ast.ConstructorDecl;
import polyglot.ast.ConstructorDecl_c;
import polyglot.ast.Formal;
import polyglot.ast.Id;
import polyglot.ast.Node;
import polyglot.ast.TypeNode;
import polyglot.ext.jl5.ast.AnnotationElem;
import polyglot.ext.jl5.ast.JL5ConstructorDecl;
import polyglot.ext.jl5.ast.JL5Formal;
import polyglot.ext.jl5.ast.ParamTypeNode;
import polyglot.ext.jl5.types.FlagAnnotations;
import polyglot.ext.jl5.types.JL5ConstructorDef;
import polyglot.ext.jl5.types.JL5ConstructorInstance;
import polyglot.ext.jl5.types.JL5Context;
import polyglot.ext.jl5.types.JL5TypeSystem;
import polyglot.ext.jl5.types.ParameterizedType;
import polyglot.ext.jl5.types.TypeVariable;
import polyglot.ext.jl5.visit.ApplicationCheck;
import polyglot.ext.jl5.visit.ApplicationChecker;
import polyglot.types.ConstructorDef;
import polyglot.types.Context;
import polyglot.types.Name;
import polyglot.types.Ref;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.Types;
import polyglot.util.CodeWriter;
import polyglot.util.CollectionUtil;
import polyglot.util.Position;
import polyglot.util.TypedList;
import polyglot.visit.ContextVisitor;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.TypeBuilder;

public class JL5ConstructorDecl_c
extends ConstructorDecl_c
implements JL5ConstructorDecl,
ApplicationCheck {
    protected boolean compilerGenerated;
    protected List<AnnotationElem> annotations;
    protected List runtimeAnnotations;
    protected List classAnnotations;
    protected List sourceAnnotations;
    protected List<ParamTypeNode> paramTypes;

    public JL5ConstructorDecl_c(Position pos, FlagAnnotations flags, Id name, List<Formal> formals, List<TypeNode> throwTypes, Block body) {
        this(pos, flags, name, formals, throwTypes, body, new ArrayList<ParamTypeNode>());
    }

    public JL5ConstructorDecl_c(Position pos, FlagAnnotations flags, Id name, List<Formal> formals, List<TypeNode> throwTypes, Block body, List<ParamTypeNode> paramTypes) {
        super(pos, flags.classicFlags(), name, formals, throwTypes, body);
        this.annotations = flags.annotations() != null ? flags.annotations() : new TypedList(new LinkedList(), AnnotationElem.class, false);
        this.paramTypes = paramTypes;
    }

    @Override
    public List<ParamTypeNode> paramTypes() {
        return this.paramTypes;
    }

    @Override
    public JL5ConstructorDecl paramTypes(List<ParamTypeNode> paramTypes) {
        JL5ConstructorDecl_c n = (JL5ConstructorDecl_c)this.copy();
        n.paramTypes = paramTypes;
        return n;
    }

    protected JL5ConstructorDecl_c reconstruct(List<AnnotationElem> annotations, List<ParamTypeNode> paramTypes) {
        if (!CollectionUtil.allEqual(annotations, this.annotations) || !CollectionUtil.allEqual(paramTypes, this.paramTypes)) {
            JL5ConstructorDecl_c n = (JL5ConstructorDecl_c)this.copy();
            n.annotations = TypedList.copyAndCheck(annotations, AnnotationElem.class, (boolean)true);
            n.paramTypes = TypedList.copyAndCheck(paramTypes, ParamTypeNode.class, (boolean)true);
            return n;
        }
        return this;
    }

    public Node visitSignature(NodeVisitor v) {
        JL5ConstructorDecl_c n = (JL5ConstructorDecl_c)super.visitSignature(v);
        List annotations = n.visitList(this.annotations, v);
        List paramTypes = n.visitList(this.paramTypes, v);
        return n.reconstruct(annotations, paramTypes);
    }

    public Node buildTypesOverride(TypeBuilder tb) throws SemanticException {
        ConstructorDecl n = (ConstructorDecl)super.buildTypesOverride(tb);
        ConstructorDef def = n.constructorDef();
        ArrayList<Ref<? extends Type>> pTypes = new ArrayList<Ref<? extends Type>>(this.paramTypes().size());
        for (ParamTypeNode p : this.paramTypes()) {
            pTypes.add((Ref<? extends Type>)p.typeRef());
        }
        ((JL5ConstructorDef)def).setTypeVariableTypes(pTypes);
        return n;
    }

    public void prettyPrintHeader(CodeWriter w, PrettyPrinter tr) {
        w.begin(0);
        tr.print((Node)this, (Node)this.flags, w);
        if (this.paramTypes != null && !this.paramTypes.isEmpty()) {
            w.write("<");
            Iterator<ParamTypeNode> it = this.paramTypes.iterator();
            while (it.hasNext()) {
                ParamTypeNode next = it.next();
                this.print((Node)next, w, tr);
                if (!it.hasNext()) continue;
                w.write(", ");
            }
            w.write("> ");
        }
        tr.print((Node)this, (Node)this.name, w);
        w.write("(");
        w.begin(0);
        Iterator i = this.formals.iterator();
        while (i.hasNext()) {
            Formal f = (Formal)i.next();
            this.print((Node)f, w, tr);
            if (!i.hasNext()) continue;
            w.write(",");
            w.allowBreak(0, " ");
        }
        w.end();
        w.write(")");
        if (!this.throwTypes().isEmpty()) {
            w.allowBreak(6);
            w.write("throws ");
            i = this.throwTypes().iterator();
            while (i.hasNext()) {
                TypeNode tn = (TypeNode)i.next();
                this.print((Node)tn, w, tr);
                if (!i.hasNext()) continue;
                w.write(",");
                w.allowBreak(4, " ");
            }
        }
        w.end();
    }

    @Override
    public List<AnnotationElem> annotations() {
        return this.annotations;
    }

    public JL5ConstructorDecl annotations(List<AnnotationElem> annotations) {
        JL5ConstructorDecl_c n = (JL5ConstructorDecl_c)this.copy();
        n.annotations = annotations;
        return n;
    }

    public Context enterScope(Context c) {
        c = super.enterScope(c);
        for (ParamTypeNode pn : this.paramTypes) {
            c = ((JL5Context)c).addTypeVariable(Name.make((String)pn.id()), (Ref<? extends Type>)Types.ref((Object)((TypeVariable)pn.type())));
        }
        return c;
    }

    public Node typeCheck(ContextVisitor tc) throws SemanticException {
        JL5ConstructorInstance c;
        for (TypeNode tn : this.throwTypes()) {
            Type next = tn.type();
            if (!(next instanceof ParameterizedType)) continue;
            throw new SemanticException("Cannot use parameterized type " + next + " in a throws clause", tn.position());
        }
        for (int i = 0; i < this.formals.size(); ++i) {
            JL5Formal f = (JL5Formal)this.formals.get(i);
            if (i == this.formals.size() - 1 || !f.isVarargs()) continue;
            throw new SemanticException("Only last formal can be variable in constructor declaration.", f.position());
        }
        if (this.ci instanceof JL5ConstructorInstance && (c = (JL5ConstructorInstance)this.ci).isGeneric()) {
            ((JL5TypeSystem)tc.typeSystem()).checkTVForwardReference(c.typeVariables());
        }
        return super.typeCheck(tc);
    }

    @Override
    public Node applicationCheck(ApplicationChecker appCheck, Context ctx) throws SemanticException {
        JL5TypeSystem ts = (JL5TypeSystem)appCheck.typeSystem();
        for (AnnotationElem next : this.annotations) {
            ts.checkAnnotationApplicability(next, (Node)this);
        }
        return this;
    }

    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        if (this.isCompilerGenerated()) {
            return;
        }
        for (AnnotationElem a : this.annotations()) {
            this.print((Node)a, w, tr);
        }
        super.prettyPrint(w, tr);
    }

    @Override
    public List runtimeAnnotations() {
        return this.runtimeAnnotations;
    }

    @Override
    public List classAnnotations() {
        return this.classAnnotations;
    }

    @Override
    public List sourceAnnotations() {
        return this.sourceAnnotations;
    }

    @Override
    public boolean isCompilerGenerated() {
        return this.compilerGenerated;
    }

    @Override
    public JL5ConstructorDecl setCompilerGenerated(boolean val) {
        JL5ConstructorDecl_c n = (JL5ConstructorDecl_c)this.copy();
        n.compilerGenerated = val;
        return n;
    }
}

