/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.jl5.ast;

import java.util.List;
import java.util.StringTokenizer;
import polyglot.ast.Import;
import polyglot.ast.Import_c;
import polyglot.ast.Node;
import polyglot.ext.jl5.ast.JL5Import;
import polyglot.frontend.Globals;
import polyglot.types.ClassDef;
import polyglot.types.ClassType;
import polyglot.types.Context;
import polyglot.types.FieldInstance;
import polyglot.types.MemberInstance;
import polyglot.types.MethodInstance;
import polyglot.types.Name;
import polyglot.types.Named;
import polyglot.types.QName;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.CodeWriter;
import polyglot.util.Position;
import polyglot.visit.ContextVisitor;
import polyglot.visit.PrettyPrinter;

public class JL5Import_c
extends Import_c
implements JL5Import {
    public JL5Import_c(Position pos, Import.Kind kind, QName name) {
        super(pos, kind, name);
    }

    public boolean isStaticImport() {
        return this.kind == ALL_STATIC_MEMBERS || this.kind == STATIC_MEMBER;
    }

    public QName findPackage(TypeSystem ts, QName name) {
        while (name != null && !ts.packageExists(name)) {
            name = name.qualifier();
        }
        return name;
    }

    protected void checkStaticImport(ContextVisitor cv) throws SemanticException {
        TypeSystem ts = cv.typeSystem();
        Context ctx = cv.context();
        QName pkg = this.findPackage(ts, this.name);
        String pkgStr = pkg.toString();
        String impStr = this.name.toString();
        QName staticImport = QName.make((String)impStr.substring(pkgStr.length(), impStr.length()));
        StringTokenizer stoken = new StringTokenizer(staticImport.toString(), ".");
        String className = stoken.nextToken();
        QName currentName = QName.make((QName)pkg, (Name)Name.make((String)className));
        Named resolved = ts.systemResolver().find(currentName);
        assert (resolved instanceof ClassType);
        ClassType ct = (ClassType)resolved;
        if (!ts.classAccessibleFromPackage((ClassDef)ct.def(), ctx.package_())) {
            throw new SemanticException("Class " + ct + " is not accessible.");
        }
        QName currentStatic = currentName;
        ClassType container = (ClassType)resolved;
        while (stoken.hasMoreTokens()) {
            Name name = Name.make((String)stoken.nextToken());
            currentStatic = QName.make((QName)currentStatic, (Name)name);
            assert (resolved instanceof ClassType);
            if (this.kind() == JL5Import.STATIC_MEMBER) {
                FieldInstance fi = null;
                fi = container.fieldNamed(name);
                if (fi != null && ts.isAccessible((MemberInstance)fi, ctx) && fi.flags().isStatic()) {
                    return;
                }
                List meths = container.methodsNamed(name);
                for (MethodInstance mi : meths) {
                    if (!ts.isAccessible((MemberInstance)mi, ctx) || !mi.flags().isStatic()) continue;
                    return;
                }
            }
            try {
                if ((container = (ClassType)ts.findMemberType((Type)container, name, ctx)).flags().isStatic() || !ts.isAccessible((MemberInstance)container, ctx)) continue;
                throw new SemanticException("Class " + container + " is not accessible.");
            }
            catch (SemanticException e) {
                throw new SemanticException("The import " + name + " cannot be resolved");
            }
        }
        if (this.kind() == JL5Import.STATIC_MEMBER && currentStatic.equals((Object)currentName) && !ct.flags().isStatic()) {
            throw new SemanticException("Cannot static import a non-static class");
        }
    }

    public Node typeCheck(ContextVisitor tc) throws SemanticException {
        if (this.isStaticImport()) {
            this.checkStaticImport(tc);
            return this;
        }
        return super.typeCheck(tc);
    }

    public String toString() {
        if (this.isStaticImport()) {
            return "import static " + this.name + (this.kind == ALL_STATIC_MEMBERS ? ".*" : "");
        }
        return super.toString();
    }

    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        if (this.isStaticImport()) {
            if (!Globals.Options().fully_qualified_names) {
                w.write("import static ");
                w.write(this.name.toString());
                if (this.kind == ALL_STATIC_MEMBERS) {
                    w.write(".*");
                }
                w.write(";");
                w.newline(0);
            }
        } else {
            super.prettyPrint(w, tr);
        }
    }
}

