/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.jl5.ast;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import polyglot.ast.Expr;
import polyglot.ast.Id;
import polyglot.ast.LocalDecl;
import polyglot.ast.LocalDecl_c;
import polyglot.ast.Node;
import polyglot.ast.TypeNode;
import polyglot.ext.jl5.ast.AnnotationElem;
import polyglot.ext.jl5.ast.JL5LocalDecl;
import polyglot.ext.jl5.types.FlagAnnotations;
import polyglot.ext.jl5.types.JL5TypeSystem;
import polyglot.ext.jl5.types.TypeVariable;
import polyglot.ext.jl5.visit.ApplicationCheck;
import polyglot.ext.jl5.visit.ApplicationChecker;
import polyglot.types.Context;
import polyglot.types.Flags;
import polyglot.types.SemanticException;
import polyglot.util.CodeWriter;
import polyglot.util.CollectionUtil;
import polyglot.util.Position;
import polyglot.util.TypedList;
import polyglot.visit.ContextVisitor;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;

public class JL5LocalDecl_c
extends LocalDecl_c
implements JL5LocalDecl,
ApplicationCheck {
    protected List annotations;

    public JL5LocalDecl_c(Position pos, FlagAnnotations flags, TypeNode type, Id name, Expr init) {
        super(pos, flags.classicFlags(), type, name, init);
        this.annotations = flags.annotations() != null ? flags.annotations() : new TypedList(new LinkedList(), AnnotationElem.class, true);
    }

    @Override
    public List annotations() {
        return this.annotations;
    }

    @Override
    public JL5LocalDecl annotations(List annotations) {
        JL5LocalDecl_c n = (JL5LocalDecl_c)this.copy();
        n.annotations = annotations;
        return n;
    }

    protected LocalDecl reconstruct(TypeNode type, Expr init, List annotations) {
        if (this.type() != type || this.init() != init || !CollectionUtil.allEqual((Collection)annotations, (Collection)this.annotations)) {
            JL5LocalDecl_c n = (JL5LocalDecl_c)this.copy();
            n.type = type;
            n.init = init;
            n.annotations = annotations;
            return n;
        }
        return this;
    }

    public Node visitChildren(NodeVisitor v) {
        TypeNode type = (TypeNode)this.visitChild((Node)this.type(), v);
        Expr init = (Expr)this.visitChild((Node)this.init(), v);
        List annots = this.visitList(this.annotations, v);
        return this.reconstruct(type, init, annots);
    }

    public Node typeCheck(ContextVisitor tc) throws SemanticException {
        if (!this.flags().flags().clearFinal().equals((Object)Flags.NONE)) {
            throw new SemanticException("Modifier: " + this.flags().flags().clearFinal() + " not allowed here.", this.position());
        }
        if (this.type().type() instanceof TypeVariable && tc.context().inStaticContext() && ((TypeVariable)this.type().type()).declaredIn().equals((Object)TypeVariable.TVarDecl.CLASSTV)) {
            throw new SemanticException("Cannot access non-static type: " + ((TypeVariable)this.type().type()).name() + " in a static context.", this.position());
        }
        JL5TypeSystem ts = (JL5TypeSystem)tc.typeSystem();
        ts.checkDuplicateAnnotations(this.annotations);
        return super.typeCheck(tc);
    }

    @Override
    public Node applicationCheck(ApplicationChecker appCheck, Context ctx) throws SemanticException {
        JL5TypeSystem ts = (JL5TypeSystem)appCheck.typeSystem();
        for (AnnotationElem next : this.annotations) {
            ts.checkAnnotationApplicability(next, (Node)this);
        }
        return this;
    }

    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        if (this.annotations != null) {
            Iterator it = this.annotations.iterator();
            while (it.hasNext()) {
                this.print((Node)((AnnotationElem)it.next()), w, tr);
            }
        }
        super.prettyPrint(w, tr);
    }
}

