/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.jl5.ast;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import polyglot.ast.Block;
import polyglot.ast.Formal;
import polyglot.ast.Id;
import polyglot.ast.MethodDecl_c;
import polyglot.ast.Node;
import polyglot.ast.TypeNode;
import polyglot.ext.jl5.ast.AnnotationElem;
import polyglot.ext.jl5.ast.JL5Formal;
import polyglot.ext.jl5.ast.JL5MethodDecl;
import polyglot.ext.jl5.ast.ParamTypeNode;
import polyglot.ext.jl5.types.FlagAnnotations;
import polyglot.ext.jl5.types.JL5Context;
import polyglot.ext.jl5.types.JL5Flags;
import polyglot.ext.jl5.types.JL5MethodDef;
import polyglot.ext.jl5.types.JL5MethodInstance;
import polyglot.ext.jl5.types.JL5TypeSystem;
import polyglot.ext.jl5.types.ParameterizedType;
import polyglot.ext.jl5.visit.ApplicationCheck;
import polyglot.ext.jl5.visit.ApplicationChecker;
import polyglot.types.ClassType;
import polyglot.types.Context;
import polyglot.types.Flags;
import polyglot.types.Name;
import polyglot.types.Ref;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.types.Types;
import polyglot.util.CodeWriter;
import polyglot.util.CollectionUtil;
import polyglot.util.Position;
import polyglot.util.TypedList;
import polyglot.visit.ContextVisitor;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.Translator;
import polyglot.visit.TypeBuilder;

public class JL5MethodDecl_c
extends MethodDecl_c
implements JL5MethodDecl,
ApplicationCheck {
    protected boolean compilerGenerated;
    protected List<AnnotationElem> annotations;
    protected List runtimeAnnotations;
    protected List classAnnotations;
    protected List sourceAnnotations;
    protected List<ParamTypeNode> paramTypes;

    public JL5MethodDecl_c(Position pos, FlagAnnotations flags, TypeNode returnType, Id name, List<Formal> formals, List<TypeNode> throwTypes, Block body) {
        this(pos, flags, returnType, name, formals, throwTypes, body, new ArrayList<ParamTypeNode>());
    }

    public JL5MethodDecl_c(Position pos, FlagAnnotations flags, TypeNode returnType, Id name, List<Formal> formals, List<TypeNode> throwTypes, Block body, List<ParamTypeNode> paramTypes) {
        this(pos, flags, returnType, name, formals, throwTypes, body, paramTypes, false);
    }

    public JL5MethodDecl_c(Position pos, FlagAnnotations flags, TypeNode returnType, Id name, List<Formal> formals, List<TypeNode> throwTypes, Block body, List<ParamTypeNode> paramTypes, boolean compilerGenerated) {
        super(pos, flags.classicFlags(), returnType, name, formals, throwTypes, body);
        this.annotations = flags.annotations() != null ? flags.annotations() : new TypedList(new LinkedList(), AnnotationElem.class, true);
        assert (paramTypes != null);
        this.paramTypes = paramTypes;
        this.compilerGenerated = compilerGenerated;
    }

    public boolean isGeneric() {
        return !this.paramTypes.isEmpty();
    }

    @Override
    public List<AnnotationElem> annotations() {
        return this.annotations;
    }

    public JL5MethodDecl annotations(List<AnnotationElem> annotations) {
        JL5MethodDecl_c n = (JL5MethodDecl_c)this.copy();
        n.annotations = annotations;
        return n;
    }

    @Override
    public List<ParamTypeNode> paramTypes() {
        return this.paramTypes;
    }

    @Override
    public JL5MethodDecl paramTypes(List<ParamTypeNode> paramTypes) {
        JL5MethodDecl_c n = (JL5MethodDecl_c)this.copy();
        n.paramTypes = paramTypes;
        return n;
    }

    protected MethodDecl_c reconstruct(TypeNode returnType, List formals, List throwTypes, Block body, List annotations, List paramTypes) {
        if (!(returnType == this.returnType && CollectionUtil.allEqual((Collection)formals, (Collection)this.formals) && CollectionUtil.allEqual((Collection)throwTypes, (Collection)this.throwTypes) && body == this.body && CollectionUtil.allEqual((Collection)annotations, this.annotations) && CollectionUtil.allEqual((Collection)paramTypes, this.paramTypes))) {
            JL5MethodDecl_c n = (JL5MethodDecl_c)this.copy();
            n.returnType = returnType;
            n.formals = TypedList.copyAndCheck((List)formals, Formal.class, (boolean)true);
            n.throwTypes = TypedList.copyAndCheck((List)throwTypes, TypeNode.class, (boolean)true);
            n.body = body;
            n.annotations = TypedList.copyAndCheck((List)annotations, AnnotationElem.class, (boolean)true);
            n.paramTypes = paramTypes;
            return n;
        }
        return this;
    }

    public Node buildTypesOverride(TypeBuilder tb) throws SemanticException {
        JL5MethodDecl n = (JL5MethodDecl)super.buildTypesOverride(tb);
        JL5MethodDef def = (JL5MethodDef)n.methodDef();
        ArrayList<Ref<? extends Type>> pTypes = new ArrayList<Ref<? extends Type>>(this.paramTypes().size());
        for (ParamTypeNode p : n.paramTypes()) {
            pTypes.add((Ref<? extends Type>)p.typeRef());
        }
        def.setTypeVariableTypes(pTypes);
        return n;
    }

    public Node visitSignature(NodeVisitor v) {
        JL5MethodDecl_c n = (JL5MethodDecl_c)super.visitSignature(v);
        List annotations = n.visitList(n.annotations, v);
        List paramTypes = n.visitList(n.paramTypes, v);
        return n.reconstruct(annotations, paramTypes);
    }

    public Node typeCheck(ContextVisitor tc) throws SemanticException {
        JL5TypeSystem ts = (JL5TypeSystem)tc.typeSystem();
        ts.checkDuplicateAnnotations(this.annotations);
        for (TypeNode tn : this.throwTypes) {
            Type next = tn.type();
            if (!(next instanceof ParameterizedType)) continue;
            throw new SemanticException("Cannot use parameterized type " + next + " in a throws clause", tn.position());
        }
        for (int i = 0; i < this.formals.size(); ++i) {
            JL5Formal f = (JL5Formal)this.formals.get(i);
            if (i == this.formals.size() - 1 || !f.isVarargs()) continue;
            throw new SemanticException("Only last formal can be variable in method declaration.", f.position());
        }
        return super.typeCheck(tc);
    }

    protected void checkFlags(ContextVisitor tc, Flags flags) throws SemanticException {
        JL5MethodInstance m;
        TypeSystem ts = tc.typeSystem();
        if (tc.context().currentClass().flags().isInterface()) {
            if (flags.isProtected() || flags.isPrivate()) {
                throw new SemanticException("Interface methods must be public.", this.position());
            }
            if (flags.isStatic()) {
                throw new SemanticException("Interface methods cannot be static.", this.position());
            }
        }
        try {
            ts.checkMethodFlags(flags);
        }
        catch (SemanticException e) {
            throw new SemanticException(e.getMessage(), this.position());
        }
        Type container = (Type)Types.get((Ref)this.methodDef().container());
        ClassType ct = container.toClass();
        if (this.body == null && !flags.isAbstract() && !flags.isNative()) {
            throw new SemanticException("Missing method body.", this.position());
        }
        if (this.body != null && ct.flags().isInterface()) {
            throw new SemanticException("Interface methods cannot have a body.", this.position());
        }
        if (this.body != null && flags.isAbstract()) {
            throw new SemanticException("An abstract method cannot have a body.", this.position());
        }
        if (this.body != null && flags.isNative()) {
            throw new SemanticException("A native method cannot have a body.", this.position());
        }
        if (ct != null && flags.isStatic() && ct.isInnerClass() && !JL5Flags.isEnumModifier(this.flags().flags())) {
            throw new SemanticException("Inner classes cannot declare static methods.", this.position());
        }
        if (this.mi instanceof JL5MethodInstance && (m = (JL5MethodInstance)this.mi).isGeneric()) {
            ((JL5TypeSystem)tc.typeSystem()).checkTVForwardReference(m.typeVariables());
        }
    }

    @Override
    public Node applicationCheck(ApplicationChecker appCheck, Context ctx) throws SemanticException {
        JL5TypeSystem ts = (JL5TypeSystem)appCheck.typeSystem();
        for (AnnotationElem a : this.annotations()) {
            ts.checkAnnotationApplicability(a, (Node)this);
        }
        return this;
    }

    protected JL5MethodDecl_c reconstruct(List<AnnotationElem> annotations, List<ParamTypeNode> paramTypes) {
        if (!CollectionUtil.allEqual(annotations, this.annotations) || !CollectionUtil.allEqual(paramTypes, this.paramTypes)) {
            JL5MethodDecl_c n = (JL5MethodDecl_c)this.copy();
            n.annotations = TypedList.copyAndCheck(annotations, AnnotationElem.class, (boolean)true);
            n.paramTypes = TypedList.copyAndCheck(paramTypes, ParamTypeNode.class, (boolean)true);
            return n;
        }
        return this;
    }

    public void translate(CodeWriter w, Translator tr) {
        if (this.isCompilerGenerated()) {
            return;
        }
        for (AnnotationElem a : this.annotations) {
            this.print((Node)a, w, (PrettyPrinter)tr);
        }
        super.translate(w, tr);
    }

    public void prettyPrintHeader(CodeWriter w, PrettyPrinter tr) {
        w.begin(0);
        this.print((Node)this.flags, w, tr);
        if (this.paramTypes != null && !this.paramTypes.isEmpty()) {
            w.write("<");
            Iterator<ParamTypeNode> it = this.paramTypes.iterator();
            while (it.hasNext()) {
                ParamTypeNode next = it.next();
                this.print((Node)next, w, tr);
                if (!it.hasNext()) continue;
                w.write(", ");
            }
            w.write("> ");
        }
        this.print((Node)this.returnType, w, tr);
        w.allowBreak(2, 2, " ", 1);
        w.write(this.name + "(");
        w.allowBreak(2, 2, "", 0);
        w.begin(0);
        Iterator i = this.formals.iterator();
        while (i.hasNext()) {
            Formal f = (Formal)i.next();
            this.print((Node)f, w, tr);
            if (!i.hasNext()) continue;
            w.write(",");
            w.allowBreak(0, " ");
        }
        w.end();
        w.write(")");
        if (!this.throwTypes().isEmpty()) {
            w.allowBreak(6);
            w.write("throws ");
            i = this.throwTypes().iterator();
            while (i.hasNext()) {
                TypeNode tn = (TypeNode)i.next();
                this.print((Node)tn, w, tr);
                if (!i.hasNext()) continue;
                w.write(",");
                w.allowBreak(4, " ");
            }
        }
        w.end();
    }

    @Override
    public List runtimeAnnotations() {
        return this.runtimeAnnotations;
    }

    @Override
    public List classAnnotations() {
        return this.classAnnotations;
    }

    @Override
    public List sourceAnnotations() {
        return this.sourceAnnotations;
    }

    public Context enterScope(Context c) {
        c = super.enterScope(c);
        for (ParamTypeNode pn : this.paramTypes) {
            c = ((JL5Context)c).addTypeVariable(Name.make((String)pn.nameString()), (Ref<? extends Type>)pn.typeRef());
        }
        return c;
    }

    public Node buildTypes(TypeBuilder tb) throws SemanticException {
        return super.buildTypes(tb);
    }

    @Override
    public boolean isCompilerGenerated() {
        return false;
    }

    @Override
    public JL5MethodDecl setCompilerGenerated(boolean val) {
        JL5MethodDecl_c n = (JL5MethodDecl_c)this.copy();
        n.compilerGenerated = val;
        return n;
    }
}

