/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.jl5.ast;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import polyglot.ast.ClassBody;
import polyglot.ast.Expr;
import polyglot.ast.New;
import polyglot.ast.New_c;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.Special;
import polyglot.ast.TypeNode;
import polyglot.ext.jl5.ast.JL5New;
import polyglot.ext.jl5.types.JL5Flags;
import polyglot.ext.jl5.types.JL5TypeSystem;
import polyglot.ext.jl5.types.TypeVariable;
import polyglot.types.ClassType;
import polyglot.types.ConstructorDef;
import polyglot.types.ConstructorInstance;
import polyglot.types.Context;
import polyglot.types.Name;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.types.TypeSystem_c;
import polyglot.types.Types;
import polyglot.util.CollectionUtil;
import polyglot.util.Position;
import polyglot.util.TypedList;
import polyglot.visit.ContextVisitor;
import polyglot.visit.NodeVisitor;
import polyglot.visit.TypeChecker;

public class JL5New_c
extends New_c
implements JL5New {
    protected List typeArguments;

    public JL5New_c(Position pos, Expr qualifier, TypeNode tn, List arguments, ClassBody body, List<TypeNode> typeArguments) {
        super(pos, qualifier, tn, arguments, body);
        this.typeArguments = typeArguments;
    }

    public List<TypeNode> typeArguments() {
        return this.typeArguments;
    }

    public JL5New typeArguments(List args) {
        JL5New_c n = (JL5New_c)this.copy();
        n.typeArguments = args;
        return n;
    }

    protected JL5New_c reconstruct(Expr qualifier, TypeNode tn, List arguments, ClassBody body, List typeArgs) {
        if (qualifier != this.qualifier || tn != this.tn || !CollectionUtil.allEqual((Collection)arguments, (Collection)this.arguments) || body != this.body || !CollectionUtil.allEqual((Collection)typeArgs, (Collection)this.typeArguments)) {
            JL5New_c n = (JL5New_c)this.copy();
            n.tn = tn;
            n.qualifier = qualifier;
            n.arguments = TypedList.copyAndCheck((List)arguments, Expr.class, (boolean)true);
            n.body = body;
            n.typeArguments = TypedList.copyAndCheck((List)typeArgs, TypeNode.class, (boolean)false);
            return n;
        }
        return this;
    }

    public Node visitChildren(NodeVisitor v) {
        Expr qualifier = (Expr)this.visitChild((Node)this.qualifier, v);
        TypeNode tn = (TypeNode)this.visitChild((Node)this.tn, v);
        List arguments = this.visitList(this.arguments, v);
        ClassBody body = (ClassBody)this.visitChild((Node)this.body, v);
        List typeArgs = this.visitList(this.typeArguments, v);
        return this.reconstruct(qualifier, tn, arguments, body, typeArgs);
    }

    protected New findQualifier(TypeChecker ar, ClassType ct) throws SemanticException {
        NodeFactory nf = ar.nodeFactory();
        TypeSystem ts = ar.typeSystem();
        Context c = ar.context();
        ClassType outer = null;
        Name name = ct.name();
        ClassType t = c.currentClass();
        if (t == this.anonType) {
            t = t.outer();
        }
        while (t != null) {
            try {
                ClassType cmt;
                Type mt = ts.findMemberType((Type)t, name, c);
                if (mt instanceof ClassType && (cmt = (ClassType)mt).def() == ct.def()) {
                    outer = t;
                    break;
                }
            }
            catch (SemanticException e) {
                // empty catch block
            }
            t = t.outer();
        }
        if (outer == null) {
            throw new SemanticException("Could not find non-static member class \"" + name + "\".", this.position());
        }
        Special q = outer.typeEquals((Type)c.currentClass(), ar.context()) ? nf.This(this.position().startOf()) : nf.This(this.position().startOf(), (TypeNode)nf.CanonicalTypeNode(this.position(), outer));
        q = q.type(outer);
        return this.qualifier((Expr)q);
    }

    public Node typeCheck(ContextVisitor tc) throws SemanticException {
        ConstructorInstance ci;
        ClassType ct;
        TypeSystem ts = tc.typeSystem();
        if (this.tn.type().isClass() && JL5Flags.isEnumModifier((ct = (ClassType)this.tn.type()).flags())) {
            throw new SemanticException("Cannot instantiate an enum type.", this.tn.position());
        }
        if (this.tn.type() instanceof TypeVariable) {
            throw new SemanticException("Cannot instantiate a type variable type.", this.tn.position());
        }
        ArrayList<Type> argTypes = new ArrayList<Type>(this.arguments.size());
        for (Expr e : this.arguments) {
            argTypes.add(e.type());
        }
        ArrayList<Type> explicitTypeArgs = null;
        if (this.typeArguments != null && !this.typeArguments.isEmpty()) {
            explicitTypeArgs = new ArrayList<Type>();
            Iterator<TypeNode> it = this.typeArguments().iterator();
            while (it.hasNext()) {
                explicitTypeArgs.add(it.next().type());
            }
        }
        this.typeCheckFlags(tc);
        this.typeCheckNested(tc);
        ClassType ct2 = this.tn.type().toClass();
        if (!ct2.flags().isInterface()) {
            Context c = tc.context();
            if (this.anonType != null) {
                c = c.pushClass(this.anonType, this.anonType.asType());
            }
            TypeSystem_c.ConstructorMatcher matcher = ((JL5TypeSystem)ts).JL5ConstructorMatcher((Type)ct2, argTypes, explicitTypeArgs, c);
            ci = ts.findConstructor((Type)ct2, matcher);
        } else {
            ConstructorDef dci = ts.defaultConstructor(this.position(), Types.ref((Object)ct2));
            ci = dci.asInstance();
        }
        New n = this.constructorInstance(ci);
        if (this.anonType != null) {
            ct2 = this.anonType.asType();
        }
        return n.type((Type)ct2);
    }
}

