/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.jl5.ast;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import polyglot.ast.Node;
import polyglot.ast.TypeNode;
import polyglot.ast.TypeNode_c;
import polyglot.ext.jl5.ast.ParamTypeNode;
import polyglot.ext.jl5.types.JL5ClassDef_c;
import polyglot.ext.jl5.types.JL5Context;
import polyglot.ext.jl5.types.JL5TypeSystem;
import polyglot.ext.jl5.types.TypeVariable;
import polyglot.types.ArrayType;
import polyglot.types.ClassDef;
import polyglot.types.ClassType;
import polyglot.types.Context;
import polyglot.types.Name;
import polyglot.types.Ref;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.Types;
import polyglot.util.CodeWriter;
import polyglot.util.CollectionUtil;
import polyglot.util.Position;
import polyglot.visit.ContextVisitor;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.TypeBuilder;

public class ParamTypeNode_c
extends TypeNode_c
implements ParamTypeNode {
    protected String id;
    protected List<TypeNode> bounds;

    public ParamTypeNode_c(Position pos, List<TypeNode> bounds, String id) {
        super(pos);
        this.id = id;
        this.bounds = bounds;
    }

    @Override
    public ParamTypeNode id(String id) {
        ParamTypeNode_c n = (ParamTypeNode_c)this.copy();
        n.id = id;
        return n;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public ParamTypeNode bounds(List<TypeNode> l) {
        ParamTypeNode_c n = (ParamTypeNode_c)this.copy();
        n.bounds = l;
        return n;
    }

    @Override
    public List<TypeNode> bounds() {
        return this.bounds;
    }

    public ParamTypeNode reconstruct(List bounds) {
        if (!CollectionUtil.allEqual((Collection)bounds, this.bounds)) {
            ParamTypeNode_c n = (ParamTypeNode_c)this.copy();
            n.bounds = bounds;
            return n;
        }
        return this;
    }

    public Node visitChildren(NodeVisitor v) {
        List bounds = this.visitList(this.bounds, v);
        return this.reconstruct(bounds);
    }

    public Context enterScope(Context c) {
        c = ((JL5Context)c).pushTypeVariable((TypeVariable)this.type.get());
        return super.enterScope(c);
    }

    public void addDecls(Context c) {
        ((JL5Context)c).addTypeVariable(Name.make((String)this.id()), (Ref<? extends Type>)Types.ref((Object)((TypeVariable)this.type())));
    }

    public Node buildTypes(TypeBuilder tb) throws SemanticException {
        if (this.type == null) {
            List boundsTypeRef;
            JL5TypeSystem ts = (JL5TypeSystem)tb.typeSystem();
            Ref tvDef = Types.ref((Object)new JL5ClassDef_c(ts));
            if (this.hasBounds()) {
                boundsTypeRef = new ArrayList(this.bounds().size());
                for (TypeNode tn : this.bounds()) {
                    boundsTypeRef.add(tn.typeRef());
                }
            } else {
                boundsTypeRef = Collections.emptyList();
            }
            TypeVariable iType = ts.typeVariable(this.position(), Name.make((String)this.id), (Ref<? extends ClassDef>)tvDef, boundsTypeRef);
            return this.typeRef(Types.ref((Object)iType));
        }
        return this;
    }

    public boolean hasBounds() {
        return !this.bounds.isEmpty();
    }

    public Node disambiguate(ContextVisitor ar) throws SemanticException {
        return this;
    }

    public Node conformanceCheck(ContextVisitor tc) throws SemanticException {
        TypeNode ti;
        int i;
        TypeVariable tv = (TypeVariable)this.type();
        JL5TypeSystem ts = (JL5TypeSystem)tc.typeSystem();
        for (i = 0; i < this.bounds.size(); ++i) {
            ti = this.bounds.get(i);
            for (int j = i + 1; j < this.bounds.size(); ++j) {
                TypeNode tj = this.bounds.get(j);
                if (!tc.typeSystem().typeEquals(ti.type(), tj.type(), tc.context())) continue;
                throw new SemanticException("Duplicate bound in type variable declaration", tj.position());
            }
        }
        for (i = 0; i < this.bounds.size(); ++i) {
            ti = this.bounds.get(i);
            if (!(ti.type() instanceof ArrayType)) continue;
            throw new SemanticException("Unexpected type bound in type variable declaration", ti.position());
        }
        for (i = 0; i < this.bounds.size(); ++i) {
            TypeNode tn = this.bounds.get(i);
            if (i <= 0 || ((ClassType)tn.type()).flags().isInterface()) continue;
            throw new SemanticException("Interface expected here.", tn.position());
        }
        ts.checkIntersectionBounds(tv.bounds(), false);
        return super.conformanceCheck(tc);
    }

    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        w.write(this.id);
        if (this.bounds() != null && !this.bounds().isEmpty()) {
            w.write(" extends ");
            Iterator<TypeNode> it = this.bounds.iterator();
            while (it.hasNext()) {
                TypeNode tn = it.next();
                this.print((Node)tn, w, tr);
                if (!it.hasNext()) continue;
                w.write(" & ");
            }
        }
    }
}

