/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.jl5.types;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import polyglot.ext.jl5.types.IntersectionType;
import polyglot.ext.jl5.types.JL5TypeSystem;
import polyglot.ext.jl5.types.TypeVariable;
import polyglot.types.ClassDef;
import polyglot.types.ClassType;
import polyglot.types.DerefTransform;
import polyglot.types.Name;
import polyglot.types.Ref;
import polyglot.types.ReferenceType;
import polyglot.types.Resolver;
import polyglot.types.Type;
import polyglot.types.TypeObject;
import polyglot.types.TypeSystem;
import polyglot.types.Type_c;
import polyglot.types.Types;
import polyglot.util.Transformation;
import polyglot.util.TransformingList;

public class IntersectionType_c
extends Type_c
implements IntersectionType {
    protected List<Ref<? extends Type>> bounds;
    protected List<Type> concreteBounds;
    protected TypeVariable boundOf_;
    protected ClassDef syntheticDef;

    public IntersectionType_c(TypeSystem ts, List<Ref<? extends Type>> bounds) {
        super(ts);
        this.bounds = bounds;
    }

    @Override
    public List<Ref<? extends Type>> bounds() {
        if (this.bounds.isEmpty()) {
            this.bounds = Collections.singletonList(Types.ref((Object)this.ts.Object()));
        }
        return this.bounds;
    }

    public String translate(Resolver c) {
        return "Intersection Type";
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        Iterator<Ref<? extends Type>> iter = this.bounds.iterator();
        while (iter.hasNext()) {
            Ref<? extends Type> b = iter.next();
            sb.append(b.get());
            if (!iter.hasNext()) continue;
            sb.append(" & ");
        }
        return sb.toString();
    }

    protected List<Type> getConcreteBounds() {
        if (this.concreteBounds == null) {
            this.concreteBounds = ((JL5TypeSystem)this.typeSystem()).concreteBounds(this.boundsTypes());
        }
        return this.concreteBounds;
    }

    @Override
    public ClassType getSyntheticClassType() {
        if (this.syntheticDef == null) {
            List<Type> cb = this.getConcreteBounds();
            ArrayList<ClassType> classesList = new ArrayList<ClassType>(cb.size());
            ArrayList<ClassType> interfacesList = new ArrayList<ClassType>(cb.size());
            for (ClassType classType : cb) {
                if (classType.isClass() && classType.flags().isInterface()) {
                    interfacesList.add(classType);
                    continue;
                }
                classesList.add(classType);
            }
            ClassDef def = this.ts.createClassDef();
            def.name(Name.make((String)this.toString()));
            if (!classesList.isEmpty()) {
                Collections.sort(classesList, new Comparator<ClassType>(){

                    @Override
                    public int compare(ClassType o1, ClassType o2) {
                        JL5TypeSystem ts = (JL5TypeSystem)IntersectionType_c.this.typeSystem();
                        if (ts.typeEquals((Type)o1, (Type)o2, null)) {
                            return 0;
                        }
                        if (ts.isSubtype((Type)o1, (Type)o2, null)) {
                            return -1;
                        }
                        return 1;
                    }
                });
                def.superType(Types.ref(classesList.get(0)));
            }
            if (!interfacesList.isEmpty()) {
                for (ClassType iType : interfacesList) {
                    def.addInterface(Types.ref((Object)iType));
                }
            }
            this.syntheticDef = def;
        }
        return this.syntheticDef.asType();
    }

    @Override
    public void boundOf(TypeVariable tv) {
        this.boundOf_ = tv;
    }

    @Override
    public TypeVariable boundOf() {
        return this.boundOf_;
    }

    public boolean equalsImpl(TypeObject other) {
        if (!super.equalsImpl(other) && other instanceof ReferenceType) {
            return this.ts.isSubtype((Type)this, (Type)other, null) && this.ts.isSubtype((Type)other, (Type)this, null);
        }
        return true;
    }

    @Override
    public List<Type> boundsTypes() {
        return new TransformingList(this.bounds(), (Transformation)new DerefTransform());
    }
}

