/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.jl5.types;

import java.util.HashMap;
import java.util.Map;
import polyglot.ext.jl5.types.JL5Context;
import polyglot.ext.jl5.types.JL5ImportTable;
import polyglot.ext.jl5.types.JL5TypeSystem;
import polyglot.ext.jl5.types.TypeVariable;
import polyglot.types.Context;
import polyglot.types.Context_c;
import polyglot.types.MethodInstance;
import polyglot.types.Name;
import polyglot.types.Named;
import polyglot.types.QName;
import polyglot.types.Ref;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.types.TypeSystem_c;
import polyglot.types.VarInstance;

public class JL5Context_c
extends Context_c
implements JL5Context {
    protected Map<Name, Ref<? extends Type>> typeVars;
    protected TypeVariable typeVariable;
    public static final Context_c.Kind TYPE_VAR = new Context_c.Kind("type-var");

    public JL5Context_c(TypeSystem ts) {
        super(ts);
    }

    @Override
    public JL5TypeSystem typeSystem() {
        return (JL5TypeSystem)this.ts;
    }

    @Override
    public VarInstance findVariableInThisScope(Name name) {
        VarInstance vi = super.findVariableInThisScope(name);
        if (vi == null && this.isClass()) {
            try {
                JL5TypeSystem jts = (JL5TypeSystem)this.ts;
                return jts.findEnumConstant((Type)this.currentClass(), jts.EnumMatcher((Type)this.currentClass(), name, this));
            }
            catch (SemanticException e) {
                return null;
            }
        }
        return vi;
    }

    @Override
    public VarInstance findVariableSilent(Name name) {
        VarInstance vi = this.findVariableInThisScope(name);
        if (vi != null) {
            return vi;
        }
        if (this.importTable() != null) {
            Name candidateClass;
            JL5ImportTable jit = (JL5ImportTable)this.importTable();
            for (QName importName : jit.explicitStaticImports()) {
                candidateClass = importName.name();
                if (!name.equals((Object)candidateClass)) continue;
                try {
                    Type t;
                    Named enclosingClass = this.ts.forName(importName.qualifier());
                    assert (enclosingClass instanceof Type);
                    if (!(enclosingClass instanceof Type) || (vi = this.ts.findField((Type)(t = (Type)enclosingClass).toClass(), this.ts.FieldMatcher((Type)t.toClass(), name, (Context)this))) == null) continue;
                    return vi;
                }
                catch (SemanticException e) {
                }
            }
            for (QName importName : jit.onDemandStaticImports()) {
                try {
                    Type t;
                    candidateClass = this.ts.forName(importName);
                    assert (candidateClass instanceof Type);
                    if (!(candidateClass instanceof Type) || (vi = this.ts.findField((Type)(t = (Type)candidateClass).toClass(), this.ts.FieldMatcher((Type)t.toClass(), name, (Context)this))) == null) continue;
                    return vi;
                }
                catch (SemanticException e) {
                }
            }
        }
        if (this.outer != null) {
            return this.outer.findVariableSilent(name);
        }
        return null;
    }

    protected Context_c push() {
        Context_c v = super.push();
        ((JL5Context_c)v).typeVars = null;
        return v;
    }

    @Override
    public JL5Context pushTypeVariable(TypeVariable iType) {
        JL5Context_c v = (JL5Context_c)this.push();
        v.typeVariable = iType;
        v.kind = TYPE_VAR;
        return v;
    }

    @Override
    public TypeVariable findTypeVariableInThisScope(Name name) {
        if (this.typeVariable != null && this.typeVariable.name().equals((Object)name)) {
            return this.typeVariable;
        }
        if (this.typeVars != null && this.typeVars.containsKey(name)) {
            return (TypeVariable)this.typeVars.get(name).get();
        }
        if (this.outer != null) {
            return ((JL5Context)this.outer).findTypeVariableInThisScope(name);
        }
        return null;
    }

    @Override
    public boolean inTypeVariable() {
        return this.kind == TYPE_VAR;
    }

    public String toString() {
        return super.toString() + "type var: " + this.typeVariable;
    }

    @Override
    public JL5Context addTypeVariable(Name name, Ref<? extends Type> type) {
        assert (type != null);
        if (this.typeVars == null) {
            this.typeVars = new HashMap<Name, Ref<? extends Type>>();
        }
        this.typeVars.put(name, type);
        return this;
    }

    public MethodInstance findMethod(TypeSystem_c.MethodMatcher matcher) throws SemanticException {
        try {
            return super.findMethod(matcher);
        }
        catch (SemanticException e) {
            MethodInstance res;
            JL5ImportTable it = (JL5ImportTable)this.importTable();
            if (it != null && this.currentClass() != null && (res = it.findMethod(matcher)) != null) {
                return res;
            }
            throw e;
        }
    }
}

