/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.jl5.types;

import java.util.ArrayList;
import java.util.List;
import polyglot.types.ImportTable;
import polyglot.types.Matcher;
import polyglot.types.MethodInstance;
import polyglot.types.Name;
import polyglot.types.Named;
import polyglot.types.NoClassException;
import polyglot.types.Package;
import polyglot.types.QName;
import polyglot.types.Ref;
import polyglot.types.SemanticException;
import polyglot.types.TypeSystem;
import polyglot.types.TypeSystem_c;
import polyglot.util.Position;

public class JL5ImportTable
extends ImportTable {
    protected List<QName> staticExplicitImports;
    protected List<Position> staticExplicitImportsPositions;
    protected List<QName> staticOnDemandImports;
    protected List<Position> staticOnDemandImportsPositions;

    public JL5ImportTable(TypeSystem ts, Ref<? extends Package> pkg) {
        this(ts, pkg, null);
    }

    public JL5ImportTable(TypeSystem ts, Ref<? extends Package> pkg, String src) {
        super(ts, pkg, src);
    }

    public void addExplicitStaticImport(QName memberName, Position pos) {
        this.explicitStaticImports().add(memberName);
        this.explicitStaticImportsPosition().add(pos);
    }

    public void addOnDemandStaticImport(QName className, Position pos) {
        this.onDemandStaticImports().add(className);
        this.onDemandStaticImportsPosition().add(pos);
    }

    public List<QName> explicitStaticImports() {
        if (this.staticExplicitImports == null) {
            this.staticExplicitImports = new ArrayList<QName>();
        }
        return this.staticExplicitImports;
    }

    public List<Position> explicitStaticImportsPosition() {
        if (this.staticExplicitImportsPositions == null) {
            this.staticExplicitImportsPositions = new ArrayList<Position>();
        }
        return this.staticExplicitImportsPositions;
    }

    public List<QName> onDemandStaticImports() {
        if (this.staticOnDemandImports == null) {
            this.staticOnDemandImports = new ArrayList<QName>();
        }
        return this.staticOnDemandImports;
    }

    public List<Position> onDemandStaticImportsPosition() {
        if (this.staticOnDemandImportsPositions == null) {
            this.staticOnDemandImportsPositions = new ArrayList<Position>();
        }
        return this.staticOnDemandImportsPositions;
    }

    public MethodInstance findMethod(TypeSystem_c.MethodMatcher matcher) throws SemanticException {
        MethodInstance mi = null;
        try {
            mi = this.lookupExplicitMethod(matcher);
        }
        catch (SemanticException semanticException) {
            // empty catch block
        }
        if (mi == null) {
            mi = this.lookupOnDemandMethod(matcher);
        }
        return mi;
    }

    protected MethodInstance lookupExplicitMethod(TypeSystem_c.MethodMatcher matcher) throws SemanticException {
        MethodInstance mi = null;
        for (QName staticName : this.explicitStaticImports()) {
            Name mthNameCandidate = staticName.name();
            if (!mthNameCandidate.equals((Object)matcher.name())) continue;
            QName className = staticName.qualifier();
            mi = this.ts.findMethod(this.ts.typeForName(className), matcher);
        }
        return mi;
    }

    protected MethodInstance lookupOnDemandMethod(TypeSystem_c.MethodMatcher matcher) throws SemanticException {
        MethodInstance mi = null;
        for (QName staticName : this.onDemandStaticImports()) {
            MethodInstance res;
            block3: {
                res = null;
                try {
                    res = this.ts.findMethod(this.ts.typeForName(staticName), matcher);
                    if (mi != null) break block3;
                    mi = res;
                    res = null;
                }
                catch (SemanticException e) {
                    continue;
                }
            }
            if (mi == null || res == null) continue;
            throw new SemanticException("The static method call '" + mi.name() + "' is ambiguous");
        }
        return mi;
    }

    public Named find(Matcher<Named> matcher) throws SemanticException {
        try {
            Named n = super.find(matcher);
            return n;
        }
        catch (NoClassException e) {
            Named exp = null;
            try {
                exp = this.lookupStaticExplicit(matcher);
                if (exp != null) {
                    return exp;
                }
            }
            catch (NoClassException ee) {
                // empty catch block
            }
            return this.lookupOnDemandStatic(matcher);
        }
    }

    protected Named lookupStaticExplicit(Matcher<Named> matcher) throws SemanticException {
        return this.lookupExplicitImpl(matcher, this.explicitStaticImports(), this.explicitStaticImportsPosition());
    }

    protected Named lookupOnDemandStatic(Matcher<Named> matcher) throws SemanticException, NoClassException {
        return this.lookupOnDemandImpl(matcher, this.onDemandStaticImports(), this.onDemandStaticImportsPosition(), false);
    }

    public boolean hasExplicitName(Name importName) {
        for (QName explicitImport : this.explicitStaticImports()) {
            Name explicitName = explicitImport.name();
            if (!explicitName.equals((Object)importName)) continue;
            return true;
        }
        return false;
    }
}

