/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.jl5.types;

import java.util.LinkedList;
import java.util.List;
import polyglot.ext.jl5.types.AnnotationElemInstance;
import polyglot.ext.jl5.types.EnumInstance;
import polyglot.ext.jl5.types.JL5ClassDef;
import polyglot.ext.jl5.types.JL5ParsedClassType;
import polyglot.ext.jl5.types.ParameterizedType;
import polyglot.ext.jl5.types.SignatureType;
import polyglot.ext.jl5.types.TypeVariable;
import polyglot.frontend.Globals;
import polyglot.types.ClassDef;
import polyglot.types.ClassType;
import polyglot.types.DerefTransform;
import polyglot.types.Name;
import polyglot.types.Named;
import polyglot.types.ParsedClassType_c;
import polyglot.types.PrimitiveType;
import polyglot.types.Ref;
import polyglot.types.Resolver;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeObject;
import polyglot.types.TypeSystem;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;
import polyglot.util.Transformation;
import polyglot.util.TransformingList;
import polyglot.util.TypedList;

public class JL5ParsedClassType_c
extends ParsedClassType_c
implements JL5ParsedClassType,
SignatureType {
    protected List<EnumInstance> enumConstants;
    protected List<AnnotationElemInstance> annotationElems;
    protected List annotations;

    public JL5ParsedClassType_c(TypeSystem ts, Position pos, Ref<? extends ClassDef> def) {
        super(ts, pos, def);
    }

    @Override
    public void annotations(List annotations) {
        this.annotations = annotations;
    }

    @Override
    public List annotations() {
        return this.annotations;
    }

    @Override
    public void addEnumConstant(EnumInstance ei) {
        this.enumConstants().add(ei);
    }

    @Override
    public void addAnnotationElem(AnnotationElemInstance ai) {
        this.annotationElems().add(ai);
    }

    @Override
    public List<EnumInstance> enumConstants() {
        if (this.enumConstants == null) {
            this.enumConstants = new TypedList(new LinkedList(), EnumInstance.class, false);
        }
        return this.enumConstants;
    }

    @Override
    public List<AnnotationElemInstance> annotationElems() {
        if (this.annotationElems == null) {
            this.annotationElems = new TypedList(new LinkedList(), AnnotationElemInstance.class, false);
        }
        return this.annotationElems;
    }

    @Override
    public EnumInstance enumConstantNamed(Name name) {
        for (EnumInstance fi : this.enumConstants()) {
            if (!fi.name().equals((Object)name)) continue;
            return fi;
        }
        return null;
    }

    @Override
    public AnnotationElemInstance annotationElemNamed(Name name) {
        for (AnnotationElemInstance ai : this.annotationElems()) {
            if (!ai.name().equals((Object)name)) continue;
            return ai;
        }
        return null;
    }

    @Override
    public List<TypeVariable> typeVariables() {
        TransformingList l = new TransformingList(((JL5ClassDef)this.def()).typeVariables(), (Transformation)new DerefTransform());
        return l;
    }

    @Override
    public boolean hasTypeVariable(Name name) {
        if (!this.typeVariables().isEmpty()) {
            for (TypeVariable tv : this.typeVariables()) {
                if (!tv.name().equals((Object)name)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isGeneric() {
        return ((JL5ClassDef)this.def()).hasTypeVariable();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(super.toString());
        return sb.toString();
    }

    public PrimitiveType toPrimitive() {
        TypeSystem ts = this.typeSystem();
        if (ts.isBoolean((Type)this)) {
            return (PrimitiveType)ts.Boolean();
        }
        if (ts.isByte((Type)this)) {
            return (PrimitiveType)ts.Byte();
        }
        if (ts.isShort((Type)this)) {
            return (PrimitiveType)ts.Short();
        }
        if (ts.isChar((Type)this)) {
            return (PrimitiveType)ts.Char();
        }
        if (ts.isInt((Type)this)) {
            return (PrimitiveType)ts.Int();
        }
        if (ts.isLong((Type)this)) {
            return (PrimitiveType)ts.Long();
        }
        if (ts.isFloat((Type)this)) {
            return (PrimitiveType)ts.Float();
        }
        if (ts.isDouble((Type)this)) {
            return (PrimitiveType)ts.Double();
        }
        if (ts.isVoid((Type)this)) {
            return (PrimitiveType)ts.Void();
        }
        return super.toPrimitive();
    }

    public String translate(Resolver c) {
        if (this.isTopLevel()) {
            if (this.package_() == null) {
                return this.name().toString();
            }
            if (c != null && !Globals.Options().fully_qualified_names) {
                try {
                    Named x = c.find(this.ts.TypeMatcher(this.name()));
                    if (x instanceof ClassType && this.def().equals(((ClassType)x).def())) {
                        return this.name().toString();
                    }
                }
                catch (SemanticException e) {
                    // empty catch block
                }
            }
            return this.package_().translate(c) + "." + this.name();
        }
        if (this.isMember()) {
            if (this.container().toClass().isAnonymous()) {
                return this.name().toString();
            }
            if (c != null && !Globals.Options().fully_qualified_names) {
                try {
                    Named x = c.find(this.ts.TypeMatcher(this.name()));
                    if (x instanceof ClassType && this.def().equals(((ClassType)x).def()) && !(this.container() instanceof ParameterizedType)) {
                        return this.name().toString();
                    }
                }
                catch (SemanticException e) {
                    // empty catch block
                }
            }
            return this.container().translate(c) + "." + this.name();
        }
        if (this.isMember()) {
            if (this.container().toClass().isAnonymous()) {
                return this.name().toString();
            }
            if (c != null && !Globals.Options().fully_qualified_names) {
                try {
                    Named x = c.find(this.ts.TypeMatcher(this.name()));
                    if (x instanceof ClassType && this.def().equals(((ClassType)x).def())) {
                        return this.name().toString();
                    }
                }
                catch (SemanticException semanticException) {
                    // empty catch block
                }
            }
            return this.container().translate(c) + "." + this.name();
        }
        if (this.isLocal()) {
            return this.name().toString();
        }
        throw new InternalCompilerError("Cannot translate an anonymous class.");
    }

    @Override
    public String signature() {
        return "L" + this.fullName().toString().replaceAll("\\.", "/") + ";";
    }

    @Override
    public boolean equivalentImpl(TypeObject arg2) {
        return this.equalsImpl(arg2);
    }
}

