/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.jl5.types;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import polyglot.ext.jl5.types.AnySubType;
import polyglot.ext.jl5.types.AnySuperType;
import polyglot.ext.jl5.types.AnyType;
import polyglot.ext.jl5.types.GenericTypeRef;
import polyglot.ext.jl5.types.GenericTypeRef_c;
import polyglot.ext.jl5.types.JL5ParsedClassType;
import polyglot.ext.jl5.types.JL5TypeSystem;
import polyglot.ext.jl5.types.ParameterizedType;
import polyglot.ext.jl5.types.SignatureType;
import polyglot.ext.jl5.types.TypeVariable;
import polyglot.ext.jl5.types.Wildcard;
import polyglot.types.ClassDef;
import polyglot.types.ClassType;
import polyglot.types.ConstructorDef;
import polyglot.types.ConstructorInstance;
import polyglot.types.Context;
import polyglot.types.FieldDef;
import polyglot.types.FieldInstance;
import polyglot.types.MethodDef;
import polyglot.types.MethodInstance;
import polyglot.types.Ref;
import polyglot.types.Resolver;
import polyglot.types.StructType;
import polyglot.types.Type;
import polyglot.types.TypeObject;
import polyglot.types.TypeSystem;
import polyglot.types.Types;
import polyglot.util.Transformation;
import polyglot.util.TransformingList;

public class ParameterizedType_c
extends GenericTypeRef_c
implements ParameterizedType,
SignatureType {
    protected List<Type> typeArguments;
    protected List<Ref<? extends Type>> typeArgumentsRefs;
    protected ParameterizedType capturedType;
    private static int captureCount = 0;
    protected List<TypeVariable> substTypeVars = null;

    public ParameterizedType_c(JL5ParsedClassType t) {
        super(t);
    }

    public ParameterizedType_c(JL5ParsedClassType type, Ref<ClassDef> defRef, List<Ref<? extends Type>> typeArgumentsRefs) {
        super(type.typeSystem(), type.position(), type, defRef);
        this.typeArgumentsRefs = typeArgumentsRefs;
    }

    @Override
    public List<Type> typeArguments() {
        if (this.typeArgumentsRefs != null) {
            LinkedList<Type> newTypeArguments = new LinkedList<Type>();
            for (Ref<? extends Type> ref : this.typeArgumentsRefs) {
                newTypeArguments.add((Type)Types.get(ref));
            }
            this.typeArguments = newTypeArguments;
            this.typeArgumentsRefs = null;
        }
        return this.typeArguments;
    }

    @Override
    public void typeArguments(List<Type> args) {
        assert (this.typeArgumentsRefs == null);
        this.typeArguments = args;
    }

    @Override
    public String translate(Resolver c) {
        StringBuffer sb = new StringBuffer(this.baseType.translate(c));
        sb.append("<");
        Iterator<Type> it = this.typeArguments().iterator();
        while (it.hasNext()) {
            sb.append(it.next().translate(c));
            if (!it.hasNext()) continue;
            sb.append(", ");
        }
        sb.append(">");
        return sb.toString();
    }

    @Override
    public String toString() {
        Type b = ((JL5TypeSystem)this.typeSystem()).erasure((Type)this.baseType());
        StringBuffer sb = new StringBuffer(b.toString());
        sb.append("<");
        Iterator<Type> it = this.typeArguments().iterator();
        while (it.hasNext()) {
            sb.append(it.next());
            if (!it.hasNext()) continue;
            sb.append(", ");
        }
        sb.append(">");
        return sb.toString();
    }

    @Override
    public boolean equivalentImpl(TypeObject t) {
        Context ctx = this.ts.emptyContext();
        if (!(t instanceof ParameterizedType)) {
            return false;
        }
        if (this.ts.typeEquals((Type)((ParameterizedType)t).baseType(), (Type)this.baseType(), ctx)) {
            int i = 0;
            for (i = 0; i < ((ParameterizedType)t).typeArguments().size() && i < this.typeArguments().size(); ++i) {
                ClassType bound2;
                ClassType bound1;
                Type t1 = ((ParameterizedType)t).typeArguments().get(i);
                Type t2 = this.typeArguments().get(i);
                if (t1 instanceof AnyType && t2 instanceof AnyType) continue;
                if (t1 instanceof AnySubType && t2 instanceof AnySubType) {
                    bound1 = ((AnySubType)t1).bound();
                    if (bound1 instanceof TypeVariable) {
                        bound1 = ((TypeVariable)bound1).erasureType();
                    }
                    if ((bound2 = ((AnySubType)t2).bound()) instanceof TypeVariable) {
                        bound2 = ((TypeVariable)bound2).erasureType();
                    }
                    if (!(bound1 instanceof ParameterizedType && bound2 instanceof ParameterizedType ? !((JL5TypeSystem)this.typeSystem()).equivalent((Type)bound1, (Type)bound2) : !this.ts.typeEquals((Type)bound1, (Type)bound2, ctx))) continue;
                    return false;
                }
                if (t1 instanceof AnySuperType && t2 instanceof AnySuperType) {
                    bound1 = ((AnySuperType)t1).bound();
                    if (bound1 instanceof TypeVariable) {
                        bound1 = ((TypeVariable)bound1).erasureType();
                    }
                    if ((bound2 = ((AnySuperType)t2).bound()) instanceof TypeVariable) {
                        bound2 = ((TypeVariable)bound2).erasureType();
                    }
                    if (!(bound1 instanceof ParameterizedType && bound2 instanceof ParameterizedType ? !((JL5TypeSystem)this.typeSystem()).equivalent((Type)bound1, (Type)bound2) : !this.ts.typeEquals((Type)bound1, (Type)bound2, ctx))) continue;
                    return false;
                }
                if (!(t1 instanceof ParameterizedType && t2 instanceof ParameterizedType ? !((JL5TypeSystem)this.typeSystem()).equivalent(t1, t2) : !this.ts.typeEquals(t1, t2, ctx))) continue;
                return false;
            }
            return i >= ((ParameterizedType)t).typeArguments().size() && i >= this.typeArguments().size();
        }
        return false;
    }

    public boolean equalsImpl(TypeObject t) {
        if (t instanceof ParameterizedType) {
            ParameterizedType other = (ParameterizedType)t;
            if (this.ts.equals((TypeObject)this.baseType(), (TypeObject)other.baseType()) && this.typeArguments().size() == other.typeArguments().size()) {
                for (int i = 0; i < this.typeArguments().size(); ++i) {
                    Type arg2;
                    Type arg1 = this.typeArguments().get(i);
                    if (this.ts.equals((TypeObject)arg1, (TypeObject)(arg2 = other.typeArguments().get(i)))) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public String signature() {
        StringBuffer signature = new StringBuffer();
        signature.append("L" + this.baseType.fullName().toString().replaceAll("\\.", "/") + "<");
        Iterator<Type> it = this.typeArguments().iterator();
        while (it.hasNext()) {
            SignatureType next = (SignatureType)it.next();
            signature.append(next.signature());
            if (!it.hasNext()) continue;
            signature.append(",");
        }
        signature.append(">;");
        return signature.toString();
    }

    @Override
    public ParameterizedType capture() {
        JL5TypeSystem ts = (JL5TypeSystem)this.typeSystem();
        ArrayList<Type> capturedArgs = new ArrayList<Type>();
        boolean anyWildCard = false;
        for (int i = 0; i < this.typeArguments().size(); ++i) {
            Type arg = this.typeArguments().get(i);
            if (arg instanceof Wildcard) {
                anyWildCard = true;
                capturedArgs.add(ts.typeVariable(this.position(), "capture of ?_" + captureCount++, null));
                continue;
            }
            capturedArgs.add(arg);
        }
        if (anyWildCard) {
            List<TypeVariable> baseTypeVars = this.baseType().typeVariables();
            for (int i = 0; i < this.typeArguments().size(); ++i) {
                Wildcard argcast;
                Type arg = this.typeArguments().get(i);
                if (!(arg instanceof Wildcard)) continue;
                TypeVariable capArg = (TypeVariable)capturedArgs.get(i);
                if (arg instanceof AnyType) {
                    capArg.bounds(ts.toRefTypes(ts.applySubstitution(baseTypeVars.get(i).bounds(), baseTypeVars, capturedArgs)));
                    continue;
                }
                if (arg instanceof AnySubType) {
                    argcast = (AnySubType)arg;
                    ArrayList<Type> newBounds = new ArrayList<Type>();
                    newBounds.add((Type)argcast.bound());
                    newBounds.addAll(ts.applySubstitution(baseTypeVars.get(i).bounds(), baseTypeVars, capturedArgs));
                    capArg.bounds(ts.toRefTypes(newBounds));
                    continue;
                }
                if (!(arg instanceof AnySuperType)) continue;
                argcast = (AnySuperType)arg;
                capArg.lowerBound((Type)argcast.bound());
                TypeVariable tv = baseTypeVars.get(i);
                List<Type> toBeSubed = tv.bounds();
                List<TypeVariable> orig = baseTypeVars;
                ArrayList<Type> sub = capturedArgs;
                capArg.bounds(ts.toRefTypes(ts.applySubstitution(toBeSubed, orig, sub)));
                anyWildCard = true;
            }
            this.capturedType = ts.parameterizedType(this.baseType());
            this.capturedType.typeArguments(capturedArgs);
        } else {
            this.capturedType = this;
        }
        return this.capturedType;
    }

    public ClassType outer() {
        ClassDef outer = (ClassDef)Types.get((Ref)this.def().outer());
        if (outer == null) {
            return null;
        }
        return (ClassType)((JL5TypeSystem)this.typeSystem()).getSubstitution(this, (Type)outer.asType());
    }

    public Type superClass() {
        Type superType = (Type)Types.get((Ref)this.def().superType());
        return ((JL5TypeSystem)this.typeSystem()).getSubstitution(this, superType);
    }

    public List<ConstructorInstance> constructors() {
        return new TransformingList(this.def().constructors(), (Transformation)new ConstructorAsSubstitutionTypeTransform(this.ts, this));
    }

    public List<ClassType> memberClasses() {
        return new TransformingList(this.def().memberClasses(), new DerefSubstitutionTransform(this.ts, this));
    }

    public List<MethodInstance> methods() {
        return new TransformingList(this.def().methods(), (Transformation)new MethodAsSubstitutionTypeTransform(this.ts, this));
    }

    public List<Type> interfaces() {
        return new TransformingList(this.def().interfaces(), new DerefSubstitutionTransform(this.ts, this));
    }

    public List<FieldInstance> fields() {
        return new TransformingList(this.def().fields(), (Transformation)new FieldAsSubstitutionTypeTransform(this.ts, this));
    }

    @Override
    public List<TypeVariable> typeVariables() {
        return this.baseType().typeVariables();
    }

    class FieldAsSubstitutionTypeTransform
    implements Transformation<FieldDef, FieldInstance> {
        private final JL5TypeSystem ts;
        private final GenericTypeRef rt;

        public FieldAsSubstitutionTypeTransform(TypeSystem ts, GenericTypeRef rt) {
            this.ts = (JL5TypeSystem)ts;
            this.rt = rt;
        }

        public FieldInstance transform(FieldDef def) {
            FieldInstance fi = def.asInstance();
            Type er = this.ts.getSubstitution(this.rt, fi.type());
            fi = fi.type(er);
            fi = fi.container((StructType)this.rt);
            return fi;
        }
    }

    class MethodAsSubstitutionTypeTransform
    implements Transformation<MethodDef, MethodInstance> {
        private final JL5TypeSystem ts;
        private final GenericTypeRef rt;

        public MethodAsSubstitutionTypeTransform(TypeSystem ts, GenericTypeRef rt) {
            this.ts = (JL5TypeSystem)ts;
            this.rt = rt;
        }

        public MethodInstance transform(MethodDef def) {
            MethodInstance mi = def.asInstance();
            mi = (MethodInstance)mi.container((StructType)this.rt);
            mi = mi.returnType(this.ts.getSubstitution(this.rt, mi.returnType()));
            TransformingList substFormalTypes = new TransformingList(def.formalTypes(), new DerefSubstitutionTransform(this.ts, this.rt));
            mi = mi.formalTypes((List)substFormalTypes);
            return mi;
        }
    }

    class ConstructorAsSubstitutionTypeTransform
    implements Transformation<ConstructorDef, ConstructorInstance> {
        private final JL5TypeSystem ts;
        private final GenericTypeRef rt;

        public ConstructorAsSubstitutionTypeTransform(TypeSystem ts, GenericTypeRef rt) {
            this.ts = (JL5TypeSystem)ts;
            this.rt = rt;
        }

        public ConstructorInstance transform(ConstructorDef def) {
            ConstructorInstance ci = def.asInstance();
            ci = ci.container((StructType)this.rt);
            TransformingList substFormalTypes = new TransformingList(def.formalTypes(), new DerefSubstitutionTransform(this.ts, this.rt));
            ci = ci.formalTypes((List)substFormalTypes);
            return ci;
        }
    }

    class DerefSubstitutionTransform<T extends TypeObject>
    implements Transformation<Ref<? extends T>, T> {
        private final JL5TypeSystem ts;
        private final GenericTypeRef pt;

        public DerefSubstitutionTransform(TypeSystem ts, GenericTypeRef pt) {
            this.ts = (JL5TypeSystem)ts;
            this.pt = pt;
        }

        public T transform(Ref<? extends T> ref) {
            return (T)this.ts.getSubstitution(this.pt, (Type)Types.get(ref));
        }
    }
}

