/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.jl5.types;

import java.util.Collections;
import java.util.List;
import polyglot.ext.jl5.types.IntersectionType;
import polyglot.ext.jl5.types.JL5ProcedureInstance;
import polyglot.ext.jl5.types.JL5TypeSystem;
import polyglot.ext.jl5.types.ParameterizedType;
import polyglot.ext.jl5.types.SignatureType;
import polyglot.ext.jl5.types.TypeVariable;
import polyglot.frontend.Job;
import polyglot.types.ClassDef;
import polyglot.types.ClassType;
import polyglot.types.ClassType_c;
import polyglot.types.Flags;
import polyglot.types.Name;
import polyglot.types.Package;
import polyglot.types.Ref;
import polyglot.types.Resolver;
import polyglot.types.StructType;
import polyglot.types.Type;
import polyglot.types.TypeObject;
import polyglot.types.TypeSystem;
import polyglot.util.Position;

public class TypeVariable_c
extends ClassType_c
implements TypeVariable,
SignatureType {
    protected Name name;
    protected Flags flags;
    protected Type lowerBound;
    protected IntersectionType upperBound;
    protected TypeVariable.TVarDecl declaredIn;
    protected ClassType declaringClass;
    protected JL5ProcedureInstance declaringProcedure;

    public TypeVariable_c(TypeSystem ts, Position pos, Name id, Ref<? extends ClassDef> def, List<Ref<? extends Type>> bounds) {
        super(ts, pos, def);
        this.name = id;
        this.upperBound = ((JL5TypeSystem)ts).intersectionType(bounds);
        this.upperBound.boundOf(this);
        this.flags = Flags.NONE;
    }

    @Override
    public void declaringProcedure(JL5ProcedureInstance pi) {
        this.declaredIn = TypeVariable.TVarDecl.PROCEDURETV;
        this.declaringProcedure = pi;
        this.declaringClass = null;
    }

    @Override
    public void declaringClass(ClassType ct) {
        this.declaredIn = TypeVariable.TVarDecl.CLASSTV;
        this.declaringProcedure = null;
        this.declaringClass = ct;
    }

    @Override
    public TypeVariable.TVarDecl declaredIn() {
        if (this.declaredIn == null) {
            this.declaredIn = TypeVariable.TVarDecl.SYNTHETICTV;
        }
        return this.declaredIn;
    }

    @Override
    public ClassType declaringClass() {
        if (this.declaredIn.equals((Object)TypeVariable.TVarDecl.CLASSTV)) {
            return this.declaringClass;
        }
        return null;
    }

    @Override
    public JL5ProcedureInstance declaringProcedure() {
        if (this.declaredIn.equals((Object)TypeVariable.TVarDecl.PROCEDURETV)) {
            return this.declaringProcedure;
        }
        return null;
    }

    @Override
    public List<Type> bounds() {
        return this.upperBound().boundsTypes();
    }

    @Override
    public void bounds(List<Ref<? extends Type>> b) {
        JL5TypeSystem ts = (JL5TypeSystem)this.typeSystem();
        this.upperBound = ts.intersectionType(b);
        this.upperBound.boundOf(this);
    }

    public ClassDef.Kind kind() {
        return TYPEVARIABLE;
    }

    public ClassType outer() {
        return null;
    }

    public Name name() {
        return this.name;
    }

    public void name(Name name) {
        this.name = name;
    }

    public Package package_() {
        if (TypeVariable.TVarDecl.CLASSTV.equals((Object)this.declaredIn)) {
            return this.declaringClass().package_();
        }
        if (TypeVariable.TVarDecl.PROCEDURETV.equals((Object)this.declaredIn)) {
            return ((ClassDef)this.declaringProcedure().def()).asType().package_();
        }
        return null;
    }

    public Flags flags() {
        return this.flags;
    }

    public List constructors() {
        return Collections.emptyList();
    }

    public List memberClasses() {
        return Collections.emptyList();
    }

    public List methods() {
        return Collections.emptyList();
    }

    public List fields() {
        return Collections.emptyList();
    }

    public List interfaces() {
        return Collections.emptyList();
    }

    public boolean inStaticContext() {
        return false;
    }

    public String translate(Resolver c) {
        return this.name().toString();
    }

    public String toString() {
        return this.name.toString();
    }

    @Override
    public IntersectionType upperBound() {
        return this.upperBound;
    }

    @Override
    public void upperBound(IntersectionType b) {
        this.upperBound = b;
        this.upperBound.boundOf(this);
    }

    public boolean equalsImpl(TypeObject other) {
        if (!(other instanceof TypeVariable)) {
            return super.equalsImpl(other);
        }
        TypeVariable arg2 = (TypeVariable)other;
        if (this.name.equals((Object)arg2.name())) {
            if (this.declaredIn().equals((Object)TypeVariable.TVarDecl.SYNTHETICTV)) {
                return arg2.declaredIn().equals((Object)TypeVariable.TVarDecl.SYNTHETICTV);
            }
            if (this.declaredIn().equals((Object)TypeVariable.TVarDecl.PROCEDURETV)) {
                return arg2.declaredIn().equals((Object)TypeVariable.TVarDecl.PROCEDURETV) && this.declaringProcedure() == arg2.declaringProcedure();
            }
            if (this.declaredIn().equals((Object)TypeVariable.TVarDecl.CLASSTV)) {
                return arg2.declaredIn().equals((Object)TypeVariable.TVarDecl.CLASSTV) && this.ts.equals((TypeObject)this.declaringClass(), (TypeObject)arg2.declaringClass());
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean equivalentImpl(TypeObject other) {
        if (!(other instanceof TypeVariable)) {
            return super.equalsImpl(other);
        }
        TypeVariable arg2 = (TypeVariable)other;
        return this.name.equals((Object)arg2.name());
    }

    @Override
    public boolean isEquivalent(TypeObject arg2) {
        if (arg2 instanceof TypeVariable) {
            if (this.erasureType() instanceof ParameterizedType && ((TypeVariable)arg2).erasureType() instanceof ParameterizedType) {
                return this.typeSystem().equals((TypeObject)((ParameterizedType)this.erasureType()).baseType(), (TypeObject)((ParameterizedType)((TypeVariable)arg2).erasureType()).baseType());
            }
            return this.typeSystem().equals((TypeObject)this.erasureType(), (TypeObject)((TypeVariable)arg2).erasureType());
        }
        return false;
    }

    @Override
    public Type erasureType() {
        return ((JL5TypeSystem)this.typeSystem()).erasure(this.bounds().get(0));
    }

    public ClassType toClass() {
        return this;
    }

    @Override
    public String signature() {
        return "T" + this.name + ";";
    }

    @Override
    public Type lowerBound() {
        if (this.lowerBound == null) {
            return this.typeSystem().Null();
        }
        return this.lowerBound;
    }

    @Override
    public void lowerBound(Type lowerBound) {
        this.lowerBound = lowerBound;
    }

    public ClassType flags(Flags flags) {
        TypeVariable_c t = (TypeVariable_c)this.copy();
        t.flags = flags;
        return t;
    }

    public ClassType container(StructType container) {
        assert (false);
        return null;
    }

    public Job job() {
        assert (false);
        return null;
    }

    public Type superClass() {
        return this.upperBound();
    }

    @Override
    public boolean isTypeVariable() {
        return true;
    }
}

