/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.jl5.types.attributes;

import java.util.LinkedList;
import java.util.List;
import polyglot.ext.jl5.types.TypeVariable;
import polyglot.types.DerefTransform;
import polyglot.types.Ref;
import polyglot.types.Type;
import polyglot.util.Transformation;
import polyglot.util.TransformingList;

public class ClassSignatureAttribute {
    private List<Type> typeVariablesTypes;
    private List<List<Type>> boundsTypes;
    private Type superType;
    private List<Type> interfacesTypes;

    public List<Type> getTypeVariablesTypes() {
        return this.typeVariablesTypes;
    }

    public List<Type> getInterfacesTypes() {
        return this.interfacesTypes;
    }

    public List<List<Type>> getBoundsTypes() {
        return this.boundsTypes;
    }

    public Type getSuperType() {
        return this.superType;
    }

    public ClassSignatureAttribute(List<Ref<? extends Type>> tvRefs, Type superRef, List<Type> interfacesTypes) {
        this.typeVariablesTypes = new TransformingList(tvRefs, (Transformation)new DerefTransform());
        this.extractBounds(tvRefs);
        this.superType = superRef;
        this.interfacesTypes = interfacesTypes;
    }

    private void extractBounds(List<Ref<? extends Type>> tvRefs) {
        this.boundsTypes = new LinkedList<List<Type>>();
        for (Ref<? extends Type> ref : tvRefs) {
            TypeVariable tv = (TypeVariable)ref.get();
            this.boundsTypes.add(tv.bounds());
        }
    }
}

