/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.jl5.types.attributes;

import java.util.Collections;
import java.util.List;
import polyglot.types.DerefTransform;
import polyglot.types.MethodDef;
import polyglot.types.Type;
import polyglot.util.Transformation;
import polyglot.util.TransformingList;

public class MethodSignatureAttribute {
    private Type returnType;
    private List<Type> formalTypes;
    private List<Type> thrownTypes;
    private List<Type> typeVariablesTypes;
    private List<List<Type>> boundsTypes;

    public MethodSignatureAttribute(MethodDef def) {
        this.returnType = (Type)def.returnType().get();
        this.formalTypes = new TransformingList(def.formalTypes(), (Transformation)new DerefTransform());
        this.thrownTypes = new TransformingList(def.throwTypes(), (Transformation)new DerefTransform());
        this.typeVariablesTypes = Collections.EMPTY_LIST;
        this.boundsTypes = Collections.EMPTY_LIST;
    }

    public Type getReturnType() {
        return this.returnType;
    }

    public List<Type> getFormalTypes() {
        return this.formalTypes;
    }

    public List<Type> getThrownTypes() {
        return this.thrownTypes;
    }

    public List<Type> getTypeVariablesTypes() {
        return this.typeVariablesTypes;
    }

    public List<List<Type>> getBoundsTypes() {
        return this.boundsTypes;
    }
}

