/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.jl5.types.inference;

import java.util.ArrayList;
import java.util.List;
import polyglot.ext.jl5.types.AnySubType;
import polyglot.ext.jl5.types.AnySuperType;
import polyglot.ext.jl5.types.ParameterizedType;
import polyglot.ext.jl5.types.TypeVariable;
import polyglot.ext.jl5.types.Wildcard;
import polyglot.ext.jl5.types.inference.Constraint;
import polyglot.ext.jl5.types.inference.InferenceSolver;
import polyglot.types.Type;

public class EqualConstraint
extends Constraint {
    public EqualConstraint(Type actual, Type formal, InferenceSolver solver) {
        super(actual, formal, solver);
    }

    @Override
    public List<Constraint> simplify() {
        ArrayList<Constraint> r;
        block7: {
            block5: {
                block6: {
                    r = new ArrayList<Constraint>();
                    if (!this.formal.isArray()) break block5;
                    if (!this.actual.isArray() || !this.actual.toArray().base().isReference()) break block6;
                    r.add(new EqualConstraint(this.actual.toArray().base(), this.formal.toArray().base(), this.solver));
                    break block7;
                }
                if (!(this.actual instanceof TypeVariable)) break block7;
                TypeVariable actual_tv = (TypeVariable)this.actual;
                for (Type b : actual_tv.bounds()) {
                    if (!b.isArray() || !b.toArray().base().isReference()) continue;
                    r.add(new EqualConstraint(b.toArray().base(), this.formal.toArray().base(), this.solver));
                }
                break block7;
            }
            if (this.formal instanceof ParameterizedType && this.actual instanceof ParameterizedType) {
                ParameterizedType formal_pt = (ParameterizedType)this.formal;
                ParameterizedType actual_pt = (ParameterizedType)this.actual;
                if (formal_pt.baseType().typeEquals((Type)actual_pt.baseType(), null)) {
                    int n = formal_pt.typeArguments().size();
                    for (int i = 0; i < n; ++i) {
                        Type formal_targ = formal_pt.typeArguments().get(i);
                        Type actual_targ = actual_pt.typeArguments().get(i);
                        if (!(formal_targ instanceof Wildcard) && !(actual_targ instanceof Wildcard)) {
                            r.add(new EqualConstraint(actual_targ, formal_targ, this.solver));
                            continue;
                        }
                        if ((!(formal_targ instanceof AnySubType) || !(actual_targ instanceof AnySubType)) && (!(formal_targ instanceof AnySuperType) || !(actual_targ instanceof AnySuperType))) continue;
                        Wildcard formal_targ_wc = (Wildcard)formal_targ;
                        Wildcard actual_targ_wc = (Wildcard)actual_targ;
                        r.add(new EqualConstraint((Type)formal_targ_wc.bound(), (Type)actual_targ_wc.bound(), this.solver));
                    }
                }
            }
        }
        return r;
    }

    @Override
    public boolean canSimplify() {
        return !this.solver.isTargetTypeVariable(this.formal);
    }

    public String toString() {
        return this.actual + " = " + this.formal;
    }
}

