/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.jl5.types.inference;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import polyglot.ext.jl5.types.AnySubType;
import polyglot.ext.jl5.types.AnySuperType;
import polyglot.ext.jl5.types.AnyType;
import polyglot.ext.jl5.types.GenericTypeRef;
import polyglot.ext.jl5.types.IntersectionType;
import polyglot.ext.jl5.types.JL5ParsedClassType;
import polyglot.ext.jl5.types.JL5TypeSystem;
import polyglot.ext.jl5.types.JL5TypeSystem_c;
import polyglot.ext.jl5.types.ParameterizedType;
import polyglot.ext.jl5.types.RawType;
import polyglot.ext.jl5.types.Wildcard;
import polyglot.ext.jl5.types.inference.LubType;
import polyglot.types.ClassType;
import polyglot.types.Ref;
import polyglot.types.Resolver;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.types.Type_c;
import polyglot.types.Types;

public class LubType_c
extends Type_c
implements LubType {
    protected JL5TypeSystem ts;
    protected List<Type> lubElems;
    protected IntersectionType lubCalculated = null;

    public LubType_c(TypeSystem ts, List<Type> lubElems) {
        super(ts);
        this.lubElems = lubElems;
        this.ts = (JL5TypeSystem)ts;
    }

    @Override
    public List<Type> lubElements() {
        return this.lubElems;
    }

    @Override
    public IntersectionType calculateLub() {
        if (this.lubCalculated == null) {
            this.lubCalculated = this.lub_force();
        }
        return this.lubCalculated;
    }

    @Override
    public List<Type> bounds() {
        return this.calculateLub().boundsTypes();
    }

    private IntersectionType lub_force() {
        HashSet<? extends Type> st = new HashSet<Type>();
        HashSet<JL5ParsedClassType> est = null;
        for (Type u : this.lubElems) {
            ArrayList<? extends Type> arrayList = new ArrayList<Type>(this.ts.allAncestorsOf(u));
            st.addAll(arrayList);
            HashSet<JL5ParsedClassType> est_of_u = new HashSet<JL5ParsedClassType>();
            for (Type type : arrayList) {
                if (type instanceof GenericTypeRef) {
                    GenericTypeRef genericTypeRef = (GenericTypeRef)type;
                    est_of_u.add(genericTypeRef.baseType());
                    continue;
                }
                est_of_u.add((JL5ParsedClassType)type);
            }
            if (est == null) {
                est = new HashSet<JL5ParsedClassType>();
                est.addAll(est_of_u);
                continue;
            }
            est.retainAll(est_of_u);
        }
        HashSet mec = new HashSet(est);
        block4: for (Type type : est) {
            for (Type type2 : est) {
                if (this.ts.typeEquals(type, type2, null) || !this.ts.isSubtype(type2, type, null)) continue;
                mec.remove(type);
                continue block4;
            }
        }
        ArrayList<Type> cand = new ArrayList<Type>();
        for (Type m : mec) {
            ArrayList<Type> arrayList = new ArrayList<Type>();
            for (Type type : st) {
                if (!this.ts.typeEquals(m, type, null) && (!(type instanceof GenericTypeRef) || !((GenericTypeRef)type).baseType().typeEquals(m, null))) continue;
                arrayList.add(type);
            }
            cand.add((Type)((ClassType)this.lci(arrayList)));
        }
        try {
            if (this.ts.checkIntersectionBounds(cand, true)) {
                return this.ts.intersectionType(this.ts.toRefTypes(cand));
            }
        }
        catch (SemanticException semanticException) {
            // empty catch block
        }
        List<Type> list = Collections.singletonList(this.ts.Object());
        return this.ts.intersectionType(list);
    }

    private Type lci(List<Type> inv) {
        Type first = inv.get(0);
        if (inv.size() == 1 || first instanceof RawType) {
            return first;
        }
        ParameterizedType res = (ParameterizedType)first;
        for (int i = 1; i < inv.size(); ++i) {
            Type next = inv.get(i);
            if (next instanceof RawType) {
                return next;
            }
            ArrayList<Type> lcta_args = new ArrayList<Type>();
            ParameterizedType nextp = (ParameterizedType)next;
            for (int argi = 0; argi < res.typeArguments().size(); ++argi) {
                Type a1 = res.typeArguments().get(argi);
                Type a2 = nextp.typeArguments().get(argi);
                lcta_args.add(this.lcta(a1, a2));
            }
            res = this.ts.parameterizedType(res.baseType());
            res.typeArguments(lcta_args);
        }
        return res;
    }

    private Type lcta(Type a1, Type a2) {
        if (!(a1 instanceof Wildcard)) {
            if (!(a2 instanceof Wildcard)) {
                if (this.ts.typeEquals(a1, a2, null)) {
                    return a1;
                }
                return this.ts.anySubType((Ref<ClassType>)Types.ref((Object)((ClassType)this.ts.lubType(a1, a2))));
            }
            if (a2 instanceof Wildcard) {
                Wildcard a2wc = (Wildcard)a2;
                if (a2wc instanceof AnyType) {
                    return a2wc;
                }
                if (a2wc instanceof AnySubType) {
                    return this.ts.anySubType((Ref<ClassType>)Types.ref((Object)((ClassType)this.ts.lubType(new Type[]{a1, a2wc.bound()}))));
                }
                if (a2wc instanceof AnySuperType) {
                    return this.ts.anySuperType((Ref<ClassType>)Types.ref((Object)((ClassType)this.glb(a1, (Type)a2wc.bound()))));
                }
            }
        } else {
            Wildcard a1wc = (Wildcard)a1;
            if (!(a2 instanceof Wildcard)) {
                return this.ts.lubType(new Type[]{a1wc.bound(), a2});
            }
            Wildcard a2wc = (Wildcard)a2;
            if (a1wc instanceof AnyType || a2wc instanceof AnyType) {
                return this.ts.anyType();
            }
            if (a1wc instanceof AnySubType && a2wc instanceof AnySubType) {
                return this.ts.anySubType((Ref<ClassType>)Types.ref((Object)((ClassType)this.ts.lubType(new Type[]{a1wc.bound(), a2wc.bound()}))));
            }
            if (a1wc instanceof AnySuperType && a2wc instanceof AnySuperType) {
                return this.ts.anySuperType((Ref<ClassType>)Types.ref((Object)((ClassType)this.glb((Type)a1wc.bound(), (Type)a2wc.bound()))));
            }
            if (this.ts.typeEquals((Type)a1wc.bound(), (Type)a2wc.bound(), null)) {
                return a1wc.bound();
            }
            return this.ts.anyType();
        }
        return this.ts.anyType();
    }

    private Type glb(Type t1, Type t2) {
        ArrayList<Type> l = new ArrayList<Type>();
        l.add(t1);
        l.add(t2);
        try {
            if (!this.ts.checkIntersectionBounds(l, true)) {
                return this.ts.Object();
            }
            return this.ts.intersectionType(this.ts.toRefTypes(l));
        }
        catch (SemanticException e) {
            return this.ts.Object();
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("lub(");
        sb.append(JL5TypeSystem_c.listToString(this.lubElems));
        sb.append(")");
        return sb.toString();
    }

    public String translate(Resolver c) {
        return null;
    }
}

