/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.jl5.types.inference;

import java.util.ArrayList;
import java.util.List;
import polyglot.ext.jl5.types.AnySubType;
import polyglot.ext.jl5.types.AnySuperType;
import polyglot.ext.jl5.types.JL5PrimitiveType;
import polyglot.ext.jl5.types.JL5TypeSystem;
import polyglot.ext.jl5.types.ParameterizedType;
import polyglot.ext.jl5.types.TypeVariable;
import polyglot.ext.jl5.types.Wildcard;
import polyglot.ext.jl5.types.inference.Constraint;
import polyglot.ext.jl5.types.inference.EqualConstraint;
import polyglot.ext.jl5.types.inference.InferenceSolver;
import polyglot.ext.jl5.types.inference.SubTypeConstraint;
import polyglot.ext.jl5.types.inference.SuperConversionConstraint;
import polyglot.types.ObjectType;
import polyglot.types.Type;

public class SubConversionConstraint
extends Constraint {
    public SubConversionConstraint(Type actual, Type formal, InferenceSolver solver) {
        super(actual, formal, solver);
    }

    @Override
    public List<Constraint> simplify() {
        ArrayList<Constraint> r;
        block9: {
            JL5TypeSystem jts;
            block11: {
                block12: {
                    block10: {
                        block8: {
                            jts = (JL5TypeSystem)this.actual.typeSystem();
                            r = new ArrayList<Constraint>();
                            if (!(this.actual instanceof JL5PrimitiveType)) break block8;
                            JL5PrimitiveType prim_actual = (JL5PrimitiveType)this.actual;
                            r.add(new SubConversionConstraint((Type)jts.classOf(prim_actual), this.formal, this.solver));
                            break block9;
                        }
                        if (!this.solver().isTargetTypeVariable(this.formal)) break block10;
                        r.add(new SubTypeConstraint(this.actual, this.formal, this.solver));
                        break block9;
                    }
                    if (!this.formal.isArray()) break block11;
                    if (!this.actual.isArray() || !this.actual.toArray().base().isReference()) break block12;
                    r.add(new SubConversionConstraint(this.actual.toArray().base(), this.formal.toArray().base(), this.solver));
                    break block9;
                }
                if (!(this.actual instanceof TypeVariable)) break block9;
                TypeVariable actual_tv = (TypeVariable)this.actual;
                for (Type b : actual_tv.bounds()) {
                    if (!b.isArray() || !b.toArray().base().isReference()) continue;
                    r.add(new SubConversionConstraint(b.toArray().base(), this.formal.toArray().base(), this.solver));
                }
                break block9;
            }
            if (this.formal instanceof ParameterizedType && this.actual instanceof ParameterizedType) {
                ParameterizedType formal_pt = (ParameterizedType)this.formal;
                ParameterizedType actual_pt = (ParameterizedType)this.actual;
                ParameterizedType s = jts.findGenericSupertype((ObjectType)formal_pt.baseType(), (ObjectType)actual_pt);
                if (s != null) {
                    int n = formal_pt.typeArguments().size();
                    for (int i = 0; i < n; ++i) {
                        Wildcard actual_targ_wc;
                        Wildcard formal_targ_wc;
                        Type formal_targ = formal_pt.typeArguments().get(i);
                        Type actual_targ = s.typeArguments().get(i);
                        if (!(formal_targ instanceof Wildcard) && !(actual_targ instanceof Wildcard)) {
                            r.add(new EqualConstraint(actual_targ, formal_targ, this.solver));
                            continue;
                        }
                        if (formal_targ instanceof AnySubType) {
                            formal_targ_wc = (AnySubType)formal_targ;
                            if (!(actual_targ instanceof Wildcard)) {
                                r.add(new SubConversionConstraint(actual_targ, (Type)formal_targ_wc.bound(), this.solver));
                                continue;
                            }
                            if (!(actual_targ instanceof AnySubType)) continue;
                            actual_targ_wc = (AnySubType)actual_targ;
                            r.add(new SubConversionConstraint((Type)actual_targ_wc.bound(), (Type)formal_targ_wc.bound(), this.solver));
                            continue;
                        }
                        if (!(formal_targ instanceof AnySuperType)) continue;
                        formal_targ_wc = (AnySuperType)formal_targ;
                        if (!(actual_targ instanceof Wildcard)) {
                            r.add(new SuperConversionConstraint(actual_targ, (Type)formal_targ_wc.bound(), this.solver));
                            continue;
                        }
                        if (!(actual_targ instanceof AnySuperType)) continue;
                        actual_targ_wc = (AnySuperType)actual_targ;
                        r.add(new SuperConversionConstraint((Type)actual_targ_wc.bound(), (Type)formal_targ_wc.bound(), this.solver));
                    }
                }
            }
        }
        return r;
    }

    @Override
    public boolean canSimplify() {
        return true;
    }

    public String toString() {
        return this.actual + " << " + this.formal;
    }
}

