/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.jl5.types.reflect;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import polyglot.ext.jl5.JL5Scheduler;
import polyglot.ext.jl5.types.JL5ClassDef;
import polyglot.ext.jl5.types.JL5ConstructorDef;
import polyglot.ext.jl5.types.JL5Flags;
import polyglot.ext.jl5.types.JL5MethodDef;
import polyglot.ext.jl5.types.JL5ParsedClassType;
import polyglot.ext.jl5.types.JL5TypeSystem;
import polyglot.ext.jl5.types.TypeVariable;
import polyglot.ext.jl5.types.reflect.JL5ClassFile;
import polyglot.ext.jl5.types.reflect.JL5Field;
import polyglot.ext.jl5.types.reflect.JL5Method;
import polyglot.ext.jl5.types.reflect.Signature;
import polyglot.frontend.Globals;
import polyglot.types.ArrayType;
import polyglot.types.ClassDef;
import polyglot.types.ConstructorDef;
import polyglot.types.FieldDef;
import polyglot.types.Flags;
import polyglot.types.LazyRef;
import polyglot.types.MethodDef;
import polyglot.types.QName;
import polyglot.types.Ref;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.types.Types;
import polyglot.types.reflect.ClassFile;
import polyglot.types.reflect.ClassFileLazyClassInitializer;
import polyglot.types.reflect.Field;
import polyglot.types.reflect.Method;

public class JL5ClassFileLazyClassInitializer
extends ClassFileLazyClassInitializer {
    protected boolean enumConstantInitialized;
    protected boolean annotationsInitialized;

    public JL5ClassFileLazyClassInitializer(ClassFile file, TypeSystem ts) {
        super(file, ts);
    }

    protected ClassDef createType() throws SemanticException {
        super.createType();
        this.initEnumConstants();
        this.initAnnotations();
        return this.ct;
    }

    public void initEnumConstants() {
    }

    public void initAnnotations() {
    }

    protected boolean hasSignature() {
        return this.getSignature() != null;
    }

    protected Signature getSignature() {
        JL5ClassFile jl5Clazz = (JL5ClassFile)this.clazz;
        return jl5Clazz.getSignature();
    }

    public void initInterfaces() {
        if (this.interfacesInitialized) {
            return;
        }
        if (this.hasSignature()) {
            Signature sig = this.getSignature();
            try {
                sig.parseClassSignature(this, this.ts, null);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (SemanticException e) {
                e.printStackTrace();
            }
            for (Ref<? extends Type> tv : sig.typeVariables()) {
                ((JL5ClassDef)this.ct).addTypeVariable(tv);
            }
            for (Ref<? extends Type> iface : sig.getSuperInterfacesType()) {
                this.ct.addInterface(iface);
            }
            this.ct.superType(sig.getSuperclassType());
            this.interfacesInitialized = true;
            if (this.initialized()) {
                this.clazz = null;
            }
        } else {
            super.initInterfaces();
        }
    }

    public FieldDef fieldInstance(Field field, ClassDef ct) {
        JL5TypeSystem jts = (JL5TypeSystem)this.ts;
        JL5Field jl5f = (JL5Field)field;
        Signature signature = jl5f.getSignature();
        FieldDef fd = super.fieldInstance(field, ct);
        if (signature != null) {
            try {
                signature.parseFieldSignature(this, jts, fd.position(), ct);
            }
            catch (SemanticException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (signature.fieldSignature != null) {
                fd.setType(signature.fieldSignature.type);
            }
        }
        return fd;
    }

    protected MethodDef methodInstance(Method method, ClassDef ct) {
        MethodDef md = super.methodInstance(method, ct);
        JL5Method jl5m = (JL5Method)method;
        Signature signature = jl5m.getSignature();
        if (signature != null) {
            try {
                signature.parseMethodSignature(this, this.ts, md.position(), ct);
            }
            catch (IOException e) {
                // empty catch block
            }
            JL5MethodDef jl5Md = (JL5MethodDef)md;
            jl5Md.setTypeVariableTypes(signature.methodSignature.typeVars());
            md.setReturnType(signature.methodSignature.returnType());
            md.setFormalTypes(signature.methodSignature.formalTypes());
        }
        if (JL5Flags.isVarargs(md.flags())) {
            ArrayList<Ref> newFormals = new ArrayList<Ref>();
            Iterator it = md.formalTypes().iterator();
            while (it.hasNext()) {
                Ref refType = (Ref)it.next();
                Type t = (Type)refType.get();
                if (!it.hasNext()) {
                    ArrayType at = ((JL5TypeSystem)this.ts).createArrayType(t.position(), (Ref<? extends Type>)Types.ref((Object)((ArrayType)t).base()), true);
                    newFormals.add(Types.ref((Object)at));
                    continue;
                }
                newFormals.add(Types.ref((Object)t));
            }
            md.setFormalTypes(newFormals);
        }
        return md;
    }

    protected ConstructorDef constructorInstance(Method method, ClassDef ct, Field[] fields) {
        ConstructorDef cd = super.constructorInstance(method, ct, fields);
        JL5Method jl5m = (JL5Method)method;
        Signature signature = jl5m.getSignature();
        if (signature != null) {
            try {
                signature.parseMethodSignature(this, this.ts, cd.position(), ct);
            }
            catch (IOException e) {
                // empty catch block
            }
            JL5ConstructorDef jl5cd = (JL5ConstructorDef)cd;
            jl5cd.setTypeVariableTypes(signature.methodSignature.typeVars());
            cd.setFormalTypes(signature.methodSignature.formalTypes());
        }
        if (cd.flags().isTransient()) {
            assert (false);
            ArrayList<Ref> newFormals = new ArrayList<Ref>();
            Iterator it = cd.formalTypes().iterator();
            while (it.hasNext()) {
                Ref t = (Ref)it.next();
                if (!it.hasNext()) {
                    ArrayType at = ((JL5TypeSystem)this.ts).createArrayType(((Type)t.get()).position(), (Ref<? extends Type>)Types.ref((Object)((ArrayType)t).base()), true);
                    newFormals.add(Types.ref((Object)at));
                    continue;
                }
                newFormals.add(t);
            }
            cd.setFormalTypes(newFormals);
        }
        return cd;
    }

    public Ref<? extends Type> typeForName(String name, List<Ref<TypeVariable>> tvList) {
        if (tvList != null && !tvList.isEmpty()) {
            Ref defRef = this.defForName(name);
            JL5ParsedClassType type = (JL5ParsedClassType)this.ts.createClassType(this.position(), defRef);
            JL5TypeSystem jts = (JL5TypeSystem)this.ts;
            List<Ref<? extends Type>> typeArguments = tvList;
            return Types.ref((Object)((JL5TypeSystem)this.ts).parameterizedType(jts.rawType(type, (Ref<ClassDef>)defRef), (Ref<ClassDef>)defRef, typeArguments));
        }
        return this.typeForName(name);
    }

    public Ref<ClassDef> defForName(String name, Flags flags, List<Ref<TypeVariable>> tvList) {
        if (tvList.isEmpty()) {
            return super.defForName(name, flags);
        }
        assert (flags == null);
        LazyRef sym2 = Types.lazyRef((Object)this.ts.unknownClassDef(), null);
        sym2.setResolver(((JL5Scheduler)Globals.Scheduler()).LookupGlobalTypeDef((LazyRef<ClassDef>)sym2, QName.make((String)name), tvList));
        return sym2;
    }
}

