/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.jl5.types.reflect;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import polyglot.ext.jl5.types.reflect.Signature;
import polyglot.types.reflect.Attribute;
import polyglot.types.reflect.ClassFile;
import polyglot.types.reflect.Constant;
import polyglot.types.reflect.ConstantValue;
import polyglot.types.reflect.Field;

public class JL5Field
extends Field {
    protected Signature signature;

    public JL5Field(DataInputStream in, ClassFile clazz) throws IOException {
        super(in, clazz);
    }

    public void initialize() throws IOException {
        this.modifiers = this.in.readUnsignedShort();
        this.name = this.in.readUnsignedShort();
        this.type = this.in.readUnsignedShort();
        int numAttributes = this.in.readUnsignedShort();
        this.attrs = new Attribute[numAttributes];
        for (int i = 0; i < numAttributes; ++i) {
            long n;
            int nameIndex = this.in.readUnsignedShort();
            int length = this.in.readInt();
            Constant name = this.clazz.getConstants()[nameIndex];
            if (name != null) {
                if ("ConstantValue".equals(name.value())) {
                    this.constantValue = new ConstantValue(this.in, nameIndex, length);
                    this.attrs[i] = this.constantValue;
                }
                if ("Synthetic".equals(name.value())) {
                    this.synthetic = true;
                }
                if ("Signature".equals(name.value())) {
                    this.signature = new Signature(this.in, nameIndex, length, this.clazz);
                    this.attrs[i] = this.signature;
                }
            }
            if (this.attrs[i] != null || (n = this.in.skip(length)) == (long)length) continue;
            throw new EOFException();
        }
    }

    public Signature getSignature() {
        return this.signature;
    }
}

