/*
 * Decompiled with CFR 0.152.
 */
package hj.parser;

import hj.parser.HjKWLexer;
import hj.parser.HjLexerprs;
import hj.parser.HjParsersym;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import lpg.runtime.Differ;
import lpg.runtime.DifferLines;
import lpg.runtime.DifferTokens;
import lpg.runtime.ILexStream;
import lpg.runtime.IPrsStream;
import lpg.runtime.IntTuple;
import lpg.runtime.LexParser;
import lpg.runtime.LpgLexStream;
import lpg.runtime.Monitor;
import lpg.runtime.ParseTable;
import lpg.runtime.PrsStream;
import lpg.runtime.RuleAction;

public class HjLexer
implements RuleAction {
    private HjLexerLpgLexStream lexStream;
    private static ParseTable prs = new HjLexerprs();
    private LexParser lexParser = new LexParser();
    HjKWLexer kwLexer;
    boolean printTokens;
    private static final int ECLIPSE_TAB_VALUE = 4;
    private static int LINES = 0;
    private static int TOKENS = 1;
    private static int JAVA = 2;
    private static int Hj;
    private static int differ_mode;
    private static boolean ignore_braces;
    private static boolean dump_input;
    private static String extension;
    private static int changeCount;
    private static int insertCount;
    private static int deleteCount;
    private static int moveCount;
    protected static int fileCount;
    protected static int lineCount;
    protected static int leftBraceCount;
    protected static int rightBraceCount;
    protected static int classCount;
    protected static int interfaceCount;
    protected static int statementCount;

    public ParseTable getParseTable() {
        return prs;
    }

    public LexParser getParser() {
        return this.lexParser;
    }

    public int getToken(int i) {
        return this.lexParser.getToken(i);
    }

    public int getRhsFirstTokenIndex(int i) {
        return this.lexParser.getFirstToken(i);
    }

    public int getRhsLastTokenIndex(int i) {
        return this.lexParser.getLastToken(i);
    }

    public int getLeftSpan() {
        return this.lexParser.getToken(1);
    }

    public int getRightSpan() {
        return this.lexParser.getLastToken();
    }

    public void resetKeywordLexer() {
        if (this.kwLexer == null) {
            this.kwLexer = new HjKWLexer(this.lexStream.getInputChars(), 34);
        } else {
            this.kwLexer.setInputChars(this.lexStream.getInputChars());
        }
    }

    public void reset(String filename, int tab) throws IOException {
        this.lexStream = new HjLexerLpgLexStream(filename, tab);
        this.lexParser.reset((ILexStream)this.lexStream, prs, (RuleAction)this);
        this.resetKeywordLexer();
    }

    public void reset(char[] input_chars, String filename) {
        this.reset(input_chars, filename, 1);
    }

    public void reset(char[] input_chars, String filename, int tab) {
        this.lexStream = new HjLexerLpgLexStream(input_chars, filename, tab);
        this.lexParser.reset((ILexStream)this.lexStream, prs, (RuleAction)this);
        this.resetKeywordLexer();
    }

    public HjLexer(String filename, int tab) throws IOException {
        this.reset(filename, tab);
    }

    public HjLexer(char[] input_chars, String filename, int tab) {
        this.reset(input_chars, filename, tab);
    }

    public HjLexer(char[] input_chars, String filename) {
        this.reset(input_chars, filename, 1);
    }

    public HjLexer() {
    }

    public ILexStream getILexStream() {
        return this.lexStream;
    }

    public ILexStream getLexStream() {
        return this.lexStream;
    }

    private void initializeLexer(IPrsStream prsStream, int start_offset, int end_offset) {
        if (this.lexStream.getInputChars() == null) {
            throw new NullPointerException("LexStream was not initialized");
        }
        this.lexStream.setPrsStream(prsStream);
        prsStream.makeToken(start_offset, end_offset, 0);
    }

    private void addEOF(IPrsStream prsStream, int end_offset) {
        prsStream.makeToken(end_offset, end_offset, 137);
        prsStream.setStreamLength(prsStream.getSize());
    }

    public void lexer(IPrsStream prsStream) {
        this.lexer(null, prsStream);
    }

    public void lexer(Monitor monitor, IPrsStream prsStream) {
        this.initializeLexer(prsStream, 0, -1);
        this.lexParser.parseCharacters(monitor);
        this.addEOF(prsStream, this.lexStream.getStreamIndex());
    }

    public void lexer(IPrsStream prsStream, int start_offset, int end_offset) {
        this.lexer(null, prsStream, start_offset, end_offset);
    }

    public void lexer(Monitor monitor, IPrsStream prsStream, int start_offset, int end_offset) {
        if (start_offset <= 1) {
            this.initializeLexer(prsStream, 0, -1);
        } else {
            this.initializeLexer(prsStream, start_offset - 1, start_offset - 1);
        }
        this.lexParser.parseCharacters(monitor, start_offset, end_offset);
        this.addEOF(prsStream, end_offset >= this.lexStream.getStreamIndex() ? this.lexStream.getStreamIndex() : end_offset + 1);
    }

    public void reportLexicalError(int startLoc, int endLoc) {
        IPrsStream prs_stream = this.lexStream.getPrsStream();
        if (prs_stream == null) {
            this.lexStream.reportLexicalError(startLoc, endLoc);
        } else {
            for (int i = prs_stream.getSize() - 1; i > 0 && prs_stream.getStartOffset(i) >= startLoc; --i) {
                prs_stream.removeLastToken();
            }
            prs_stream.makeToken(startLoc, endLoc, 0);
        }
    }

    public int[] getKeywordKinds() {
        return this.kwLexer.getKeywordKinds();
    }

    public HjLexer(String filename) throws IOException {
        this(filename, 4);
        this.kwLexer = new HjKWLexer(this.lexStream.getInputChars(), 34);
    }

    public void initialize(char[] content, String filename) {
        this.reset(content, filename);
    }

    final void makeToken(int left_token, int right_token, int kind) {
        this.lexStream.makeToken(left_token, right_token, kind);
    }

    final void makeToken(int kind) {
        int startOffset = this.getLeftSpan();
        int endOffset = this.getRightSpan();
        this.lexStream.makeToken(startOffset, endOffset, kind);
        if (this.printTokens) {
            this.printValue(startOffset, endOffset);
        }
    }

    final void makeComment(int kind) {
        int startOffset = this.getLeftSpan();
        int endOffset = this.getRightSpan();
        this.lexStream.getIPrsStream().makeAdjunct(startOffset, endOffset, kind);
    }

    final void skipToken() {
        if (this.printTokens) {
            this.printValue(this.getLeftSpan(), this.getRightSpan());
        }
    }

    final void checkForKeyWord() {
        int startOffset = this.getLeftSpan();
        int endOffset = this.getRightSpan();
        int kwKind = this.kwLexer.lexer(startOffset, endOffset);
        this.lexStream.makeToken(startOffset, endOffset, kwKind);
        if (this.printTokens) {
            this.printValue(startOffset, endOffset);
        }
    }

    final void checkForKeyWord(int defaultKind) {
        int endOffset;
        int startOffset = this.getLeftSpan();
        int kwKind = this.kwLexer.lexer(startOffset, endOffset = this.getRightSpan());
        if (kwKind == 34) {
            kwKind = defaultKind;
        }
        this.lexStream.makeToken(startOffset, endOffset, kwKind);
        if (this.printTokens) {
            this.printValue(startOffset, endOffset);
        }
    }

    final void printValue(int startOffset, int endOffset) {
        String s = new String(this.lexStream.getInputChars(), startOffset, endOffset - startOffset + 1);
        System.out.print(s);
    }

    public HjLexer(Reader reader, String filename) throws IOException {
        char[] block;
        int n;
        ArrayList<char[]> buffers = new ArrayList<char[]>();
        int size = 0;
        while ((n = reader.read(block = new char[8192], 0, block.length)) >= 0) {
            size += n;
            buffers.add(block);
        }
        char[] buffer = new char[size];
        for (int i = 0; i < buffers.size(); ++i) {
            char[] block2 = (char[])buffers.get(i);
            int blocksize = size / block2.length > 0 ? block2.length : size;
            size -= blocksize;
            System.arraycopy(block2, 0, buffer, i * block2.length, blocksize);
        }
        assert (size == 0);
        this.initialize(buffer, filename);
        this.kwLexer = new HjKWLexer(this.lexStream.getInputChars(), 34);
    }

    private static void computeStats(String file) {
        try {
            ++fileCount;
            HjLexer lexer = new HjLexer(file);
            PrsStream stream = new PrsStream(lexer.getILexStream());
            lexer.lexer((IPrsStream)stream);
            DifferJava diff = differ_mode == JAVA ? new DifferJava(dump_input, stream) : new DifferHj(dump_input, stream);
            lineCount += stream.getLexStream().getLineCount();
            classCount += diff.getClassCount();
            interfaceCount += diff.getInterfaceCount();
            statementCount += diff.getElementCount() - diff.getLeftBraceCount() - diff.getRightBraceCount();
            leftBraceCount += diff.getLeftBraceCount();
            rightBraceCount += diff.getRightBraceCount();
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
        }
    }

    private static void computeStats(File dir) {
        try {
            File[] file = dir.listFiles();
            for (int i = 0; i < file.length; ++i) {
                if (file[i].isDirectory()) {
                    HjLexer.computeStats(file[i]);
                    continue;
                }
                if (!file[i].getName().endsWith(extension)) continue;
                HjLexer.computeStats(file[i].getPath());
            }
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
        }
    }

    private static void compareFiles(String old_file, String new_file) {
        try {
            HjLexer new_lexer;
            HjLexer old_lexer;
            char[] input_chars;
            if (old_file.equals("")) {
                input_chars = new char[]{};
                old_lexer = new HjLexer(input_chars, "null_file");
            } else {
                old_lexer = new HjLexer(old_file);
            }
            if (new_file.equals("")) {
                input_chars = new char[]{};
                new_lexer = new HjLexer(input_chars, "null_file");
            } else {
                new_lexer = new HjLexer(new_file);
            }
            PrsStream old_stream = new PrsStream(old_lexer.getILexStream());
            old_lexer.lexer((IPrsStream)old_stream);
            PrsStream new_stream = new PrsStream(new_lexer.getILexStream());
            new_lexer.lexer((IPrsStream)new_stream);
            DifferLines diff = differ_mode == LINES ? new DifferLines((IPrsStream)old_stream, (IPrsStream)new_stream) : (differ_mode == TOKENS ? new DifferTokens((IPrsStream)old_stream, (IPrsStream)new_stream) : (differ_mode == JAVA ? new DifferJava(old_stream, new_stream) : new DifferHj(old_stream, new_stream)));
            diff.compare();
            if (diff.getChangeCount() > 0) {
                diff.outputChanges();
                changeCount += diff.getChangeCount();
                insertCount += diff.getInsertCount() + diff.getReplaceInsertCount();
                deleteCount += diff.getDeleteCount() + diff.getReplaceDeleteCount();
                moveCount += diff.getMoveCount();
            }
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
        }
    }

    private static void compareDirectories(File old_dir, File new_dir) {
        try {
            int i;
            File[] old_file = old_dir.listFiles();
            File[] new_file = new_dir.listFiles();
            HashMap<String, File> old_map = new HashMap<String, File>();
            for (i = 0; i < old_file.length; ++i) {
                String name = old_file[i].getName();
                if (!old_file[i].isDirectory() && !name.endsWith(extension)) continue;
                old_map.put(name, old_file[i]);
            }
            for (i = 0; i < new_file.length; ++i) {
                File file = (File)old_map.get(new_file[i].getName());
                if (file != null) {
                    old_map.remove(new_file[i].getName());
                    if (file.isDirectory() && new_file[i].isDirectory()) {
                        HjLexer.compareDirectories(file, new_file[i]);
                        continue;
                    }
                    HjLexer.compareFiles(file.getPath(), new_file[i].getPath());
                    continue;
                }
                if (!new_file[i].isDirectory() && !new_file[i].getName().endsWith(extension)) continue;
                String s = new_file[i].getName() + " found in directory " + new_dir.getPath() + " does not exist in directory " + old_dir.getPath();
                System.err.println("*Warning: " + s);
                if (new_file[i].isDirectory()) continue;
                HjLexer.compareFiles("", new_file[i].getPath());
            }
            for (Map.Entry e : old_map.entrySet()) {
                File file = (File)e.getValue();
                String s = file.getName() + " found in directory " + old_dir.getPath() + " does not exist in directory " + new_dir.getPath();
                System.err.println("*Warning: " + s);
                if (file.isDirectory()) continue;
                HjLexer.compareFiles(file.getPath(), "");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        int i;
        String new_file = null;
        String old_file = null;
        boolean help = false;
        for (i = 0; i < args.length && args[i].charAt(0) == '-'; ++i) {
            if (args[i].equals("-b")) {
                ignore_braces = false;
                continue;
            }
            if (args[i].equals("-d")) {
                dump_input = true;
                continue;
            }
            if (args[i].equals("-ext")) {
                extension = i + 1 < args.length ? args[++i] : "";
                continue;
            }
            if (args[i].equals("-h")) {
                help = true;
                continue;
            }
            if (args[i].equals("-j")) {
                differ_mode = JAVA;
                continue;
            }
            if (args[i].equals("-l")) {
                differ_mode = LINES;
                continue;
            }
            if (args[i].equals("-t")) {
                differ_mode = TOKENS;
                continue;
            }
            if (!args[i].equals("-x")) continue;
            differ_mode = Hj;
        }
        if (i < args.length) {
            old_file = new_file = args[i++];
        }
        if (i < args.length) {
            old_file = args[i++];
        }
        while (i < args.length) {
            System.err.println("Invalid argument: " + args[i]);
            ++i;
        }
        if (help || new_file == null && old_file == null) {
            System.out.println();
            System.out.println("Usage: diff [OPTION]... file1 [file2]");
            System.out.println("Compute stats for file1 or compare file1 to file2 statement by statement.");
            System.out.println();
            System.out.println("  -b     -- do not ignore braces");
            System.out.println("  -d     -- if file2 is not specified, dump the relevant content of file1");
            System.out.println("  -ext s -- if file1 and file2 are directories, compare only files that end\n            with the extension (suffix) s.");
            System.out.println("  -h     -- print this help message");
            System.out.println("  -j     -- assume input is Java");
            System.out.println("  -l     -- compare line by line instead of statement by statement");
            System.out.println("  -t     -- compare token by token instead of statement by statement");
            System.out.println("  -x     -- assume input is Hj (default)");
        } else if (old_file.equals(new_file)) {
            assert (old_file != null);
            assert (new_file != null);
            File old_dir = new File(old_file);
            if (old_dir.isDirectory()) {
                HjLexer.computeStats(old_dir);
            } else {
                HjLexer.computeStats(old_file);
            }
            System.out.println("Stats for " + old_file + ":");
            System.out.println("    Number of files: " + fileCount);
            System.out.println("    Number of lines: " + lineCount);
            System.out.println("    Number of types (classes/interfaces): " + (classCount + interfaceCount) + " (" + classCount + "/" + interfaceCount + ")");
            System.out.println("    Number of statements: " + statementCount);
            System.out.println("    Number of braces (left/right): (" + leftBraceCount + "/" + rightBraceCount + ")");
        } else {
            assert (old_file != null);
            assert (new_file != null);
            File old_dir = new File(old_file);
            File new_dir = new File(new_file);
            if (old_dir.isDirectory() && new_dir.isDirectory()) {
                HjLexer.compareDirectories(old_dir, new_dir);
            } else {
                HjLexer.compareFiles(old_file, new_file);
            }
            if (changeCount == 0) {
                System.out.println("***** No difference *****");
            } else {
                System.out.println("***** " + changeCount + " different " + (changeCount == 1 ? "section" : "sections") + " *****");
                System.out.println("    " + moveCount + " statements moved");
                System.out.println("    " + insertCount + " statements inserted");
                System.out.println("    " + deleteCount + " statements deleted");
            }
        }
    }

    public void ruleAction(int ruleNumber) {
        switch (ruleNumber) {
            case 1: {
                this.checkForKeyWord();
                break;
            }
            case 2: {
                this.makeToken(68);
                break;
            }
            case 3: {
                this.makeToken(67);
                break;
            }
            case 4: {
                this.makeToken(63);
                break;
            }
            case 5: {
                this.makeToken(64);
                break;
            }
            case 6: {
                this.makeToken(65);
                break;
            }
            case 7: {
                this.makeToken(66);
                break;
            }
            case 10: {
                this.skipToken();
                break;
            }
            case 11: {
                this.makeToken(98);
                break;
            }
            case 12: {
                this.makeToken(97);
                break;
            }
            case 13: {
                this.makeToken(115);
                break;
            }
            case 14: {
                this.makeToken(128);
                break;
            }
            case 15: {
                this.makeToken(1);
                break;
            }
            case 16: {
                this.makeToken(49);
                break;
            }
            case 17: {
                this.makeToken(102);
                break;
            }
            case 18: {
                this.makeToken(76);
                break;
            }
            case 19: {
                this.makeToken(85);
                break;
            }
            case 20: {
                this.makeToken(51);
                break;
            }
            case 21: {
                this.makeToken(116);
                break;
            }
            case 22: {
                this.makeToken(124);
                break;
            }
            case 23: {
                this.makeToken(100);
                break;
            }
            case 24: {
                this.makeToken(112);
                break;
            }
            case 25: {
                this.makeToken(105);
                break;
            }
            case 26: {
                this.makeToken(83);
                break;
            }
            case 27: {
                this.makeToken(78);
                break;
            }
            case 28: {
                this.makeToken(77);
                break;
            }
            case 29: {
                this.makeToken(96);
                break;
            }
            case 30: {
                this.makeToken(50);
                break;
            }
            case 31: {
                this.makeToken(99);
                break;
            }
            case 32: {
                this.makeToken(80);
                break;
            }
            case 33: {
                this.makeToken(101);
                break;
            }
            case 34: {
                this.makeToken(109);
                break;
            }
            case 35: {
                this.makeToken(35);
                break;
            }
            case 36: {
                this.makeToken(58);
                break;
            }
            case 37: {
                this.makeToken(57);
                break;
            }
            case 38: {
                this.makeToken(118);
                break;
            }
            case 39: {
                this.makeToken(110);
                break;
            }
            case 40: {
                this.makeToken(113);
                break;
            }
            case 41: {
                this.makeToken(117);
                break;
            }
            case 42: {
                this.makeToken(132);
                break;
            }
            case 43: {
                this.makeToken(123);
                break;
            }
            case 44: {
                this.makeToken(127);
                break;
            }
            case 45: {
                this.makeToken(129);
                break;
            }
            case 46: {
                this.makeToken(126);
                break;
            }
            case 47: {
                this.makeToken(131);
                break;
            }
            case 48: {
                this.makeToken(130);
                break;
            }
            case 49: {
                this.makeToken(125);
                break;
            }
            case 50: {
                this.makeToken(133);
                break;
            }
            case 51: {
                this.makeToken(120);
                break;
            }
            case 52: {
                this.makeToken(114);
                break;
            }
            case 53: {
                this.makeToken(134);
                break;
            }
            case 68: {
                if (this.lexStream.getKind(this.getRhsFirstTokenIndex(3)) == 81 && this.lexStream.getKind(this.lexStream.getNext(this.getRhsFirstTokenIndex(3))) != 81) {
                    this.makeComment(150);
                    break;
                }
                this.makeComment(149);
                break;
            }
            case 75: {
                this.makeComment(148);
                break;
            }
            case 355: {
                this.makeToken(53);
                break;
            }
        }
    }

    static {
        differ_mode = Hj = 3;
        ignore_braces = true;
        dump_input = false;
        extension = "";
        changeCount = 0;
        insertCount = 0;
        deleteCount = 0;
        moveCount = 0;
        fileCount = 0;
        lineCount = 0;
        leftBraceCount = 0;
        rightBraceCount = 0;
        classCount = 0;
        interfaceCount = 0;
    }

    public static class DifferHj
    extends DifferJava {
        protected DifferHj() {
        }

        public DifferHj(PrsStream newStream, PrsStream oldStream) {
            super(newStream, oldStream);
        }

        public DifferHj(boolean dump_input, PrsStream stream) {
            this.dump_input = dump_input;
            Differ.ILine[] lines = this.getBuffer(stream);
        }

        public Differ.ILine[] getBuffer(PrsStream stream) {
            IntTuple line_start = new IntTuple();
            int left_brace_count = 0;
            int right_brace_count = 0;
            int class_count = 0;
            int interface_count = 0;
            line_start.add(0);
            int token = 1;
            block2: while (token < stream.getSize()) {
                line_start.add(token);
                if (stream.getKind(token) == 80) {
                    ++left_brace_count;
                    ++token;
                    continue;
                }
                if (stream.getKind(token) == 101) {
                    ++right_brace_count;
                    ++token;
                    continue;
                }
                if ((stream.getKind(token) == 136 || stream.getKind(token) == 17) && token + 1 < stream.getSize()) {
                    ++token;
                }
                if (stream.getKind(token) == 84 || stream.getKind(token) == 90 || stream.getKind(token) == 13 || stream.getKind(token) == 91 || stream.getKind(token) == 48 || stream.getKind(token) == 44 || stream.getKind(token) == 28) {
                    token = this.balanceParentheses(stream, token + 1);
                    continue;
                }
                if (stream.getKind(token) == 19 || stream.getKind(token) == 13 || stream.getKind(token) == 73) {
                    token = this.balanceParentheses(stream, token + 1);
                    token = this.balanceParentheses(stream, token);
                    continue;
                }
                if (stream.getKind(token) == 121 || stream.getKind(token) == 122) {
                    while (token < stream.getSize()) {
                        if (stream.getKind(token) == 85) {
                            ++token;
                            continue block2;
                        }
                        if (stream.getKind(token) == 80 || stream.getKind(token) == 101) continue block2;
                        ++token;
                    }
                    continue;
                }
                while (token < stream.getSize()) {
                    try {
                        if (stream.getKind(token) == 79 && stream.getKind(token + 1) == 34) {
                            ++class_count;
                        } else if (stream.getKind(token) == 81 && stream.getKind(token + 1) == 34) {
                            ++interface_count;
                        }
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        // empty catch block
                    }
                    if (stream.getKind(token) == 51) {
                        ++token;
                        continue block2;
                    }
                    if (stream.getKind(token) == 80 || stream.getKind(token) == 101) continue block2;
                    ++token;
                }
            }
            DifferLines.Line[] buffer = new DifferLines.Line[line_start.size() - (ignore_braces ? left_brace_count + right_brace_count : 0)];
            buffer[0] = new DifferLines.Line((DifferLines)this, (IPrsStream)stream, 0, 0);
            line_start.add(stream.getSize());
            int index = 1;
            for (int line_no = 1; line_no < line_start.size() - 1; ++line_no) {
                if (ignore_braces && (stream.getKind(line_start.get(line_no)) == 80 || stream.getKind(line_start.get(line_no)) == 101)) continue;
                buffer[index++] = new DifferLines.Line((DifferLines)this, (IPrsStream)stream, line_start.get(line_no), line_start.get(line_no + 1));
            }
            assert (buffer.length == index);
            leftBraceCount += left_brace_count;
            rightBraceCount += right_brace_count;
            classCount += class_count;
            interfaceCount += interface_count;
            statementCount += buffer.length - 2;
            if (this.dump_input) {
                System.out.println();
                System.out.println("Dumping file " + stream.getFileName());
                for (int i = 1; i < buffer.length; ++i) {
                    System.out.println("    " + i + " " + buffer[i].toString());
                }
            }
            return buffer;
        }
    }

    public static class DifferJava
    extends DifferLines
    implements HjParsersym {
        boolean dump_input = false;
        private int leftBraceCount = 0;
        private int rightBraceCount = 0;
        private int classCount = 0;
        private int interfaceCount = 0;
        private int elementCount;

        protected DifferJava() {
        }

        public DifferJava(PrsStream newStream, PrsStream oldStream) {
            super((IPrsStream)newStream, (IPrsStream)oldStream);
        }

        public DifferJava(boolean dump_input, PrsStream stream) {
            this.dump_input = dump_input;
            Differ.ILine[] lines = this.getBuffer(stream);
        }

        public int getLeftBraceCount() {
            return this.leftBraceCount;
        }

        public int getRightBraceCount() {
            return this.rightBraceCount;
        }

        public int getClassCount() {
            return this.classCount;
        }

        public int getInterfaceCount() {
            return this.interfaceCount;
        }

        public int getElementCount() {
            return this.elementCount;
        }

        public int balanceParentheses(PrsStream stream, int token) {
            int count = 0;
            if (stream.getKind(token) == 1) {
                ++count;
                ++token;
                while (token < stream.getSize()) {
                    if (stream.getKind(token) == 1) {
                        ++count;
                    } else if (stream.getKind(token) == 49 && --count == 0) {
                        ++token;
                        break;
                    }
                    ++token;
                }
            }
            return token;
        }

        public Differ.ILine[] getBuffer(PrsStream stream) {
            IntTuple line_start = new IntTuple();
            int left_brace_count = 0;
            int right_brace_count = 0;
            int class_count = 0;
            int interface_count = 0;
            line_start.add(0);
            int token = 1;
            block2: while (token < stream.getSize()) {
                line_start.add(token);
                if (stream.getKind(token) == 80) {
                    ++left_brace_count;
                    ++token;
                    continue;
                }
                if (stream.getKind(token) == 101) {
                    ++right_brace_count;
                    ++token;
                    continue;
                }
                if (stream.getKind(token) == 136 && token + 1 < stream.getSize()) {
                    ++token;
                }
                if (stream.getKind(token) == 84 || stream.getKind(token) == 90 || stream.getKind(token) == 91 || stream.getKind(token) == 93) {
                    token = this.balanceParentheses(stream, token + 1);
                    continue;
                }
                if (stream.getKind(token) == 121 || stream.getKind(token) == 122) {
                    while (token < stream.getSize()) {
                        if (stream.getKind(token) == 85) {
                            ++token;
                            continue block2;
                        }
                        if (stream.getKind(token) == 80 || stream.getKind(token) == 101) continue block2;
                        ++token;
                    }
                    continue;
                }
                while (token < stream.getSize()) {
                    try {
                        if (stream.getKind(token) == 79 && stream.getKind(token + 1) == 34) {
                            ++class_count;
                        } else if (stream.getKind(token) == 81 && stream.getKind(token + 1) == 34) {
                            ++interface_count;
                        }
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        // empty catch block
                    }
                    if (stream.getKind(token) == 51) {
                        ++token;
                        continue block2;
                    }
                    if (stream.getKind(token) == 80 || stream.getKind(token) == 101) continue block2;
                    ++token;
                }
            }
            DifferLines.Line[] buffer = new DifferLines.Line[line_start.size() - (ignore_braces ? left_brace_count + right_brace_count : 0)];
            buffer[0] = new DifferLines.Line((DifferLines)this, (IPrsStream)stream, 0, 0);
            line_start.add(stream.getSize());
            int index = 1;
            for (int line_no = 1; line_no < line_start.size() - 1; ++line_no) {
                if (ignore_braces && (stream.getKind(line_start.get(line_no)) == 80 || stream.getKind(line_start.get(line_no)) == 101)) continue;
                buffer[index++] = new DifferLines.Line((DifferLines)this, (IPrsStream)stream, line_start.get(line_no), line_start.get(line_no + 1));
            }
            assert (buffer.length == index);
            this.leftBraceCount += left_brace_count;
            this.rightBraceCount += right_brace_count;
            this.classCount += class_count;
            this.interfaceCount += interface_count;
            this.elementCount += buffer.length - 2;
            if (this.dump_input) {
                System.out.println();
                System.out.println("Dumping file " + stream.getFileName());
                for (int i = 1; i < buffer.length; ++i) {
                    System.out.println("    " + i + " " + buffer[i].toString());
                }
            }
            return buffer;
        }
    }

    static class HjLexerLpgLexStream
    extends LpgLexStream {
        public static final int[] tokenKind = new int[]{102, 102, 102, 102, 102, 102, 102, 102, 102, 37, 100, 102, 38, 101, 102, 102, 102, 102, 102, 102, 102, 102, 102, 102, 102, 102, 102, 102, 102, 102, 102, 102, 73, 83, 34, 99, 75, 82, 76, 24, 95, 96, 81, 35, 94, 36, 31, 80, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 87, 88, 78, 18, 79, 93, 84, 21, 22, 23, 13, 17, 14, 54, 55, 56, 57, 58, 26, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 33, 70, 71, 91, 77, 92, 86, 53, 98, 19, 15, 20, 12, 16, 11, 39, 40, 41, 42, 43, 25, 44, 27, 45, 46, 47, 28, 48, 29, 30, 49, 50, 32, 51, 52, 89, 74, 90, 85, 72, 97};

        public final int getKind(int i) {
            int c;
            int n = c = i >= this.getStreamLength() ? 65535 : (int)this.getCharValue(i);
            return c < 128 ? tokenKind[c] : (c == 65535 ? 97 : 72);
        }

        public String[] orderedExportedSymbols() {
            return HjParsersym.orderedTerminalSymbols;
        }

        public HjLexerLpgLexStream(String filename, int tab) throws IOException {
            super(filename, tab);
        }

        public HjLexerLpgLexStream(char[] input_chars, String filename, int tab) {
            super(input_chars, filename, tab);
        }

        public HjLexerLpgLexStream(char[] input_chars, String filename) {
            super(input_chars, filename, 1);
        }
    }
}

