/*
 * Decompiled with CFR 0.152.
 */
package hj.process;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PostCompile {
    private static String getCompilerOption(String[] compilerArgs, String flag) {
        if (compilerArgs != null) {
            for (int i = 0; i < compilerArgs.length - 1; ++i) {
                String compilerArg = compilerArgs[i];
                if (!flag.equals(compilerArg)) continue;
                return compilerArgs[i + 1];
            }
        }
        return null;
    }

    private static String getRuntimeOption(String[] compilerArgs) {
        return PostCompile.getCompilerOption(compilerArgs, "-rt");
    }

    private static String getOutputDirectoryOption(String[] compilerArgs) {
        return PostCompile.getCompilerOption(compilerArgs, "-d");
    }

    private static String getMainClass(String[] compilerArgs) {
        return PostCompile.getCompilerOption(compilerArgs, "-main-class");
    }

    public static void main(String[] args) {
        String runtimeOption = PostCompile.getRuntimeOption(args);
        if ("c".equals(runtimeOption)) {
            PostCompile.performKilimWeaving(args);
        }
    }

    private static void performKilimWeaving(String[] args) {
        String javaClasspath = System.getProperty("java.class.path");
        String javaCmd = PostCompile.getJavaCommand();
        String outputDirPath = PostCompile.getOutputDirPath(args);
        String pathSeparator = System.getProperty("path.separator");
        ArrayList<String> processCmd = new ArrayList<String>();
        processCmd.add(javaCmd);
        processCmd.add("-cp");
        processCmd.add(javaClasspath + pathSeparator + outputDirPath);
        processCmd.add("kilim.tools.Weaver");
        processCmd.add("-q");
        processCmd.add("-d");
        processCmd.add(outputDirPath);
        processCmd.add(outputDirPath);
        try {
            String line;
            ProcessBuilder processBuilder = new ProcessBuilder(processCmd);
            Process process = processBuilder.start();
            BufferedReader inputStream = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((line = inputStream.readLine()) != null) {
                System.out.println(line);
            }
        }
        catch (Throwable th) {
            th.printStackTrace();
        }
    }

    private static String getJavaCommand() {
        String javaCmd;
        String javaHome = System.getenv("JAVA_HOME");
        String jreHome = System.getenv("JRE_HOME");
        if (javaHome != null) {
            javaCmd = javaHome + "/bin/java";
        } else if (jreHome != null) {
            javaCmd = jreHome + "/bin/java";
        } else {
            throw new RuntimeException("ERROR: JAVA_HOME (JRE_HOME) is not pointing to a JRE or a JDK");
        }
        return javaCmd;
    }

    private static String getOutputDirPath(String[] args) {
        String outputDirStr = PostCompile.getOutputDirectoryOption(args);
        File outputDirectory = new File(outputDirStr == null ? "" : outputDirStr);
        return outputDirectory.getAbsolutePath();
    }

    private static void performVerification(String[] args) {
        try {
            System.out.println("PostCompile.main: verify class files after weaving");
            String outputDirPath = PostCompile.getOutputDirPath(args);
            File inputFile = new File(outputDirPath);
            ArrayList<File> classFiles = new ArrayList<File>();
            PostCompile.accumulateClassFiles(inputFile, classFiles);
            Class<?> c = Class.forName("kilim.tools.Weaver");
            Method method = c.getDeclaredMethod("verify", File.class);
            for (File classFile : classFiles) {
                try {
                    method.invoke(null, classFile);
                }
                catch (Throwable th) {
                    th.printStackTrace();
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static void accumulateClassFiles(File inputFile, List<File> classFiles) {
        String[] entries;
        if (inputFile.isFile()) {
            if (inputFile.getName().endsWith(".class")) {
                classFiles.add(inputFile);
            }
        } else if (inputFile.isDirectory() && (entries = inputFile.list()) != null) {
            for (String entry : entries) {
                File childDir = new File(inputFile, entry);
                PostCompile.accumulateClassFiles(childDir, classFiles);
            }
        }
    }
}

