/*
 * Decompiled with CFR 0.152.
 */
package hj.process;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.util.ClassLoaderRepository;
import org.apache.bcel.util.Repository;
import org.apache.bcel.verifier.VerificationResult;
import org.apache.bcel.verifier.Verifier;
import org.apache.bcel.verifier.VerifierFactory;

public class PostCompileVerifier {
    public static void verify(String mainClass, String classpath, boolean verbose) {
        boolean error = false;
        try {
            error = PostCompileVerifier.verifyUnsafe(mainClass, classpath, false);
        }
        catch (Exception e) {
            throw new PostCompileVerificationException(e);
        }
        if (error) {
            throw new PostCompileVerificationException("Verification Failed");
        }
    }

    public static void printError(String msg, VerificationResult vr) {
        System.out.println(msg);
        System.out.println(vr);
    }

    public static boolean verifyUnsafe(String mainClass, String classpath, boolean verbose) throws MalformedURLException, ClassNotFoundException {
        String[] warnings;
        boolean error = false;
        URLClassLoader cl = new URLClassLoader(new URL[]{new File(classpath).toURI().toURL()});
        ClassLoaderRepository clr = new ClassLoaderRepository((ClassLoader)cl);
        org.apache.bcel.Repository.setRepository((Repository)clr);
        Verifier v = VerifierFactory.getVerifier((String)mainClass);
        VerificationResult vr = v.doPass1();
        if (vr != VerificationResult.VR_OK) {
            error = true;
            PostCompileVerifier.printError("Error in Verification Pass 1:", vr);
        }
        if ((vr = v.doPass2()) != VerificationResult.VR_OK) {
            error = true;
            PostCompileVerifier.printError("Error in Verification Pass 2:", vr);
        }
        if (vr == VerificationResult.VR_OK) {
            JavaClass jc = org.apache.bcel.Repository.lookupClass((String)mainClass);
            for (int i = 0; i < jc.getMethods().length; ++i) {
                vr = v.doPass3a(i);
                if (vr != VerificationResult.VR_OK) {
                    error = true;
                    PostCompileVerifier.printError("Error in Verification Pass 3a, method number " + i + " ['" + jc.getMethods()[i] + "']:", vr);
                    continue;
                }
                vr = v.doPass3b(i);
                if (vr == VerificationResult.VR_OK) continue;
                error = true;
                PostCompileVerifier.printError("Error in Verification Pass 3b, method number " + i + " ['" + jc.getMethods()[i] + "']:", vr);
            }
        }
        if ((warnings = v.getMessages()).length != 0) {
            boolean printHeader = true;
            for (int j = 0; j < warnings.length; ++j) {
                if (warnings[j].contains("has a funny name")) continue;
                if (printHeader) {
                    System.out.println("Verification Warnings:");
                    printHeader = false;
                }
                System.out.println(warnings[j]);
            }
        }
        v.flush();
        org.apache.bcel.Repository.clearCache();
        return error;
    }

    public static class PostCompileVerificationException
    extends RuntimeException {
        private Throwable exp;

        public PostCompileVerificationException(String error) {
            super(error);
        }

        public PostCompileVerificationException(Exception exp) {
            this.exp = exp;
        }

        public String getMessage() {
            if (this.exp != null) {
                return this.exp.getMessage();
            }
            return super.getMessage();
        }

        public void printStackTrace() {
            if (this.exp != null) {
                this.exp.printStackTrace();
            }
        }
    }
}

