/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.hj.ast;

import java.util.Iterator;
import java.util.List;
import polyglot.ast.CompoundStmt;
import polyglot.ast.Expr;
import polyglot.ast.Expr_c;
import polyglot.ast.Formal;
import polyglot.ast.Node;
import polyglot.ast.Receiver;
import polyglot.ast.Stmt;
import polyglot.ast.Term;
import polyglot.ext.hj.ast.Async;
import polyglot.ext.hj.ast.AsyncCall;
import polyglot.ext.hj.ast.AsyncClauseList;
import polyglot.ext.hj.ast.Async_c;
import polyglot.ext.hj.ast.AwaitableChecker;
import polyglot.ext.hj.ast.FutureNode;
import polyglot.ext.hj.ast.HjNodeFactory;
import polyglot.ext.hj.ast.Phased;
import polyglot.ext.hj.ast.PhasedChecker;
import polyglot.ext.hj.ast.RemoteActivityInvocation;
import polyglot.ext.hj.types.AsyncDef;
import polyglot.ext.hj.types.AsyncInstance;
import polyglot.ext.hj.types.HjContext;
import polyglot.ext.hj.types.HjTypeSystem;
import polyglot.types.Context;
import polyglot.types.ErrorRef_c;
import polyglot.types.Ref;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.CodeWriter;
import polyglot.util.Position;
import polyglot.visit.AscriptionVisitor;
import polyglot.visit.CFGBuilder;
import polyglot.visit.ContextVisitor;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.TypeBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsyncCall_c
extends Expr_c
implements AsyncCall,
CompoundStmt {
    protected Async async;
    protected Expr place;
    protected Expr seqCond;
    protected List phasers;
    protected List awaitables;
    protected Expr whenCondExpr;
    protected boolean hasExplicitPlaceClause;
    protected AsyncInstance ai;

    public AsyncCall_c(Position pos, FutureNode returnType, AsyncClauseList clauses, Stmt body, boolean isAsyncWithReturn, boolean hasExplicitPlaceClause) {
        super(pos);
        this.async = new Async_c(pos, returnType, isAsyncWithReturn, body);
        assert (clauses != null);
        this.place = clauses.getPlaceClause();
        this.phasers = clauses.getPhasedClause();
        this.whenCondExpr = clauses.getWhenClause();
        this.seqCond = clauses.getSeqClause();
        this.awaitables = clauses.getAwaitClause();
        this.hasExplicitPlaceClause = hasExplicitPlaceClause;
        assert (this.place != null);
    }

    @Override
    public boolean hasExplicitPlaceClause() {
        return this.hasExplicitPlaceClause;
    }

    @Override
    public boolean hasSeqCond() {
        return this.seqCond != null;
    }

    @Override
    public Expr seqCond() {
        return this.seqCond;
    }

    public AsyncCall seqCond(Expr seqCond) {
        if (seqCond != this.seqCond) {
            AsyncCall_c n = (AsyncCall_c)this.copy();
            n.seqCond = seqCond;
            return n;
        }
        return this;
    }

    @Override
    public List phasers() {
        return this.phasers;
    }

    @Override
    public Phased phasers(List phasers) {
        AsyncCall_c n = (AsyncCall_c)this.copy();
        n.phasers = phasers;
        return n;
    }

    @Override
    public Expr cond() {
        return this.whenCondExpr;
    }

    @Override
    public Expr place() {
        return this.place;
    }

    @Override
    public RemoteActivityInvocation place(Expr place) {
        if (place != this.place) {
            AsyncCall_c n = (AsyncCall_c)this.copy();
            n.place = place;
            return n;
        }
        return this;
    }

    @Override
    public List dataDrivenFutureList() {
        return this.awaitables;
    }

    protected AsyncCall reconstruct(Expr place, Expr seqCond, List phasers, Expr condExpr, List awaitables, Async async) {
        if (place != this.place || seqCond != this.seqCond || phasers != this.phasers || condExpr != this.whenCondExpr || awaitables != this.awaitables || async != this.async) {
            AsyncCall_c n = (AsyncCall_c)this.copy();
            n.place = place;
            n.seqCond = seqCond;
            n.phasers = phasers;
            n.whenCondExpr = condExpr;
            n.awaitables = awaitables;
            n.async = async;
            return n;
        }
        return this;
    }

    @Override
    public AsyncInstance asyncInstance() {
        return this.ai;
    }

    public Node asyncInstance(AsyncInstance ai) {
        if (ai == this.ai) {
            return this;
        }
        AsyncCall_c n = (AsyncCall_c)this.copy();
        n.ai = ai;
        return n;
    }

    public Node visitChildren(NodeVisitor v) {
        Expr place = (Expr)this.visitChild((Node)this.place, v);
        Expr seqCond = (Expr)this.visitChild((Node)this.seqCond, v);
        List phasers = this.visitList(this.phasers, v);
        List dataDrivenFutureList = this.visitList(this.awaitables, v);
        Expr condExpr = (Expr)this.visitChild((Node)this.whenCondExpr, v);
        Async async = (Async)this.visitChild((Node)this.async, v);
        return this.reconstruct(place, seqCond, phasers, condExpr, dataDrivenFutureList, async);
    }

    public Node buildTypes(TypeBuilder tb) throws SemanticException {
        HjTypeSystem xts = (HjTypeSystem)tb.typeSystem();
        AsyncInstance ai = xts.createAsyncInstance(this.position(), (Ref<? extends AsyncDef>)new ErrorRef_c((TypeSystem)xts, this.position(), "Cannot get AsyncDef before type-checking async invocation."));
        return this.asyncInstance(ai);
    }

    public Context enterChildScope(Node child, Context c) {
        if (child == this.whenCondExpr) {
            c = ((HjContext)c).pushWhenBlock();
        }
        return super.enterChildScope(child, c);
    }

    public Node typeCheck(ContextVisitor tc) throws SemanticException {
        HjContext c;
        HjTypeSystem ts = (HjTypeSystem)tc.typeSystem();
        HjNodeFactory nf = (HjNodeFactory)tc.nodeFactory();
        Context ctx = tc.context();
        if (this.whenCondExpr != null && !this.whenCondExpr.type().isBoolean()) {
            throw new SemanticException("Conditional expression must be of Boolean type", this.position());
        }
        if (this.seqCond != null && !this.seqCond.type().isBoolean()) {
            throw new SemanticException("seq condition expression must be of Boolean type", this.position());
        }
        Type placeType = this.place.type();
        boolean placeIsPlace = ts.isImplicitCastValid(placeType, (Type)ts.place(), tc.context());
        if (!placeIsPlace) {
            if (ts.isCastValid(placeType, (Type)ts.HjObject(), ctx) && !placeType.isPrimitive()) {
                this.place = (Expr)nf.Field(this.position(), (Receiver)this.place, nf.Id(this.position(), "location")).del().typeCheck(tc);
            } else {
                throw new SemanticException("place expression must be of type hj.lang.place or inherit hj.lang.Object", this.position());
            }
        }
        if ((c = (HjContext)tc.context()).inSequentialCode()) {
            throw new SemanticException("async may not be invoked in sequential code.", this.position());
        }
        AwaitableChecker.typeCheck(tc, this.awaitables);
        PhasedChecker.typeCheck(tc, this.phasers);
        AsyncDef def = this.async.asyncDef();
        AsyncInstance ai = def.asInstance();
        return ((AsyncCall)this.asyncInstance(ai)).type(ai.returnType());
    }

    public Type childExpectedType(Expr child, AscriptionVisitor av) {
        TypeSystem ts = av.typeSystem();
        if (child == this.place) {
            return ts.Object();
        }
        return child.type();
    }

    public String toString() {
        return "async <" + this.type + "> (" + this.place + ") { ... }";
    }

    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        w.write("async (");
        this.printBlock((Node)this.place, w, tr);
        w.write(") ");
        if (this.hasPhasers()) {
            w.write("phased (");
            w.begin(0);
            Iterator i = this.phasers.iterator();
            while (i.hasNext()) {
                Formal f = (Formal)i.next();
                this.print((Node)f, w, tr);
                if (!i.hasNext()) continue;
                w.write(",");
                w.allowBreak(0, " ");
            }
            w.end();
            w.write(")");
        }
    }

    public Term firstChild() {
        return this.place;
    }

    public List<Term> acceptCFG(CFGBuilder v, List<Term> succs) {
        v.visitCFG((Term)this.place, (Term)this, 0);
        if (this.seqCond != null) {
            v.visitCFG((Term)this.seqCond, (Term)this, 0);
        }
        if (this.whenCondExpr != null) {
            v.visitCFG((Term)this.whenCondExpr, (Term)this, 0);
        }
        if (this.dataDrivenFutureList() != null && !this.dataDrivenFutureList().isEmpty()) {
            v.visitCFGList(this.awaitables, (Term)this, 0);
        }
        if (this.phasers() != null && !this.phasers().isEmpty()) {
            v.visitCFGList(this.phasers, (Term)this, 0);
        }
        return succs;
    }

    @Override
    public boolean hasPhasers() {
        return this.phasers != null && !this.phasers.isEmpty();
    }

    @Override
    public Async getAsync() {
        return this.async;
    }
}

