/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.hj.ast;

import java.util.LinkedList;
import java.util.List;
import polyglot.ast.Expr;
import polyglot.ext.hj.ast.AsyncClause;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsyncClauseList
extends LinkedList<AsyncClause> {
    public Expr getSeqClause() {
        return (Expr)this.getAsyncClauseType(AsyncClause.AsyncClauseType.SEQ);
    }

    public Expr getPlaceClause() {
        return (Expr)this.getAsyncClauseType(AsyncClause.AsyncClauseType.PLACE);
    }

    public List getPhasedClause() {
        return (List)this.getAsyncClauseType(AsyncClause.AsyncClauseType.PHASER);
    }

    public Expr getWhenClause() {
        return (Expr)this.getAsyncClauseType(AsyncClause.AsyncClauseType.WHEN);
    }

    public List getAwaitClause() {
        return (List)this.getAsyncClauseType(AsyncClause.AsyncClauseType.AWAIT);
    }

    private Object getAsyncClauseType(AsyncClause.AsyncClauseType clauseType) {
        for (AsyncClause clause : this) {
            if (!clause.isAsyncClauseType(clauseType)) continue;
            return clause.getAstNode();
        }
        return null;
    }

    public boolean hasPlaceClause() {
        return this.getPlaceClause() != null;
    }

    public String checkDuplicatedClauses() {
        int placeClause = 0;
        int seqClause = 0;
        int whenClause = 0;
        int phasedClause = 0;
        int awaitClause = 0;
        for (AsyncClause clause : this) {
            if (clause.isPlaceClause()) {
                ++placeClause;
            }
            if (clause.isSeqClause()) {
                ++seqClause;
            }
            if (clause.isWhenClause()) {
                ++whenClause;
            }
            if (clause.isAwaitClause()) {
                ++awaitClause;
            }
            if (!clause.isPhaserClause()) continue;
            ++phasedClause;
        }
        if (placeClause > 1) {
            return "at";
        }
        if (seqClause > 1) {
            return "seq";
        }
        if (whenClause > 1) {
            return "when";
        }
        if (awaitClause > 1) {
            return "await";
        }
        if (phasedClause > 1) {
            return "phased";
        }
        return null;
    }
}

