/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.hj.ast;

import java.util.List;
import polyglot.ast.Block;
import polyglot.ast.Node;
import polyglot.ast.Stmt;
import polyglot.ast.Term;
import polyglot.ast.Term_c;
import polyglot.ast.TypeNode;
import polyglot.ext.hj.ast.Async;
import polyglot.ext.hj.ast.FutureNode;
import polyglot.ext.hj.types.AsyncDef;
import polyglot.ext.hj.types.HjContext;
import polyglot.ext.hj.types.HjTypeSystem;
import polyglot.types.CodeDef;
import polyglot.types.Context;
import polyglot.types.Ref;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.util.Position;
import polyglot.visit.CFGBuilder;
import polyglot.visit.ContextVisitor;
import polyglot.visit.NodeVisitor;
import polyglot.visit.TypeBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Async_c
extends Term_c
implements Async {
    protected FutureNode returnType;
    protected Block body;
    protected boolean isAsyncWithReturn;
    protected AsyncDef ai;

    public Async_c(Position pos, FutureNode returnType, boolean isAsyncWithReturn, Stmt body) {
        super(pos);
        this.returnType = returnType;
        this.isAsyncWithReturn = isAsyncWithReturn;
        this.body = (Block)body;
    }

    public Node visitChildren(NodeVisitor v) {
        FutureNode returnType = (FutureNode)this.visitChild((Node)this.returnType, v);
        Block body = (Block)this.visitChild((Node)this.body, v);
        return this.reconstruct(returnType, body);
    }

    public Node buildTypes(TypeBuilder tb) throws SemanticException {
        HjTypeSystem xts = (HjTypeSystem)tb.typeSystem();
        AsyncDef def = this.isAsyncWithReturn() ? xts.createAsyncWithReturnDef((Ref<? extends Type>)this.returnType().typeRef()) : xts.createAsyncDef((Ref<? extends Type>)this.returnType().typeRef());
        TypeBuilder tbChk = tb.pushCode((CodeDef)def);
        FutureNode returnType = (FutureNode)this.visitChild((Node)this.returnType, (NodeVisitor)tbChk);
        def.setReturnType(returnType.typeRef());
        Block body = (Block)this.visitChild((Node)this.body, (NodeVisitor)tbChk);
        Async n = this.reconstruct(returnType, body);
        return n.asyncDef(def);
    }

    public Node typeCheck(ContextVisitor tc) throws SemanticException {
        Context ctx = tc.context();
        if (ctx.inStaticContext()) {
            this.ai.setFlags(tc.typeSystem().Public().Static());
        }
        return super.typeCheck(tc);
    }

    @Override
    public AsyncDef asyncDef() {
        return this.ai;
    }

    @Override
    public Async asyncDef(AsyncDef ai) {
        if (ai == this.ai) {
            return this;
        }
        Async_c n = (Async_c)this.copy();
        n.ai = ai;
        return n;
    }

    @Override
    public Type baseType() {
        return this.returnType.base().type();
    }

    public Term codeBody() {
        return this.body();
    }

    public CodeDef codeDef() {
        return this.ai;
    }

    public boolean isAsyncWithReturn() {
        return this.isAsyncWithReturn;
    }

    public Context enterChildScope(Node child, Context c) {
        if (child == this.body) {
            c = ((HjContext)c).pushAsync((CodeDef)this.ai, this.isAsyncWithReturn());
        }
        return super.enterChildScope(child, c);
    }

    protected Async reconstruct(FutureNode returnType, Block body) {
        if (returnType != this.returnType || body != this.body) {
            Async_c n = (Async_c)this.copy();
            n.returnType = returnType;
            n.body = body;
            return n;
        }
        return this;
    }

    public TypeNode returnType() {
        return this.returnType;
    }

    public Async body(Block body) {
        Async_c n = (Async_c)this.copy();
        n.body = body;
        return n;
    }

    @Override
    public Block body() {
        return this.body;
    }

    public Context enterScope(Context c) {
        c = c.pushCode((CodeDef)this.ai);
        return c;
    }

    public Term firstChild() {
        return this.returnType();
    }

    public List<Term> acceptCFG(CFGBuilder v, List<Term> succs) {
        v.visitCFG((Term)this.returnType(), (Term)this.body(), 1);
        v.visitCFG((Term)this.body(), (Term)this, 0);
        return succs;
    }
}

