/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.hj.ast;

import java.util.List;
import polyglot.ast.Expr;
import polyglot.ext.hj.types.HjTypeSystem;
import polyglot.types.QName;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.visit.ContextVisitor;

public class AwaitableChecker {
    public static void typeCheck(ContextVisitor tc, List awaitables) throws SemanticException {
        if (awaitables != null) {
            HjTypeSystem ts = (HjTypeSystem)tc.typeSystem();
            boolean isDynamic = false;
            boolean isStatic = false;
            int nbElem = 0;
            for (Expr awaitableExpr : awaitables) {
                Type awaitableType = awaitableExpr.type();
                if (AwaitableChecker.isDynamic(ts, awaitableType)) {
                    isDynamic = true;
                }
                if (AwaitableChecker.isStatic(ts, awaitableType)) {
                    isStatic = true;
                }
                if (!isDynamic && !isStatic) {
                    throw new SemanticException("Type \"" + awaitableType + "\" in await clause must be either implement java.lang.Iterable or be hj.lang.DataDrivenFuture.", awaitableExpr.position());
                }
                if (isDynamic && isStatic) {
                    throw new SemanticException("An await clause cannot contains references to both ddf and list of ddf", awaitableExpr.position());
                }
                if (isDynamic && nbElem > 0) {
                    throw new SemanticException("A DDF can only be parameterized with one list of ddf", awaitableExpr.position());
                }
                ++nbElem;
            }
        }
    }

    public static boolean isDynamic(HjTypeSystem ts, Type awaitableType) throws SemanticException {
        Type javaIterableType = ts.typeForName(QName.make((String)"java.lang.Iterable"));
        return awaitableType.isSubtype(javaIterableType, ts.emptyContext());
    }

    public static boolean isStatic(HjTypeSystem ts, Type awaitableType) {
        return awaitableType.isSubtype((Type)ts.ddf(), ts.emptyContext());
    }
}

