/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.hj.ast;

import java.util.List;
import polyglot.ast.Expr;
import polyglot.ast.Node;
import polyglot.ast.Stmt;
import polyglot.ast.Stmt_c;
import polyglot.ast.Term;
import polyglot.ext.hj.ast.Finish;
import polyglot.ext.hj.types.HjTypeSystem;
import polyglot.types.ClassType;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.util.CodeWriter;
import polyglot.util.Position;
import polyglot.util.TypedList;
import polyglot.visit.CFGBuilder;
import polyglot.visit.ContextVisitor;
import polyglot.visit.FlowGraph;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Finish_c
extends Stmt_c
implements Finish {
    protected Stmt body;
    protected List<Expr> accumulators;
    protected Stmt empty;

    public Finish_c(Position pos) {
        super(pos);
    }

    public Finish_c(Position pos, List accumulators, Stmt body) {
        super(pos);
        this.accumulators = TypedList.copyAndCheck((List)accumulators, Expr.class, (boolean)true);
        this.body = body;
    }

    @Override
    public Stmt body() {
        return this.body;
    }

    public Finish body(Stmt body) {
        Finish_c n = (Finish_c)this.copy();
        n.body = body;
        return n;
    }

    @Override
    public List<Expr> getAccumulators() {
        return this.accumulators;
    }

    protected Finish reconstruct(Stmt body, List<Expr> accumulators, Stmt empty) {
        if (body != this.body || empty != this.empty || accumulators != this.accumulators) {
            Finish_c n = (Finish_c)this.copy();
            n.body = body;
            n.empty = empty;
            n.accumulators = accumulators;
            return n;
        }
        return this;
    }

    protected void typeCheckAccumulatorList(ContextVisitor tc) throws SemanticException {
        if (this.accumulators != null) {
            HjTypeSystem ts = (HjTypeSystem)tc.typeSystem();
            ClassType targetType = ts.accumulator();
            for (Expr expr : this.accumulators) {
                Type t = expr.type();
                if (ts.isSubtype(t, (Type)targetType, tc.context())) continue;
                throw new SemanticException("finish accumulator clause argument " + expr + " must be of type " + targetType, expr.position());
            }
        }
    }

    public Node typeCheck(ContextVisitor tc) throws SemanticException {
        this.empty = tc.nodeFactory().Empty(this.position());
        this.typeCheckAccumulatorList(tc);
        return super.typeCheck(tc);
    }

    public String toString() {
        return "finish  { ... }";
    }

    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        w.write("finish ");
        this.printSubStmt(this.body, w, tr);
    }

    public Term firstChild() {
        return this.empty;
    }

    public List acceptCFG(CFGBuilder v, List succs) {
        v.visitCFG((Term)this.empty, FlowGraph.EDGE_KEY_TRUE, (Term)this.body, 1, FlowGraph.EDGE_KEY_FALSE, (Term)this, 0);
        if (this.accumulators == null || this.accumulators.isEmpty()) {
            v.visitCFG((Term)this.body, (Term)this, 0);
        } else {
            v.visitCFGList(this.accumulators, (Term)this.body, 1);
            v.visitCFG((Term)this.body, (Term)this, 0);
        }
        return succs;
    }

    public Node visitChildren(NodeVisitor v) {
        Stmt empty = (Stmt)this.visitChild((Node)this.empty, v);
        List accumulators = this.visitList(this.accumulators, v);
        Stmt body = (Stmt)this.visitChild((Node)this.body, v);
        return this.reconstruct(body, accumulators, empty);
    }
}

