/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.hj.ast;

import polyglot.ast.ArrayAccessAssign_c;
import polyglot.ast.Assign;
import polyglot.ast.Expr;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ext.hj.ast.HjArrayAccessAssign;
import polyglot.ext.hj.ast.HjCanonicalTypeNode_c;
import polyglot.ext.hj.ast.Point;
import polyglot.ext.hj.types.HjParsedClassType;
import polyglot.ext.hj.types.HjType;
import polyglot.ext.hj.types.HjTypeSystem;
import polyglot.types.Ref;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.Types;
import polyglot.util.CodeWriter;
import polyglot.util.Position;
import polyglot.visit.ContextVisitor;
import polyglot.visit.PrettyPrinter;

public class HjArrayAccessAssign_c
extends ArrayAccessAssign_c
implements HjArrayAccessAssign {
    protected NodeFactory nf = null;

    public HjArrayAccessAssign_c(Position pos, Expr array, Expr index, Assign.Operator op, Expr right, NodeFactory nf) {
        super(pos, array, index, op, right);
        this.nf = nf;
    }

    public Assign typeCheckLeft(ContextVisitor tc) throws SemanticException {
        HjTypeSystem ts = (HjTypeSystem)tc.typeSystem();
        Type type = this.array().type();
        boolean isJavaArray = type.isArray();
        boolean isIndexable = ts.isIndexable(type);
        if (!isJavaArray && !isIndexable) {
            throw new SemanticException("Subscript can only follow an array type, and not " + type + ".", this.position());
        }
        HjArrayAccessAssign_c node = this;
        Expr index = node.index();
        if (!ts.isImplicitCastValid(index.type(), (Type)ts.point(), tc.context()) && !index.type().isInt()) {
            throw new SemanticException("Array subscript |" + this.toString() + "| must be an integer or a point.", this.position());
        }
        Point p = (Point)index;
        return node.reconstruct(node.array(), p);
    }

    public Expr left(NodeFactory nf) {
        if (nf != null) {
            return super.left(nf);
        }
        return super.left(this.nf);
    }

    public Type leftType() {
        Type arrayType;
        HjTypeSystem ts;
        Type leftType = super.leftType();
        if (leftType == null && (ts = (HjTypeSystem)(arrayType = this.array().type()).typeSystem()).isIndexable(arrayType)) {
            leftType = ts.baseType(arrayType);
        }
        return leftType;
    }

    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        assert (false);
        Expr array = this.array();
        Expr index = this.index();
        HjType pt = (HjType)this.type;
        if (pt instanceof HjParsedClassType && ((HjParsedClassType)pt).isParameterized()) {
            HjParsedClassType ct = (HjParsedClassType)pt;
            Type result = ct.typeParameter();
            w.write("((");
            this.print((Node)new HjCanonicalTypeNode_c(Position.COMPILER_GENERATED, (Ref<? extends Type>)Types.ref((Object)result)), w, tr);
            w.write(")");
        }
        this.printSubExpr(array, w, tr);
        w.write("." + this.op.toString() + "(");
        this.printSubExpr(this.right, w, tr);
        w.write(",");
        this.print((Node)index, w, tr);
        w.write(")");
    }
}

