/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.hj.ast;

import java.util.ArrayList;
import java.util.List;
import polyglot.ast.ClassBody;
import polyglot.ast.ClassDecl;
import polyglot.ast.ClassMember;
import polyglot.ast.Id;
import polyglot.ast.MethodDecl;
import polyglot.ast.Node;
import polyglot.ast.TypeNode;
import polyglot.ext.hj.ast.HjClassDecl;
import polyglot.ext.hj.ast.HjNodeFactory;
import polyglot.ext.hj.ast.SemanticError;
import polyglot.ext.hj.ast.TypeDecl;
import polyglot.ext.hj.ast.ValueClassDecl_c;
import polyglot.ext.hj.types.HjFlags;
import polyglot.ext.jl5.ast.JL5ClassDecl_c;
import polyglot.ext.jl5.types.FlagAnnotations;
import polyglot.types.Flags;
import polyglot.types.SemanticException;
import polyglot.util.Position;
import polyglot.visit.ContextVisitor;

public class HjClassDecl_c
extends JL5ClassDecl_c
implements TypeDecl,
HjClassDecl {
    public static TypeDecl make(Position pos, FlagAnnotations flags, Id name, TypeNode superClass, List interfaces, ClassBody body, HjNodeFactory nf, boolean valueClass) {
        TypeDecl result = (TypeDecl)(valueClass ? new ValueClassDecl_c(pos, flags, name, superClass, interfaces, body, nf) : new HjClassDecl_c(pos, flags, name, superClass, interfaces, body));
        return result;
    }

    protected HjClassDecl_c(Position pos, FlagAnnotations flags, Id name, TypeNode superClass, List interfaces, ClassBody body) {
        super(pos, flags, name, superClass, interfaces, body);
    }

    protected HjClassDecl_c(Position pos, FlagAnnotations flags, Id name, TypeNode superClass, List interfaces, ClassBody body, List paramTypes) {
        super(pos, flags, name, superClass, interfaces, body, paramTypes);
    }

    public Node disambiguate(ContextVisitor ar) throws SemanticException {
        ClassDecl n = (ClassDecl)super.disambiguate(ar);
        HjFlags xf = HjFlags.toHjFlags(n.flags().flags());
        if (xf.isSafe()) {
            ClassBody b = n.body();
            List m = b.members();
            int count = m.size();
            ArrayList<ClassMember> newM = new ArrayList<ClassMember>(count);
            for (int i = 0; i < count; ++i) {
                ClassMember mem = (ClassMember)m.get(i);
                if (mem instanceof MethodDecl) {
                    MethodDecl decl = (MethodDecl)mem;
                    HjFlags mxf = HjFlags.toHjFlags(decl.flags().flags()).Safe();
                    mem = decl.flags(decl.flags().flags((Flags)mxf));
                }
                newM.add(mem);
            }
            n = n.body(b.members(newM));
        }
        return n;
    }

    public Node typeCheck(ContextVisitor tc) throws SemanticException {
        boolean notInnerClass;
        HjClassDecl_c result = (HjClassDecl_c)super.typeCheck(tc);
        String sourceFileName = this.type.sourceFile().name();
        String expectedFileName = this.name() + ".hj";
        boolean bl = notInnerClass = tc.context().currentClassDef() == null;
        if (notInnerClass && this.flags().flags().isPublic() && !sourceFileName.equals(expectedFileName)) {
            throw new SemanticError("class " + this.name() + " is public, should be declared in a file named " + expectedFileName);
        }
        return result;
    }
}

