/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.hj.extension;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import polyglot.ast.Block;
import polyglot.ast.Block_c;
import polyglot.ast.Call;
import polyglot.ast.Call_c;
import polyglot.ast.CanonicalTypeNode;
import polyglot.ast.ClassBody_c;
import polyglot.ast.Expr;
import polyglot.ast.FlagsNode;
import polyglot.ast.Formal;
import polyglot.ast.Id;
import polyglot.ast.Local;
import polyglot.ast.MethodDecl;
import polyglot.ast.MethodDecl_c;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.Receiver;
import polyglot.ext.hj.extension.HjExt_c;
import polyglot.ext.hj.extension.extern.HjClassBodyExtArrayViewHelper;
import polyglot.ext.hj.extension.extern.HjClassBodyExtHelperJNI;
import polyglot.ext.hj.extension.extern.HjClassBodyExtJniStubGenerator;
import polyglot.ext.hj.types.HjTypeSystem;
import polyglot.frontend.ExtensionInfo;
import polyglot.types.LocalDef;
import polyglot.types.MethodDef;
import polyglot.types.MethodInstance;
import polyglot.types.Name;
import polyglot.types.ParsedClassType_c;
import polyglot.types.Ref;
import polyglot.types.Type;
import polyglot.util.Position;

public class HjClassBodyExt_c
extends HjExt_c {
    HjTypeSystem typeSystem;
    private static int containingClassDepth = 0;

    private MethodDecl createNewNative(MethodDecl nativeMethod, boolean isOverloaded, NodeFactory nf, HjClassBodyExtArrayViewHelper viewHelper, HjClassBodyExtHelperJNI jniHelper) {
        MethodDef mi = (MethodDef)nativeMethod.methodDef().copy();
        Position pos = nativeMethod.name().position();
        String nativeName = jniHelper.generateMangledHjNativeName(nativeMethod, isOverloaded, viewHelper);
        mi.setName(Name.make((String)nativeName));
        Id nativeNameId = nf.Id(pos, nativeName);
        MethodDecl_c newNative = (MethodDecl_c)nativeMethod.name(nativeNameId);
        newNative = (MethodDecl_c)newNative.methodDef(mi);
        ArrayList<Formal> newFormals = new ArrayList<Formal>();
        ArrayList<Ref<? extends Type>> newFormalsType = new ArrayList<Ref<? extends Type>>();
        boolean seenNonPrimitive = false;
        for (Formal parameter : nativeMethod.formals()) {
            LocalDef def = parameter.localDef();
            if (parameter.declType().isPrimitive()) {
                newFormals.add(parameter);
                newFormalsType.add(def.type());
                continue;
            }
            if (HjClassBodyExtHelperJNI.isString(parameter.declType())) {
                seenNonPrimitive = true;
                newFormals.add(parameter);
                newFormalsType.add((Ref<? extends Type>)def.type());
                continue;
            }
            seenNonPrimitive = true;
            viewHelper.generateViewSignature(nativeMethod.position(), parameter, newFormals, newFormalsType);
        }
        if (seenNonPrimitive) {
            MethodDef nativeMi = newNative.methodDef();
            nativeMi.setFormalTypes(newFormalsType);
            newNative = (MethodDecl_c)newNative.formals(newFormals);
        }
        return newNative;
    }

    private MethodDecl createNativeWrapper(MethodDecl nativeWrapper, MethodDecl nativeMethod, NodeFactory nf, HjClassBodyExtArrayViewHelper viewHelper) {
        MethodInstance nativeMi = nativeMethod.methodDef().asInstance();
        FlagsNode cFlags = nativeWrapper.flags();
        cFlags = nf.FlagsNode(cFlags.position(), nativeMi.flags().clearNative());
        nativeWrapper = nativeWrapper.flags(cFlags);
        MethodDef wrapperMi = nativeWrapper.methodDef();
        wrapperMi.setFlags(wrapperMi.flags().clearNative());
        Position pos = nativeMethod.position();
        Name jniName = nativeMethod.name().id();
        CanonicalTypeNode receiver = nf.CanonicalTypeNode(pos, (Type)nativeMi.container());
        Call jniCall = nf.Call(pos, (Receiver)receiver, nf.Id(pos, jniName), Collections.EMPTY_LIST);
        jniCall = (Call_c)jniCall.targetImplicit(true);
        jniCall = (Call_c)jniCall.methodInstance(nativeMi);
        ArrayList<Local> args = new ArrayList<Local>();
        for (Formal wrapperParameter : nativeWrapper.formals()) {
            Local arg;
            if (wrapperParameter.declType().isPrimitive()) {
                arg = nf.Local(pos, wrapperParameter.name());
                arg = (Local)arg.type(wrapperParameter.declType());
                arg = arg.localInstance(wrapperParameter.localDef().asInstance());
                args.add(arg);
                continue;
            }
            if (HjClassBodyExtHelperJNI.isString(wrapperParameter.declType())) {
                arg = nf.Local(pos, wrapperParameter.name());
                arg = (Local)arg.type(wrapperParameter.declType());
                arg = arg.localInstance(wrapperParameter.localDef().asInstance());
                args.add(arg);
                continue;
            }
            viewHelper.createNativeWrapperViewArgument(pos, args, wrapperParameter);
        }
        jniCall = (Call_c)jniCall.arguments(args);
        jniCall = (Call)jniCall.type(nativeMethod.returnType().type());
        ArrayList<Object> newStmts = new ArrayList<Object>();
        if (nativeMethod.methodDef().asInstance().returnType().isVoid()) {
            newStmts.add(nf.Eval(pos, (Expr)jniCall));
        } else {
            newStmts.add(nf.Return(pos, (Expr)jniCall));
        }
        Block_c newBlock = (Block_c)nf.Block(pos, newStmts);
        nativeWrapper = (MethodDecl_c)nativeWrapper.body((Block)newBlock);
        return nativeWrapper;
    }

    public boolean containsExtern(List members) {
        ListIterator i = members.listIterator();
        while (i.hasNext()) {
            MethodDecl md;
            MethodDef mi;
            Object o = i.next();
            if (!(o instanceof MethodDecl) || !(mi = (md = (MethodDecl)o).methodDef()).flags().isNative()) continue;
            return true;
        }
        return false;
    }

    public Node rewrite(HjTypeSystem ts, NodeFactory nf, ExtensionInfo info) {
        this.typeSystem = ts;
        boolean seenNativeMethodDecl = false;
        ClassBody_c cb = (ClassBody_c)this.node();
        List members = cb.members();
        Map methodHash = null;
        ArrayList newListOfMembers = new ArrayList();
        HjClassBodyExtHelperJNI jniHelper = new HjClassBodyExtHelperJNI(ts);
        HjClassBodyExtJniStubGenerator jniStubHelper = new HjClassBodyExtJniStubGenerator(jniHelper);
        ListIterator i = members.listIterator();
        while (i.hasNext()) {
            Object o = i.next();
            if (o instanceof MethodDecl) {
                MethodDecl_c md = (MethodDecl_c)o;
                MethodInstance mi = md.methodDef().asInstance();
                HjClassBodyExtArrayViewHelper viewHelper = new HjClassBodyExtArrayViewHelper(ts, nf);
                if (!mi.flags().isNative()) {
                    newListOfMembers.add(o);
                    continue;
                }
                if (!seenNativeMethodDecl) {
                    methodHash = this.buildNativeMethodHash(members);
                    if (0 == containingClassDepth++) {
                        List additionalInclude = Collections.EMPTY_LIST;
                        File outputDir = this.getOutputFile(mi);
                        jniStubHelper.createWrapperFile(jniHelper.JNImangle(jniHelper.canonicalTypeString((Type)mi.container())), outputDir);
                        jniStubHelper.generateWrapperPrologue(additionalInclude);
                    }
                    seenNativeMethodDecl = true;
                }
                boolean isOverLoaded = null != methodHash.get(md.name().id());
                MethodDecl newNative = this.createNewNative((MethodDecl)md, isOverLoaded, nf, viewHelper, jniHelper);
                MethodDecl newNativeWrapper = this.createNativeWrapper((MethodDecl)md, newNative, nf, viewHelper);
                jniStubHelper.generateStub(newNative, isOverLoaded, viewHelper);
                newListOfMembers.add(newNative);
                newListOfMembers.add(newNativeWrapper);
                continue;
            }
            newListOfMembers.add(o);
        }
        if (seenNativeMethodDecl && 0 == --containingClassDepth) {
            jniStubHelper.generateWrapperEpilogue();
        }
        cb = (ClassBody_c)cb.members(newListOfMembers);
        return cb;
    }

    private File getOutputFile(MethodInstance mi) {
        File sourceFile = new File(((ParsedClassType_c)mi.container()).fromSource().path());
        String sourceFolder = sourceFile.getParent();
        File outputDir = null;
        outputDir = sourceFolder != null ? new File(sourceFolder) : new File(System.getProperty("user.dir"));
        return outputDir;
    }

    private Map buildNativeMethodHash(List members) {
        HashMap<Name, MethodDecl_c> methodHash = new HashMap<Name, MethodDecl_c>();
        ListIterator j = members.listIterator();
        while (j.hasNext()) {
            MethodDecl_c methodDecl;
            Object theObj = j.next();
            if (!(theObj instanceof MethodDecl) || !(methodDecl = (MethodDecl_c)theObj).flags().flags().isNative()) continue;
            Name key = methodDecl.name().id();
            if (methodHash.containsKey(key)) {
                methodHash.put(key, methodDecl);
                continue;
            }
            methodHash.put(key, null);
        }
        return methodHash;
    }
}

