/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.hj.extension.extern;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.ListIterator;
import polyglot.ast.Formal_c;
import polyglot.ast.MethodDecl;
import polyglot.ext.hj.extension.extern.HjClassBodyExtArrayViewHelper;
import polyglot.ext.hj.extension.extern.HjClassBodyExtHelperJNI;
import polyglot.types.MethodInstance;
import polyglot.types.StructType;
import polyglot.types.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HjClassBodyExtJniStubGenerator {
    private BufferedWriter wrapperFile;
    String[] wrapperEpilogue = new String[]{"\n", "#ifdef __cplusplus\n", "}\n", "#endif\n"};
    private HjClassBodyExtHelperJNI jniHelper;

    public HjClassBodyExtJniStubGenerator(HjClassBodyExtHelperJNI jniHelper) {
        this.jniHelper = jniHelper;
    }

    public void generateWrapperPrologue(List<String> includeList) {
        try {
            this.wrapperFile.write("/*Automatically generated -- DO NOT EDIT THIS FILE */\n");
            this.wrapperFile.write("#include <sys/types.h>\n");
            this.wrapperFile.write("#include <jni.h>\n");
            for (String include : includeList) {
                this.wrapperFile.write(include);
            }
            this.wrapperFile.write("#ifdef __cplusplus\n");
            this.wrapperFile.write("extern \"C\" {\n");
            this.wrapperFile.write("#endif\n");
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new Error("Problems writing to " + this.wrapperFile);
        }
    }

    public void generateWrapperEpilogue() {
        try {
            for (int i = 0; i < this.wrapperEpilogue.length; ++i) {
                this.wrapperFile.write(this.wrapperEpilogue[i]);
            }
            this.wrapperFile.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new Error("Problems with " + this.wrapperFile);
        }
    }

    public void createWrapperFile(String containingClassName, File output_dir) {
        String fileName = containingClassName + "_hjstub.c";
        Date timeStamp = new Date();
        SimpleDateFormat formatter = new SimpleDateFormat();
        try {
            this.wrapperFile = new BufferedWriter(new FileWriter(new File(output_dir, fileName)));
            this.wrapperFile.write("/*\n * Filename:" + fileName + "\n * Generated: " + formatter.format(timeStamp) + " */\n");
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new Error("Problems writing to " + this.wrapperFile);
        }
    }

    public String maybeCast(String to, String from) {
        if (!to.equals(from)) {
            return "(" + to + ")";
        }
        return "";
    }

    public String maybeCast(Type theType) {
        return this.maybeCast(this.jniHelper.typeToCType(theType), this.jniHelper.typeToJNIString(theType));
    }

    public String maybeUncast(Type theType) {
        return this.maybeCast(this.jniHelper.typeToJNIString(theType), this.jniHelper.typeToCType(theType));
    }

    public String generateAcquireStringStmt(String paramName, String ptrName) {
        String stmt = "#ifdef __cplusplus\n";
        stmt = stmt + "  const char *" + ptrName + " = (env)->GetStringUTFChars(" + paramName + ",0);\n";
        stmt = stmt + "#else\n";
        stmt = stmt + "  const char *" + ptrName + " = (*env)->GetStringUTFChars(env," + paramName + ",0);\n";
        stmt = stmt + "#endif\n";
        return stmt;
    }

    public String generateReleaseStringStmt(String paramName, String ptrName) {
        String stmt = "#ifdef __cplusplus\n";
        stmt = stmt + "  (env)->ReleaseStringUTFChars(env," + paramName + "," + ptrName + ");\n";
        stmt = stmt + "#else\n";
        stmt = stmt + "  (*env)->ReleaseStringUTFChars(env," + paramName + "," + ptrName + ");\n";
        stmt = stmt + "#endif\n";
        return stmt;
    }

    public String generateAcquireStmt(String arrayName, String ptrName) {
        String stmt = "void *" + ptrName + " = NULL;\n";
        stmt = stmt + "if (" + arrayName + " != NULL) {\n";
        stmt = stmt + "  #ifdef __cplusplus\n";
        stmt = stmt + "    " + ptrName + " = (env)->GetPrimitiveArrayCritical(" + arrayName + ",0);\n";
        stmt = stmt + "  #else\n";
        stmt = stmt + "    " + ptrName + " = (*env)->GetPrimitiveArrayCritical(env," + arrayName + ",0);\n";
        stmt = stmt + "  #endif\n";
        stmt = stmt + "}\n";
        return stmt;
    }

    public String generateReleaseStmt(String arrayName, String ptrName) {
        String stmt = "if (" + ptrName + " != NULL) {\n";
        stmt = stmt + "#ifdef __cplusplus\n";
        stmt = stmt + "  (env)->ReleasePrimitiveArrayCritical(" + arrayName + "," + ptrName + ",0);\n";
        stmt = stmt + "#else\n";
        stmt = stmt + "  (*env)->ReleasePrimitiveArrayCritical(env," + arrayName + "," + ptrName + ",0);\n";
        stmt = stmt + "#endif\n";
        stmt = stmt + "}\n";
        return stmt;
    }

    public String returnString(String varToReturn) {
        String stmt = "#ifdef __cplusplus\n";
        stmt = stmt + " return (env)->NewStringUTF(" + varToReturn + ");\n";
        stmt = stmt + "#else\n";
        stmt = stmt + " return (*env)->NewStringUTF(env, " + varToReturn + ");\n";
        stmt = stmt + "#endif\n";
        return stmt;
    }

    public void generateStub(MethodDecl nativeMethod, boolean isOverloaded, HjClassBodyExtArrayViewHelper viewHelper) {
        MethodInstance mi = nativeMethod.methodDef().asInstance();
        String newName = mi.name().toString();
        StringBuffer jniCall = new StringBuffer("");
        StringBuffer wrapperCall = new StringBuffer("");
        StringBuffer wrapperDecl = new StringBuffer("");
        StringBuffer releaseStmts = new StringBuffer("");
        StringBuffer acquireStmts = new StringBuffer("");
        String saveTheValue = "";
        wrapperCall.append("  " + newName + "(");
        wrapperDecl.append("extern " + this.jniHelper.typeToCType(mi.returnType()) + " ");
        wrapperDecl.append(wrapperCall);
        newName = this.jniHelper.generateJNIName(nativeMethod, isOverloaded, viewHelper);
        String parm = mi.flags().isStatic() ? "jclass cls" : "jobject obj";
        jniCall.append("JNIEXPORT " + this.jniHelper.typeToJNIString(mi.returnType()) + " JNICALL\n" + newName + "(JNIEnv *env, " + parm);
        String returnedValue = "";
        if (!mi.returnType().isVoid()) {
            String tempName = "_hjReTuRnVaL";
            saveTheValue = this.jniHelper.typeToCType(mi.returnType()) + " " + tempName + "=" + this.maybeUncast(mi.returnType());
            returnedValue = mi.returnType().isPrimitive() ? "return " + tempName + ";\n" : this.returnString(tempName);
        }
        String commaString = "";
        ListIterator i = nativeMethod.formals().listIterator();
        while (i.hasNext()) {
            Formal_c parameter = (Formal_c)i.next();
            if (parameter.declType().isPrimitive()) {
                jniCall.append(", " + this.jniHelper.typeToJNIString(parameter.declType()) + " " + parameter.name());
                wrapperDecl.append(commaString + this.jniHelper.typeToCType(parameter.declType()) + " " + parameter.name());
                wrapperCall.append(commaString + this.maybeCast(parameter.declType()) + parameter.name());
            } else if (HjClassBodyExtHelperJNI.isString(parameter.declType())) {
                jniCall.append(", " + this.jniHelper.typeToJNIString(parameter.declType()) + " " + parameter.name());
                String newCharName = parameter.name() + "_";
                acquireStmts.append(this.generateAcquireStringStmt(parameter.name().id().toString(), newCharName));
                releaseStmts.insert(0, this.generateReleaseStringStmt(parameter.name().id().toString(), newCharName));
                wrapperDecl.append(commaString + this.jniHelper.typeToCType(parameter.declType()) + " " + parameter.name());
                wrapperCall.append(commaString + this.maybeCast(parameter.declType()) + newCharName);
            } else {
                String arrayPtr = parameter.name() + "_hjPoInTeR";
                acquireStmts.append(this.generateAcquireStmt(parameter.name().id().toString(), arrayPtr));
                releaseStmts.insert(0, this.generateReleaseStmt(parameter.name().id().toString(), arrayPtr));
                Type type = parameter.type().type();
                jniCall.append(", " + this.jniHelper.typeToJNIString(type) + " " + parameter.name());
                wrapperDecl.append(commaString + this.jniHelper.typeToCType(type) + " " + arrayPtr);
                wrapperCall.append(commaString + this.maybeCast(type) + arrayPtr);
            }
            commaString = ", ";
        }
        jniCall.append(")");
        wrapperCall.append(")");
        wrapperDecl.append(");");
        String jniAlias = "";
        if (((StructType)nativeMethod.memberDef().container().get()).toClass().isNested()) {
            String aliasName = this.jniHelper.generateJNIAlias(nativeMethod, isOverloaded, viewHelper);
            jniAlias = "#ifndef __WIN32__\nextern JNIEXPORT __typeof(" + newName + ") JNICALL\n" + aliasName + "\n__attribute((weak, alias(\"" + newName + "\")));\n#endif\n\n";
        }
        try {
            this.wrapperFile.write("\n/* * * * * * * */\n" + wrapperDecl + "\n" + jniCall + " {\n" + acquireStmts + "\n" + "\n" + saveTheValue + wrapperCall + ";\n\n" + releaseStmts + returnedValue + "}\n" + jniAlias);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new Error("Problems writing file");
        }
    }
}

