/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.hj.types;

import java.util.Collection;
import polyglot.ext.hj.types.HjContext;
import polyglot.ext.jl5.types.JL5Context_c;
import polyglot.main.Report;
import polyglot.types.ClassType;
import polyglot.types.CodeDef;
import polyglot.types.Context;
import polyglot.types.Context_c;
import polyglot.types.ImportTable;
import polyglot.types.Name;
import polyglot.types.TypeSystem;
import polyglot.util.CollectionUtil;

public class HjContext_c
extends JL5Context_c
implements HjContext {
    public static final Context_c.Kind FORALL = new Context_c.Kind("forall");
    public static final Context_c.Kind FOREACH = new Context_c.Kind("foreach");
    public static final Context_c.Kind ASYNC = new Context_c.Kind("async");
    public static final Context_c.Kind ASYNC_WITH_RETURN = new Context_c.Kind("async<T>");
    public static final Context_c.Kind WHEN = new Context_c.Kind("when");
    protected boolean inSafeCode;
    protected boolean inSequentialCode;
    protected boolean inLocalCode;
    protected boolean inNonBlockingCode;
    protected Context_c.Kind hjKind;
    private static final Collection TOPICS = CollectionUtil.list((Object)"types", (Object)"context", (Object[])new String[0]);
    protected static int varCount = 0;

    public HjContext_c(TypeSystem ts) {
        super(ts);
    }

    public String getKind() {
        if (this.hjKind == null) {
            return "inner class";
        }
        return this.hjKind.toString();
    }

    public boolean inInnerClass() {
        return this.hjKind == null;
    }

    public boolean inAsync() {
        return this.hjKind != null && (this.hjKind == ASYNC || this.hjKind == ASYNC_WITH_RETURN);
    }

    public boolean inAsyncWithReturn() {
        return this.hjKind != null && this.hjKind == ASYNC_WITH_RETURN;
    }

    public boolean inWhen() {
        return this.hjKind != null && this.hjKind == WHEN;
    }

    public boolean inForEach() {
        return this.hjKind != null && this.hjKind == FOREACH;
    }

    public boolean inForAll() {
        return this.hjKind != null && this.hjKind == FORALL;
    }

    public boolean inSafeCode() {
        return this.inSafeCode;
    }

    public boolean inSequentialCode() {
        return this.inSequentialCode;
    }

    public boolean inNonBlockingCode() {
        return this.inNonBlockingCode;
    }

    public boolean inLocalCode() {
        return this.inLocalCode;
    }

    public void setSafeCode() {
        this.inSafeCode = true;
    }

    public void setSequentialCode() {
        this.inSequentialCode = true;
    }

    public void setNonBlockingCode() {
        this.inNonBlockingCode = true;
    }

    public void setLocalCode() {
        this.inLocalCode = true;
    }

    protected Context_c push() {
        HjContext_c v = (HjContext_c)super.push();
        v.hjKind = null;
        return v;
    }

    private boolean checkLocal() {
        return this.inAsync() || this.inForAll() || this.inForEach();
    }

    public boolean isLocalToClass(Name name) {
        return this.isLocalToClassInternal(name);
    }

    public boolean isLocal(Name name) {
        return this.isLocalInternal(name);
    }

    private boolean isLocalToClassInternal(Name name) {
        if (this.isClass()) {
            return false;
        }
        if ((this.isBlock() || this.isCode() || this.checkLocal()) && (this.findVariableInThisScope(name) != null || this.findInThisScope(this.ts.TypeMatcher(name)) != null)) {
            return true;
        }
        if (this.outer == null) {
            return false;
        }
        return ((HjContext)this.outer).isLocalToClass(name);
    }

    private boolean isLocalInternal(Name name) {
        if (name.equals((Object)Name.make((String)""))) {
            return false;
        }
        if (this.isClass()) {
            return false;
        }
        if ((this.isBlock() || this.isCode()) && (this.findVariableInThisScope(name) != null || this.findInThisScope(this.ts.TypeMatcher(name)) != null)) {
            return true;
        }
        if (this.outer == null) {
            return false;
        }
        boolean outerRes = this.outer.isLocal(name);
        if (this.checkLocal() && outerRes) {
            return false;
        }
        return outerRes;
    }

    public ClassType type() {
        return this.type;
    }

    public Context pushSource(ImportTable it) {
        return super.pushSource(it);
    }

    public HjContext pushWhenBlock() {
        HjContext_c c = (HjContext_c)this.pushBlock();
        c.hjKind = WHEN;
        return c;
    }

    public HjContext pushIsolatedBlock() {
        HjContext c = (HjContext)super.pushBlock();
        return c;
    }

    public Context pushAsync(CodeDef asyncCodeInstance, boolean withReturn) {
        if (Report.should_report((Collection)TOPICS, (int)4)) {
            Report.report((int)4, (String)"push async");
        }
        HjContext_c c = (HjContext_c)this.pushCode(asyncCodeInstance);
        c.hjKind = withReturn ? ASYNC_WITH_RETURN : ASYNC;
        return c;
    }

    public Context pushForAll() {
        HjContext_c c = (HjContext_c)this.pushBlock();
        c.hjKind = FORALL;
        return c;
    }

    public Context pushForEach() {
        HjContext_c c = (HjContext_c)this.pushBlock();
        c.hjKind = FOREACH;
        return c;
    }

    public String toString() {
        return "(" + this.kind.toString() + " " + this.mapsToString() + " " + this.outer + ")";
    }

    public Name getNewVarName() {
        return Name.make((String)("hj$__var" + varCount++));
    }
}

