/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.hj.visit;

import java.util.HashSet;
import java.util.List;
import polyglot.ast.Assign;
import polyglot.ast.Block;
import polyglot.ast.Call;
import polyglot.ast.Eval;
import polyglot.ast.Expr;
import polyglot.ast.New;
import polyglot.ast.NewArray;
import polyglot.ast.Node;
import polyglot.ast.ProcedureCall;
import polyglot.ast.Receiver;
import polyglot.ast.Stmt;
import polyglot.ext.hj.ast.AsyncCall;
import polyglot.visit.NodeVisitor;

public class AsyncElimination
extends NodeVisitor {
    private final boolean DEBUG_ = false;

    public Node leave(Node old, Node n, NodeVisitor v) {
        Node ret = n;
        if (n instanceof AsyncCall) {
            AsyncCall as = (AsyncCall)n;
            Block as_body = as.getAsync().body();
            Stmt simple_stmt = this.checkIfSimpleBlock_((Stmt)as_body);
            if (simple_stmt != null && this.isOptimizableStmt_(simple_stmt)) {
                ret = simple_stmt;
            }
        } else if (n instanceof Call) {
            Call c = (Call)n;
            List args = c.arguments();
            Receiver r = c.target();
        }
        return ret;
    }

    private Stmt checkIfSimpleBlock_(Stmt s) {
        Stmt the_one_stmt = null;
        if (s instanceof Block) {
            Block b = (Block)s;
            List l = b.statements();
            if (l.size() == 1) {
                the_one_stmt = (Stmt)l.get(0);
            }
        } else {
            the_one_stmt = s;
        }
        return the_one_stmt;
    }

    private boolean isOptimizableStmt_(Stmt s) {
        Eval e;
        Expr e_expr;
        boolean ret = false;
        if (s instanceof Eval && (e_expr = (e = (Eval)s).expr()) instanceof Assign) {
            Assign a_expr = (Assign)e_expr;
            ret = this.isOptimizableExpr_(a_expr.right());
        }
        return ret;
    }

    private boolean isOptimizableExpr_(Expr e) {
        final HashSet critical = new HashSet();
        e.visit(new NodeVisitor(){

            public Node leave(Node old, Node n, NodeVisitor v) {
                if (n instanceof ProcedureCall || n instanceof New || n instanceof NewArray) {
                    critical.add(n);
                }
                return n;
            }
        });
        return critical.isEmpty();
    }
}

