/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.hj.visit;

import java.util.LinkedList;
import java.util.List;
import polyglot.ast.Assign;
import polyglot.ast.Binary;
import polyglot.ast.CanonicalTypeNode;
import polyglot.ast.Conditional;
import polyglot.ast.Do;
import polyglot.ast.Eval;
import polyglot.ast.Expr;
import polyglot.ast.Field;
import polyglot.ast.For;
import polyglot.ast.Id;
import polyglot.ast.Lit;
import polyglot.ast.Local;
import polyglot.ast.LocalDecl;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.Special;
import polyglot.ast.Stmt;
import polyglot.ast.TypeNode;
import polyglot.ext.hj.ast.HjArrayAccess;
import polyglot.ext.hj.ast.HjArrayAccess1;
import polyglot.ext.hj.ast.HjBinary;
import polyglot.ext.hj.ast.HjNodeFactory;
import polyglot.ext.hj.types.HjContext;
import polyglot.frontend.Job;
import polyglot.types.Context;
import polyglot.types.Flags;
import polyglot.types.LocalDef;
import polyglot.types.Name;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.types.Types;
import polyglot.util.Position;
import polyglot.visit.ContextVisitor;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PruningVisitor;

public class ExprFlattener
extends ContextVisitor {
    public static final Position pos = Position.COMPILER_GENERATED;
    static final NodeVisitor done = new PruningVisitor();
    public static final Flags flags = Flags.FINAL;

    public ExprFlattener(Job job, TypeSystem ts, NodeFactory nf) {
        super(job, ts, nf);
    }

    protected boolean needsFlattening(Node n) {
        NeedsFlatteningVisitor v = new NeedsFlatteningVisitor(n);
        n.visit((NodeVisitor)v);
        return v.needsFlattening();
    }

    public NodeVisitor enterCall(Node p, Node n) {
        if (p instanceof For) {
            return done;
        }
        return this;
    }

    public Node leaveCall(Node parent, Node old, Node n, NodeVisitor v) {
        if (!(n instanceof Stmt)) {
            return n;
        }
        Stmt s = (Stmt)n;
        HjContext xc = (HjContext)this.context();
        Object result = n;
        if (this.needsFlattening((Node)s)) {
            Flattener newVisitor = (Flattener)new Flattener(this.job, this.ts, this.nf, n).context((Context)xc);
            Node nn = n.visit((NodeVisitor)newVisitor);
            List l = newVisitor.stmtList();
            if (!(nn instanceof Local || nn instanceof Eval && ((Eval)nn).expr() instanceof Local)) {
                l.add((Stmt)nn);
            }
            HjNodeFactory xnf = (HjNodeFactory)this.nf;
            result = xnf.StmtSeq(pos, l);
        }
        return result;
    }

    public static class Flattener
    extends ContextVisitor {
        List stmtList = new LinkedList();
        PruningVisitor done = new PruningVisitor();
        protected Node root;

        public List stmtList() {
            return this.stmtList;
        }

        public void add(Stmt m) {
            this.stmtList.add(m);
        }

        public Flattener(Job job, TypeSystem ts, NodeFactory nf, Node root) {
            super(job, ts, nf);
            this.root = root;
        }

        public Node override(Node p, Node n) {
            if (n instanceof Stmt && n != this.root) {
                return n;
            }
            if (n instanceof HjBinary) {
                HjBinary f = (HjBinary)n;
                Binary.Operator op = f.operator();
                if (this.ts.typeEquals(f.type(), this.ts.Boolean(), null) && (op == Binary.COND_AND || op == Binary.COND_OR)) {
                    return f.flatten(this);
                }
            }
            return null;
        }

        public Node leaveCall(Node parent, Node old, Node n, NodeVisitor v) {
            Node result = n;
            HjContext xc = (HjContext)this.context();
            if (n instanceof Expr) {
                Expr e = (Expr)n;
                if (e instanceof Local || e instanceof Field || e instanceof Lit || e instanceof Special || e instanceof Assign) {
                    return e;
                }
                if (parent instanceof LocalDecl || parent instanceof Assign) {
                    return e;
                }
                Type type = e.type();
                if (!this.ts.typeEquals(type, this.ts.Void(), null)) {
                    Name varName = xc.getNewVarName();
                    CanonicalTypeNode tn = this.nf.CanonicalTypeNode(pos, type);
                    LocalDef li = this.ts.localDef(pos, flags, Types.ref((Object)type), varName);
                    Id varId = this.nf.Id(n.position(), varName);
                    LocalDecl ld = this.nf.LocalDecl(n.position(), this.nf.FlagsNode(n.position(), flags), (TypeNode)tn, varId, e);
                    ld = ld.localDef(li);
                    Local ldRef = (Local)this.nf.Local(n.position(), varId).localInstance(ld.localDef().asInstance()).type(type);
                    this.stmtList.add(ld);
                    result = ldRef;
                }
            }
            return result;
        }
    }

    public static class NeedsFlatteningVisitor
    extends NodeVisitor {
        boolean needsFlattening = false;
        protected Node root;

        public NeedsFlatteningVisitor(Node root) {
            this.root = root;
        }

        public NodeVisitor enter(Node p, Node n) {
            if (this.needsFlattening) {
                return done;
            }
            if (p instanceof Conditional) {
                return done;
            }
            if (p instanceof Do) {
                return done;
            }
            if (p instanceof For) {
                return done;
            }
            if (n instanceof Stmt && n != this.root) {
                return done;
            }
            this.needsFlattening = (n instanceof HjArrayAccess || n instanceof HjArrayAccess1) && !(p instanceof LocalDecl);
            return this.needsFlattening ? done : this;
        }

        public boolean needsFlattening() {
            return this.needsFlattening;
        }
    }
}

