/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.hj.visit;

import java.util.Collections;
import polyglot.ast.Assign;
import polyglot.ast.Binary;
import polyglot.ast.Call;
import polyglot.ast.CanonicalTypeNode;
import polyglot.ast.Cast;
import polyglot.ast.Expr;
import polyglot.ast.FloatLit;
import polyglot.ast.IntLit;
import polyglot.ast.Lit;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.Receiver;
import polyglot.ast.TypeNode;
import polyglot.ast.Unary;
import polyglot.ext.hj.extension.HjExt;
import polyglot.ext.hj.types.HjTypeSystem;
import polyglot.frontend.Job;
import polyglot.types.ClassType;
import polyglot.types.MethodInstance;
import polyglot.types.PrimitiveType;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.Position;
import polyglot.visit.AscriptionVisitor;
import polyglot.visit.NodeVisitor;

public class HjBoxer
extends AscriptionVisitor {
    HjTypeSystem xts;

    public HjBoxer(Job job, TypeSystem ts, NodeFactory nf) {
        super(job, ts, nf);
        this.xts = (HjTypeSystem)ts;
    }

    public static Call box(HjTypeSystem ts, NodeFactory nf, Expr e, PrimitiveType ct) {
        ClassType classType = ts.classOf((Type)ct);
        MethodInstance valueOfMeth = ts.wrapperCreator(ct);
        CanonicalTypeNode receiver = nf.CanonicalTypeNode(e.position(), (Type)classType);
        Call valueOfCall = nf.Call(e.position(), (Receiver)receiver, nf.Id(e.position(), valueOfMeth.name()), Collections.singletonList(e));
        valueOfCall = valueOfCall.methodInstance(valueOfMeth);
        valueOfCall = (Call)valueOfCall.type(valueOfMeth.returnType());
        return valueOfCall;
    }

    public static Call unbox(HjTypeSystem ts, NodeFactory nf, Expr e, ClassType ct) {
        MethodInstance xxxValueMi = ts.wrapperGetter(ct.toPrimitive());
        Call xxxValueCall = nf.Call(e.position(), (Receiver)e, nf.Id(e.position(), xxxValueMi.name()));
        xxxValueCall = xxxValueCall.methodInstance(xxxValueMi);
        xxxValueCall = (Call)xxxValueCall.type(xxxValueMi.returnType());
        return xxxValueCall;
    }

    public Expr ascribe(Expr e, Type toType) {
        Type fromType = e.type();
        if (toType == null) {
            return e;
        }
        Position p = e.position();
        if (e instanceof Call) {
            Call call_n = (Call)e;
            String m_name = call_n.name().toString();
            Type target_t = call_n.target().type();
            if (m_name.equals("get") && this.xts.isFuture(target_t) && !this.xts.isFutureVoid(target_t)) {
                Cast ret_notype;
                if (fromType.isPrimitive()) {
                    ClassType boxed_t = ((HjTypeSystem)this.ts).classOf(fromType);
                    call_n = (Call)call_n.type((Type)boxed_t);
                    ret_notype = this.nf.Cast(p, (TypeNode)this.nf.CanonicalTypeNode(p, fromType), (Expr)call_n);
                } else {
                    ret_notype = this.nf.Cast(p, (TypeNode)this.nf.CanonicalTypeNode(p, fromType), (Expr)call_n);
                }
                return ret_notype.type(fromType);
            }
        }
        if (e instanceof Unary && HjBoxer.isBoxedReference(this.xts, fromType)) {
            return this.handleUnaryOps(p, (Unary)e, fromType);
        }
        return this.applyBoxUnbox(fromType, toType, e);
    }

    public Expr applyBoxUnbox(Type fromType, Type toType, Expr e) {
        if (HjBoxer.isPrimitiveNonVoid(toType) && HjBoxer.isBoxedReference(this.xts, fromType)) {
            Call unboxCall = HjBoxer.unbox(this.xts, this.nf, e, (ClassType)fromType);
            return unboxCall;
        }
        if ((HjBoxer.isBoxedReference(this.xts, toType) || this.ts.typeEquals(this.ts.Object(), toType, this.ts.emptyContext())) && HjBoxer.isPrimitiveNonVoid(fromType)) {
            Call boxCall = HjBoxer.box(this.xts, this.nf, e, (PrimitiveType)fromType);
            return boxCall;
        }
        return e;
    }

    public Expr handleUnaryOps(Position p, Unary uExp, Type fromType) {
        Object result = null;
        Call unboxCall = HjBoxer.unbox(this.xts, this.nf, uExp.expr(), (ClassType)uExp.type());
        Type targetType = unboxCall.type();
        result = uExp.operator() == Unary.POST_INC || uExp.operator() == Unary.PRE_INC ? this.nf.Binary(p, (Expr)unboxCall, Binary.ADD, (Expr)this.getLitteral(p, targetType, 1, 1.0)) : (uExp.operator() == Unary.POST_DEC || uExp.operator() == Unary.PRE_DEC ? this.nf.Binary(p, (Expr)unboxCall, Binary.SUB, (Expr)this.getLitteral(p, targetType, -1, -1.0)) : this.nf.Unary(p, (Expr)unboxCall, uExp.operator()));
        result = result.type(targetType);
        result = HjBoxer.box(this.xts, this.nf, (Expr)result, ((ClassType)fromType).toPrimitive());
        Assign ass = this.nf.Assign(p, uExp.expr(), Assign.ASSIGN, (Expr)result);
        result = ass.type(fromType);
        return result;
    }

    private Lit getLitteral(Position p, Type type, int ilit, double flit) {
        IntLit res = null;
        if (type.isLongOrLess()) {
            IntLit.Kind kind = type.isLong() ? IntLit.LONG : IntLit.INT;
            res = this.nf.IntLit(p, kind, (long)ilit);
        } else if (type.isDouble() || type.isFloat()) {
            FloatLit.Kind kind = type.isDouble() ? FloatLit.DOUBLE : FloatLit.FLOAT;
            res = this.nf.FloatLit(p, kind, flit);
        } else {
            System.out.println("ERROR: Boxing/Unboxing of " + type + " expressions not yet supported");
        }
        res = (Lit)res.type(type);
        return res;
    }

    public static boolean isPrimitiveNonVoid(Type t) {
        return !t.isVoid() && t.isPrimitive();
    }

    public static boolean isBoxedReference(HjTypeSystem ts, Type t) {
        return !t.isNull() && t.isReference() && (t.isNumeric() || t.isBoolean());
    }

    public Node leaveCall(Node parent, Node old, Node n, NodeVisitor v) throws SemanticException {
        if ((n = super.leaveCall(parent, old, n, v)).ext() instanceof HjExt) {
            return ((HjExt)n.ext()).rewrite((HjTypeSystem)this.typeSystem(), this.nodeFactory(), this.job.extensionInfo());
        }
        return n;
    }
}

