/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.hj.visit;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import polyglot.ast.CodeNode;
import polyglot.ast.MethodDecl;
import polyglot.ast.NodeFactory;
import polyglot.ast.Return;
import polyglot.ast.Term;
import polyglot.ext.hj.ast.Async;
import polyglot.frontend.Job;
import polyglot.types.SemanticException;
import polyglot.types.TypeSystem;
import polyglot.visit.DataFlow;
import polyglot.visit.FlowGraph;

public class HjExitChecker
extends DataFlow {
    protected CodeNode code;

    public HjExitChecker(Job job, TypeSystem ts, NodeFactory nf) {
        super(job, ts, nf, false);
    }

    protected FlowGraph initGraph(CodeNode code, Term root) {
        Async a;
        MethodDecl d;
        this.code = code;
        if (code instanceof MethodDecl && !(d = (MethodDecl)code).methodDef().asInstance().returnType().isVoid()) {
            return super.initGraph(code, root);
        }
        if (code instanceof Async && !(a = (Async)code).baseType().isVoid()) {
            return super.initGraph(code, root);
        }
        return null;
    }

    protected DataFlow.Item createInitialItem(FlowGraph graph, Term node, boolean entry) {
        return DataFlowItem.EXITS;
    }

    public Map flow(DataFlow.Item in, FlowGraph graph, Term n, boolean entry, Set succEdgeKeys) {
        if (n instanceof Return) {
            return HjExitChecker.itemToMap((DataFlow.Item)DataFlowItem.EXITS, (Set)succEdgeKeys);
        }
        if (n == graph.root() && !entry) {
            Map m = HjExitChecker.itemToMap((DataFlow.Item)DataFlowItem.EXITS, (Set)succEdgeKeys);
            if (succEdgeKeys.contains(FlowGraph.EDGE_KEY_OTHER)) {
                m.put(FlowGraph.EDGE_KEY_OTHER, DataFlowItem.DOES_NOT_EXIT);
            }
            if (succEdgeKeys.contains(FlowGraph.EDGE_KEY_TRUE)) {
                m.put(FlowGraph.EDGE_KEY_TRUE, DataFlowItem.DOES_NOT_EXIT);
            }
            if (succEdgeKeys.contains(FlowGraph.EDGE_KEY_FALSE)) {
                m.put(FlowGraph.EDGE_KEY_FALSE, DataFlowItem.DOES_NOT_EXIT);
            }
            return m;
        }
        return HjExitChecker.itemToMap((DataFlow.Item)in, (Set)succEdgeKeys);
    }

    public DataFlow.Item confluence(List inItems, Term node, boolean entry, FlowGraph graph) {
        Iterator i = inItems.iterator();
        while (i.hasNext()) {
            if (((DataFlowItem)((Object)i.next())).exits) continue;
            return DataFlowItem.DOES_NOT_EXIT;
        }
        return DataFlowItem.EXITS;
    }

    protected void check(FlowGraph graph, Term n, boolean entry, DataFlow.Item inItem, Map outItems) throws SemanticException {
        DataFlowItem outItem;
        if (n == graph.root() && entry && outItems != null && !outItems.isEmpty() && (outItem = (DataFlowItem)((Object)outItems.values().iterator().next())) != null && !outItem.exits) {
            throw new SemanticException("Missing return statement.", this.code.position());
        }
    }

    protected static class DataFlowItem
    extends DataFlow.Item {
        public final boolean exits;
        public static final DataFlowItem EXITS = new DataFlowItem(true);
        public static final DataFlowItem DOES_NOT_EXIT = new DataFlowItem(false);

        protected DataFlowItem(boolean exits) {
            this.exits = exits;
        }

        public String toString() {
            return "exits=" + this.exits;
        }

        public boolean equals(Object o) {
            if (o instanceof DataFlowItem) {
                return this.exits == ((DataFlowItem)((Object)o)).exits;
            }
            return false;
        }

        public int hashCode() {
            return this.exits ? 5235 : 8673;
        }
    }
}

