/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.hj.visit;

import polyglot.ast.Call;
import polyglot.ast.Expr;
import polyglot.ast.New;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.Return;
import polyglot.ast.VarInit;
import polyglot.ext.hj.ast.AsyncCall;
import polyglot.ext.hj.ast.Phased;
import polyglot.ext.hj.types.HjContext;
import polyglot.ext.hj.types.HjTypeSystem;
import polyglot.frontend.Job;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.visit.AscriptionVisitor;
import polyglot.visit.NodeVisitor;

public class HjLimitationChecker
extends AscriptionVisitor {
    private HjTypeSystem hts;
    private boolean wstCompilation;

    public HjLimitationChecker(Job job, TypeSystem ts, NodeFactory nf, boolean wstCompilation) {
        super(job, ts, nf);
        this.hts = (HjTypeSystem)ts;
        this.wstCompilation = wstCompilation;
    }

    public NodeVisitor enterCall(Node parent, Node n) throws SemanticException {
        if (this.wstCompilation) {
            if (n instanceof Return && ((HjContext)this.context()).inAsync() && !((HjContext)this.context()).inAsyncWithReturn()) {
                throw new SemanticException("Work-Stealing compiler doesn't support return stmt in async construct " + n.position());
            }
        } else if (n instanceof VarInit) {
            VarInit var = (VarInit)n;
            Type varType = (Type)var.varDef().type().get();
            if (var.varDef().flags().isStatic() && this.ts.typeEquals(varType, (Type)this.hts.phaser(), this.context)) {
                throw new SemanticException("Phasers can't be declared static " + n.position());
            }
        }
        return super.enterCall(parent, n);
    }

    public Node leave(Node old, Node n, NodeVisitor v) {
        return super.leave(old, n, v);
    }

    public Expr ascribe(Expr e, Type toType) throws SemanticException {
        New n;
        Call c;
        Type targetType;
        if (this.wstCompilation) {
            if (e instanceof AsyncCall) {
                AsyncCall stmt = (AsyncCall)e;
                if (stmt.hasExplicitPlaceClause()) {
                    throw new SemanticException("Work-Stealing compiler doesn't support the place clause in async<T> construct " + e.position());
                }
                if (stmt.asyncInstance().isAsyncWithReturn()) {
                    throw new SemanticException("Work-Stealing compiler doesn't support the async<T> construct " + e.position());
                }
                if (stmt.hasPhasers()) {
                    throw new SemanticException("Work-Stealing compiler doesn't support phaser constructs " + e.position());
                }
            } else if (e instanceof Phased) {
                throw new SemanticException("Work-Stealing compiler doesn't support phaser constructs " + e.position());
            }
        }
        HjTypeSystem hts = (HjTypeSystem)this.ts;
        if (e instanceof Call && this.ts.isSubtype(targetType = (c = (Call)e).target().type(), (Type)hts.ddf(), this.ts.emptyContext()) && c.name().toString().equals("put")) {
            if (this.ts.typeEquals((Type)hts.ddfVoid(), c.target().type(), this.ts.emptyContext())) {
                if (!c.arguments().isEmpty()) {
                    throw new SemanticException("No valid method call found for " + c.toString() + " in hj.lang.DataDrivenFuture<java.lang.Void>");
                }
            } else if (c.arguments().isEmpty()) {
                throw new SemanticException("No valid method call found for put() in " + targetType);
            }
        }
        if (e instanceof New && this.ts.typeEquals((Type)hts.ddfVoid(), e.type(), this.ts.emptyContext()) && !(n = (New)e).arguments().isEmpty()) {
            throw new SemanticException("Constructor DataDrivenFuture<Void>(java.lang.Void) cannot be invoked with argument null");
        }
        return super.ascribe(e, toType);
    }
}

