/*
 * Decompiled with CFR 0.152.
 */
package soot.hj;

import hj.process.PostCompileVerifier;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import soot.Body;
import soot.BodyPack;
import soot.CompilationDeathException;
import soot.G;
import soot.JavaToJimpleBodyPack;
import soot.JimpleBodyPack;
import soot.Pack;
import soot.PackManager;
import soot.Printer;
import soot.Scene;
import soot.ScenePack;
import soot.Singletons;
import soot.SootClass;
import soot.SootMethod;
import soot.SourceLocator;
import soot.Transform;
import soot.Transformer;
import soot.baf.JasminClass;
import soot.baf.toolkits.base.LoadStoreOptimizer;
import soot.baf.toolkits.base.PeepholeOptimizer;
import soot.grimp.toolkits.base.ConstructorFolder;
import soot.hj.HjScene;
import soot.hj.HjToJimple.HjUtil;
import soot.hj.HjToJimple.graphics.GraphicsInstrumentor;
import soot.hj.HjToJimple.jimple.HjFELCTranslator;
import soot.hj.HjToJimple.jimple.HjHPIRToMPIRTranslator;
import soot.hj.HjToJimple.jimple.HjInternalObjectsTranslator;
import soot.hj.HjToJimple.jimple.HjMHPTranslator;
import soot.hj.HjToJimple.jimple.HjNextTranslator;
import soot.hj.HjToJimple.jimple.HjOVDTranslator;
import soot.hj.HjToJimple.jimple.HjRSTTranslator;
import soot.hj.HjToJimple.jimple.HjRedundantAsyncElim;
import soot.hj.HjToJimple.jimple.HjRuntimeTranslator;
import soot.hj.HjToJimple.jimple.HjWSTranslator;
import soot.hj.HjToJimple.jimple.TargetedHjRuntime;
import soot.hj.HjToJimple.jimple.ext.complex.HjComplexTransformer;
import soot.hj.HjToJimple.jimple.ext.conformance.HjConformanceTransformer;
import soot.hj.HjToJimple.jimple.ext.cooperative.HjCooperativeFutureGetTranslator;
import soot.hj.HjToJimple.jimple.ext.cooperative.HjCooperativePhaserWaitTranslator;
import soot.hj.HjToJimple.jimple.ext.cooperative.HjPausableMethodMarker;
import soot.hj.HjToJimple.jl5.BridgeMethodGenerator;
import soot.hj.HjToJimple.racedet.RaceDetInstrumentor;
import soot.hj.options.HjOptions;
import soot.hj.workstealing.FinishAsyncTransformer;
import soot.jimple.HjJasminClass;
import soot.jimple.paddle.PaddleHook;
import soot.jimple.spark.SparkTransformer;
import soot.jimple.spark.fieldrw.FieldTagAggregator;
import soot.jimple.spark.fieldrw.FieldTagger;
import soot.jimple.toolkits.annotation.AvailExprTagger;
import soot.jimple.toolkits.annotation.DominatorsTagger;
import soot.jimple.toolkits.annotation.arraycheck.ArrayBoundsChecker;
import soot.jimple.toolkits.annotation.arraycheck.RectangularArrayFinder;
import soot.jimple.toolkits.annotation.callgraph.CallGraphGrapher;
import soot.jimple.toolkits.annotation.callgraph.CallGraphTagger;
import soot.jimple.toolkits.annotation.defs.ReachingDefsTagger;
import soot.jimple.toolkits.annotation.fields.UnreachableFieldsTagger;
import soot.jimple.toolkits.annotation.liveness.LiveVarsTagger;
import soot.jimple.toolkits.annotation.logic.LoopInvariantFinder;
import soot.jimple.toolkits.annotation.methods.UnreachableMethodsTagger;
import soot.jimple.toolkits.annotation.nullcheck.NullCheckEliminator;
import soot.jimple.toolkits.annotation.nullcheck.NullPointerChecker;
import soot.jimple.toolkits.annotation.nullcheck.NullPointerColorer;
import soot.jimple.toolkits.annotation.parity.ParityTagger;
import soot.jimple.toolkits.annotation.profiling.ProfilingGenerator;
import soot.jimple.toolkits.annotation.purity.PurityAnalysis;
import soot.jimple.toolkits.annotation.qualifiers.TightestQualifiersTagger;
import soot.jimple.toolkits.annotation.tags.ArrayNullTagAggregator;
import soot.jimple.toolkits.base.Aggregator;
import soot.jimple.toolkits.callgraph.CHATransformer;
import soot.jimple.toolkits.callgraph.CallGraphPack;
import soot.jimple.toolkits.callgraph.UnreachableMethodTransformer;
import soot.jimple.toolkits.invoke.StaticInliner;
import soot.jimple.toolkits.invoke.StaticMethodBinder;
import soot.jimple.toolkits.pointer.CastCheckEliminatorDumper;
import soot.jimple.toolkits.pointer.DependenceTagAggregator;
import soot.jimple.toolkits.pointer.ParameterAliasTagger;
import soot.jimple.toolkits.pointer.SideEffectTagger;
import soot.jimple.toolkits.scalar.CommonSubexpressionEliminator;
import soot.jimple.toolkits.scalar.ConditionalBranchFolder;
import soot.jimple.toolkits.scalar.ConstantPropagatorAndFolder;
import soot.jimple.toolkits.scalar.CopyPropagator;
import soot.jimple.toolkits.scalar.DeadAssignmentEliminator;
import soot.jimple.toolkits.scalar.LocalNameStandardizer;
import soot.jimple.toolkits.scalar.NopEliminator;
import soot.jimple.toolkits.scalar.UnconditionalBranchFolder;
import soot.jimple.toolkits.scalar.UnreachableCodeEliminator;
import soot.jimple.toolkits.scalar.pre.BusyCodeMotion;
import soot.jimple.toolkits.scalar.pre.LazyCodeMotion;
import soot.jimple.toolkits.typing.TypeAssigner;
import soot.options.Options;
import soot.shimple.toolkits.scalar.SConstantPropagatorAndFolder;
import soot.sootify.TemplatePrinter;
import soot.tagkit.LineNumberTagAggregator;
import soot.toolkits.exceptions.TrapTightener;
import soot.toolkits.scalar.LocalPacker;
import soot.toolkits.scalar.LocalSplitter;
import soot.toolkits.scalar.UnusedLocalEliminator;
import soot.util.EscapedWriter;
import soot.util.JasminOutputStream;
import soot.xml.XMLPrinter;

public class HjPackManager
extends PackManager {
    public static boolean DEBUG = false;

    public HjPackManager(Singletons.Global g) {
        super(g);
    }

    protected void init() {
        JimpleBodyPack p = new JimpleBodyPack();
        this.addPack((Pack)p);
        p.add(new Transform("jb.tt", (Transformer)TrapTightener.v()));
        p.add(new Transform("jb.ls", (Transformer)LocalSplitter.v()));
        p.add(new Transform("jb.a", (Transformer)Aggregator.v()));
        p.add(new Transform("jb.ule", (Transformer)UnusedLocalEliminator.v()));
        p.add(new Transform("jb.tr", (Transformer)TypeAssigner.v()));
        p.add(new Transform("jb.ulp", (Transformer)LocalPacker.v()));
        p.add(new Transform("jb.lns", (Transformer)LocalNameStandardizer.v()));
        p.add(new Transform("jb.cp", (Transformer)CopyPropagator.v()));
        p.add(new Transform("jb.dae", (Transformer)DeadAssignmentEliminator.v()));
        p.add(new Transform("jb.cp-ule", (Transformer)UnusedLocalEliminator.v()));
        p.add(new Transform("jb.lp", (Transformer)LocalPacker.v()));
        p.add(new Transform("jb.ne", (Transformer)NopEliminator.v()));
        p.add(new Transform("jb.uce", (Transformer)UnreachableCodeEliminator.v()));
        p = new JavaToJimpleBodyPack();
        this.addPack((Pack)p);
        p.add(new Transform("jj.ls", (Transformer)LocalSplitter.v()));
        p.add(new Transform("jj.a", (Transformer)Aggregator.v()));
        p.add(new Transform("jj.ule", (Transformer)UnusedLocalEliminator.v()));
        p.add(new Transform("jj.ne", (Transformer)NopEliminator.v()));
        p.add(new Transform("jj.tr", (Transformer)TypeAssigner.v()));
        p.add(new Transform("jj.ulp", (Transformer)LocalPacker.v()));
        p.add(new Transform("jj.lns", (Transformer)LocalNameStandardizer.v()));
        p.add(new Transform("jj.cp", (Transformer)CopyPropagator.v()));
        p.add(new Transform("jj.dae", (Transformer)DeadAssignmentEliminator.v()));
        p.add(new Transform("jj.cp-ule", (Transformer)UnusedLocalEliminator.v()));
        p.add(new Transform("jj.lp", (Transformer)LocalPacker.v()));
        p.add(new Transform("jj.uce", (Transformer)UnreachableCodeEliminator.v()));
        p = new CallGraphPack("cg");
        this.addPack((Pack)p);
        p.add(new Transform("cg.cha", (Transformer)CHATransformer.v()));
        p.add(new Transform("cg.spark", (Transformer)SparkTransformer.v()));
        p.add(new Transform("cg.paddle", (Transformer)PaddleHook.v()));
        p = new ScenePack("wstp");
        this.addPack((Pack)p);
        p = new ScenePack("wsop");
        this.addPack((Pack)p);
        p = new ScenePack("wjtp");
        this.addPack((Pack)p);
        p.add(new Transform("wjtp.finishAsyncTransformer", (Transformer)FinishAsyncTransformer.v()));
        p = new ScenePack("wjop");
        this.addPack((Pack)p);
        p.add(new Transform("wjop.smb", (Transformer)StaticMethodBinder.v()));
        p.add(new Transform("wjop.si", (Transformer)StaticInliner.v()));
        p = new ScenePack("wjap");
        this.addPack((Pack)p);
        p.add(new Transform("wjap.ra", (Transformer)RectangularArrayFinder.v()));
        p.add(new Transform("wjap.umt", (Transformer)UnreachableMethodsTagger.v()));
        p.add(new Transform("wjap.uft", (Transformer)UnreachableFieldsTagger.v()));
        p.add(new Transform("wjap.tqt", (Transformer)TightestQualifiersTagger.v()));
        p.add(new Transform("wjap.cgg", (Transformer)CallGraphGrapher.v()));
        p.add(new Transform("wjap.purity", (Transformer)PurityAnalysis.v()));
        p = new BodyPack("shimple");
        this.addPack((Pack)p);
        p = new BodyPack("stp");
        this.addPack((Pack)p);
        p = new BodyPack("sop");
        this.addPack((Pack)p);
        p.add(new Transform("sop.cpf", (Transformer)SConstantPropagatorAndFolder.v()));
        p = new BodyPack("jtp");
        this.addPack((Pack)p);
        p = new BodyPack("jop");
        this.addPack((Pack)p);
        p.add(new Transform("jop.cse", (Transformer)CommonSubexpressionEliminator.v()));
        p.add(new Transform("jop.bcm", (Transformer)BusyCodeMotion.v()));
        p.add(new Transform("jop.lcm", (Transformer)LazyCodeMotion.v()));
        p.add(new Transform("jop.cp", (Transformer)CopyPropagator.v()));
        p.add(new Transform("jop.cpf", (Transformer)ConstantPropagatorAndFolder.v()));
        p.add(new Transform("jop.cbf", (Transformer)ConditionalBranchFolder.v()));
        p.add(new Transform("jop.dae", (Transformer)DeadAssignmentEliminator.v()));
        p.add(new Transform("jop.nce", (Transformer)new NullCheckEliminator()));
        p.add(new Transform("jop.uce1", (Transformer)UnreachableCodeEliminator.v()));
        p.add(new Transform("jop.ubf1", (Transformer)UnconditionalBranchFolder.v()));
        p.add(new Transform("jop.uce2", (Transformer)UnreachableCodeEliminator.v()));
        p.add(new Transform("jop.ubf2", (Transformer)UnconditionalBranchFolder.v()));
        p.add(new Transform("jop.ule", (Transformer)UnusedLocalEliminator.v()));
        p = new BodyPack("complex");
        this.addPack((Pack)p);
        p.add(new Transform("complex.bodyproc", (Transformer)HjComplexTransformer.v()));
        p = new BodyPack("conformance");
        this.addPack((Pack)p);
        p.add(new Transform("conformance.bodyproc", (Transformer)HjConformanceTransformer.v()));
        p = new BodyPack("hjopti");
        this.addPack((Pack)p);
        p.add(new Transform("hjopti.ls", (Transformer)LocalSplitter.v()));
        p.add(new Transform("hjopti.a", (Transformer)Aggregator.v()));
        p.add(new Transform("hjopti.ule", (Transformer)UnusedLocalEliminator.v()));
        p.add(new Transform("hjopti.lns", (Transformer)LocalNameStandardizer.v()));
        p.add(new Transform("hjopti.cp", (Transformer)CopyPropagator.v()));
        p.add(new Transform("hjopti.dae", (Transformer)DeadAssignmentEliminator.v()));
        p.add(new Transform("hjopti.cp-ule", (Transformer)UnusedLocalEliminator.v()));
        p.add(new Transform("hjopti.uce", (Transformer)UnreachableCodeEliminator.v()));
        p = new BodyPack("hj");
        this.addPack((Pack)p);
        p.add(new Transform("hj.rst", (Transformer)HjRSTTranslator.v()));
        p.add(new Transform("hj.mhp", (Transformer)HjMHPTranslator.v()));
        if (HjOptions.v().felc()) {
            p.add(new Transform("hj.felc", (Transformer)HjFELCTranslator.v()));
        }
        p.add(new Transform("hj.hpir2mpir", (Transformer)HjHPIRToMPIRTranslator.v()));
        p.add(new Transform("hj.phasercommand", (Transformer)HjNextTranslator.v()));
        p.add(new Transform("hj.internalobjects", (Transformer)HjInternalObjectsTranslator.v()));
        if (HjOptions.v().rae()) {
            p = new ScenePack("rae");
            this.addPack((Pack)p);
            p.add(new Transform("rae.run", (Transformer)HjRedundantAsyncElim.v()));
        }
        p = new BodyPack("wshrt");
        this.addPack((Pack)p);
        p.add(new Transform("wshrt.mpir2lpir", (Transformer)HjRuntimeTranslator.v()));
        if (TargetedHjRuntime.isRuntimeWorkSharingCooperative()) {
            p = new ScenePack("wshc");
            this.addPack((Pack)p);
            p.add(new Transform("wshc.futuregettrans", (Transformer)HjCooperativeFutureGetTranslator.v()));
            p.add(new Transform("wshc.phaserwaittrans", (Transformer)HjCooperativePhaserWaitTranslator.v()));
            p.add(new Transform("wshc.pausemarker", (Transformer)HjPausableMethodMarker.v()));
        }
        p = new ScenePack("wstrt");
        this.addPack((Pack)p);
        p.add(new Transform("wstrt.wf", (Transformer)HjWSTranslator.v()));
        p = new ScenePack("ovd");
        this.addPack((Pack)p);
        p.add(new Transform("ovd.codegen", (Transformer)HjOVDTranslator.v()));
        p = new ScenePack("racedet");
        this.addPack((Pack)p);
        p.add(new Transform("racedet.codegen", (Transformer)RaceDetInstrumentor.v()));
        p = new ScenePack("graphics");
        this.addPack((Pack)p);
        p.add(new Transform("graphics.codegen", (Transformer)GraphicsInstrumentor.v()));
        p = new ScenePack("jl5");
        this.addPack((Pack)p);
        p.add(new Transform("jl5.codegen", (Transformer)BridgeMethodGenerator.v()));
        p = new BodyPack("jap");
        this.addPack((Pack)p);
        p.add(new Transform("jap.npc", (Transformer)NullPointerChecker.v()));
        p.add(new Transform("jap.npcolorer", (Transformer)NullPointerColorer.v()));
        p.add(new Transform("jap.abc", (Transformer)ArrayBoundsChecker.v()));
        p.add(new Transform("jap.profiling", (Transformer)ProfilingGenerator.v()));
        p.add(new Transform("jap.sea", (Transformer)SideEffectTagger.v()));
        p.add(new Transform("jap.fieldrw", (Transformer)FieldTagger.v()));
        p.add(new Transform("jap.cgtagger", (Transformer)CallGraphTagger.v()));
        p.add(new Transform("jap.parity", (Transformer)ParityTagger.v()));
        p.add(new Transform("jap.pat", (Transformer)ParameterAliasTagger.v()));
        p.add(new Transform("jap.rdtagger", (Transformer)ReachingDefsTagger.v()));
        p.add(new Transform("jap.lvtagger", (Transformer)LiveVarsTagger.v()));
        p.add(new Transform("jap.che", (Transformer)CastCheckEliminatorDumper.v()));
        p.add(new Transform("jap.umt", (Transformer)new UnreachableMethodTransformer()));
        p.add(new Transform("jap.lit", (Transformer)LoopInvariantFinder.v()));
        p.add(new Transform("jap.aet", (Transformer)AvailExprTagger.v()));
        p.add(new Transform("jap.dmt", (Transformer)DominatorsTagger.v()));
        p = new BodyPack("gb");
        this.addPack((Pack)p);
        p.add(new Transform("gb.a1", (Transformer)Aggregator.v()));
        p.add(new Transform("gb.cf", (Transformer)ConstructorFolder.v()));
        p.add(new Transform("gb.a2", (Transformer)Aggregator.v()));
        p.add(new Transform("gb.ule", (Transformer)UnusedLocalEliminator.v()));
        p = new BodyPack("gop");
        this.addPack((Pack)p);
        p = new BodyPack("bb");
        this.addPack((Pack)p);
        p.add(new Transform("bb.lso", (Transformer)LoadStoreOptimizer.v()));
        p.add(new Transform("bb.pho", (Transformer)PeepholeOptimizer.v()));
        p.add(new Transform("bb.ule", (Transformer)UnusedLocalEliminator.v()));
        p.add(new Transform("bb.lp", (Transformer)LocalPacker.v()));
        p = new BodyPack("bop");
        this.addPack((Pack)p);
        p = new BodyPack("tag");
        this.addPack((Pack)p);
        p.add(new Transform("tag.ln", (Transformer)LineNumberTagAggregator.v()));
        p.add(new Transform("tag.an", (Transformer)ArrayNullTagAggregator.v()));
        p.add(new Transform("tag.dep", (Transformer)DependenceTagAggregator.v()));
        p.add(new Transform("tag.fieldrw", (Transformer)FieldTagAggregator.v()));
        p = new BodyPack("db");
        this.addPack((Pack)p);
        p.add(new Transform("db.transformations", null));
        p.add(new Transform("db.renamer", null));
        p.add(new Transform("db.deobfuscate", null));
        p.add(new Transform("db.force-recompile", null));
        this.onlyStandardPacks = true;
    }

    private void addExtraClasses() {
        Iterator<SootClass> extraClassIter = ((HjScene)Scene.v()).extraClasses.iterator();
        while (extraClassIter.hasNext()) {
            Scene.v().getApplicationClasses().add((Object)extraClassIter.next());
        }
        ((HjScene)Scene.v()).extraClasses.clear();
    }

    protected void runBodyPacks() {
        Iterator classIter = this.reachableClasses();
        while (classIter.hasNext()) {
            Iterator methodIter = ((SootClass)classIter.next()).methodIterator();
            while (methodIter.hasNext()) {
                SootMethod method = (SootMethod)methodIter.next();
                if (!method.isConcrete()) continue;
                Body body = method.retrieveActiveBody();
            }
        }
        while (HjComplexTransformer.v().inlineComplex(this.reachableClasses())) {
        }
        HjComplexTransformer.v().handleMethods(this.reachableClasses());
        this.applyTransform(PackManager.v().getPack("complex"));
        HjComplexTransformer.v().cleanClass(this.reachableClasses());
        this.addExtraClasses();
        if (HjOptions.v().racedet()) {
            this.getPack("racedet").apply();
        }
        this.applyTransform(PackManager.v().getPack("hj"));
        if (HjOptions.v().rae()) {
            this.getPack("rae").apply();
        }
        if (HjOptions.v().dcg()) {
            this.getPack("graphics").apply();
        }
        if (TargetedHjRuntime.isRuntimeWorkStealing()) {
            this.getPack("cg").apply();
            this.getPack("wstrt").apply();
            PaddleHook.v().finishPhases();
        } else {
            this.applyTransform(PackManager.v().getPack("wshrt"));
        }
        this.addExtraClasses();
        if (TargetedHjRuntime.isRuntimeWorkSharingCooperative()) {
            this.getPack("wshc").apply();
        }
        if (HjOptions.v().ovd()) {
            this.getPack("ovd").apply();
        }
        this.applyTransform(PackManager.v().getPack("hjopti"));
        this.getPack("jl5").apply();
        this.applyTransform(PackManager.v().getPack("conformance"));
    }

    public void writeOutput() {
        super.writeOutput();
        if (HjOptions.v().verify()) {
            try {
                PostCompileVerifier.verify((String)Scene.v().getMainClass().getName(), (String)Options.v().output_dir(), (boolean)false);
            }
            catch (PostCompileVerifier.PostCompileVerificationException t) {
                throw new CompilationDeathException(t.getMessage(), (Throwable)t);
            }
        }
    }

    private void applyTransform(Pack p) {
        for (Transform transform : p) {
            Iterator classIter = this.reachableClasses();
            while (classIter.hasNext()) {
                Iterator<SootMethod> methodIter = HjUtil.snapMethodIter((SootClass)classIter.next());
                while (methodIter.hasNext()) {
                    SootMethod method = methodIter.next();
                    if (!method.isConcrete()) continue;
                    transform.apply(method.retrieveActiveBody());
                }
            }
        }
    }

    protected void runWholeProgramPacks() {
    }

    protected void writeClass(SootClass c) {
        int format;
        if (HjOptions.v().info()) {
            System.out.println("SOOT writing class: " + c);
        }
        if ((format = Options.v().output_format()) == 10) {
            return;
        }
        if (format == 13) {
            return;
        }
        OutputStream streamOut = null;
        PrintWriter writerOut = null;
        String fileName = SourceLocator.v().getFileNameFor(c, format);
        if (Options.v().gzip()) {
            fileName = fileName + ".gz";
        }
        OutputStream fileOutputStream = null;
        try {
            if (this.jarFile != null) {
                ZipEntry entry = new ZipEntry(fileName);
                this.jarFile.putNextEntry(entry);
                streamOut = this.jarFile;
            } else {
                new File(fileName).getParentFile().mkdirs();
                streamOut = new FileOutputStream(fileName);
                fileOutputStream = streamOut;
            }
            if (Options.v().gzip()) {
                streamOut = new GZIPOutputStream(streamOut);
            }
            if (format == 12) {
                streamOut = new JasminOutputStream(streamOut);
            }
            writerOut = new PrintWriter(new OutputStreamWriter(streamOut));
            if (HjOptions.v().info()) {
                G.v().out.println("Writing to " + fileName);
            }
            if (Options.v().xml_attributes()) {
                Printer.v().setOption(16);
            }
            switch (format) {
                case 11: 
                case 12: {
                    if (c.containsBafBody()) {
                        new JasminClass(c).print(writerOut);
                        break;
                    }
                    new HjJasminClass(c).print(writerOut);
                    break;
                }
                case 2: 
                case 4: 
                case 6: 
                case 8: {
                    Printer.v().setOption(1);
                    Printer.v().printTo(c, writerOut);
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 7: {
                    writerOut = new PrintWriter((Writer)new EscapedWriter((Writer)new OutputStreamWriter(streamOut)));
                    Printer.v().printTo(c, writerOut);
                    break;
                }
                case 9: {
                    writerOut = new PrintWriter((Writer)new EscapedWriter((Writer)new OutputStreamWriter(streamOut)));
                    XMLPrinter.v().printJimpleStyleTo(c, writerOut);
                    break;
                }
                case 14: {
                    writerOut = new PrintWriter(new OutputStreamWriter(streamOut));
                    TemplatePrinter.v().printTo(c, writerOut);
                    break;
                }
                default: {
                    throw new RuntimeException();
                }
            }
            writerOut.flush();
            streamOut.close();
        }
        catch (Throwable e) {
            new File(fileName).delete();
            throw new RuntimeException(e);
        }
    }

    protected void retrieveAllBodies() {
        Iterator clIt = this.reachableClasses();
        while (clIt.hasNext()) {
            SootClass cl = (SootClass)clIt.next();
            Iterator methodIt = cl.methodIterator();
            while (methodIt.hasNext()) {
                SootMethod m = (SootMethod)methodIt.next();
                if (DEBUG && cl.isApplicationClass()) {
                    if (m.getExceptions().size() != 0) {
                        System.out.println("PackManager printing out from within retrieveAllBodies exceptions for method " + m.toString() + " " + m.getExceptions().toString());
                    } else {
                        System.out.println("in retrieveAllBodies......Currently Method " + m.toString() + " has no exceptions ");
                    }
                }
                if (!m.isConcrete()) continue;
            }
        }
        this.addExtraClasses();
    }
}

