/*
 * Decompiled with CFR 0.152.
 */
package soot.hj;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import soot.G;
import soot.Scene;
import soot.Singletons;
import soot.SootClass;
import soot.SourceLocator;
import soot.hj.HjClassProvider;
import soot.hj.options.HjOptions;
import soot.javaToJimple.Util;
import soot.options.Options;
import soot.util.Chain;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HjScene
extends Scene {
    public ArrayList<SootClass> extraClasses = new ArrayList();

    public HjScene(Singletons.Global g) {
        super(g);
    }

    protected List<String> getClassName() {
        LinkedList ll = Options.v().classes();
        LinkedList llc = new LinkedList();
        llc.addAll(ll);
        ll.removeAll(llc);
        for (String className : llc) {
            className = HjClassProvider.removeHjExtension(className);
            ll.add(className);
        }
        return ll;
    }

    public void loadNecessaryClasses() {
        this.loadBasicClasses();
        List<String> classes = this.getClassName();
        while (!classes.isEmpty()) {
            String name = classes.remove(0);
            this.loadNecessaryClass(name);
        }
        this.loadDynamicClasses();
        for (String path : Options.v().process_dir()) {
            for (String cl : SourceLocator.v().getClassesUnder(path)) {
                this.loadClassAndSupport(cl).setApplicationClass();
            }
        }
        this.prepareClasses();
        this.setDoneResolving();
    }

    public String getSootClassPath() {
        if (this.sootClassPath == null) {
            this.sootClassPath = super.getSootClassPath();
            assert (this.sootClassPath != null);
            String optionssp = HjOptions.v().sourcepath();
            if (optionssp.length() > 0) {
                this.sootClassPath = Options.v().prepend_classpath() ? this.sootClassPath + File.pathSeparator + optionssp : optionssp + File.pathSeparator + this.sootClassPath;
            }
        }
        return this.sootClassPath;
    }

    protected void addSootBasicClasses() {
        super.addSootBasicClasses();
        this.addBasicClass("java.util.List");
        this.addBasicClass("java.util.Iterator", 2);
        this.addBasicClass("java.util.LinkedList", 2);
        this.addBasicClass("java.util.Collection");
        this.addBasicClass("hj.lang.place", 2);
        this.addBasicClass("hj.lang.Runtime", 2);
        this.addBasicClass("hj.lang.activity");
        this.addBasicClass("hj.runtime.wsh.blocking.WshBlockingRuntime");
        this.addBasicClass("hj.runtime.wsh.blocking.BlockingActivity", 2);
        this.addBasicClass("hj.runtime.wsh.cooperative.WshCooperativeRuntime");
        this.addBasicClass("hj.runtime.wsh.cooperative.SuspendableActivity", 2);
        this.addBasicClass("hj.runtime.wsh.cooperative.SuspendableFuture", 2);
        this.addBasicClass("hj.lang.Future", 2);
        this.addBasicClass("hj.runtime.wst.adaptive.UnCatchableWorkerException");
        this.addBasicClass("hj.runtime.wsh.WshFuture", 2);
        this.addBasicClass("hj.lang.phaser", 2);
        this.addBasicClass("hj.lang.PhaserAbst");
        this.addBasicClass("hj.runtime.wsh.phaser.PhaserImpl", 2);
        this.addBasicClass("hj.lang.phaserRegMode", 2);
        this.addBasicClass("hj.runtime.wsh.phaser.PhaserRegModeImpl", 2);
        this.addBasicClass("hj.lang.phaserMode");
        this.addBasicClass("hj.array.view.ObjectArrayView");
        this.addBasicClass("hj.array.view.ShortArrayView");
        this.addBasicClass("hj.array.view.IntArrayView");
        this.addBasicClass("hj.array.view.LongArrayView");
        this.addBasicClass("hj.array.view.DoubleArrayView");
        this.addBasicClass("hj.array.view.FloatArrayView");
        this.addBasicClass("hj.array.view.BooleanArrayView");
        this.addBasicClass("hj.array.view.CharArrayView");
        this.addBasicClass("hj.array.view.ByteArrayView");
        this.addBasicClass("hj.array.view.Complex32ArrayView");
        this.addBasicClass("hj.array.view.Complex64ArrayView");
        this.addBasicClass("hj.array.sharedmemory.SpecializedArrayFactory");
        this.addBasicClass("hj.runtime.wst.adaptive.Runtime");
        this.addBasicClass("hj.runtime.wst.adaptive.Worker");
        this.addBasicClass("hj.runtime.wst.adaptive.Closure");
        this.addBasicClass("hj.runtime.wst.adaptive.ActivationFrame");
        this.addBasicClass("hj.runtime.wst.basic.Worker");
        this.addBasicClass("hj.runtime.wst.adaptive.BfAsyncFrame");
        this.addBasicClass("hj.runtime.wst.adaptive.DelayedAsync");
        this.addBasicClass("hj.lang.point");
        this.addBasicClass("hj.lang.dist", 2);
        this.addBasicClass("hj.lang.region");
        this.addBasicClass("hj.lang.region$factory");
        this.addBasicClass("hj.array.Operator$Pointwise");
        this.addBasicClass("hj.runtime.wsh.ovd.WshOVDManager");
        this.addBasicClass("kilim.Pausable");
    }

    public void setMainClassFromOptions() {
        if (this.mainClass != null) {
            return;
        }
        if (Options.v().main_class() != null && Options.v().main_class().length() > 0) {
            this.setMainClass(this.getSootClass(Options.v().main_class()));
        } else {
            for (SootClass c : this.getApplicationClasses()) {
                if (!Util.declaresMainMethod((SootClass)c)) continue;
                G.v().out.println("No main class given. Inferred '" + c.getName() + "' as main class.");
                this.setMainClass(c);
                break;
            }
        }
    }

    public Chain<SootClass> getApplicationClasses() {
        return super.getApplicationClasses();
    }
}

