/*
 * Decompiled with CFR 0.152.
 */
package soot.hj;

import hj.process.PostCompile;
import java.util.LinkedList;
import polyglot.ext.hj.Version;
import soot.CompilationDeathException;
import soot.G;
import soot.Main;
import soot.Singletons;
import soot.factory.ISootFactory;
import soot.factory.SootFactory;
import soot.hj.HjSingletons;
import soot.hj.factory.SootFactoryHj;
import soot.hj.options.HjOptions;
import soot.options.Options;

public class HjSootMain
extends Main {
    public HjSootMain(Singletons.Global g) {
        super(g);
    }

    protected void printVersion() {
        G.v().out.println("Habanero-Java Compiler (build " + Version.getVersion() + ")");
        super.printVersion();
    }

    protected void postCmdLineCheck() {
        super.postCmdLineCheck();
        this.postCmdLineHjCheck();
        if (Options.v().classes().isEmpty() && Options.v().process_dir().isEmpty()) {
            throw new CompilationDeathException(0, "No input classes specified!");
        }
    }

    public int run(String[] args) {
        args = HjOptions.v().parse(args);
        if (args == null) {
            throw new CompilationDeathException(0, "Option parse error");
        }
        return super.run(args);
    }

    private void postCmdLineHjCheck() {
        LinkedList<String> l;
        Options.v().set_keep_line_number(true);
        if (HjOptions.v().dcg()) {
            l = new LinkedList<String>();
            l.addAll(Options.v().dynamic_package());
            l.add("hj.runtime.graphics");
            Options.v().set_dynamic_package(l);
        }
        if (HjOptions.v().racedet()) {
            l = new LinkedList();
            l.addAll(Options.v().dynamic_package());
            l.add("hj.runtime.wst");
            Options.v().set_dynamic_package(l);
            Options.v().set_keep_line_number(true);
            HjOptions.v().set_rt(3);
        }
    }

    public static void main(String[] args) {
        int ret = HjSootMain.mainEntry(args);
        System.exit(ret);
    }

    public static int mainEntry(String[] args) {
        SootFactory.instantiate((ISootFactory)new SootFactoryHj());
        int ret = Main.mainEntry((String[])args);
        return HjSootMain.postCompilationProcessing(args, ret, 0);
    }

    public static int mainEntryNoReset(String[] args) {
        SootFactory.instantiate((ISootFactory)new SootFactoryHj());
        int ret = Main.mainEntryNoReset((String[])args);
        return HjSootMain.postCompilationProcessing(args, ret, 1);
    }

    private static int postCompilationProcessing(String[] args, int ret, int expectedRet) {
        if (ret == expectedRet) {
            PostCompile.main((String[])args);
        }
        return ret;
    }

    public static void reset() {
        Main.reset();
        HjSingletons.reset();
    }
}

