/*
 * Decompiled with CFR 0.152.
 */
package soot.hj;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import soot.ClassSource;
import soot.G;
import soot.Scene;
import soot.Singletons;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.SootResolver;
import soot.SourceLocator;
import soot.Type;
import soot.javaToJimple.IInitialResolver;
import soot.options.Options;

public class HjSootResolver
extends SootResolver {
    private final List<SootClass>[] processed = new LinkedList[4];

    public HjSootResolver(Singletons.Global g) {
        super(g, false);
        this.processed[1] = new LinkedList<SootClass>();
        this.processed[2] = new LinkedList<SootClass>();
        this.processed[3] = new LinkedList<SootClass>();
    }

    protected void processResolveWorklist() {
        for (int i = 3; i >= 1; --i) {
            while (!this.worklist[i].isEmpty()) {
                SootClass sc = (SootClass)this.worklist[i].remove(0);
                if (this.isVendorVMLibrary(sc)) continue;
                if (this.isLibraryClass(sc)) {
                    this.bringToSignatures(sc, false);
                    continue;
                }
                if (this.isHjLibrary(sc)) {
                    this.bringToSignatures(sc, false);
                    continue;
                }
                if (sc.isPhantom()) {
                    this.bringToSignatures(sc, false);
                    continue;
                }
                this.bringToBodies(sc);
            }
        }
    }

    private boolean isLibraryClass(SootClass sc) {
        return this.isJavaLibrary(sc);
    }

    private boolean isHjLibrary(SootClass sc) {
        String toStr = sc.toString();
        if (toStr.startsWith("hj")) {
            return toStr.startsWith("hj.lang") || toStr.startsWith("hj.runtime") || toStr.startsWith("hj.array") || toStr.startsWith("hj.base") || toStr.startsWith("hj.util") || toStr.startsWith("hj.compilergenerated");
        }
        if (toStr.startsWith("jsr166y")) {
            return true;
        }
        return toStr.startsWith("kilim");
    }

    private boolean isJavaLibrary(SootClass sc) {
        return sc.toString().startsWith("java");
    }

    private boolean isVendorVMLibrary(SootClass sc) {
        return sc.toString().startsWith("sun") || sc.toString().startsWith("com.ibm");
    }

    protected void addToResolveWorklist(SootClass sc, int desiredLevel) {
        if (sc.resolvingLevel() >= desiredLevel) {
            return;
        }
        if (!this.processed[desiredLevel].contains(sc)) {
            super.addToResolveWorklist(sc, desiredLevel);
            this.processed[desiredLevel].add(sc);
        }
    }

    protected void bringToHierarchy(SootClass sc, boolean resolveDependencies) {
        boolean modelAsPhantomRef;
        String scName = sc.toString();
        assert (!scName.substring(scName.indexOf("$") + 1, scName.length()).startsWith("null"));
        if (sc.resolvingLevel() >= 1) {
            return;
        }
        if (Options.v().debug_resolver()) {
            G.v().out.println("bringing to HIERARCHY: " + sc);
        }
        sc.setResolvingLevel(1);
        String className = sc.getName();
        ClassSource is = SourceLocator.v().getClassSource(className);
        boolean bl = modelAsPhantomRef = is == null;
        if (modelAsPhantomRef) {
            if (!Scene.v().allowsPhantomRefs()) {
                String suffix = "";
                if (className.equals("java.lang.Object")) {
                    suffix = " Try adding rt.jar to Soot's classpath, e.g.:\njava -cp sootclasses.jar soot.hj.HjSootMain -cp .:/path/to/jdk/jre/lib/rt.jar <other options>";
                } else if (className.equals("javax.crypto.Cipher")) {
                    suffix = " Try adding jce.jar to Soot's classpath, e.g.:\njava -cp sootclasses.jar soot.hj.HjSootMain -cp .:/path/to/jdk/jre/lib/rt.jar:/path/to/jdk/jre/lib/jce.jar <other options>";
                }
                throw new RuntimeException("couldn't find class: " + className + " (is your soot-class-path set properly?)" + suffix);
            }
            G.v().out.println("Warning: " + className + " is a phantom class!");
            sc.setPhantomClass();
            this.classToTypesSignature.put(sc, new ArrayList());
            this.classToTypesHierarchy.put(sc, new ArrayList());
        } else {
            IInitialResolver.Dependencies dependencies = is.resolve(sc);
            if (resolveDependencies) {
                this.classToTypesSignature.put(sc, new ArrayList(dependencies.typesToSignature));
                this.classToTypesHierarchy.put(sc, new ArrayList(dependencies.typesToHierarchy));
            }
        }
        this.reResolveHierarchy(sc);
    }

    protected void bringToSignatures(SootClass sc, boolean resolveDependencies) {
        if (sc.resolvingLevel() >= 2) {
            return;
        }
        this.bringToHierarchy(sc, resolveDependencies);
        if (Options.v().debug_resolver()) {
            G.v().out.println("bringing to SIGNATURES: " + sc);
        }
        sc.setResolvingLevel(2);
        for (SootField f : sc.getFields()) {
            this.addToResolveWorklist(f.getType(), 1);
        }
        for (SootMethod m : sc.getMethods()) {
            this.addToResolveWorklist(m.getReturnType(), 1);
            for (Type ptype : m.getParameterTypes()) {
                this.addToResolveWorklist(ptype, 1);
            }
            for (SootClass exception : m.getExceptions()) {
                this.addToResolveWorklist(exception, 1);
            }
        }
        if (sc.hasSuperclass()) {
            this.addToResolveWorklist(sc.getSuperclass(), 2);
        }
        for (SootClass iface : sc.getInterfaces()) {
            this.addToResolveWorklist(iface, 2);
        }
    }

    protected void bringToBodies(SootClass sc) {
        if (sc.resolvingLevel() >= 3) {
            return;
        }
        this.bringToSignatures(sc, true);
        if (Options.v().debug_resolver()) {
            G.v().out.println("bringing to BODIES: " + sc);
        }
        sc.setResolvingLevel(3);
        Collection references = (Collection)this.classToTypesHierarchy.get(sc);
        if (references == null) {
            return;
        }
        for (Object o : references) {
            if (o instanceof String) {
                this.addToResolveWorklist((String)o, 1);
                continue;
            }
            if (o instanceof Type) {
                this.addToResolveWorklist((Type)o, 1);
                continue;
            }
            throw new RuntimeException(o.toString());
        }
        references = (Collection)this.classToTypesSignature.get(sc);
        if (references == null) {
            return;
        }
        for (Object o : references) {
            if (o instanceof String) {
                this.addToResolveWorklist((String)o, 2);
                continue;
            }
            if (o instanceof Type) {
                String scName = o.toString();
                assert (!scName.substring(scName.indexOf("$") + 1, scName.length()).startsWith("null"));
                this.addToResolveWorklist((Type)o, 2);
                continue;
            }
            throw new RuntimeException(o.toString());
        }
    }
}

