/*
 * Decompiled with CFR 0.152.
 */
package soot.hj;

import polyglot.ext.hj.types.HjArrayViewType;
import polyglot.ext.hj.types.HjType;
import polyglot.ext.hj.types.HjTypeSystem;
import polyglot.types.ClassDef;
import polyglot.types.ClassType;
import polyglot.util.IdentityKey;
import soot.ArrayType;
import soot.BooleanType;
import soot.ByteType;
import soot.CharType;
import soot.DoubleType;
import soot.FloatType;
import soot.IntType;
import soot.LongType;
import soot.NullType;
import soot.RefType;
import soot.ShortType;
import soot.Type;
import soot.VoidType;
import soot.factory.ISootType;
import soot.factory.SootType;
import soot.hj.HjToJimple.jimple.Complex32Type;
import soot.hj.HjToJimple.jimple.Complex64Type;
import soot.hj.HjToJimple.jimple.FutureType;
import soot.hj.HjToJimple.jimple.utils.ArrayViewUtils;
import soot.javaToJimple.InitialResolver;

public class HjSootType
extends SootType
implements ISootType {
    public Type getSootType(polyglot.types.Type typeParam) {
        if (typeParam == null) {
            throw new RuntimeException("Trying to get soot type for null polyglot type");
        }
        HjType type = (HjType)typeParam;
        HjTypeSystem hts = (HjTypeSystem)type.typeSystem();
        Object sootType = null;
        if (type.isArray()) {
            polyglot.types.Type polyglotBase = ((polyglot.types.ArrayType)type).base();
            while (polyglotBase instanceof polyglot.types.ArrayType) {
                polyglotBase = ((polyglot.types.ArrayType)polyglotBase).base();
            }
            Type baseType = this.getSootType(polyglotBase);
            int dims = ((polyglot.types.ArrayType)type).dims();
            sootType = ArrayType.v((Type)baseType, (int)dims);
        } else if (type.isPrimitive()) {
            if (type.isInt()) {
                sootType = IntType.v();
            } else if (type.isBoolean()) {
                sootType = BooleanType.v();
            } else if (type.isByte()) {
                sootType = ByteType.v();
            } else if (type.isChar()) {
                sootType = CharType.v();
            } else if (type.isDouble()) {
                sootType = DoubleType.v();
            } else if (type.isFloat()) {
                sootType = FloatType.v();
            } else if (type.isLong()) {
                sootType = LongType.v();
            } else if (type.isShort()) {
                sootType = ShortType.v();
            } else if (type.isNull()) {
                sootType = NullType.v();
            } else if (type.isVoid()) {
                sootType = VoidType.v();
            } else if (type.isComplex32()) {
                sootType = Complex32Type.v();
            } else if (type.isComplex64()) {
                sootType = Complex64Type.v();
            }
        } else if (type.isArrayView()) {
            sootType = ArrayViewUtils.getHjArrayViewType(this.getSootType(((HjArrayViewType)type).base()));
        } else if (type.isClass()) {
            String className;
            ClassType classType = (ClassType)type;
            ClassDef classDef = (ClassDef)classType.def();
            if (classType.isNested()) {
                IdentityKey key = new IdentityKey((Object)classDef);
                if (classType.isAnonymous() && InitialResolver.v().getAnonTypeMap().containsKey(key)) {
                    className = (String)InitialResolver.v().getAnonTypeMap().get(key);
                } else if (classType.isLocal() && InitialResolver.v().getLocalTypeMap() != null && InitialResolver.v().getLocalTypeMap().containsKey(key)) {
                    className = (String)InitialResolver.v().getLocalTypeMap().get(key);
                } else {
                    String pkgName = "";
                    if (classType.package_() != null) {
                        pkgName = classType.package_().fullName().toString();
                    }
                    className = classType.name().toString();
                    if (classType.isAnonymous()) {
                        throw new RuntimeException("Compiler Internal Error: Anonymous class should have been processed before");
                    }
                    if (classType.outer().isAnonymous() || classType.outer().isLocal()) {
                        className = this.getSootType((polyglot.types.Type)classType.outer()).toString() + "$" + className;
                    } else {
                        while (classType.outer() != null) {
                            className = classType.outer().name() + "$" + className;
                            classType = classType.outer();
                        }
                        if (!pkgName.equals("")) {
                            className = pkgName + "." + className;
                        }
                    }
                }
            } else {
                className = classType.fullName().toString();
            }
            sootType = RefType.v((String)className);
        } else if (hts.isFuture((polyglot.types.Type)type)) {
            sootType = FutureType.v("hj.lang.Future", this.getSootType(((polyglot.ext.hj.types.FutureType)type).base()));
        } else {
            throw new RuntimeException("Unknown Type: " + type + " --> class: " + type.getClass().getName());
        }
        return sootType;
    }
}

