/*
 * Decompiled with CFR 0.152.
 */
package soot.hj;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import polyglot.util.FileUtil;
import polyglot.util.InternalCompilerError;
import soot.CoffiClassProvider;
import soot.CompilationDeathException;
import soot.G;
import soot.JavaClassProvider;
import soot.JimpleClassProvider;
import soot.Singletons;
import soot.SourceLocator;
import soot.hj.HjClassProvider;
import soot.options.Options;

public class HjSourceLocator
extends SourceLocator {
    protected Map zipCache = new HashMap();
    protected Set dirCache;
    protected Map dirContentsCache = new HashMap();
    protected static final Object not_found = new Object();

    public HjSourceLocator(Singletons.Global g) {
        super(g);
        this.dirCache = new HashSet();
    }

    protected void setupClassProviders() {
        this.classProviders = new LinkedList();
        this.classProviders.add(new HjClassProvider());
        this.classProviders.add(new CoffiClassProvider());
        this.classProviders.add(new JimpleClassProvider());
        this.classProviders.add(new JavaClassProvider());
    }

    public String getOutputDir() {
        File dir;
        String ret = Options.v().output_dir();
        if (ret.length() == 0) {
            ret = ".";
        }
        if (!(dir = new File(ret)).exists()) {
            try {
                if (!Options.v().output_jar()) {
                    dir.mkdirs();
                }
            }
            catch (SecurityException se) {
                G.v().out.println("Unable to create " + ret);
                throw new CompilationDeathException(0);
            }
        }
        return ret;
    }

    public SourceLocator.FoundFile lookupInClassPath(String fileName) {
        for (String dir : this.classPath()) {
            SourceLocator.FoundFile ret = dir.endsWith(".jar") || dir.endsWith(".zip") ? this.lookupInJar(dir, fileName) : this.lookupInDir(dir, fileName);
            if (ret == null) continue;
            return ret;
        }
        return null;
    }

    private SourceLocator.FoundFile lookupInDir(String dir, String fileName) {
        File dirFile = new File(dir);
        return this.loadFromFile(fileName, dirFile);
    }

    private SourceLocator.FoundFile lookupInJar(String jar, String fileName) {
        try {
            ZipFile jarFile = this.loadZip(new File(jar));
            ZipEntry entry = jarFile.getEntry(fileName);
            if (entry == null) {
                return null;
            }
            return new SourceLocator.FoundFile(jarFile, entry);
        }
        catch (IOException e) {
            throw new RuntimeException("Caught IOException " + e + " looking in jar file " + jar + " for file " + fileName);
        }
    }

    SourceLocator.FoundFile loadFromFile(String name, File dir) {
        File file;
        int sepIndex = name.indexOf(File.separatorChar);
        if (sepIndex > 0) {
            File newDir = new File(dir, name.substring(0, sepIndex));
            String newName = name.substring(sepIndex + 1);
            return this.loadFromFile(newName, newDir);
        }
        HashSet<String> dirContents = (HashSet<String>)this.dirContentsCache.get(dir);
        if (dirContents == null) {
            String[] contents;
            dirContents = new HashSet<String>();
            this.dirContentsCache.put(dir, dirContents);
            if (dir.exists() && dir.isDirectory() && (contents = dir.list()) != null) {
                for (int j = 0; j < contents.length; ++j) {
                    dirContents.add(contents[j]);
                }
            }
        }
        if (!(file = new File(dir, name)).exists()) {
            return null;
        }
        String firstPart = name;
        if (!dirContents.contains(firstPart)) {
            return null;
        }
        return new SourceLocator.FoundFile(file);
    }

    public boolean dirExists(File dir, String name) {
        if (!dir.canRead()) {
            return false;
        }
        try {
            if (dir.getName().endsWith(".jar") || dir.getName().endsWith(".zip")) {
                if (this.dirCache.contains(name)) {
                    return true;
                }
                this.loadZip(dir);
                return this.dirCache.contains(name);
            }
            File f = new File(dir, name);
            return f.isDirectory() && FileUtil.checkNameFromRoot((File)dir, (File)f);
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException e) {
            throw new InternalCompilerError((Throwable)e);
        }
        return false;
    }

    ZipFile loadZip(File dir) throws IOException {
        Object o = this.zipCache.get(dir);
        if (o != not_found) {
            ZipFile zip = (ZipFile)o;
            if (zip != null) {
                return zip;
            }
            if (!dir.exists()) {
                this.zipCache.put(dir, not_found);
            } else {
                zip = dir.getName().endsWith(".jar") ? new JarFile(dir) : new ZipFile(dir);
                this.zipCache.put(dir, zip);
                Enumeration<? extends ZipEntry> i = zip.entries();
                while (i.hasMoreElements()) {
                    ZipEntry ei = i.nextElement();
                    String n = ei.getName();
                    int index = n.indexOf(47);
                    while (index >= 0) {
                        this.dirCache.add(n.substring(0, index));
                        index = n.indexOf(47, index + 1);
                    }
                }
                return zip;
            }
        }
        throw new FileNotFoundException(dir.getAbsolutePath());
    }
}

