/*
 * Decompiled with CFR 0.152.
 */
package soot.hj.HjToJimple.graphics;

import java.util.Iterator;
import java.util.Map;
import soot.Scene;
import soot.SceneTransformer;
import soot.Singletons;
import soot.SootClass;
import soot.SootMethod;
import soot.Unit;
import soot.Value;
import soot.hj.HjSingletons;
import soot.hj.HjToJimple.graphics.RuntimeRef;
import soot.hj.HjToJimple.jimple.HjRSTTranslator;
import soot.hj.HjToJimple.jimple.RegionStmt;
import soot.jimple.InvokeStmt;
import soot.jimple.Jimple;
import soot.jimple.JimpleBody;
import soot.jimple.RetStmt;
import soot.jimple.ReturnStmt;
import soot.jimple.ReturnVoidStmt;
import soot.jimple.Stmt;
import soot.jimple.StringConstant;

public class GraphicsInstrumentor
extends SceneTransformer {
    public static final boolean debug = false;

    public GraphicsInstrumentor(Singletons.Global g) {
    }

    public static GraphicsInstrumentor v() {
        return HjSingletons.v().soot_hj_HjToJimple_graphics_GraphicsInstrumentor();
    }

    protected void internalTransform(String phase, Map opts) {
        System.out.println("Instrumenting for Dynamic Computation Graph generation");
        RuntimeRef.initReferences();
        for (SootClass sClass : Scene.v().getApplicationClasses()) {
            Iterator methodsIt = sClass.methodIterator();
            while (methodsIt.hasNext()) {
                SootMethod sMethod = (SootMethod)methodsIt.next();
                if (!this.needsInstrumentation(sMethod)) continue;
                HjRSTTranslator.v().rebuildRST(sMethod.getActiveBody(), phase, null);
                if (sMethod.getName().equals("main")) {
                    this.instrumentMainMethod(sMethod);
                }
                this.instrumentMethod(sMethod);
                GraphicsInstrumentor.removeAsyncFinish(sMethod);
            }
        }
    }

    private boolean needsInstrumentation(SootMethod sMethod) {
        if (sMethod.isAbstract()) {
            return false;
        }
        return sMethod.hasActiveBody();
    }

    private void instrumentMainMethod(SootMethod sMethod) {
        JimpleBody body = (JimpleBody)sMethod.getActiveBody();
        Stmt firstSt = body.getFirstNonIdentityStmt();
        InvokeStmt initSt = Jimple.v().newInvokeStmt((Value)Jimple.v().newStaticInvokeExpr(RuntimeRef.dcgInit.makeRef(), new Value[]{StringConstant.v((String)sMethod.getDeclaringClass().getName())}));
        body.getUnits().insertBefore((Unit)initSt, (Unit)firstSt);
        Iterator unitsIt = sMethod.getActiveBody().getUnits().snapshotIterator();
        while (unitsIt.hasNext()) {
            Stmt st = (Stmt)unitsIt.next();
            if (!(st instanceof RetStmt) && !(st instanceof ReturnStmt) && !(st instanceof ReturnVoidStmt)) continue;
            InvokeStmt endSt = Jimple.v().newInvokeStmt((Value)Jimple.v().newStaticInvokeExpr(RuntimeRef.dcgEnd.makeRef()));
            body.getUnits().insertBefore((Unit)endSt, (Unit)st);
        }
    }

    private void instrumentMethod(SootMethod sMethod) {
        JimpleBody body = (JimpleBody)sMethod.getActiveBody();
        Iterator unitsIt = body.getUnits().snapshotIterator();
        while (unitsIt.hasNext()) {
            Stmt rstEnd;
            Stmt st = (Stmt)unitsIt.next();
            if (!(st instanceof RegionStmt)) continue;
            RegionStmt rst = (RegionStmt)st;
            if (rst.isFinishRegion()) {
                InvokeStmt startFinishSt = Jimple.v().newInvokeStmt((Value)Jimple.v().newStaticInvokeExpr(RuntimeRef.dcgStartFinish.makeRef()));
                body.getUnits().insertBefore((Unit)startFinishSt, (Unit)rst);
                rstEnd = rst.getConnect();
                InvokeStmt endFinishSt = Jimple.v().newInvokeStmt((Value)Jimple.v().newStaticInvokeExpr(RuntimeRef.dcgEndFinish.makeRef()));
                body.getUnits().insertAfter((Unit)endFinishSt, (Unit)rstEnd);
            }
            if (!rst.isAsyncRegion() && !rst.isForEachRegion() || rst.isRegionExit()) continue;
            InvokeStmt startAsyncSt = Jimple.v().newInvokeStmt((Value)Jimple.v().newStaticInvokeExpr(RuntimeRef.dcgStartAsync.makeRef()));
            body.getUnits().insertBefore((Unit)startAsyncSt, (Unit)rst);
            rstEnd = rst.getConnect();
            InvokeStmt endAsyncSt = Jimple.v().newInvokeStmt((Value)Jimple.v().newStaticInvokeExpr(RuntimeRef.dcgEndAsync.makeRef()));
            body.getUnits().insertAfter((Unit)endAsyncSt, (Unit)rstEnd);
        }
    }

    private static void removeAsyncFinish(SootMethod theMethod) {
        JimpleBody body = (JimpleBody)theMethod.getActiveBody();
        Iterator unitsIt = body.getUnits().snapshotIterator();
        while (unitsIt.hasNext()) {
            Stmt st = (Stmt)unitsIt.next();
            if (!(st instanceof RegionStmt)) continue;
            RegionStmt rst = (RegionStmt)st;
            if (rst.isFinishRegion()) {
                Stmt connectSt = rst.getConnect();
                body.getUnits().remove((Object)rst);
                body.getUnits().remove((Object)connectSt);
                continue;
            }
            if (!rst.isAsyncRegion()) continue;
            body.getUnits().remove((Object)rst);
        }
    }
}

