/*
 * Decompiled with CFR 0.152.
 */
package soot.hj.HjToJimple.jimple;

import java.util.ArrayList;
import soot.ClassMember;
import soot.RefType;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.Value;
import soot.hj.HjToJimple.jimple.AccessMethodsGenerator;
import soot.hj.util.TypeUtils;
import soot.jimple.AssignStmt;
import soot.jimple.FieldRef;
import soot.jimple.InstanceFieldRef;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.Jimple;
import soot.jimple.StaticInvokeExpr;
import soot.jimple.Stmt;
import soot.tagkit.AbstractHost;

public class AccessMethods {
    private static AccessMethods accessMethods = new AccessMethods();

    public static AccessMethods v() {
        return accessMethods;
    }

    public boolean needsAccessCheck(Stmt stmt) {
        return this.hasMethodCall(stmt) || this.hasFieldRef(stmt);
    }

    public boolean needsMemberAccessor(ClassMember cm, SootClass currentClass) {
        RefType targetType = cm.getDeclaringClass().getType();
        RefType currentType = currentClass.getType();
        if (cm.isPrivate()) {
            if (!targetType.equals(currentType)) {
                return true;
            }
        } else if (cm.isProtected()) {
            String containerPackage = cm.getDeclaringClass().getPackageName();
            if (targetType.equals(currentType)) {
                return false;
            }
            while (currentClass.hasOuterClass()) {
                if (!targetType.equals((currentClass = currentClass.getOuterClass()).getType())) continue;
                return false;
            }
            while (currentClass.hasSuperclass()) {
                if (!targetType.equals((currentClass = currentClass.getSuperclass()).getType())) continue;
                return !containerPackage.equals(currentClass.getPackageName());
            }
        }
        return false;
    }

    public boolean hasFieldGetter(Stmt stmt) {
        return this.hasGetOrSetFieldImpl(stmt, true);
    }

    public boolean hasFieldSetter(Stmt stmt) {
        return this.hasGetOrSetFieldImpl(stmt, false);
    }

    public boolean hasGetOrSetFieldImpl(Stmt stmt, boolean checkGet) {
        if (stmt.containsFieldRef()) {
            assert (stmt instanceof AssignStmt);
            if (stmt instanceof AssignStmt) {
                AssignStmt assign = (AssignStmt)stmt;
                if (checkGet) {
                    return this.hasGetField(assign);
                }
                return this.hasSetField(assign);
            }
            throw new RuntimeException("Internal error: can't handle field access");
        }
        return false;
    }

    public boolean hasSetField(AssignStmt stmt) {
        return stmt.getLeftOp() instanceof FieldRef;
    }

    public boolean hasGetField(AssignStmt stmt) {
        return stmt.getRightOp() instanceof FieldRef;
    }

    public boolean hasFieldRef(Stmt stmt) {
        return stmt.containsFieldRef();
    }

    public boolean hasMethodCall(Stmt stmt) {
        return stmt.containsInvokeExpr();
    }

    public boolean needsAccessor(Stmt stmt, SootClass currentClass) {
        if (stmt.containsFieldRef() && this.needsMemberAccessor((ClassMember)stmt.getFieldRef().getField(), currentClass)) {
            return true;
        }
        return stmt.containsInvokeExpr() && !TypeUtils.v().isSynthetic((AbstractHost)stmt.getInvokeExpr().getMethod()) && this.needsMemberAccessor((ClassMember)stmt.getInvokeExpr().getMethod(), currentClass);
    }

    public InvokeExpr checkMethodCall(SootClass currentClass, Stmt stmt) {
        if (this.hasMethodCall(stmt) && this.needsAccessor(stmt, currentClass) && this.hasMethodCall(stmt)) {
            InvokeExpr invokeExpr = stmt.getInvokeExpr();
            SootMethod accessMethod = AccessMethodsGenerator.addMethodAccessMeth(invokeExpr.getMethod().getDeclaringClass(), invokeExpr.getMethod());
            SootMethod invokeMethod = invokeExpr.getMethod();
            ArrayList<Value> paramList = new ArrayList<Value>();
            if (!invokeMethod.isStatic()) {
                InstanceInvokeExpr iinvokeExpr = (InstanceInvokeExpr)invokeExpr;
                paramList.add(iinvokeExpr.getBase());
            }
            paramList.addAll(invokeExpr.getArgs());
            StaticInvokeExpr staticInvoke = Jimple.v().newStaticInvokeExpr(accessMethod.makeRef(), paramList);
            return staticInvoke;
        }
        return null;
    }

    public InvokeExpr checkFieldRefs(SootClass currentClass, Stmt stmt) {
        if (this.hasFieldRef(stmt)) {
            SootMethod accessMethod = null;
            if (this.needsAccessor(stmt, currentClass)) {
                SootField field;
                if (this.hasFieldSetter(stmt)) {
                    field = stmt.getFieldRef().getField();
                    accessMethod = AccessMethodsGenerator.addSetFieldAccessMeth(field);
                }
                if (this.hasFieldGetter(stmt)) {
                    field = stmt.getFieldRef().getField();
                    accessMethod = AccessMethodsGenerator.addGetFieldAccessMeth(field);
                }
                if (this.hasFieldRef(stmt)) {
                    FieldRef fieldRef = stmt.getFieldRef();
                    SootField field2 = fieldRef.getField();
                    ArrayList<Value> paramList = new ArrayList<Value>();
                    if (!field2.isStatic()) {
                        InstanceFieldRef ifieldRef = (InstanceFieldRef)fieldRef;
                        paramList.add(ifieldRef.getBase());
                    }
                    if (this.hasFieldSetter(stmt)) {
                        assert (stmt instanceof AssignStmt);
                        paramList.add(((AssignStmt)stmt).getRightOp());
                    }
                    StaticInvokeExpr staticInvoke = Jimple.v().newStaticInvokeExpr(accessMethod.makeRef(), paramList);
                    return staticInvoke;
                }
            }
        }
        return null;
    }

    public Stmt checkAssign(SootClass currentClass, Stmt stmt) {
        AssignStmt assignStmt = (AssignStmt)stmt;
        if (this.hasFieldSetter((Stmt)assignStmt)) {
            InvokeExpr accessorInvoke = AccessMethods.v().checkFieldRefs(currentClass, (Stmt)assignStmt);
            if (accessorInvoke != null) {
                return Jimple.v().newInvokeStmt((Value)accessorInvoke);
            }
        } else {
            InvokeExpr accessorInvoke;
            assert (!this.hasFieldGetter((Stmt)assignStmt) || !this.hasMethodCall((Stmt)assignStmt));
            if (this.hasFieldGetter((Stmt)assignStmt) && (accessorInvoke = AccessMethods.v().checkFieldRefs(currentClass, (Stmt)assignStmt)) != null) {
                assignStmt.getRightOpBox().setValue((Value)accessorInvoke);
            }
            if (this.hasMethodCall((Stmt)assignStmt) && (accessorInvoke = AccessMethods.v().checkMethodCall(currentClass, (Stmt)assignStmt)) != null) {
                assignStmt.getRightOpBox().setValue((Value)accessorInvoke);
            }
        }
        return assignStmt;
    }
}

