/*
 * Decompiled with CFR 0.152.
 */
package soot.hj.HjToJimple.jimple;

import java.util.ArrayList;
import java.util.List;
import polyglot.ast.Call;
import polyglot.ast.Field;
import polyglot.ast.ProcedureCall;
import polyglot.types.LocalInstance;
import soot.ClassMember;
import soot.MethodSource;
import soot.RefType;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.Type;
import soot.factory.SootType;
import soot.javaToJimple.InitialResolver;
import soot.javaToJimple.PrivateFieldAccMethodSource;
import soot.javaToJimple.PrivateFieldSetMethodSource;
import soot.javaToJimple.PrivateMethodAccMethodSource;
import soot.javaToJimple.Util;
import soot.tagkit.SyntheticTag;
import soot.tagkit.Tag;

public class AccessMethodsGenerator {
    public static SootMethod addGetFieldAccessMeth(SootClass conClass, Field field) {
        SootField sf = conClass.getField(field.name().toString(), SootType.v().getSootType(field.fieldInstance().type()));
        SootMethod meth = AccessMethodsGenerator.addGetFieldAccessMeth(sf);
        return meth;
    }

    public static SootMethod addSetFieldAccessMeth(SootClass conClass, Field field) {
        SootField sf = Util.getFieldFromCH((SootClass)conClass, (String)field.name().toString(), (Type)SootType.v().getSootType(field.fieldInstance().type()));
        SootMethod meth = AccessMethodsGenerator.addSetFieldAccessMeth(sf);
        return meth;
    }

    public static SootMethod addSetFieldAccessMeth(SootField field) {
        SootMethod meth = InitialResolver.v().getSootFieldSetAccessMap((ClassMember)field);
        if (meth != null) {
            return meth;
        }
        meth = AccessMethodsGenerator.addFieldAccessMethImpl(field, true);
        InitialResolver.v().addToSootFieldSetAccessMap(field, meth);
        return meth;
    }

    public static SootMethod addGetFieldAccessMeth(SootField field) {
        SootMethod meth = InitialResolver.v().getSootFieldGetAccessMap((ClassMember)field);
        if (meth != null) {
            return meth;
        }
        meth = AccessMethodsGenerator.addFieldAccessMethImpl(field, false);
        InitialResolver.v().addToSootFieldGetAccessMap(field, meth);
        return meth;
    }

    private static SootMethod addFieldAccessMethImpl(SootField field, boolean isSetter) {
        SootClass targetClass = field.getDeclaringClass();
        Type fieldType = field.getType();
        ArrayList<Object> paramTypes = new ArrayList<Object>(2);
        if (!field.isStatic()) {
            paramTypes.add(targetClass.getType());
        }
        if (isSetter) {
            paramTypes.add(fieldType);
        }
        Type returnType = fieldType;
        SootMethod meth = AccessMethodsGenerator.createMethodAccessor(paramTypes, returnType);
        Object accessorMth = null;
        accessorMth = isSetter ? new PrivateFieldSetMethodSource(fieldType, field.getName(), field.isStatic()) : new PrivateFieldAccMethodSource(fieldType, field.getName(), field.isStatic());
        targetClass.addMethod(meth);
        meth.setActiveBody(accessorMth.getBody(meth, null));
        return meth;
    }

    public static SootMethod addMethodAccessMeth(SootClass containerClass, SootClass accessorClass, Call call) {
        SootMethod sm = containerClass.getMethod(call.name().toString(), SootType.v().getSootParamsTypes((ProcedureCall)call), SootType.v().getSootType(call.methodInstance().returnType()));
        return AccessMethodsGenerator.addMethodAccessMeth(accessorClass, sm);
    }

    public static SootMethod addMethodAccessMeth(SootClass accessorClass, SootMethod sm) {
        SootMethod accessorMethod = InitialResolver.v().getPrivateMethodGetAccessMap(accessorClass, (ClassMember)sm);
        if (accessorMethod != null) {
            return accessorMethod;
        }
        ArrayList<RefType> paramTypes = new ArrayList<RefType>();
        if (!sm.isStatic()) {
            paramTypes.add(accessorClass.getType());
        }
        paramTypes.addAll(sm.getParameterTypes());
        accessorMethod = AccessMethodsGenerator.createMethodAccessor(paramTypes, sm.getReturnType());
        PrivateMethodAccMethodSource pmams = new PrivateMethodAccMethodSource(accessorClass, sm.getName(), sm.isStatic());
        accessorClass.addMethod(accessorMethod);
        accessorMethod.setActiveBody(pmams.getBody(accessorMethod, null));
        InitialResolver.v().addToPrivateMethodGetAccessMap(sm, accessorMethod);
        return accessorMethod;
    }

    public static String getNextAccessorName() {
        String name = "access$" + InitialResolver.v().getNextPrivateAccessCounter() + "00";
        return name;
    }

    public static SootMethod createMethodAccessor(List paramTypes, Type returnType) {
        String name = AccessMethodsGenerator.getNextAccessorName();
        SootMethod meth = new SootMethod(name, paramTypes, returnType, 8);
        meth.addTag((Tag)new SyntheticTag());
        return meth;
    }

    public static MethodSource createMethodSource(Type fieldType, String fieldName, boolean isStatic, SootClass classToInvoke) {
        PrivateFieldAccMethodSource src = new PrivateFieldAccMethodSource(fieldType, fieldName, isStatic);
        return src;
    }

    public static SootMethod makeSuperAccessMethod(SootClass classToInvoke, Object memberToAccess) {
        SootMethod meth;
        ArrayList<RefType> paramTypes = new ArrayList<RefType>();
        paramTypes.add(classToInvoke.getType());
        if (memberToAccess instanceof Field) {
            Field fieldToAccess = (Field)memberToAccess;
            SootClass targetSootClass = ((RefType)SootType.v().getSootType(fieldToAccess.target().type())).getSootClass();
            meth = AccessMethodsGenerator.addGetFieldAccessMeth(targetSootClass, fieldToAccess);
        } else if (memberToAccess instanceof Call) {
            SootClass containerSootClass;
            Call methToAccess = (Call)memberToAccess;
            SootClass accessorSootClass = containerSootClass = ((RefType)SootType.v().getSootType((polyglot.types.Type)methToAccess.methodInstance().container())).getSootClass();
            meth = AccessMethodsGenerator.addMethodAccessMeth(containerSootClass, accessorSootClass, methToAccess);
        } else {
            throw new RuntimeException("trying to access unhandled member type: " + memberToAccess);
        }
        return meth;
    }

    public static SootMethod makeLiFieldAccessMethod(SootClass classToInvoke, LocalInstance li) {
        String name = AccessMethodsGenerator.getNextAccessorName();
        ArrayList<RefType> paramTypes = new ArrayList<RefType>();
        paramTypes.add(classToInvoke.getType());
        SootMethod meth = AccessMethodsGenerator.createMethodAccessor(paramTypes, SootType.v().getSootType(li.type()));
        classToInvoke.addMethod(meth);
        PrivateFieldAccMethodSource src = new PrivateFieldAccMethodSource(SootType.v().getSootType(li.type()), "val$" + li.name(), false);
        meth.setActiveBody(src.getBody(meth, null));
        return meth;
    }
}

