/*
 * Decompiled with CFR 0.152.
 */
package soot.hj.HjToJimple.jimple;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import soot.Body;
import soot.BooleanType;
import soot.IntType;
import soot.Local;
import soot.PrimType;
import soot.RefType;
import soot.Scene;
import soot.Singletons;
import soot.SootClass;
import soot.SootField;
import soot.SootFieldRef;
import soot.SootMethod;
import soot.SootMethodRef;
import soot.Trap;
import soot.Type;
import soot.Unit;
import soot.Value;
import soot.ValueBox;
import soot.VoidType;
import soot.factory.LocalGenerator;
import soot.factory.SootFactory;
import soot.hj.HjSingletons;
import soot.hj.HjToJimple.jimple.ActivityClassBuilder;
import soot.hj.HjToJimple.jimple.AsyncRegionExpr;
import soot.hj.HjToJimple.jimple.FinishRegionExpr;
import soot.hj.HjToJimple.jimple.HabAttrBox;
import soot.hj.HjToJimple.jimple.HjDistHere;
import soot.hj.HjToJimple.jimple.HjOperator;
import soot.hj.HjToJimple.jimple.HjWSTool;
import soot.hj.HjToJimple.jimple.NopRegionExpr;
import soot.hj.HjToJimple.jimple.Region1TStmt;
import soot.hj.HjToJimple.jimple.RegionStmt;
import soot.hj.HjToJimple.jimple.utils.PrimitiveTypeUtils;
import soot.hj.HjToJimple.jimple.utils.RSTNodeMap;
import soot.hj.HjToJimple.util.Place;
import soot.hj.HjToJimple.util.RSTNode;
import soot.hj.HjToJimple.util.RSTNode_c;
import soot.jimple.AssignStmt;
import soot.jimple.ConditionExpr;
import soot.jimple.IdentityStmt;
import soot.jimple.IfStmt;
import soot.jimple.InstanceFieldRef;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.IntConstant;
import soot.jimple.InterfaceInvokeExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.InvokeStmt;
import soot.jimple.Jimple;
import soot.jimple.JimpleBody;
import soot.jimple.NewExpr;
import soot.jimple.NopStmt;
import soot.jimple.ParameterRef;
import soot.jimple.ReturnStmt;
import soot.jimple.ReturnVoidStmt;
import soot.jimple.SpecialInvokeExpr;
import soot.jimple.StaticInvokeExpr;
import soot.jimple.Stmt;
import soot.jimple.TableSwitchStmt;
import soot.jimple.ThisRef;
import soot.jimple.VirtualInvokeExpr;
import soot.jimple.internal.JimpleLocal;
import soot.util.Chain;
import soot.util.HashChain;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HabRTClassBuilder
extends ActivityClassBuilder {
    public SootClass javaLangObject;
    public SootClass hjLangRuntime;
    public SootMethod hjRuntimeAsPlace;
    public SootMethod hjRuntimeHere;
    public SootClass habHFWorker;
    public SootClass habHFFrame;
    public SootClass habHFPlace;
    public SootClass habHFClosure;
    public SootClass habHFFinishTreeNode;
    public SootClass habHFRuntime;
    public SootClass habHFBfAsyncFrame;
    public SootClass habHFDelayedAsyncFrame;
    public SootClass habHFSpawnFrameStolenException;
    public SootMethod habHFWorkerStartFinish;
    public SootMethod habHFWorkerStartFinishAccums;
    public SootMethod habHFWorkerStopFinishSlow;
    public SootMethod habHFWorkerStopFinishFast;
    public SootMethod habHFWorkerGetClosure;
    public SootMethod habHFWorkerGetCurrentFinishScope;
    public SootMethod habHFWorkerBeginMethod;
    public SootMethod habHFWorkerEndMethodSlow;
    public SootMethod habHFWorkerEndMethodSlowObject;
    public SootMethod habHFWorkerEndMethodFast;
    public SootMethod habHFWorkerPushBfAsync;
    public SootMethod habHFWorkerPushDelayedAsync;
    public SootMethod habHFRuntimeStartWorkers;
    public SootMethod habHFFrameSetFinishScope;
    public SootMethod habHFClosureGetCurrentFinishScope;
    public SootField habHFFramePC;
    protected static HashMap<String, SootMethod> methodNameMap = new HashMap();
    private static int localClassID = 0;
    protected HjWSTool wsTool;
    protected HashSet<String> frameClassNameSet = new HashSet();

    public HabRTClassBuilder() {
        this.javaLangObject = Scene.v().getSootClass("java.lang.Object");
        this.hjLangRuntime = Scene.v().getSootClass("hj.lang.Runtime");
        this.habHFWorker = Scene.v().getSootClass("hj.runtime.wst.adaptive.Worker");
        this.habHFClosure = Scene.v().getSootClass("hj.runtime.wst.adaptive.Closure");
        this.habHFFinishTreeNode = Scene.v().getSootClass("hj.runtime.wst.adaptive.FinishTreeNode");
        this.habHFRuntime = Scene.v().getSootClass("hj.runtime.wst.adaptive.Runtime");
        this.habHFFrame = Scene.v().getSootClass("hj.runtime.wst.adaptive.ActivationFrame");
        this.habHFBfAsyncFrame = Scene.v().getSootClass("hj.runtime.wst.adaptive.BfAsyncFrame");
        this.habHFDelayedAsyncFrame = Scene.v().getSootClass("hj.runtime.wst.adaptive.DelayedAsync");
        this.habHFSpawnFrameStolenException = Scene.v().getSootClass("hj.runtime.wst.adaptive.WorkerBlockedException");
        this.habHFWorkerStartFinish = this.habHFWorker.getMethodByName("startFinish");
        this.habHFWorkerStartFinishAccums = this.habHFWorker.getMethodByName("startFinishWithAccums");
        this.habHFWorkerStopFinishSlow = this.habHFWorker.getMethodByName("stopFinishSlow");
        this.habHFWorkerStopFinishFast = this.habHFWorker.getMethodByName("stopFinishFast");
        this.habHFWorkerGetCurrentFinishScope = this.habHFWorker.getMethodByName("getCurrentFinishScope");
        this.habHFWorkerGetClosure = this.habHFWorker.getMethodByName("getClosure");
        this.habHFRuntimeStartWorkers = this.habHFRuntime.getMethodByName("startWorkers");
        this.habHFClosureGetCurrentFinishScope = this.habHFClosure.getMethodByName("getFinishScope");
        this.habHFWorkerBeginMethod = this.habHFWorker.getMethodByName("beginMethod");
        this.habHFWorkerEndMethodSlow = this.habHFWorker.getMethod("void endMethodSlow()");
        this.habHFWorkerEndMethodSlowObject = this.habHFWorker.getMethod("void endMethodSlow(java.lang.Object)");
        this.habHFWorkerEndMethodFast = this.habHFWorker.getMethodByName("endMethodFast");
        List<RefType> typeList = Collections.singletonList(this.habHFBfAsyncFrame.getType());
        this.habHFWorkerPushBfAsync = this.habHFWorker.getMethod("pushBfAsync", typeList, (Type)VoidType.v());
        typeList = Collections.singletonList(this.habHFBfAsyncFrame.getType());
        this.habHFFramePC = this.habHFFrame.getFieldByName("pc");
    }

    public HabRTClassBuilder(Singletons.Global g) {
        this();
    }

    public static HabRTClassBuilder v() {
        return HjSingletons.v().soot_hj_HjToJimple_jimple_HabRTClassBuilder();
    }

    public void addContMethod(SootMethod method) {
        methodNameMap.put(method.toString(), method);
    }

    public void extractAsync(SootMethod method, SootMethod origMethod, RSTNode rstNode, Map contMethodMap, int classID) {
        Body body;
        methodNameMap.put(origMethod.toString(), origMethod);
        SootClass habFrameClass = null;
        SootMethod execMethod = null;
        if (rstNode.isAsyncNode()) {
            body = method.retrieveActiveBody();
            SootClass declClass = method.getDeclaringClass();
            RegionStmt asyncEntryStmt = rstNode.getRegionStmt();
            habFrameClass = new SootClass(declClass.getName() + "$" + localClassID++);
            habFrameClass.setOuterClass(declClass);
            if (asyncEntryStmt instanceof Region1TStmt) {
                habFrameClass.setSuperclass(this.habHFDelayedAsyncFrame);
            } else {
                habFrameClass.setSuperclass(this.habHFBfAsyncFrame);
            }
            Scene.v().addClass(habFrameClass);
            habFrameClass.setApplicationClass();
            HashMap<Local, SootField> classParams = new HashMap<Local, SootField>();
            if (asyncEntryStmt instanceof Region1TStmt) {
                this.buildIsHjTaskReadyMethod(habFrameClass, body, rstNode.getRegionStmt(), classParams, origMethod);
            } else {
                this.buildIsHjTaskReadyMethod(habFrameClass);
            }
            execMethod = this.buildExecMethod(habFrameClass, method, rstNode.getRegionStmt(), body, classParams, origMethod, contMethodMap);
            RSTNode_c newRSTNode = new RSTNode_c();
            newRSTNode.setNodeValue(execMethod);
            newRSTNode.setSubNodes(rstNode.getSubNodes());
            RSTNodeMap.setRstNode(execMethod, newRSTNode);
        } else if (!rstNode.isFinishNode() && !rstNode.isMethodNode()) {
            if (rstNode.isForLoopNode()) {
                if (!rstNode.isLabeledForLoopNode()) {
                    throw new RuntimeException("The labeled for loop node should not be here");
                }
                RegionStmt regionEntryStmt = rstNode.getRegionStmt();
                Stmt regionExitStmt = regionEntryStmt.getConnect();
                Body body2 = method.retrieveActiveBody();
                body2.getUnits().remove((Object)regionEntryStmt);
                body2.getUnits().remove((Object)regionExitStmt);
            } else if (rstNode.isIsolatedNode()) {
                body = method.retrieveActiveBody();
                this.buildIsolatedRegion(body, rstNode);
            } else if (!rstNode.isHjOperator()) {
                throw new RuntimeException("Not support this type of region: " + rstNode);
            }
        }
        if (execMethod == null) {
            execMethod = method;
        }
        Iterator<RSTNode> nodeIter = rstNode.getSubNodes().iterator();
        while (nodeIter.hasNext()) {
            this.extractAsync(execMethod, origMethod, nodeIter.next(), contMethodMap, localClassID++);
        }
    }

    public void extractIsolated(SootMethod method, RSTNode rstNode) {
        if (rstNode.isIsolatedNode()) {
            Body body = method.retrieveActiveBody();
            this.buildIsolatedRegion(body, rstNode);
        }
        Iterator<RSTNode> nodeIter = rstNode.getSubNodes().iterator();
        while (nodeIter.hasNext()) {
            this.extractIsolated(method, nodeIter.next());
        }
    }

    protected void buildIsHjTaskReadyMethod(SootClass activityClass, Body body, RegionStmt asyncRegionStmt, HashMap<Local, SootField> classParams, SootMethod origMethod) {
        ReturnStmt retStmt;
        Body origBody = origMethod.retrieveActiveBody();
        Local origThisLocal = null;
        if (!origMethod.isStatic()) {
            origThisLocal = origBody.getThisLocal();
        }
        JimpleBody methodBody = Jimple.v().newBody();
        SootMethod statusMethod = new SootMethod("isHjTaskReady", new ArrayList(), (Type)BooleanType.v(), 1);
        methodBody.setMethod(statusMethod);
        statusMethod.setActiveBody((Body)methodBody);
        statusMethod.setDeclaringClass(activityClass);
        activityClass.addMethod(statusMethod);
        Local thisLocal = Jimple.v().newLocal("tl", (Type)activityClass.getType());
        methodBody.getLocals().add((Object)thisLocal);
        Local outerThisLocal = null;
        if (!body.getMethod().isStatic()) {
            outerThisLocal = body.getThisLocal();
        }
        LocalGenerator lg = SootFactory.v().getLocalGenerator((Body)methodBody);
        RegionStmt labelStmt = ((Region1TStmt)asyncRegionStmt).getLabel();
        Iterator unitIter = body.getUnits().iterator(body.getUnits().getSuccOf((Unit)asyncRegionStmt), body.getUnits().getPredOf((Unit)labelStmt));
        HashChain outerMethodLocals = (HashChain)body.getLocals();
        HashChain methodLocals = (HashChain)methodBody.getLocals();
        RegionStmt predStmt = asyncRegionStmt;
        Stmt succStmt = (Stmt)body.getUnits().getSuccOf((Unit)labelStmt);
        ArrayList<Stmt> removeStmts = new ArrayList<Stmt>();
        while (unitIter.hasNext()) {
            Stmt stmt = (Stmt)unitIter.next();
            methodBody.getUnits().add((Unit)stmt);
            this.checkUses(stmt, (HashChain<Local>)outerMethodLocals, (HashChain<Local>)methodLocals, classParams);
            this.checkDefs(stmt, (HashChain<Local>)outerMethodLocals, (HashChain<Local>)methodLocals, classParams);
            removeStmts.add(stmt);
        }
        this.checkUses((Stmt)labelStmt, (HashChain<Local>)outerMethodLocals, (HashChain<Local>)methodLocals, classParams);
        Iterator<SootField> fieldIter = classParams.values().iterator();
        while (fieldIter.hasNext()) {
            activityClass.addField(fieldIter.next());
        }
        for (Local local : classParams.keySet()) {
            SootField field = classParams.get(local);
            InstanceFieldRef fieldRef = Jimple.v().newInstanceFieldRef((Value)thisLocal, field.makeRef());
            AssignStmt assignStmt = Jimple.v().newAssignStmt((Value)local, (Value)fieldRef);
            methodBody.getUnits().addFirst((Unit)assignStmt);
        }
        methodBody.getUnits().addFirst((Unit)Jimple.v().newIdentityStmt((Value)thisLocal, (Value)Jimple.v().newThisRef(activityClass.getType())));
        Value statusValue = ((NopRegionExpr)labelStmt.getRegionExpr()).getNopValue();
        if (statusValue instanceof Local || statusValue instanceof IntConstant) {
            retStmt = Jimple.v().newReturnStmt(statusValue);
            methodBody.getUnits().add((Unit)retStmt);
            labelStmt.redirectJumpsToThisTo((Unit)retStmt);
        } else if (statusValue instanceof ConditionExpr) {
            ConditionExpr condExpr = (ConditionExpr)statusValue;
            Local retLocal = lg.generateLocal((Type)BooleanType.v());
            AssignStmt assignStmt = Jimple.v().newAssignStmt((Value)retLocal, (Value)IntConstant.v((int)1));
            retStmt = Jimple.v().newReturnStmt((Value)retLocal);
            IfStmt ifStmt = Jimple.v().newIfStmt((Value)condExpr, (Unit)assignStmt);
            methodBody.getUnits().add((Unit)ifStmt);
            methodBody.getUnits().add((Unit)Jimple.v().newAssignStmt((Value)retLocal, (Value)IntConstant.v((int)0)));
            methodBody.getUnits().add((Unit)Jimple.v().newGotoStmt((Unit)retStmt));
            methodBody.getUnits().add((Unit)assignStmt);
            methodBody.getUnits().add((Unit)retStmt);
            labelStmt.redirectJumpsToThisTo((Unit)ifStmt);
        } else {
            throw new RuntimeException("Unsupport status label value: " + statusValue.getClass().getName());
        }
        Iterator removeIter = removeStmts.iterator();
        while (removeIter.hasNext()) {
            body.getUnits().getNonPatchingChain().remove(removeIter.next());
        }
    }

    protected void buildIsolatedRegion_(Body body, RSTNode rstNode) {
        this.buildIsolatedRegion(body, rstNode, SootFactory.v().getLocalGenerator(body));
    }

    protected void buildIsolatedRegion(Body body, RSTNode rstNode) {
        LocalGenerator lg = SootFactory.v().getLocalGenerator(body);
        RegionStmt isolatedEntryStmt = rstNode.getRegionStmt();
        Stmt isolatedExitStmt = isolatedEntryStmt.getConnect();
        ArrayList<Stmt> predStmts = new ArrayList<Stmt>();
        ArrayList<Stmt> succStmts = new ArrayList<Stmt>();
        ArrayList<Stmt> removedStmts = new ArrayList<Stmt>();
        ActivityClassBuilder.buildIsolatedRegion(body, isolatedEntryStmt, lg, predStmts, succStmts, removedStmts);
        for (Stmt stmt : predStmts) {
            body.getUnits().insertBefore((Unit)stmt, (Unit)isolatedEntryStmt);
        }
        Stmt labelStmt = isolatedExitStmt;
        for (Stmt stmt : succStmts) {
            body.getUnits().insertAfter((Unit)stmt, (Unit)labelStmt);
            labelStmt = stmt;
        }
        for (Stmt stmt : removedStmts) {
            body.getUnits().remove((Object)stmt);
        }
    }

    protected void buildIsolatedRegion(Body body, RSTNode rstNode, LocalGenerator lg) {
        RegionStmt isolatedEntryStmt = rstNode.getRegionStmt();
        Stmt isolatedExitStmt = isolatedEntryStmt.getConnect();
        SootClass hjRTClass = Scene.v().getSootClass("hj.lang.Runtime");
        SootClass hjObjectClass = Scene.v().getSootClass("hj.lang.Object");
        SootMethod startIsolationMethod = hjRTClass.getMethod("startIsolation", Collections.EMPTY_LIST, (Type)VoidType.v());
        SootMethod stopIsolationMethod = hjRTClass.getMethod("stopIsolation", Collections.EMPTY_LIST, (Type)VoidType.v());
        InvokeStmt invokeStmt = Jimple.v().newInvokeStmt((Value)Jimple.v().newStaticInvokeExpr(startIsolationMethod.makeRef(), Collections.EMPTY_LIST));
        body.getUnits().insertBefore((Unit)invokeStmt, (Unit)isolatedEntryStmt);
        Stmt handlerLabel0 = (Stmt)body.getUnits().getSuccOf((Unit)isolatedEntryStmt);
        invokeStmt = Jimple.v().newInvokeStmt((Value)Jimple.v().newStaticInvokeExpr(stopIsolationMethod.makeRef(), Collections.EMPTY_LIST));
        body.getUnits().insertBefore((Unit)invokeStmt, (Unit)isolatedExitStmt);
        body.getUnits().remove((Object)isolatedEntryStmt);
        body.getUnits().remove((Object)isolatedExitStmt);
    }

    public void identityLocals(SootMethod method) {
        HashSet<String> localsSet = new HashSet<String>();
        for (Local local : method.getActiveBody().getLocals()) {
            while (localsSet.contains(local.getName())) {
                local.setName(local.getName() + "_");
            }
            localsSet.add(local.getName());
        }
    }

    protected void installExecCon(SootClass activityClass, SootMethod initMethod, Local workerLocal, Local placeLocal, HashMap<Local, SootField> classParams, LocalGenerator lg, ArrayList<Stmt> rtStmtList) {
        Local activityLocal = lg.generateLocal((Type)activityClass.getType());
        AssignStmt assignStmt = Jimple.v().newAssignStmt((Value)activityLocal, (Value)Jimple.v().newNewExpr(activityClass.getType()));
        rtStmtList.add((Stmt)assignStmt);
        ArrayList<Type> activityTypeList = new ArrayList<Type>();
        ArrayList<Local> activityParamList = new ArrayList<Local>();
        activityTypeList.add(workerLocal.getType());
        activityParamList.add(workerLocal);
        for (Local local : classParams.keySet()) {
            activityTypeList.add(local.getType());
            activityParamList.add(local);
        }
        InvokeStmt invokeStmt = Jimple.v().newInvokeStmt((Value)Jimple.v().newSpecialInvokeExpr(activityLocal, initMethod.makeRef(), activityParamList));
        rtStmtList.add((Stmt)invokeStmt);
        rtStmtList.add((Stmt)Jimple.v().newInvokeStmt((Value)Jimple.v().newVirtualInvokeExpr(workerLocal, this.habHFWorkerPushBfAsync.makeRef(), (Value)activityLocal)));
    }

    protected void installDelayExecCon(SootClass activityClass, SootMethod initMethod, Local workerLocal, Local placeLocal, HashMap<Local, SootField> classParams, LocalGenerator lg, ArrayList<Stmt> rtStmtList) {
        Local activityLocal = lg.generateLocal((Type)activityClass.getType());
        AssignStmt assignStmt = Jimple.v().newAssignStmt((Value)activityLocal, (Value)Jimple.v().newNewExpr(activityClass.getType()));
        rtStmtList.add((Stmt)assignStmt);
        ArrayList<Type> activityTypeList = new ArrayList<Type>();
        ArrayList<Local> activityParamList = new ArrayList<Local>();
        activityTypeList.add(workerLocal.getType());
        activityParamList.add(workerLocal);
        for (Local local : classParams.keySet()) {
            activityTypeList.add(local.getType());
            activityParamList.add(local);
        }
        InvokeStmt invokeStmt = Jimple.v().newInvokeStmt((Value)Jimple.v().newSpecialInvokeExpr(activityLocal, initMethod.makeRef(), activityParamList));
        rtStmtList.add((Stmt)invokeStmt);
        rtStmtList.add((Stmt)Jimple.v().newInvokeStmt((Value)Jimple.v().newVirtualInvokeExpr(workerLocal, this.habHFWorkerPushDelayedAsync.makeRef(), (Value)activityLocal)));
    }

    protected SootMethod buildInitMethod(SootClass activityClass, HashMap<Local, SootField> classParams, SootClass linkClass) {
        JimpleBody methodBody = Jimple.v().newBody();
        LocalGenerator lg = SootFactory.v().getLocalGenerator((Body)methodBody);
        Local thisLocal = lg.generateLocal((Type)activityClass.getType());
        ArrayList<Object> typeList = new ArrayList<Object>();
        int paramCounter = 0;
        Local conWorkerLocal = lg.generateLocal((Type)this.habHFWorker.getType());
        methodBody.getUnits().add((Unit)Jimple.v().newIdentityStmt((Value)conWorkerLocal, (Value)Jimple.v().newParameterRef((Type)this.habHFWorker.getType(), paramCounter++)));
        typeList.add(conWorkerLocal.getType());
        for (Local local : classParams.keySet()) {
            typeList.add(local.getType());
            this.createFieldInit(activityClass, methodBody, classParams.get(local), lg, thisLocal, paramCounter++);
        }
        Local linkedListLocal = null;
        if (linkClass != null) {
            linkedListLocal = lg.generateLocal((Type)linkClass.getType());
            typeList.add(linkClass.getType());
            SootField field = this.createField(linkedListLocal);
            activityClass.addField(field);
            this.createFieldInit(linkedListLocal, methodBody, field, lg, thisLocal, paramCounter++);
        }
        methodBody.getUnits().addFirst((Unit)Jimple.v().newIdentityStmt((Value)thisLocal, (Value)Jimple.v().newThisRef(activityClass.getType())));
        SootMethod initMethod = new SootMethod("<init>", typeList, (Type)VoidType.v(), 1);
        methodBody.setMethod(initMethod);
        initMethod.setActiveBody((Body)methodBody);
        initMethod.setDeclaringClass(activityClass);
        activityClass.addMethod(initMethod);
        ArrayList<Object> typesList = new ArrayList<Object>();
        ArrayList<Local> paramsList = new ArrayList<Local>();
        if (linkClass != null) {
            typesList.add(this.javaListClass.getType());
            paramsList.add(linkedListLocal);
        }
        Local scopeLocal = lg.generateLocal((Type)this.habHFFinishTreeNode.getType());
        AssignStmt scopeStmt = Jimple.v().newAssignStmt((Value)scopeLocal, (Value)Jimple.v().newVirtualInvokeExpr(conWorkerLocal, this.habHFWorkerGetCurrentFinishScope.makeRef()));
        typesList = new ArrayList();
        paramsList = new ArrayList();
        typesList.add(scopeLocal.getType());
        paramsList.add(scopeLocal);
        SootMethod superInitMethod = activityClass.getSuperclass() == this.habHFDelayedAsyncFrame ? this.habHFDelayedAsyncFrame.getMethod("<init>", typesList, (Type)VoidType.v()) : this.habHFBfAsyncFrame.getMethod("<init>", typesList, (Type)VoidType.v());
        InvokeStmt invokeStmt = Jimple.v().newInvokeStmt((Value)Jimple.v().newSpecialInvokeExpr(methodBody.getThisLocal(), superInitMethod.makeRef(), paramsList));
        methodBody.getUnits().add((Unit)scopeStmt);
        methodBody.getUnits().add((Unit)invokeStmt);
        methodBody.getUnits().add((Unit)Jimple.v().newReturnVoidStmt());
        return initMethod;
    }

    protected SootMethod buildExecMethod(SootClass activityClass, SootMethod curMethod, RegionStmt asyncRegionStmt, Body body, HashMap<Local, SootField> classParams, SootMethod origMethod, Map contMethodMap) {
        Iterator unitIter;
        HabAttrBox habBox;
        Local workerLocal;
        Body origBody = origMethod.retrieveActiveBody();
        Local origThisLocal = null;
        if (!origMethod.isStatic()) {
            origThisLocal = origBody.getThisLocal();
        }
        if ((workerLocal = (habBox = (HabAttrBox)contMethodMap.get(curMethod)).getFCWorker()) == null) {
            throw new Error("xxx " + curMethod);
        }
        JimpleBody methodBody = Jimple.v().newBody();
        ArrayList<RefType> paramList = new ArrayList<RefType>();
        paramList.add(this.habHFWorker.getType());
        SootMethod execMethod = new SootMethod("execute", paramList, (Type)VoidType.v(), 1);
        execMethod.addException(this.habHFSpawnFrameStolenException);
        methodBody.setMethod(execMethod);
        execMethod.setActiveBody((Body)methodBody);
        execMethod.setDeclaringClass(activityClass);
        activityClass.addMethod(execMethod);
        Local thisLocal = Jimple.v().newLocal("tl", (Type)activityClass.getType());
        methodBody.getLocals().add((Object)thisLocal);
        Local outerThisLocal = null;
        if (!body.getMethod().isStatic()) {
            outerThisLocal = body.getThisLocal();
        }
        Local fcWorkerLocal = this.addLocal((Body)methodBody, "$worker", (Type)this.habHFWorker.getType());
        ArrayList<RegionStmt> removeStmts = new ArrayList<RegionStmt>();
        Stmt regionExitStmt = asyncRegionStmt.getConnect();
        if (asyncRegionStmt instanceof Region1TStmt) {
            RegionStmt labelStmt = ((Region1TStmt)asyncRegionStmt).getLabel();
            unitIter = body.getUnits().iterator(body.getUnits().getSuccOf((Unit)labelStmt), body.getUnits().getPredOf((Unit)regionExitStmt));
            removeStmts.add(labelStmt);
        } else {
            unitIter = body.getUnits().iterator(body.getUnits().getSuccOf((Unit)asyncRegionStmt), body.getUnits().getPredOf((Unit)regionExitStmt));
        }
        HashChain outerMethodLocals = (HashChain)body.getLocals();
        HashChain methodLocals = (HashChain)methodBody.getLocals();
        Stmt predStmt = (Stmt)body.getUnits().getPredOf((Unit)asyncRegionStmt);
        Stmt succStmt = (Stmt)body.getUnits().getSuccOf((Unit)regionExitStmt);
        removeStmts.add(asyncRegionStmt);
        removeStmts.add((RegionStmt)regionExitStmt);
        while (unitIter.hasNext()) {
            Stmt stmt = (Stmt)unitIter.next();
            Unit newStmt = null;
            if (newStmt != null) {
                stmt.redirectJumpsToThisTo(newStmt);
                methodBody.getUnits().add(newStmt);
            } else if (stmt instanceof AssignStmt && ((AssignStmt)stmt).getRightOp() instanceof HjOperator) {
                Value retValue = ((AssignStmt)stmt).getLeftOp();
                methodBody.getUnits().add((Unit)Jimple.v().newAssignStmt(retValue, (Value)Jimple.v().newVirtualInvokeExpr(fcWorkerLocal, this.habHFWorker.getMethodByName("place").makeRef(), Collections.EMPTY_LIST)));
            } else {
                methodBody.getUnits().add((Unit)stmt);
            }
            this.checkUses(stmt, (HashChain<Local>)outerMethodLocals, (HashChain<Local>)methodLocals, classParams);
            this.checkDefs(stmt, (HashChain<Local>)outerMethodLocals, (HashChain<Local>)methodLocals, classParams);
            removeStmts.add((RegionStmt)stmt);
        }
        Iterator<SootField> fieldIter = classParams.values().iterator();
        while (fieldIter.hasNext()) {
            try {
                activityClass.addField(fieldIter.next());
            }
            catch (Exception e) {}
        }
        for (Local local : classParams.keySet()) {
            SootField field = classParams.get(local);
            if (!methodBody.getLocals().contains((Object)local)) continue;
            InstanceFieldRef fieldRef = Jimple.v().newInstanceFieldRef((Value)thisLocal, field.makeRef());
            AssignStmt assignStmt = Jimple.v().newAssignStmt((Value)local, (Value)fieldRef);
            methodBody.getUnits().addFirst((Unit)assignStmt);
        }
        if (!origMethod.isStatic() && !classParams.containsKey(outerThisLocal)) {
            SootField field = this.createField(outerThisLocal);
            classParams.put(outerThisLocal, field);
            activityClass.addField(field);
        }
        SootMethod initMethod = this.buildInitMethod(activityClass, classParams, null);
        ArrayList<Stmt> rtStmtList = new ArrayList<Stmt>();
        LocalGenerator lg = SootFactory.v().getLocalGenerator(body);
        Place placeObj = ((AsyncRegionExpr)asyncRegionStmt.getRegionExpr()).getPlace();
        Local placeLocal = null;
        this.installExecCon(activityClass, initMethod, workerLocal, placeLocal, classParams, lg, rtStmtList);
        Iterator<Stmt> stmtIter = rtStmtList.iterator();
        Stmt tempLabel = regionExitStmt;
        while (stmtIter.hasNext()) {
            Stmt stmt = stmtIter.next();
            body.getUnits().insertAfter((Unit)stmt, (Unit)tempLabel);
            tempLabel = stmt;
        }
        methodBody.getUnits().addFirst((Unit)Jimple.v().newIdentityStmt((Value)fcWorkerLocal, (Value)Jimple.v().newParameterRef((Type)this.habHFWorker.getType(), 0)));
        methodBody.getUnits().addFirst((Unit)Jimple.v().newIdentityStmt((Value)thisLocal, (Value)Jimple.v().newThisRef(activityClass.getType())));
        ReturnVoidStmt retStmt = Jimple.v().newReturnVoidStmt();
        methodBody.getUnits().addLast((Unit)retStmt);
        asyncRegionStmt.redirectJumpsToThisTo((Unit)rtStmtList.get(0));
        regionExitStmt.redirectJumpsToThisTo((Unit)retStmt);
        this.checkTraps(body, (Body)methodBody, (Chain<Trap>)body.getTraps(), (Stmt)asyncRegionStmt, regionExitStmt);
        HabAttrBox newHabBox = new HabAttrBox(true);
        newHabBox.setFastClone(execMethod);
        newHabBox.setFCWorker(fcWorkerLocal);
        contMethodMap.put(execMethod, newHabBox);
        Iterator removeIter = removeStmts.iterator();
        while (removeIter.hasNext()) {
            body.getUnits().getNonPatchingChain().remove(removeIter.next());
        }
        return execMethod;
    }

    protected void checkTraps(Body body, Body methodBody, Chain<Trap> traps, Stmt regionEntryStmt, Stmt regionExitStmt) {
        for (Trap trap : traps) {
            Stmt beginStmt = (Stmt)trap.getBeginUnit();
            if (body.getUnits().contains((Object)beginStmt) && (!body.getUnits().follows((Unit)beginStmt, (Unit)regionEntryStmt) || !body.getUnits().follows((Unit)regionExitStmt, (Unit)beginStmt))) continue;
            methodBody.getTraps().add((Object)trap);
        }
        Iterator trapIter = methodBody.getTraps().iterator();
        while (trapIter.hasNext()) {
            body.getTraps().remove(trapIter.next());
        }
    }

    @Override
    protected void checkUses(Stmt s, HashChain<Local> outerMethodLocals, HashChain<Local> methodLocals, HashMap<Local, SootField> classParams) {
        Object[] uses = s.getUseBoxes().toArray();
        for (int i = 0; i < uses.length; ++i) {
            Local local;
            Value value = ((ValueBox)uses[i]).getValue();
            if (!(value instanceof Local) || methodLocals.contains((Object)(local = (Local)value)) || !outerMethodLocals.contains((Object)local)) continue;
            methodLocals.add((Object)local);
            if (classParams.containsKey(local)) continue;
            classParams.put(local, this.createField(local));
        }
    }

    @Override
    protected void checkDefs(Stmt s, HashChain<Local> outerMethodLocals, HashChain<Local> methodLocals, HashMap<Local, SootField> classParams) {
        Object[] defs = s.getDefBoxes().toArray();
        for (int i = 0; i < defs.length; ++i) {
            Local local;
            Value value = ((ValueBox)defs[i]).getValue();
            if (!(value instanceof Local) || methodLocals.contains((Object)(local = (Local)value)) || !outerMethodLocals.contains((Object)local)) continue;
            methodLocals.add((Object)local);
            outerMethodLocals.remove((Object)local);
        }
    }

    public SootMethod createFCMethod(SootMethod method, HabAttrBox habBox) {
        SootMethod fcMethod = new SootMethod(method.getName(), method.getParameterTypes(), method.getReturnType(), method.getModifiers());
        fcMethod.setActiveBody(method.retrieveActiveBody());
        RSTNodeMap.copyRstNode(method, fcMethod);
        fcMethod.addExceptionIfAbsent(this.habHFSpawnFrameStolenException);
        this.incParamRef(fcMethod);
        JimpleLocal fcWorkerLocal = new JimpleLocal("$worker", (Type)this.habHFWorker.getType());
        method.retrieveActiveBody().getLocals().add((Object)fcWorkerLocal);
        habBox.setFCWorker((Local)fcWorkerLocal);
        ArrayList<RefType> params = new ArrayList<RefType>(method.getParameterTypes().size() + 1);
        params.add(0, this.habHFWorker.getType());
        params.addAll(method.getParameterTypes());
        fcMethod.setParameterTypes(params);
        IdentityStmt identityStmt = Jimple.v().newIdentityStmt((Value)fcWorkerLocal, (Value)Jimple.v().newParameterRef((Type)this.habHFWorker.getType(), 0));
        JimpleBody methodBody = (JimpleBody)method.retrieveActiveBody();
        Stmt firstNonIdentityStmt = methodBody.getFirstNonIdentityStmt();
        Stmt labelStmt = (Stmt)methodBody.getUnits().getPredOf((Unit)firstNonIdentityStmt);
        if (labelStmt == null) {
            labelStmt = firstNonIdentityStmt;
            methodBody.getUnits().insertBefore((Unit)identityStmt, (Unit)labelStmt);
        } else {
            methodBody.getUnits().insertAfter((Unit)identityStmt, (Unit)labelStmt);
        }
        method.getDeclaringClass().addMethod(fcMethod);
        return fcMethod;
    }

    public SootMethod createSCMethod(SootMethod method, Body scBody) {
        SootClass declClass = method.getDeclaringClass();
        String scMethodName = method.getName() + "Slow";
        boolean hasSameName = true;
        while (hasSameName) {
            try {
                declClass.getMethodByName(scMethodName);
                scMethodName = scMethodName + "_";
            }
            catch (Exception e) {
                hasSameName = false;
            }
        }
        ArrayList<RefType> paramTypeList = new ArrayList<RefType>();
        paramTypeList.add(this.habHFWorker.getType());
        paramTypeList.add(this.habHFFrame.getType());
        SootMethod scMethod = new SootMethod(scMethodName, paramTypeList, (Type)VoidType.v(), method.getModifiers());
        scMethod.setActiveBody(scBody);
        scMethod.addExceptionIfAbsent(this.habHFSpawnFrameStolenException);
        scMethod.setDeclaringClass(declClass);
        declClass.addMethod(scMethod);
        return scMethod;
    }

    public SootMethod genFastClone(SootMethod origMethod, SootClass frameClass, SootMethod frameConMethod, Map contMethodMap, HabAttrBox habBox) {
        SootMethod fcMethod = habBox.getFastClone();
        JimpleBody fcBody = (JimpleBody)fcMethod.getActiveBody();
        Local fcWorkerLocal = habBox.getFCWorker();
        LocalGenerator fcLg = SootFactory.v().getLocalGenerator((Body)fcBody);
        Local fcFrameLocal = fcLg.generateLocal("frame", (Type)frameClass.getType());
        ArrayList<Stmt> contList = new ArrayList<Stmt>();
        int currentPC = 1;
        this.handleMethodBody(RSTNodeMap.getRstNode(fcMethod), frameClass, fcMethod, fcBody, fcWorkerLocal, fcFrameLocal, fcLg, contMethodMap, habBox, contList, currentPC);
        Stmt label0 = fcBody.getFirstNonIdentityStmt();
        contList.add(0, label0);
        habBox.setContList(contList);
        Stmt tempLabel = (Stmt)fcBody.getUnits().getPredOf((Unit)label0);
        Local pcLocal = fcLg.generateLocal((Type)IntType.v());
        AssignStmt assignStmt = Jimple.v().newAssignStmt((Value)pcLocal, (Value)Jimple.v().newInstanceFieldRef((Value)fcFrameLocal, this.habHFFramePC.makeRef()));
        fcBody.getUnits().insertAfter((Unit)assignStmt, (Unit)tempLabel);
        tempLabel = assignStmt;
        Stmt defaultLabel = (Stmt)fcBody.getUnits().getLast();
        fcBody.getUnits().insertBefore((Unit)Jimple.v().newNopStmt(), (Unit)defaultLabel);
        TableSwitchStmt switchStmt = Jimple.v().newTableSwitchStmt((Value)pcLocal, 0, contList.size() - 1, contList, (Unit)defaultLabel);
        fcBody.getUnits().insertAfter((Unit)switchStmt, (Unit)tempLabel);
        fcBody.getUnits().addFirst((Unit)Jimple.v().newAssignStmt((Value)fcFrameLocal, (Value)fcWorkerLocal));
        for (Stmt stmt : fcBody.getUnits()) {
            InstanceFieldRef ifr;
            if (!(stmt instanceof AssignStmt) || !(((AssignStmt)stmt).getRightOp() instanceof InstanceFieldRef) || !(ifr = (InstanceFieldRef)((AssignStmt)stmt).getRightOp()).getField().getName().equals("val$this")) continue;
            fcBody.getUnits().remove((Object)stmt);
            fcBody.getUnits().insertBefore((Unit)stmt, (Unit)assignStmt);
            break;
        }
        JimpleBody scBody = (JimpleBody)fcBody.clone();
        fcBody.getUnits().remove((Object)fcBody.getUnits().getFirst());
        fcBody.getUnits().remove((Object)assignStmt);
        fcBody.getUnits().remove((Object)switchStmt);
        tempLabel = (Stmt)fcBody.getUnits().getPredOf((Unit)fcBody.getFirstNonIdentityStmt());
        assignStmt = Jimple.v().newAssignStmt((Value)fcFrameLocal, (Value)Jimple.v().newNewExpr(frameClass.getType()));
        fcBody.getUnits().insertAfter((Unit)assignStmt, (Unit)tempLabel);
        tempLabel = assignStmt;
        ArrayList<Local> fcParamList = new ArrayList<Local>();
        if (!fcMethod.isStatic()) {
            fcParamList.add(fcBody.getThisLocal());
        }
        for (int i = 1; i < fcMethod.getParameterCount(); ++i) {
            fcParamList.add(fcBody.getParameterLocal(i));
        }
        InvokeStmt frameInitStmt = Jimple.v().newInvokeStmt((Value)Jimple.v().newSpecialInvokeExpr(fcFrameLocal, frameConMethod.makeRef(), fcParamList));
        fcBody.getUnits().insertAfter((Unit)frameInitStmt, (Unit)tempLabel);
        tempLabel = frameInitStmt;
        InvokeStmt virtualInvoke = Jimple.v().newInvokeStmt((Value)Jimple.v().newVirtualInvokeExpr(fcWorkerLocal, this.habHFWorkerBeginMethod.makeRef(), (Value)fcFrameLocal));
        fcBody.getUnits().insertAfter((Unit)virtualInvoke, (Unit)tempLabel);
        tempLabel = virtualInvoke;
        this.genEndMethodFast(fcWorkerLocal, fcBody);
        SootMethod scMethod = this.createSCMethod(origMethod, (Body)scBody);
        habBox.setSlowClone(scMethod);
        LocalGenerator scLg = SootFactory.v().getLocalGenerator((Body)scBody);
        Stmt scSpecLabel = (Stmt)scBody.getUnits().getFirst();
        Local scWorkerLocal = (Local)((AssignStmt)scSpecLabel).getRightOp();
        Local scFrameLocal = (Local)((AssignStmt)scSpecLabel).getLeftOp();
        scBody.getUnits().remove((Object)scSpecLabel);
        habBox.setSCWorker(scWorkerLocal);
        habBox.setSCFrame(scFrameLocal);
        this.removeIdentityStmt(scBody, 0);
        this.genEndMethodSlow(scWorkerLocal, scBody, scLg, origMethod.getReturnType());
        tempLabel = scBody.getFirstNonIdentityStmt();
        Local tempFrameLocal = scLg.generateLocal((Type)this.habHFFrame.getType());
        IdentityStmt identityStmt = Jimple.v().newIdentityStmt((Value)tempFrameLocal, (Value)Jimple.v().newParameterRef((Type)this.habHFFrame.getType(), 1));
        scBody.getUnits().insertBefore((Unit)identityStmt, (Unit)tempLabel);
        assignStmt = Jimple.v().newAssignStmt((Value)scFrameLocal, (Value)Jimple.v().newCastExpr((Value)tempFrameLocal, (Type)frameClass.getType()));
        scBody.getUnits().insertBefore((Unit)assignStmt, (Unit)tempLabel);
        for (Local local : scBody.getLocals()) {
            if (!frameClass.declaresField(local.getName(), local.getType())) continue;
            SootField field = frameClass.getField(local.getName(), local.getType());
            assignStmt = Jimple.v().newAssignStmt((Value)local, (Value)Jimple.v().newInstanceFieldRef((Value)scFrameLocal, field.makeRef()));
            scBody.getUnits().insertBefore((Unit)assignStmt, (Unit)tempLabel);
        }
        return fcMethod;
    }

    public void resetMethodInvoke(RSTNode rstNode, HabAttrBox habBox, Map contMethodMap) {
        for (RSTNode subNode : rstNode.getSubNodes()) {
            ValueBox valueBox;
            if (!subNode.isMethodNode()) continue;
            Stmt invokeStmt = subNode.getNodeStmt();
            if (invokeStmt instanceof InvokeStmt) {
                valueBox = ((InvokeStmt)invokeStmt).getInvokeExprBox();
            } else if (invokeStmt instanceof AssignStmt) {
                valueBox = ((AssignStmt)invokeStmt).getRightOpBox();
            } else {
                throw new RuntimeException("Unsupport invoke stmt: " + invokeStmt.getClass().getName());
            }
            InvokeExpr invokeExpr = (InvokeExpr)valueBox.getValue();
            if ((invokeExpr = this.handleInvoke(invokeExpr, habBox.getFCWorker(), contMethodMap)) == null) continue;
            valueBox.setValue((Value)invokeExpr);
        }
    }

    public void resetMethodInvoke_(SootMethod method, HabAttrBox habBox, Map contMethodMap) {
        Body body = method.getActiveBody();
        for (Stmt stmt : body.getUnits()) {
            if (!stmt.containsInvokeExpr()) continue;
            InvokeExpr invokeExpr = stmt.getInvokeExpr();
            if ((invokeExpr = this.handleInvoke(invokeExpr, habBox.getFCWorker(), contMethodMap)) == null) continue;
            stmt.getInvokeExprBox().setValue((Value)invokeExpr);
        }
    }

    protected int handleMethodBody(RSTNode rstNode, SootClass frameClass, SootMethod fcMethod, JimpleBody fcBody, Local fcWorkerLocal, Local fcFrameLocal, LocalGenerator fcLg, Map contMethodMap, HabAttrBox habBox, ArrayList<Stmt> contList, int currentPC) {
        for (RSTNode subNode : rstNode.getSubNodes()) {
            ValueBox valueBox;
            Stmt invokeStmt;
            if (subNode.isFinishNode()) {
                currentPC = this.handleMethodBody(subNode, frameClass, fcMethod, fcBody, fcWorkerLocal, fcFrameLocal, fcLg, contMethodMap, habBox, contList, currentPC);
                RegionStmt regionEntryStmt = subNode.getRegionStmt();
                Stmt regionExitStmt = regionEntryStmt.getConnect();
                FinishRegionExpr finishRegion = (FinishRegionExpr)regionEntryStmt.getRegionExpr();
                VirtualInvokeExpr startFinishExpr = null;
                List<Value> accumulators = finishRegion.getAccumulators();
                startFinishExpr = accumulators != null ? Jimple.v().newVirtualInvokeExpr(fcWorkerLocal, this.habHFWorkerStartFinishAccums.makeRef(), (Value)this.createListStmts(accumulators, (Body)fcBody, fcLg, (Stmt)regionEntryStmt)) : Jimple.v().newVirtualInvokeExpr(fcWorkerLocal, this.habHFWorkerStartFinish.makeRef());
                InvokeStmt invokeStmt2 = Jimple.v().newInvokeStmt((Value)startFinishExpr);
                fcBody.getUnits().insertBefore((Unit)invokeStmt2, (Unit)regionEntryStmt);
                fcBody.getUnits().remove((Object)regionEntryStmt);
                Stmt followStmt = (Stmt)fcBody.getUnits().getSuccOf((Unit)regionExitStmt);
                if (this.hasContinuation(subNode, contMethodMap, false)) {
                    Stmt tempLabel = regionExitStmt;
                    for (Local local : fcBody.getLocals()) {
                        if (!frameClass.declaresField(local.getName(), local.getType()) || !this.wsTool.shouldSave(tempLabel, local) && !this.wsTool.shouldSave((Stmt)fcBody.getUnits().getPredOf((Unit)invokeStmt2), local)) continue;
                        SootField field = frameClass.getField(local.getName(), local.getType());
                        AssignStmt assignStmt = Jimple.v().newAssignStmt((Value)Jimple.v().newInstanceFieldRef((Value)fcFrameLocal, field.makeRef()), (Value)local);
                        fcBody.getUnits().insertBefore((Unit)assignStmt, (Unit)tempLabel);
                    }
                    AssignStmt pcUpdateStmt = Jimple.v().newAssignStmt((Value)Jimple.v().newInstanceFieldRef((Value)fcFrameLocal, this.habHFFramePC.makeRef()), (Value)IntConstant.v((int)currentPC));
                    fcBody.getUnits().insertBefore((Unit)pcUpdateStmt, (Unit)tempLabel);
                    Local checkLocal = fcLg.generateLocal((Type)BooleanType.v());
                    AssignStmt stopFinishStmt = Jimple.v().newAssignStmt((Value)checkLocal, (Value)Jimple.v().newVirtualInvokeExpr(fcWorkerLocal, this.habHFWorkerStopFinishSlow.makeRef()));
                    fcBody.getUnits().insertBefore((Unit)stopFinishStmt, (Unit)tempLabel);
                    NopStmt contLabel = Jimple.v().newNopStmt();
                    fcBody.getUnits().insertAfter((Unit)contLabel, (Unit)regionExitStmt);
                    contList.add((Stmt)contLabel);
                    ++currentPC;
                } else {
                    InvokeStmt stopFinishStmt = Jimple.v().newInvokeStmt((Value)Jimple.v().newVirtualInvokeExpr(fcWorkerLocal, this.habHFWorkerStopFinishSlow.makeRef()));
                    fcBody.getUnits().insertAfter((Unit)stopFinishStmt, (Unit)regionExitStmt);
                }
                fcBody.getUnits().remove((Object)regionExitStmt);
                continue;
            }
            if (!subNode.isMethodNode()) continue;
            Stmt tempLabel = invokeStmt = subNode.getNodeStmt();
            if (invokeStmt instanceof InvokeStmt) {
                valueBox = ((InvokeStmt)invokeStmt).getInvokeExprBox();
            } else if (invokeStmt instanceof AssignStmt) {
                valueBox = ((AssignStmt)invokeStmt).getRightOpBox();
            } else {
                throw new RuntimeException("Unsupport invoke stmt: " + invokeStmt.getClass().getName());
            }
            InvokeExpr invokeExpr = (InvokeExpr)valueBox.getValue();
            if ((invokeExpr = this.handleInvoke(invokeExpr, fcWorkerLocal, contMethodMap)) == null) continue;
            valueBox.setValue((Value)invokeExpr);
            for (Local local : fcBody.getLocals()) {
                if (!frameClass.declaresField(local.getName(), local.getType()) || !this.wsTool.shouldSave(tempLabel, local)) continue;
                SootField field = frameClass.getField(local.getName(), local.getType());
                AssignStmt assignStmt = Jimple.v().newAssignStmt((Value)Jimple.v().newInstanceFieldRef((Value)fcFrameLocal, field.makeRef()), (Value)local);
                fcBody.getUnits().insertBefore((Unit)assignStmt, (Unit)tempLabel);
            }
            AssignStmt pcUpdateStmt = Jimple.v().newAssignStmt((Value)Jimple.v().newInstanceFieldRef((Value)fcFrameLocal, this.habHFFramePC.makeRef()), (Value)IntConstant.v((int)currentPC));
            fcBody.getUnits().insertBefore((Unit)pcUpdateStmt, (Unit)tempLabel);
            NopStmt contLabel = Jimple.v().newNopStmt();
            fcBody.getUnits().insertAfter((Unit)contLabel, (Unit)invokeStmt);
            contList.add((Stmt)contLabel);
            if (invokeStmt instanceof AssignStmt) {
                habBox.addCallCont((Stmt)contLabel, invokeStmt);
            }
            ++currentPC;
        }
        return currentPC;
    }

    protected Local createListStmts(List<Value> valueList, Body body, LocalGenerator lg, Stmt label) {
        SootMethodRef linkedListConstructor = this.javaLinkedListClass.getMethod("<init>", Collections.EMPTY_LIST).makeRef();
        Local listLocal = lg.generateLocal((Type)this.javaLinkedListClass.getType());
        NewExpr newListExpr = Jimple.v().newNewExpr(this.javaLinkedListClass.getType());
        AssignStmt newListAssignStmt = Jimple.v().newAssignStmt((Value)listLocal, (Value)newListExpr);
        body.getUnits().insertBefore((Unit)newListAssignStmt, (Unit)label);
        SpecialInvokeExpr listInitInvokeExpr = Jimple.v().newSpecialInvokeExpr(listLocal, linkedListConstructor, Collections.EMPTY_LIST);
        InvokeStmt createListInitStmt = Jimple.v().newInvokeStmt((Value)listInitInvokeExpr);
        body.getUnits().insertBefore((Unit)createListInitStmt, (Unit)label);
        for (Value valObj : valueList) {
            VirtualInvokeExpr listAddExpr = Jimple.v().newVirtualInvokeExpr(listLocal, this.addMethod.makeRef(), valObj);
            InvokeStmt listAddStmt = Jimple.v().newInvokeStmt((Value)listAddExpr);
            body.getUnits().insertBefore((Unit)listAddStmt, (Unit)label);
        }
        return listLocal;
    }

    protected void genEndMethodFast(Local fcWorkerLocal, JimpleBody fcBody) {
        Iterator unitIter = fcBody.getUnits().snapshotIterator();
        while (unitIter.hasNext()) {
            Stmt retStmt = (Stmt)unitIter.next();
            if (retStmt instanceof ReturnVoidStmt || retStmt instanceof ReturnStmt) {
                InvokeStmt endFastStmt = Jimple.v().newInvokeStmt((Value)Jimple.v().newVirtualInvokeExpr(fcWorkerLocal, this.habHFWorkerEndMethodFast.makeRef()));
                fcBody.getUnits().insertBefore((Unit)endFastStmt, (Unit)retStmt);
                continue;
            }
            if (!(retStmt instanceof AssignStmt) || !(((AssignStmt)retStmt).getRightOp() instanceof HjDistHere)) continue;
            Value retValue = ((AssignStmt)retStmt).getLeftOp();
            fcBody.getUnits().insertBefore((Unit)Jimple.v().newAssignStmt(retValue, (Value)Jimple.v().newVirtualInvokeExpr(fcWorkerLocal, this.habHFWorker.getMethodByName("place").makeRef(), Collections.EMPTY_LIST)), (Unit)retStmt);
            fcBody.getUnits().remove((Object)retStmt);
        }
    }

    protected void genEndMethodSlow(Local scWorkerLocal, JimpleBody scBody, LocalGenerator scLg, Type returnType) {
        Iterator unitIter = scBody.getUnits().snapshotIterator();
        while (unitIter.hasNext()) {
            Stmt tempLabel;
            Stmt retStmt = (Stmt)unitIter.next();
            if (retStmt instanceof ReturnVoidStmt) {
                tempLabel = (Stmt)scBody.getUnits().getPredOf((Unit)retStmt);
                InvokeStmt endSlowStmt = Jimple.v().newInvokeStmt((Value)Jimple.v().newVirtualInvokeExpr(scWorkerLocal, this.habHFWorkerEndMethodSlow.makeRef()));
                scBody.getUnits().insertAfter((Unit)endSlowStmt, (Unit)tempLabel);
                continue;
            }
            if (retStmt instanceof ReturnStmt) {
                tempLabel = (Stmt)scBody.getUnits().getPredOf((Unit)retStmt);
                Value retValue = ((ReturnStmt)retStmt).getOp();
                Stmt objStmt = this.genReturnObject(returnType, retValue, scLg);
                if (objStmt != null) {
                    scBody.getUnits().insertAfter((Unit)objStmt, (Unit)tempLabel);
                    tempLabel = objStmt;
                    retValue = (Local)((AssignStmt)objStmt).getLeftOp();
                }
                InvokeStmt endSlowStmt = Jimple.v().newInvokeStmt((Value)Jimple.v().newVirtualInvokeExpr(scWorkerLocal, this.habHFWorkerEndMethodSlowObject.makeRef(), retValue));
                scBody.getUnits().insertAfter((Unit)endSlowStmt, (Unit)tempLabel);
                ReturnVoidStmt retVoidStmt = Jimple.v().newReturnVoidStmt();
                scBody.getUnits().swapWith((Unit)retStmt, (Unit)retVoidStmt);
                continue;
            }
            if (!(retStmt instanceof AssignStmt) || !(((AssignStmt)retStmt).getRightOp() instanceof HjDistHere)) continue;
            Value retValue = ((AssignStmt)retStmt).getLeftOp();
            scBody.getUnits().insertBefore((Unit)Jimple.v().newAssignStmt(retValue, (Value)Jimple.v().newVirtualInvokeExpr(scWorkerLocal, this.habHFWorker.getMethodByName("place").makeRef(), Collections.EMPTY_LIST)), (Unit)retStmt);
            scBody.getUnits().remove((Object)retStmt);
        }
    }

    protected void removeIdentityStmt(JimpleBody methodBody, int paramIndex) {
        ArrayList<Stmt> removeStmts = new ArrayList<Stmt>();
        Iterator unitIter = methodBody.getUnits().iterator(methodBody.getUnits().getFirst(), (Unit)methodBody.getFirstNonIdentityStmt());
        while (unitIter.hasNext()) {
            Value value;
            Stmt stmt = (Stmt)unitIter.next();
            if (!(stmt instanceof IdentityStmt) || !((value = ((IdentityStmt)stmt).getRightOp()) instanceof ParameterRef) || ((ParameterRef)value).getIndex() <= paramIndex) continue;
            removeStmts.add(stmt);
        }
        Iterator stmtIter = removeStmts.iterator();
        while (stmtIter.hasNext()) {
            methodBody.getUnits().remove(stmtIter.next());
        }
    }

    protected InvokeExpr handleInvoke(InvokeExpr invokeExpr, Local workerLocal, Map contMethodMap) {
        SootMethodRef methodRef = invokeExpr.getMethodRef();
        HabAttrBox habBox = null;
        SootMethod origMethod = methodNameMap.get(methodRef.resolve().toString());
        if (origMethod != null) {
            habBox = (HabAttrBox)contMethodMap.get(origMethod);
        }
        if (habBox == null) {
            return null;
        }
        SootMethod method = habBox.getFastClone();
        ArrayList<Local> params = new ArrayList<Local>();
        params.add(workerLocal);
        params.addAll(invokeExpr.getArgs());
        if (invokeExpr instanceof InstanceInvokeExpr) {
            Local baseLocal = (Local)((InstanceInvokeExpr)invokeExpr).getBase();
            if (invokeExpr instanceof VirtualInvokeExpr) {
                return Jimple.v().newVirtualInvokeExpr(baseLocal, method.makeRef(), params);
            }
            if (invokeExpr instanceof InterfaceInvokeExpr) {
                return Jimple.v().newInterfaceInvokeExpr(baseLocal, method.makeRef(), params);
            }
            if (invokeExpr instanceof SpecialInvokeExpr) {
                return Jimple.v().newSpecialInvokeExpr(baseLocal, method.makeRef(), params);
            }
            throw new RuntimeException("Unsupport invoke: " + invokeExpr.getClass().getName());
        }
        if (invokeExpr instanceof StaticInvokeExpr) {
            return Jimple.v().newStaticInvokeExpr(method.makeRef(), params);
        }
        throw new RuntimeException("Unsupport invoke: " + invokeExpr.getClass().getName());
    }

    protected Stmt genReturnObject(Type retType, Value retValue, LocalGenerator lg) {
        if (retType instanceof RefType) {
            return null;
        }
        Type boxType = PrimitiveTypeUtils.getJavaLangType(retType);
        Local retLocal = lg.generateLocal(boxType);
        StaticInvokeExpr reifiedValue = null;
        if (retType instanceof BooleanType && retValue instanceof IntConstant) {
            boolean isTrue = IntConstant.v((int)1).equals((Object)retValue);
            SootFieldRef reifiedBooleanConstant = isTrue ? PrimitiveTypeUtils.getTrueBoolean() : PrimitiveTypeUtils.getFalseBoolean();
            reifiedValue = Jimple.v().newStaticFieldRef(reifiedBooleanConstant);
        } else {
            reifiedValue = Jimple.v().newStaticInvokeExpr(PrimitiveTypeUtils.getJavaLangTypeValueOfRef(boxType), new Value[]{retValue});
        }
        return Jimple.v().newAssignStmt((Value)retLocal, (Value)reifiedValue);
    }

    public boolean hasContinuation(RSTNode rstNode, Map contMethodMap, boolean isFinishNode) {
        if (rstNode.isFinishNode()) {
            isFinishNode = true;
        }
        for (RSTNode subNode : rstNode.getSubNodes()) {
            if (subNode.isAsyncNode()) {
                return true;
            }
            if (subNode.isMethodNode() && methodNameMap.containsKey(subNode.getNodeMethod().toString())) {
                return true;
            }
            if (!this.hasContinuation(subNode, contMethodMap, isFinishNode)) continue;
            return true;
        }
        return false;
    }

    public boolean hasAsync(RSTNode rstNode) {
        for (RSTNode subNode : rstNode.getSubNodes()) {
            if (subNode.isAsyncNode()) {
                return true;
            }
            if (!this.hasAsync(subNode)) continue;
            return true;
        }
        return false;
    }

    public boolean hasContinuation(RSTNode rstNode, boolean isFinishNode) {
        if (rstNode.isFinishNode()) {
            isFinishNode = true;
        }
        for (RSTNode subNode : rstNode.getSubNodes()) {
            if (subNode.isAsyncNode()) {
                return true;
            }
            if (!this.hasContinuation(subNode, isFinishNode)) continue;
            return true;
        }
        return false;
    }

    protected SootMethod buildSetReturn(SootClass frameClass, Map local2FieldMap, HabAttrBox habBox) {
        List<Stmt> contList = habBox.getContList();
        SootMethod setRetMethod = new SootMethod("setReturnResult", Arrays.asList(this.javaLangObject.getType()), (Type)VoidType.v(), 1);
        frameClass.addMethod(setRetMethod);
        JimpleBody setRetBody = Jimple.v().newBody(setRetMethod);
        setRetMethod.setActiveBody((Body)setRetBody);
        LocalGenerator lg = SootFactory.v().getLocalGenerator((Body)setRetBody);
        Local thisLocal = lg.generateLocal((Type)frameClass.getType());
        setRetBody.getUnits().add((Unit)Jimple.v().newIdentityStmt((Value)thisLocal, (Value)Jimple.v().newThisRef(frameClass.getType())));
        Local retObjLocal = lg.generateLocal((Type)this.javaLangObject.getType());
        setRetBody.getUnits().add((Unit)Jimple.v().newIdentityStmt((Value)retObjLocal, (Value)Jimple.v().newParameterRef((Type)this.javaLangObject.getType(), 0)));
        ArrayList<Object> targetList = new ArrayList<Object>();
        for (int i = 0; i < contList.size(); ++i) {
            Stmt contStmt = contList.get(i);
            Stmt callContStmt = habBox.getCallCont(contStmt);
            if (callContStmt != null) {
                Local retLocal = (Local)((AssignStmt)callContStmt).getLeftOp();
                SootField retField = (SootField)local2FieldMap.get(retLocal);
                if (retField == null) {
                    throw new RuntimeException("Can't find corresponding frame class field for local: " + retLocal);
                }
                Stmt targetStmt = this.createAssign(retLocal.getType(), lg, retObjLocal, (Body)setRetBody, thisLocal, retField);
                targetList.add(targetStmt);
                setRetBody.getUnits().add((Unit)Jimple.v().newReturnVoidStmt());
                continue;
            }
            ReturnVoidStmt retStmt = Jimple.v().newReturnVoidStmt();
            setRetBody.getUnits().add((Unit)retStmt);
            targetList.add(retStmt);
        }
        ReturnVoidStmt retStmt = Jimple.v().newReturnVoidStmt();
        setRetBody.getUnits().add((Unit)retStmt);
        Stmt tempLabel = (Stmt)setRetBody.getUnits().getPredOf((Unit)setRetBody.getFirstNonIdentityStmt());
        Local pcLocal = lg.generateLocal((Type)IntType.v());
        AssignStmt assignStmt = Jimple.v().newAssignStmt((Value)pcLocal, (Value)Jimple.v().newInstanceFieldRef((Value)thisLocal, this.habHFFramePC.makeRef()));
        setRetBody.getUnits().insertAfter((Unit)assignStmt, (Unit)tempLabel);
        tempLabel = assignStmt;
        if (targetList.size() == 0) {
            return setRetMethod;
        }
        TableSwitchStmt switchStmt = Jimple.v().newTableSwitchStmt((Value)pcLocal, 0, targetList.size() - 1, targetList, (Unit)retStmt);
        setRetBody.getUnits().insertAfter((Unit)switchStmt, (Unit)tempLabel);
        return setRetMethod;
    }

    protected Stmt createAssign(Type type, LocalGenerator lg, Local retObjLocal, Body setRetBody, Local thisLocal, SootField retField) {
        AssignStmt segStmt = null;
        if (type instanceof PrimType) {
            Type returnType = PrimitiveTypeUtils.getJavaLangType(type);
            Local defLocal = lg.generateLocal(type);
            Local defIntegerLocal = lg.generateLocal(returnType);
            segStmt = Jimple.v().newAssignStmt((Value)defIntegerLocal, (Value)Jimple.v().newCastExpr((Value)retObjLocal, returnType));
            setRetBody.getUnits().add((Unit)segStmt);
            AssignStmt assignStmt = Jimple.v().newAssignStmt((Value)defLocal, (Value)Jimple.v().newVirtualInvokeExpr(defIntegerLocal, PrimitiveTypeUtils.getJavaLangTypeValueRef(returnType)));
            setRetBody.getUnits().add((Unit)assignStmt);
            assignStmt = Jimple.v().newAssignStmt((Value)Jimple.v().newInstanceFieldRef((Value)thisLocal, retField.makeRef()), (Value)defLocal);
            setRetBody.getUnits().add((Unit)assignStmt);
        } else if (type instanceof RefType) {
            Local defLocal = lg.generateLocal(type);
            segStmt = Jimple.v().newAssignStmt((Value)defLocal, (Value)Jimple.v().newCastExpr((Value)retObjLocal, type));
            setRetBody.getUnits().add((Unit)segStmt);
            AssignStmt assignStmt = Jimple.v().newAssignStmt((Value)Jimple.v().newInstanceFieldRef((Value)thisLocal, retField.makeRef()), (Value)defLocal);
            setRetBody.getUnits().add((Unit)assignStmt);
        } else {
            throw new RuntimeException("Unsupport set return result type: " + type);
        }
        return segStmt;
    }

    protected void genFrameClassFields(SootMethod origMethod, SootClass frameClass, Map local2FieldMap, Map field2LocalMap) {
        Body methodBody = origMethod.retrieveActiveBody();
        for (Local local : methodBody.getLocals()) {
            if (!this.isLocalNeededInFrame(local) || !origMethod.isStatic() && methodBody.getThisLocal() == local) continue;
            SootField field = new SootField(local.getName(), local.getType());
            frameClass.addField(field);
            local2FieldMap.put(local, field);
            field2LocalMap.put(field, local);
        }
        for (Stmt stmt : methodBody.getUnits()) {
            Local retLocal;
            InvokeExpr invokeExpr;
            if (!(stmt instanceof AssignStmt) || !stmt.containsInvokeExpr() || (invokeExpr = stmt.getInvokeExpr()) instanceof HjDistHere || !methodNameMap.containsKey(invokeExpr.getMethodRef().resolve().toString()) || local2FieldMap.containsKey(retLocal = (Local)((AssignStmt)stmt).getLeftOp())) continue;
            SootField field = new SootField(retLocal.getName(), retLocal.getType());
            frameClass.addField(field);
            local2FieldMap.put(retLocal, field);
            field2LocalMap.put(field, retLocal);
        }
    }

    public SootClass buildFrameClass(SootMethod origMethod, Map contMethodMap, HabAttrBox habBox, Map local2FieldMap, Map field2LocalMap) {
        SootClass declClass = origMethod.getDeclaringClass();
        SootMethod fcMethod = habBox.getFastClone();
        String frameClassName = declClass.getName() + "$" + origMethod.getName() + "frame";
        while (this.frameClassNameSet.contains(frameClassName)) {
            frameClassName = frameClassName + "_";
        }
        this.frameClassNameSet.add(frameClassName);
        SootClass frameClass = new SootClass(frameClassName, fcMethod.getModifiers());
        this.wsTool = new HjWSTool(origMethod.getActiveBody());
        frameClass.setOuterClass(declClass);
        frameClass.setSuperclass(Scene.v().getSootClass("hj.runtime.wst.adaptive.ActivationFrame"));
        Scene.v().addClass(frameClass);
        frameClass.setApplicationClass();
        this.genFrameClassFields(origMethod, frameClass, local2FieldMap, field2LocalMap);
        SootField frameThisOuter = null;
        if (!origMethod.isStatic()) {
            frameThisOuter = new SootField("this$0", (Type)declClass.getType());
        }
        SootMethod frameConMethod = this.buildFrameConSC(frameClass, declClass, fcMethod, origMethod, frameThisOuter, habBox, local2FieldMap);
        habBox.setFrameCon(frameConMethod);
        this.genFastClone(origMethod, frameClass, frameConMethod, contMethodMap, habBox);
        SootMethod frameExecMethod = this.buildFrameExecSlow(frameClass, declClass, fcMethod, habBox.getSlowClone(), frameThisOuter);
        this.buildSetReturn(frameClass, local2FieldMap, habBox);
        return frameClass;
    }

    public SootMethod buildFrameConSC(SootClass frameClass, SootClass declClass, SootMethod fcMethod, SootMethod origMethod, SootField frameThisOuter, HabAttrBox habBox, Map local2FieldMap) {
        ArrayList<RefType> paramTypeList = new ArrayList<RefType>();
        if (!origMethod.isStatic()) {
            paramTypeList.add(0, declClass.getType());
        }
        if (!habBox.isExecMethod()) {
            paramTypeList.addAll(origMethod.getParameterTypes());
        }
        SootMethod frameCon = new SootMethod("<init>", paramTypeList, (Type)VoidType.v(), 1);
        frameClass.addMethod(frameCon);
        JimpleBody conBody = Jimple.v().newBody(frameCon);
        frameCon.setActiveBody((Body)conBody);
        LocalGenerator lg = SootFactory.v().getLocalGenerator((Body)conBody);
        Local conThisLocal = lg.generateLocal("this", (Type)frameClass.getType());
        conBody.getUnits().add((Unit)Jimple.v().newIdentityStmt((Value)conThisLocal, (Value)Jimple.v().newThisRef(frameClass.getType())));
        SootMethod superConMethod = frameClass.getSuperclass().getMethodByName("<init>");
        InvokeStmt superConStmt = Jimple.v().newInvokeStmt((Value)Jimple.v().newSpecialInvokeExpr(conThisLocal, superConMethod.makeRef()));
        conBody.getUnits().add((Unit)superConStmt);
        int paramCounter = 0;
        InvokeStmt tempLabel = superConStmt;
        if (!origMethod.isStatic()) {
            frameClass.addField(frameThisOuter);
            Local outerThisLocal = lg.generateLocal((Type)declClass.getType());
            IdentityStmt identityStmt = Jimple.v().newIdentityStmt((Value)outerThisLocal, (Value)Jimple.v().newParameterRef((Type)declClass.getType(), paramCounter++));
            conBody.getUnits().insertBefore((Unit)identityStmt, (Unit)tempLabel);
            AssignStmt assignStmt = Jimple.v().newAssignStmt((Value)Jimple.v().newInstanceFieldRef((Value)conThisLocal, frameThisOuter.makeRef()), (Value)outerThisLocal);
            conBody.getUnits().insertAfter((Unit)assignStmt, (Unit)tempLabel);
        }
        if (!habBox.isExecMethod()) {
            for (int i = 0; i < origMethod.getParameterCount(); ++i) {
                Local paramLocal = origMethod.getActiveBody().getParameterLocal(i + 1);
                SootField paramField = (SootField)local2FieldMap.get(paramLocal);
                Local conParamLocal = lg.generateLocal(paramLocal.getType());
                IdentityStmt identityStmt = Jimple.v().newIdentityStmt((Value)conParamLocal, (Value)Jimple.v().newParameterRef((Type)declClass.getType(), paramCounter++));
                conBody.getUnits().insertBefore((Unit)identityStmt, (Unit)tempLabel);
                AssignStmt assignStmt = Jimple.v().newAssignStmt((Value)Jimple.v().newInstanceFieldRef((Value)conThisLocal, paramField.makeRef()), (Value)conParamLocal);
                conBody.getUnits().insertAfter((Unit)assignStmt, (Unit)tempLabel);
            }
        }
        conBody.getUnits().add((Unit)Jimple.v().newReturnVoidStmt());
        return frameCon;
    }

    public SootMethod buildFrameExecSlow(SootClass frameClass, SootClass declClass, SootMethod fcMethod, SootMethod scMethod, SootField frameThisOuter) {
        SootMethod frameExecSlow = new SootMethod("execute", Arrays.asList(this.habHFWorker.getType()), (Type)VoidType.v(), 1);
        frameClass.addMethod(frameExecSlow);
        JimpleBody execBody = Jimple.v().newBody(frameExecSlow);
        frameExecSlow.setActiveBody((Body)execBody);
        frameExecSlow.addException(this.habHFSpawnFrameStolenException);
        LocalGenerator lg = SootFactory.v().getLocalGenerator((Body)execBody);
        Local execThis = Jimple.v().newLocal("this", (Type)frameClass.getType());
        execBody.getLocals().add((Object)execThis);
        execBody.getUnits().add((Unit)Jimple.v().newIdentityStmt((Value)execThis, (Value)Jimple.v().newThisRef(frameClass.getType())));
        Local worker = Jimple.v().newLocal("worker", (Type)this.habHFWorker.getType());
        execBody.getLocals().add((Object)worker);
        execBody.getUnits().add((Unit)Jimple.v().newIdentityStmt((Value)worker, (Value)Jimple.v().newParameterRef((Type)this.habHFWorker.getType(), 0)));
        if (fcMethod.isStatic()) {
            InvokeStmt invokeStmt = Jimple.v().newInvokeStmt((Value)Jimple.v().newStaticInvokeExpr(scMethod.makeRef(), (Value)worker, (Value)execBody.getThisLocal()));
            execBody.getUnits().add((Unit)invokeStmt);
        } else {
            Local outerObject = lg.generateLocal((Type)declClass.getType());
            AssignStmt assignStmt = Jimple.v().newAssignStmt((Value)outerObject, (Value)Jimple.v().newInstanceFieldRef((Value)execThis, frameThisOuter.makeRef()));
            execBody.getUnits().add((Unit)assignStmt);
            InvokeStmt invokeStmt = Jimple.v().newInvokeStmt((Value)Jimple.v().newVirtualInvokeExpr(outerObject, scMethod.makeRef(), (Value)worker, (Value)execThis));
            execBody.getUnits().add((Unit)invokeStmt);
        }
        execBody.getUnits().add((Unit)Jimple.v().newReturnVoidStmt());
        return frameExecSlow;
    }

    public Local addLocalParamRefStmt(Body body, String name, Type paramType, int paramID) {
        Local newLocal = Jimple.v().newLocal(name, paramType);
        body.getLocals().add((Object)newLocal);
        Stmt thisStmt = null;
        if (body.getUnits().size() > 0) {
            thisStmt = (Stmt)body.getUnits().getFirst();
        }
        if (thisStmt != null && thisStmt instanceof IdentityStmt && ((IdentityStmt)thisStmt).getRightOp() instanceof ThisRef) {
            body.getUnits().insertAfter((Unit)Jimple.v().newIdentityStmt((Value)newLocal, (Value)Jimple.v().newParameterRef(paramType, paramID)), (Unit)thisStmt);
        } else {
            body.getUnits().addFirst((Unit)Jimple.v().newIdentityStmt((Value)newLocal, (Value)Jimple.v().newParameterRef(paramType, paramID)));
        }
        return newLocal;
    }

    protected void incParamRef(SootMethod method) {
        Body body = method.getActiveBody();
        int paramCount = method.getParameterCount();
        Iterator unitIter = body.getUnits().iterator();
        while (paramCount > 0) {
            IdentityStmt identityStmt;
            Value value;
            assert (unitIter.hasNext());
            Stmt stmt = (Stmt)unitIter.next();
            if (!(stmt instanceof IdentityStmt) || !((value = (identityStmt = (IdentityStmt)stmt).getRightOp()) instanceof ParameterRef)) continue;
            ParameterRef paramRef = (ParameterRef)value;
            paramRef.setIndex(paramRef.getIndex() + 1);
            --paramCount;
        }
    }

    protected void incParamRef(SootMethod method, int fromParam) {
        Body body = method.getActiveBody();
        for (Stmt stmt : body.getUnits()) {
            ParameterRef paramRef;
            IdentityStmt identityStmt;
            Value value;
            if (!(stmt instanceof IdentityStmt) || !((value = (identityStmt = (IdentityStmt)stmt).getRightOp()) instanceof ParameterRef) || (paramRef = (ParameterRef)value).getIndex() < fromParam) continue;
            paramRef.setIndex(paramRef.getIndex() + 1);
        }
    }

    public boolean isUserSpecifiedLocal(Local local) {
        return local.getName().charAt(0) != '$';
    }

    public boolean isThisParameter(Local local) {
        return local.getName().equals("this");
    }

    public boolean isThrowableObject(Local local) {
        return local.getType().equals(RefType.v((String)"java.lang.Throwable"));
    }

    public boolean isLocalNeededInFrame(Local local) {
        if (this.isThisParameter(local)) {
            return false;
        }
        if (this.isThrowableObject(local)) {
            return false;
        }
        return local.getType() != this.habHFWorker.getType();
    }

    public Local addLocalAndParamRefStmt(Body body, String name, Type paramType, int paramNum) {
        Local newLocal = this.addLocal(body, name, paramType);
        this.addParamRefStmt(body, newLocal, paramType, paramNum);
        return newLocal;
    }

    public Local addLocalAndThisRefStmt(Body body, String name, RefType rType) {
        Local thisLocal = this.addLocal(body, name, (Type)rType);
        this.addThisRefStmt(body, thisLocal, rType);
        return thisLocal;
    }

    public Local addLocal(Body body, String name, Type type) {
        Local newLocal = Jimple.v().newLocal(name, type);
        body.getLocals().add((Object)newLocal);
        return newLocal;
    }

    public void addParamRefStmt(Body body, Local leftOp, Type paramType, int paramNum) {
        Stmt thisStmt = null;
        if (body.getUnits().size() > 0) {
            thisStmt = (Stmt)body.getUnits().getFirst();
        }
        if (thisStmt != null && thisStmt instanceof IdentityStmt && ((IdentityStmt)thisStmt).getRightOp() instanceof ThisRef) {
            body.getUnits().insertAfter((Unit)Jimple.v().newIdentityStmt((Value)leftOp, (Value)Jimple.v().newParameterRef(paramType, paramNum)), (Unit)thisStmt);
        } else {
            body.getUnits().addFirst((Unit)Jimple.v().newIdentityStmt((Value)leftOp, (Value)Jimple.v().newParameterRef(paramType, paramNum)));
        }
    }

    public void addThisRefStmt(Body body, Local leftOp, RefType rType) {
        body.getUnits().addFirst((Unit)Jimple.v().newIdentityStmt((Value)leftOp, (Value)Jimple.v().newThisRef(rType)));
    }
}

