/*
 * Decompiled with CFR 0.152.
 */
package soot.hj.HjToJimple.jimple;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import soot.Body;
import soot.BooleanType;
import soot.IntType;
import soot.Local;
import soot.RefType;
import soot.Scene;
import soot.Singletons;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.SootMethodRef;
import soot.Type;
import soot.Unit;
import soot.Value;
import soot.ValueBox;
import soot.VoidType;
import soot.factory.LocalGenerator;
import soot.factory.SootFactory;
import soot.hj.HjSingletons;
import soot.hj.HjToJimple.jimple.FinishRegionExpr;
import soot.hj.HjToJimple.jimple.HabAttrBox;
import soot.hj.HjToJimple.jimple.HabRTClassBuilder;
import soot.hj.HjToJimple.jimple.HjDistHere;
import soot.hj.HjToJimple.jimple.HjWSTool;
import soot.hj.HjToJimple.jimple.RegionExit;
import soot.hj.HjToJimple.jimple.RegionStmt;
import soot.hj.HjToJimple.jimple.ReturnRegionExpr;
import soot.hj.HjToJimple.jimple.utils.RSTNodeMap;
import soot.hj.HjToJimple.util.RSTNode;
import soot.jimple.AssignStmt;
import soot.jimple.IdentityStmt;
import soot.jimple.IfStmt;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.IntConstant;
import soot.jimple.InterfaceInvokeExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.InvokeStmt;
import soot.jimple.Jimple;
import soot.jimple.JimpleBody;
import soot.jimple.NopStmt;
import soot.jimple.ParameterRef;
import soot.jimple.ReturnStmt;
import soot.jimple.ReturnVoidStmt;
import soot.jimple.SpecialInvokeExpr;
import soot.jimple.StaticInvokeExpr;
import soot.jimple.Stmt;
import soot.jimple.TableSwitchStmt;
import soot.jimple.ThisRef;
import soot.jimple.VirtualInvokeExpr;
import soot.jimple.internal.JimpleLocal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HabRTWFClassBuilder
extends HabRTClassBuilder {
    public SootClass habWFWorker;
    public SootClass habWFFrame;
    public SootClass habWFClosure;
    public SootClass habWFFinishTreeNode;
    public SootClass habWFRuntime;
    public SootClass habWFFrameStolenException;
    public SootMethod habWFWorkerStartFinish;
    public SootMethod habWFWorkerStartFinishAccums;
    public SootMethod habWFWorkerStopFinishSlow;
    public SootMethod habWFWorkerStopFinishFast;
    public SootMethod habWFWorkerGetClosure;
    public SootMethod habWFWorkerGetCurrentFinishScope;
    public SootMethod habWFWorkerBeginMethod;
    public SootMethod habWFWorkerEndMethodSlow;
    public SootMethod habWFWorkerEndMethodSlowObject;
    public SootMethod habWFWorkerEndMethodFast;
    public SootMethod habWFWorkerCheckActivationFrameStolen;
    public SootMethod habWFRuntimeStartWorkers;
    public SootMethod habWFFrameSetFinishScope;
    public SootMethod habWFClosureGetCurrentFinishScope;
    public SootMethod habWFWorkerPopFrame;
    public SootMethod habWFWorkerPopFrameOrAbort;
    public SootMethod habWFWorkerPushFrame;
    public SootField habWFFramePC;
    protected HashSet<Local> frameLocalSet = new HashSet();
    protected HjWSTool wsTool;
    protected HashSet<String> frameClassNameSet = new HashSet();

    public HabRTWFClassBuilder() {
        this.habWFWorker = Scene.v().getSootClass("hj.runtime.wst.adaptive.Worker");
        this.habWFClosure = Scene.v().getSootClass("hj.runtime.wst.adaptive.Closure");
        this.habWFFinishTreeNode = Scene.v().getSootClass("hj.runtime.wst.adaptive.FinishTreeNode");
        this.habWFRuntime = Scene.v().getSootClass("hj.runtime.wst.adaptive.Runtime");
        this.habWFFrame = Scene.v().getSootClass("hj.runtime.wst.adaptive.ActivationFrame");
        this.habWFFrameStolenException = Scene.v().getSootClass("hj.runtime.wst.adaptive.WorkerBlockedException");
        this.habWFWorkerStartFinish = this.habWFWorker.getMethodByName("startFinish");
        this.habWFWorkerStartFinishAccums = this.habWFWorker.getMethodByName("startFinishWithAccums");
        this.habWFWorkerStopFinishSlow = this.habWFWorker.getMethodByName("stopFinishSlow");
        this.habWFWorkerStopFinishFast = this.habWFWorker.getMethodByName("stopFinishFast");
        this.habWFWorkerGetClosure = this.habWFWorker.getMethodByName("getClosure");
        this.habWFRuntimeStartWorkers = this.habWFRuntime.getMethodByName("startWorkers");
        this.habWFWorkerPopFrameOrAbort = this.habWFWorker.getMethodByName("popAndAbortOnSteal");
        this.habWFWorkerPushFrame = this.habWFWorker.getMethodByName("pushContinuation");
        this.habWFWorkerBeginMethod = this.habWFWorker.getMethodByName("beginMethod");
        this.habWFWorkerEndMethodSlow = this.habWFWorker.getMethod("void endMethodSlow()");
        this.habWFWorkerEndMethodSlowObject = this.habWFWorker.getMethod("void endMethodSlow(java.lang.Object)");
        this.habWFWorkerEndMethodFast = this.habWFWorker.getMethodByName("endMethodFast");
        this.habWFFramePC = this.habWFFrame.getFieldByName("pc");
    }

    public HabRTWFClassBuilder(Singletons.Global g) {
        this();
    }

    public static HabRTWFClassBuilder v() {
        return HjSingletons.v().soot_hj_HjToJimple_jimple_HabRTWFClassBuilder();
    }

    @Override
    public void extractAsync(SootMethod method, SootMethod origMethod, RSTNode rstNode, Map contMethodMap, int classID) {
        methodNameMap.put(origMethod.toString(), origMethod);
    }

    @Override
    public SootMethod createFCMethod(SootMethod method, HabAttrBox habBox) {
        SootMethod fcMethod = new SootMethod(method.getName(), method.getParameterTypes(), method.getReturnType(), method.getModifiers());
        fcMethod.setActiveBody(method.retrieveActiveBody());
        RSTNodeMap.copyRstNode(method, fcMethod);
        fcMethod.addExceptionIfAbsent(this.habWFFrameStolenException);
        this.incParamRef(fcMethod);
        JimpleLocal fcWorkerLocal = new JimpleLocal("$worker", (Type)this.habWFWorker.getType());
        method.retrieveActiveBody().getLocals().add((Object)fcWorkerLocal);
        habBox.setFCWorker((Local)fcWorkerLocal);
        ArrayList<RefType> params = new ArrayList<RefType>();
        params.add(0, this.habWFWorker.getType());
        params.addAll(method.getParameterTypes());
        fcMethod.setParameterTypes(params);
        IdentityStmt identityStmt = Jimple.v().newIdentityStmt((Value)fcWorkerLocal, (Value)Jimple.v().newParameterRef((Type)this.habWFWorker.getType(), 0));
        JimpleBody methodBody = (JimpleBody)method.retrieveActiveBody();
        Stmt labelStmt = (Stmt)methodBody.getUnits().getPredOf((Unit)methodBody.getFirstNonIdentityStmt());
        if (labelStmt != null) {
            methodBody.getUnits().insertAfter((Unit)identityStmt, (Unit)labelStmt);
        } else {
            labelStmt = methodBody.getFirstNonIdentityStmt();
            methodBody.getUnits().insertBefore((Unit)identityStmt, (Unit)labelStmt);
        }
        method.getDeclaringClass().addMethod(fcMethod);
        return fcMethod;
    }

    @Override
    public SootMethod createSCMethod(SootMethod method, Body scBody) {
        SootClass declClass = method.getDeclaringClass();
        String scMethodName = method.getName() + "Slow";
        boolean hasSameName = true;
        while (hasSameName) {
            try {
                declClass.getMethodByName(scMethodName);
                scMethodName = scMethodName + "_";
            }
            catch (Exception e) {
                hasSameName = false;
            }
        }
        ArrayList<RefType> paramTypeList = new ArrayList<RefType>();
        paramTypeList.add(this.habWFWorker.getType());
        paramTypeList.add(this.habWFFrame.getType());
        SootMethod scMethod = new SootMethod(scMethodName, paramTypeList, (Type)VoidType.v(), method.getModifiers());
        scMethod.setActiveBody(scBody);
        scMethod.addExceptionIfAbsent(this.habWFFrameStolenException);
        scMethod.setDeclaringClass(declClass);
        declClass.addMethod(scMethod);
        return scMethod;
    }

    @Override
    public SootMethod genFastClone(SootMethod origMethod, SootClass frameClass, SootMethod frameConMethod, Map contMethodMap, HabAttrBox habBox) {
        SootMethod fcMethod = habBox.getFastClone();
        JimpleBody fcBody = (JimpleBody)fcMethod.getActiveBody();
        Local fcWorkerLocal = habBox.getFCWorker();
        Stmt labelStmt = (Stmt)fcBody.getUnits().getPredOf((Unit)fcBody.getFirstNonIdentityStmt());
        LocalGenerator fcLg = SootFactory.v().getLocalGenerator((Body)fcBody);
        Local fcFrameLocal = fcLg.generateLocal("frame", (Type)frameClass.getType());
        ArrayList<Stmt> contList = new ArrayList<Stmt>();
        int currentPC = 1;
        this.handleMethodBody(RSTNodeMap.getRstNode(fcMethod), frameClass, fcMethod, frameConMethod, fcBody, fcWorkerLocal, fcFrameLocal, fcLg, contMethodMap, habBox, contList, currentPC, false);
        contList.add(0, fcBody.getFirstNonIdentityStmt());
        habBox.setContList(contList);
        Stmt tempLabel = (Stmt)fcBody.getUnits().getPredOf((Unit)fcBody.getFirstNonIdentityStmt());
        Local pcLocal = fcLg.generateLocal((Type)IntType.v());
        AssignStmt assignStmt = Jimple.v().newAssignStmt((Value)pcLocal, (Value)Jimple.v().newInstanceFieldRef((Value)fcFrameLocal, this.habWFFramePC.makeRef()));
        fcBody.getUnits().insertAfter((Unit)assignStmt, (Unit)tempLabel);
        tempLabel = assignStmt;
        Stmt defaultLabel = (Stmt)fcBody.getUnits().getLast();
        fcBody.getUnits().insertBefore((Unit)Jimple.v().newNopStmt(), (Unit)defaultLabel);
        TableSwitchStmt switchStmt = Jimple.v().newTableSwitchStmt((Value)pcLocal, 0, contList.size() - 1, contList, (Unit)defaultLabel);
        fcBody.getUnits().insertAfter((Unit)switchStmt, (Unit)tempLabel);
        fcBody.getUnits().addFirst((Unit)Jimple.v().newAssignStmt((Value)fcFrameLocal, (Value)fcWorkerLocal));
        JimpleBody scBody = (JimpleBody)fcBody.clone();
        this.handleFastBody(frameClass, fcMethod, fcWorkerLocal, fcFrameLocal, fcBody, frameConMethod);
        this.wsTool = new HjWSTool((Body)scBody);
        this.handleSlowBody(frameClass, origMethod, scBody, frameConMethod, habBox);
        return fcMethod;
    }

    protected void handleFastBody(SootClass frameClass, SootMethod fcMethod, Local fcWorkerLocal, Local fcFrameLocal, JimpleBody fcBody, SootMethod frameConMethod) {
        fcBody.getUnits().remove((Object)fcBody.getUnits().getFirst());
        fcBody.getUnits().remove((Object)fcBody.getFirstNonIdentityStmt());
        fcBody.getUnits().remove((Object)fcBody.getFirstNonIdentityStmt());
        Stmt tempLabel = (Stmt)fcBody.getUnits().getPredOf((Unit)fcBody.getFirstNonIdentityStmt());
        AssignStmt assignStmt = Jimple.v().newAssignStmt((Value)fcFrameLocal, (Value)Jimple.v().newNewExpr(frameClass.getType()));
        fcBody.getUnits().insertAfter((Unit)assignStmt, (Unit)tempLabel);
        tempLabel = assignStmt;
        ArrayList<Local> fcParamList = new ArrayList<Local>();
        if (!fcMethod.isStatic()) {
            fcParamList.add(fcBody.getThisLocal());
        }
        for (int i = 1; i < fcMethod.getParameterCount(); ++i) {
            fcParamList.add(fcBody.getParameterLocal(i));
        }
        InvokeStmt frameInitStmt = Jimple.v().newInvokeStmt((Value)Jimple.v().newSpecialInvokeExpr(fcFrameLocal, frameConMethod.makeRef(), fcParamList));
        fcBody.getUnits().insertAfter((Unit)frameInitStmt, (Unit)tempLabel);
        tempLabel = frameInitStmt;
        InvokeStmt virtualInvoke = Jimple.v().newInvokeStmt((Value)Jimple.v().newVirtualInvokeExpr(fcWorkerLocal, this.habWFWorkerBeginMethod.makeRef(), (Value)fcFrameLocal));
        fcBody.getUnits().insertAfter((Unit)virtualInvoke, (Unit)tempLabel);
        tempLabel = virtualInvoke;
        Iterator unitIter = fcBody.getUnits().snapshotIterator();
        while (unitIter.hasNext()) {
            Stmt stmt = (Stmt)unitIter.next();
            if (stmt instanceof ReturnVoidStmt || stmt instanceof ReturnStmt) {
                InvokeStmt endFastStmt = Jimple.v().newInvokeStmt((Value)Jimple.v().newVirtualInvokeExpr(fcWorkerLocal, this.habWFWorkerEndMethodFast.makeRef()));
                fcBody.getUnits().insertBefore((Unit)endFastStmt, (Unit)stmt);
                continue;
            }
            if (stmt instanceof RegionStmt) {
                if (((RegionStmt)stmt).getRegionExpr() instanceof ReturnRegionExpr) {
                    fcBody.getUnits().swapWith((Unit)stmt, (Unit)Jimple.v().newReturnVoidStmt());
                    continue;
                }
                if (!(((RegionStmt)stmt).getRegionExpr() instanceof RegionExit)) continue;
                int currentPC = ((RegionStmt)stmt).getScratch();
                this.genStopFinishFast(frameClass, stmt, fcWorkerLocal, fcFrameLocal, fcBody, currentPC);
                fcBody.getUnits().remove((Object)stmt);
                continue;
            }
            if (!(stmt instanceof AssignStmt) || !(((AssignStmt)stmt).getRightOp() instanceof HjDistHere)) continue;
            Value retValue = ((AssignStmt)stmt).getLeftOp();
            fcBody.getUnits().insertBefore((Unit)Jimple.v().newAssignStmt(retValue, (Value)Jimple.v().newVirtualInvokeExpr(fcWorkerLocal, this.habHFWorker.getMethodByName("place").makeRef(), Collections.EMPTY_LIST)), (Unit)stmt);
            fcBody.getUnits().remove((Object)stmt);
        }
    }

    protected void handleSlowBody(SootClass frameClass, SootMethod origMethod, JimpleBody scBody, SootMethod frameConMethod, HabAttrBox habBox) {
        SootMethod scMethod = this.createSCMethod(origMethod, (Body)scBody);
        habBox.setSlowClone(scMethod);
        LocalGenerator scLg = SootFactory.v().getLocalGenerator((Body)scBody);
        Stmt scSpecLabel = (Stmt)scBody.getUnits().getFirst();
        Local scWorkerLocal = (Local)((AssignStmt)scSpecLabel).getRightOp();
        Local scFrameLocal = (Local)((AssignStmt)scSpecLabel).getLeftOp();
        scBody.getUnits().remove((Object)scSpecLabel);
        habBox.setSCWorker(scWorkerLocal);
        habBox.setSCFrame(scFrameLocal);
        this.removeIdentityStmt(scBody, 0);
        Iterator unitIter = scBody.getUnits().snapshotIterator();
        while (unitIter.hasNext()) {
            Stmt stmt = (Stmt)unitIter.next();
            if (stmt instanceof ReturnVoidStmt) {
                Stmt tempLabel = (Stmt)scBody.getUnits().getPredOf((Unit)stmt);
                InvokeStmt endSlowStmt = Jimple.v().newInvokeStmt((Value)Jimple.v().newVirtualInvokeExpr(scWorkerLocal, this.habWFWorkerEndMethodSlow.makeRef()));
                scBody.getUnits().insertAfter((Unit)endSlowStmt, (Unit)tempLabel);
                continue;
            }
            if (stmt instanceof ReturnStmt) {
                Stmt tempLabel = (Stmt)scBody.getUnits().getPredOf((Unit)stmt);
                Value retValue = ((ReturnStmt)stmt).getOp();
                Stmt objStmt = this.genReturnObject(origMethod.getReturnType(), retValue, scLg);
                if (objStmt != null) {
                    scBody.getUnits().insertAfter((Unit)objStmt, (Unit)tempLabel);
                    tempLabel = objStmt;
                    retValue = (Local)((AssignStmt)objStmt).getLeftOp();
                }
                InvokeStmt endSlowStmt = Jimple.v().newInvokeStmt((Value)Jimple.v().newVirtualInvokeExpr(scWorkerLocal, this.habWFWorkerEndMethodSlowObject.makeRef(), retValue));
                scBody.getUnits().insertAfter((Unit)endSlowStmt, (Unit)tempLabel);
                ReturnVoidStmt retVoidStmt = Jimple.v().newReturnVoidStmt();
                scBody.getUnits().swapWith((Unit)stmt, (Unit)retVoidStmt);
                continue;
            }
            if (stmt instanceof RegionStmt) {
                if (((RegionStmt)stmt).getRegionExpr() instanceof ReturnRegionExpr) {
                    scBody.getUnits().swapWith((Unit)stmt, (Unit)Jimple.v().newReturnVoidStmt());
                    continue;
                }
                if (!(((RegionStmt)stmt).getRegionExpr() instanceof RegionExit)) continue;
                int currentPC = ((RegionStmt)stmt).getScratch();
                Stmt contLabel = (Stmt)scBody.getUnits().getSuccOf((Unit)stmt);
                this.genStopFinishSlow(stmt, contLabel, frameClass, scFrameLocal, scWorkerLocal, scLg, scBody, currentPC);
                scBody.getUnits().remove((Object)stmt);
                continue;
            }
            if (!(stmt instanceof AssignStmt) || !(((AssignStmt)stmt).getRightOp() instanceof HjDistHere)) continue;
            Value retValue = ((AssignStmt)stmt).getLeftOp();
            scBody.getUnits().insertBefore((Unit)Jimple.v().newAssignStmt(retValue, (Value)Jimple.v().newVirtualInvokeExpr(scWorkerLocal, this.habHFWorker.getMethodByName("place").makeRef(), Collections.EMPTY_LIST)), (Unit)stmt);
            scBody.getUnits().remove((Object)stmt);
        }
        Stmt tempLabel = scBody.getFirstNonIdentityStmt();
        Local tempFrameLocal = scLg.generateLocal((Type)this.habWFFrame.getType());
        IdentityStmt identityStmt = Jimple.v().newIdentityStmt((Value)tempFrameLocal, (Value)Jimple.v().newParameterRef((Type)this.habWFFrame.getType(), 1));
        scBody.getUnits().insertBefore((Unit)identityStmt, (Unit)tempLabel);
        AssignStmt assignStmt = Jimple.v().newAssignStmt((Value)scFrameLocal, (Value)Jimple.v().newCastExpr((Value)tempFrameLocal, (Type)frameClass.getType()));
        scBody.getUnits().insertBefore((Unit)assignStmt, (Unit)tempLabel);
        for (Local local : scBody.getLocals()) {
            if (!frameClass.declaresField(local.getName(), local.getType())) continue;
            SootField field = frameClass.getField(local.getName(), local.getType());
            assignStmt = Jimple.v().newAssignStmt((Value)local, (Value)Jimple.v().newInstanceFieldRef((Value)scFrameLocal, field.makeRef()));
            scBody.getUnits().insertBefore((Unit)assignStmt, (Unit)tempLabel);
        }
    }

    protected boolean hasInnerCont(RSTNode rstNode) {
        for (RSTNode subNode : rstNode.getSubNodes()) {
            if (subNode.isAsyncNode()) {
                return true;
            }
            if (subNode.isMethodNode() && methodNameMap.containsKey(subNode.getNodeMethod().toString())) {
                return true;
            }
            if (!this.hasInnerCont(subNode)) continue;
            return true;
        }
        return false;
    }

    protected boolean hasInnerMethodCont(RSTNode rstNode) {
        for (RSTNode subNode : rstNode.getSubNodes()) {
            if (subNode.isMethodNode() && methodNameMap.containsKey(subNode.getNodeMethod().toString())) {
                return true;
            }
            if (!this.hasInnerMethodCont(subNode)) continue;
            return true;
        }
        return false;
    }

    protected int handleMethodBody(RSTNode rstNode, SootClass frameClass, SootMethod fcMethod, SootMethod frameConMethod, JimpleBody fcBody, Local fcWorkerLocal, Local fcFrameLocal, LocalGenerator fcLg, Map contMethodMap, HabAttrBox habBox, ArrayList<Stmt> contList, int currentPC, boolean isNestedFrame) {
        for (RSTNode subNode : rstNode.getSubNodes()) {
            NopStmt contLabel;
            if (subNode.isAsyncNode()) {
                RegionStmt asyncEntryStmt = subNode.getRegionStmt();
                Stmt asyncExitStmt = asyncEntryStmt.getConnect();
                Local newFrameLocal = null;
                if (this.hasInnerCont(subNode)) {
                    newFrameLocal = fcLg.generateLocal((Type)frameClass.getType());
                    AssignStmt assignStmt = Jimple.v().newAssignStmt((Value)newFrameLocal, (Value)Jimple.v().newNewExpr(frameClass.getType()));
                    fcBody.getUnits().insertAfter((Unit)assignStmt, (Unit)asyncEntryStmt);
                    SootField frameField = new SootField(newFrameLocal.getName(), newFrameLocal.getType());
                    frameClass.addField(frameField);
                    ArrayList<Local> fcParamList = new ArrayList<Local>();
                    if (!fcMethod.isStatic()) {
                        fcParamList.add(fcBody.getThisLocal());
                    }
                    for (int i = 1; i < fcMethod.getParameterCount(); ++i) {
                        fcParamList.add(fcBody.getParameterLocal(i));
                    }
                    InvokeStmt frameInitStmt = Jimple.v().newInvokeStmt((Value)Jimple.v().newSpecialInvokeExpr(newFrameLocal, frameConMethod.makeRef(), fcParamList));
                    fcBody.getUnits().insertAfter((Unit)frameInitStmt, (Unit)assignStmt);
                    if (!this.hasInnerMethodCont(subNode)) {
                        InvokeStmt virtualInvoke = Jimple.v().newInvokeStmt((Value)Jimple.v().newVirtualInvokeExpr(fcWorkerLocal, this.habWFWorkerBeginMethod.makeRef(), (Value)newFrameLocal));
                        fcBody.getUnits().insertAfter((Unit)virtualInvoke, (Unit)frameInitStmt);
                        virtualInvoke = Jimple.v().newInvokeStmt((Value)Jimple.v().newVirtualInvokeExpr(fcWorkerLocal, this.habWFWorkerEndMethodFast.makeRef(), Collections.EMPTY_LIST));
                        fcBody.getUnits().insertBefore((Unit)virtualInvoke, (Unit)asyncExitStmt);
                    }
                }
                Local tempLocal = fcFrameLocal;
                if (newFrameLocal != null) {
                    fcFrameLocal = newFrameLocal;
                    this.frameLocalSet.add(newFrameLocal);
                }
                currentPC = this.handleMethodBody(subNode, frameClass, fcMethod, frameConMethod, fcBody, fcWorkerLocal, fcFrameLocal, fcLg, contMethodMap, habBox, contList, currentPC, newFrameLocal != null);
                if (newFrameLocal != null) {
                    this.frameLocalSet.remove(newFrameLocal);
                }
                fcFrameLocal = tempLocal;
                RegionStmt tempLabel = asyncEntryStmt;
                for (Local local : fcBody.getLocals()) {
                    if ((!frameClass.declaresField(local.getName(), local.getType()) || !this.wsTool.shouldSave((Stmt)tempLabel, local)) && !this.frameLocalSet.contains(local)) continue;
                    SootField field = frameClass.getField(local.getName(), local.getType());
                    AssignStmt assignStmt = Jimple.v().newAssignStmt((Value)Jimple.v().newInstanceFieldRef((Value)fcFrameLocal, field.makeRef()), (Value)local);
                    fcBody.getUnits().insertBefore((Unit)assignStmt, (Unit)tempLabel);
                }
                AssignStmt updatePCStmt = Jimple.v().newAssignStmt((Value)Jimple.v().newInstanceFieldRef((Value)fcFrameLocal, this.habWFFramePC.makeRef()), (Value)IntConstant.v((int)currentPC));
                fcBody.getUnits().insertBefore((Unit)updatePCStmt, (Unit)tempLabel);
                InvokeStmt pushFrameStmt = Jimple.v().newInvokeStmt((Value)Jimple.v().newVirtualInvokeExpr(fcWorkerLocal, this.habWFWorkerPushFrame.makeRef()));
                fcBody.getUnits().insertBefore((Unit)pushFrameStmt, (Unit)tempLabel);
                fcBody.getUnits().remove((Object)asyncEntryStmt);
                tempLabel = asyncExitStmt;
                NopStmt contLabel2 = Jimple.v().newNopStmt();
                InvokeStmt popFrameStmt = Jimple.v().newInvokeStmt((Value)Jimple.v().newVirtualInvokeExpr(fcWorkerLocal, this.habWFWorkerPopFrameOrAbort.makeRef()));
                fcBody.getUnits().insertBefore((Unit)popFrameStmt, (Unit)tempLabel);
                fcBody.getUnits().insertBefore((Unit)contLabel2, (Unit)tempLabel);
                fcBody.getUnits().remove((Object)asyncExitStmt);
                contList.add((Stmt)contLabel2);
                ++currentPC;
                continue;
            }
            if (subNode.isFinishNode()) {
                RegionStmt finishEntryStmt = subNode.getRegionStmt();
                RegionStmt finishExitStmt = (RegionStmt)finishEntryStmt.getConnect();
                currentPC = this.handleMethodBody(subNode, frameClass, fcMethod, frameConMethod, fcBody, fcWorkerLocal, fcFrameLocal, fcLg, contMethodMap, habBox, contList, currentPC, false);
                FinishRegionExpr finishRegion = (FinishRegionExpr)finishEntryStmt.getRegionExpr();
                VirtualInvokeExpr startFinishExpr = null;
                List<Value> accumulators = finishRegion.getAccumulators();
                startFinishExpr = accumulators != null ? Jimple.v().newVirtualInvokeExpr(fcWorkerLocal, this.habWFWorkerStartFinishAccums.makeRef(), (Value)this.createListStmts(accumulators, (Body)fcBody, fcLg, (Stmt)finishEntryStmt)) : Jimple.v().newVirtualInvokeExpr(fcWorkerLocal, this.habWFWorkerStartFinish.makeRef());
                InvokeStmt invokeStmt = Jimple.v().newInvokeStmt((Value)startFinishExpr);
                fcBody.getUnits().insertBefore((Unit)invokeStmt, (Unit)finishEntryStmt);
                fcBody.getUnits().remove((Object)finishEntryStmt);
                contLabel = Jimple.v().newNopStmt();
                fcBody.getUnits().insertAfter((Unit)contLabel, (Unit)finishExitStmt);
                contList.add((Stmt)contLabel);
                finishExitStmt.setScratch(currentPC);
                ++currentPC;
                continue;
            }
            if (subNode.isMethodNode()) {
                ValueBox valueBox;
                Stmt invokeStmt;
                Stmt tempLabel = invokeStmt = subNode.getNodeStmt();
                if (invokeStmt instanceof InvokeStmt) {
                    valueBox = ((InvokeStmt)invokeStmt).getInvokeExprBox();
                } else if (invokeStmt instanceof AssignStmt) {
                    valueBox = ((AssignStmt)invokeStmt).getRightOpBox();
                } else {
                    throw new RuntimeException("Unsupport invoke stmt: " + invokeStmt.getClass().getName());
                }
                InvokeExpr invokeExpr = (InvokeExpr)valueBox.getValue();
                if ((invokeExpr = this.handleInvoke(invokeExpr, fcWorkerLocal, contMethodMap)) == null) continue;
                valueBox.setValue((Value)invokeExpr);
                for (Local local : fcBody.getLocals()) {
                    if (!frameClass.declaresField(local.getName(), local.getType()) || !this.wsTool.shouldSave(tempLabel, local)) continue;
                    SootField field = frameClass.getField(local.getName(), local.getType());
                    AssignStmt assignStmt = Jimple.v().newAssignStmt((Value)Jimple.v().newInstanceFieldRef((Value)fcFrameLocal, field.makeRef()), (Value)local);
                    fcBody.getUnits().insertBefore((Unit)assignStmt, (Unit)tempLabel);
                }
                AssignStmt pcUpdateStmt = Jimple.v().newAssignStmt((Value)Jimple.v().newInstanceFieldRef((Value)fcFrameLocal, this.habWFFramePC.makeRef()), (Value)IntConstant.v((int)currentPC));
                fcBody.getUnits().insertBefore((Unit)pcUpdateStmt, (Unit)tempLabel);
                contLabel = Jimple.v().newNopStmt();
                fcBody.getUnits().insertAfter((Unit)contLabel, (Unit)invokeStmt);
                contList.add((Stmt)contLabel);
                if (invokeStmt instanceof AssignStmt) {
                    habBox.addCallCont((Stmt)contLabel, invokeStmt);
                }
                ++currentPC;
                continue;
            }
            if (!subNode.isIsolatedNode()) continue;
            this.buildIsolatedRegion((Body)fcBody, subNode, fcLg);
            currentPC = this.handleMethodBody(subNode, frameClass, fcMethod, frameConMethod, fcBody, fcWorkerLocal, fcFrameLocal, fcLg, contMethodMap, habBox, contList, currentPC, false);
        }
        return currentPC;
    }

    protected Stmt genStopFinishFast(SootClass frameClass, Stmt regionExitStmt, Local fcWorkerLocal, Local fcFrameLocal, JimpleBody fcBody, int currentPC) {
        Stmt tempLabel = regionExitStmt;
        for (Local local : fcBody.getLocals()) {
            if (!frameClass.declaresField(local.getName(), local.getType()) || !this.wsTool.shouldSave(tempLabel, local)) continue;
            SootField field = frameClass.getField(local.getName(), local.getType());
            AssignStmt assignStmt = Jimple.v().newAssignStmt((Value)Jimple.v().newInstanceFieldRef((Value)fcFrameLocal, field.makeRef()), (Value)local);
            fcBody.getUnits().insertBefore((Unit)assignStmt, (Unit)tempLabel);
        }
        AssignStmt pcUpdateStmt = Jimple.v().newAssignStmt((Value)Jimple.v().newInstanceFieldRef((Value)fcFrameLocal, this.habWFFramePC.makeRef()), (Value)IntConstant.v((int)currentPC));
        fcBody.getUnits().insertBefore((Unit)pcUpdateStmt, (Unit)tempLabel);
        InvokeStmt stopFinishStmt = Jimple.v().newInvokeStmt((Value)Jimple.v().newVirtualInvokeExpr(fcWorkerLocal, this.habWFWorkerStopFinishFast.makeRef()));
        fcBody.getUnits().insertBefore((Unit)stopFinishStmt, (Unit)tempLabel);
        return stopFinishStmt;
    }

    protected Stmt genStopFinishSlow(Stmt regionExitStmt, Stmt contLabel, SootClass frameClass, Local scFrameLocal, Local scWorkerLocal, LocalGenerator scLg, JimpleBody scBody, int currentPC) {
        Stmt tempLabel = regionExitStmt;
        for (Local local : scBody.getLocals()) {
            if (!frameClass.declaresField(local.getName(), local.getType()) || !this.wsTool.shouldSave(tempLabel, local)) continue;
            SootField field = frameClass.getField(local.getName(), local.getType());
            AssignStmt assignStmt = Jimple.v().newAssignStmt((Value)Jimple.v().newInstanceFieldRef((Value)scFrameLocal, field.makeRef()), (Value)local);
            scBody.getUnits().insertBefore((Unit)assignStmt, (Unit)tempLabel);
        }
        AssignStmt pcUpdateStmt = Jimple.v().newAssignStmt((Value)Jimple.v().newInstanceFieldRef((Value)scFrameLocal, this.habWFFramePC.makeRef()), (Value)IntConstant.v((int)currentPC));
        scBody.getUnits().insertBefore((Unit)pcUpdateStmt, (Unit)tempLabel);
        Local checkLocal = scLg.generateLocal((Type)BooleanType.v());
        AssignStmt stopFinishStmt = Jimple.v().newAssignStmt((Value)checkLocal, (Value)Jimple.v().newVirtualInvokeExpr(scWorkerLocal, this.habWFWorkerStopFinishSlow.makeRef()));
        scBody.getUnits().insertBefore((Unit)stopFinishStmt, (Unit)tempLabel);
        IfStmt ifStmt = Jimple.v().newIfStmt((Value)Jimple.v().newEqExpr((Value)checkLocal, (Value)IntConstant.v((int)1)), (Unit)contLabel);
        scBody.getUnits().insertBefore((Unit)ifStmt, (Unit)tempLabel);
        scBody.getUnits().insertBefore((Unit)Jimple.v().newReturnVoidStmt(), (Unit)tempLabel);
        return contLabel;
    }

    @Override
    protected InvokeExpr handleInvoke(InvokeExpr invokeExpr, Local workerLocal, Map contMethodMap) {
        SootMethodRef methodRef = invokeExpr.getMethodRef();
        HabAttrBox habBox = null;
        SootMethod origMethod = (SootMethod)methodNameMap.get(methodRef.resolve().toString());
        if (origMethod != null) {
            habBox = (HabAttrBox)contMethodMap.get(origMethod);
        }
        if (habBox == null) {
            return null;
        }
        SootMethod method = habBox.getFastClone();
        ArrayList<Local> params = new ArrayList<Local>();
        params.add(workerLocal);
        params.addAll(invokeExpr.getArgs());
        if (invokeExpr instanceof InstanceInvokeExpr) {
            Local baseLocal = (Local)((InstanceInvokeExpr)invokeExpr).getBase();
            if (invokeExpr instanceof VirtualInvokeExpr) {
                return Jimple.v().newVirtualInvokeExpr(baseLocal, method.makeRef(), params);
            }
            if (invokeExpr instanceof InterfaceInvokeExpr) {
                return Jimple.v().newInterfaceInvokeExpr(baseLocal, method.makeRef(), params);
            }
            if (invokeExpr instanceof SpecialInvokeExpr) {
                return Jimple.v().newSpecialInvokeExpr(baseLocal, method.makeRef(), params);
            }
            throw new RuntimeException("Unsupport invoke: " + invokeExpr.getClass().getName());
        }
        if (invokeExpr instanceof StaticInvokeExpr) {
            return Jimple.v().newStaticInvokeExpr(method.makeRef(), params);
        }
        throw new RuntimeException("Unsupport invoke: " + invokeExpr.getClass().getName());
    }

    @Override
    protected SootMethod buildSetReturn(SootClass frameClass, Map local2FieldMap, HabAttrBox habBox) {
        List<Stmt> contList = habBox.getContList();
        SootMethod setRetMethod = new SootMethod("setReturnResult", Arrays.asList(this.javaLangObject.getType()), (Type)VoidType.v(), 1);
        frameClass.addMethod(setRetMethod);
        JimpleBody setRetBody = Jimple.v().newBody(setRetMethod);
        setRetMethod.setActiveBody((Body)setRetBody);
        LocalGenerator lg = SootFactory.v().getLocalGenerator((Body)setRetBody);
        Local thisLocal = lg.generateLocal((Type)frameClass.getType());
        setRetBody.getUnits().add((Unit)Jimple.v().newIdentityStmt((Value)thisLocal, (Value)Jimple.v().newThisRef(frameClass.getType())));
        Local retObjLocal = lg.generateLocal((Type)this.javaLangObject.getType());
        setRetBody.getUnits().add((Unit)Jimple.v().newIdentityStmt((Value)retObjLocal, (Value)Jimple.v().newParameterRef((Type)this.javaLangObject.getType(), 0)));
        ArrayList<Object> targetList = new ArrayList<Object>();
        for (int i = 0; i < contList.size(); ++i) {
            Stmt contStmt = contList.get(i);
            Stmt callContStmt = habBox.getCallCont(contStmt);
            if (callContStmt != null) {
                Local retLocal = (Local)((AssignStmt)callContStmt).getLeftOp();
                SootField retField = (SootField)local2FieldMap.get(retLocal);
                if (retField == null) {
                    throw new RuntimeException("Can't find corresponding frame class field for local: " + retLocal);
                }
                Stmt targetStmt = this.createAssign(retLocal.getType(), lg, retObjLocal, (Body)setRetBody, thisLocal, retField);
                targetList.add(targetStmt);
                setRetBody.getUnits().add((Unit)Jimple.v().newReturnVoidStmt());
                continue;
            }
            ReturnVoidStmt retStmt = Jimple.v().newReturnVoidStmt();
            setRetBody.getUnits().add((Unit)retStmt);
            targetList.add(retStmt);
        }
        ReturnVoidStmt retStmt = Jimple.v().newReturnVoidStmt();
        setRetBody.getUnits().add((Unit)retStmt);
        Stmt tempLabel = (Stmt)setRetBody.getUnits().getPredOf((Unit)setRetBody.getFirstNonIdentityStmt());
        Local pcLocal = lg.generateLocal((Type)IntType.v());
        AssignStmt assignStmt = Jimple.v().newAssignStmt((Value)pcLocal, (Value)Jimple.v().newInstanceFieldRef((Value)thisLocal, this.habWFFramePC.makeRef()));
        setRetBody.getUnits().insertAfter((Unit)assignStmt, (Unit)tempLabel);
        tempLabel = assignStmt;
        if (targetList.size() == 0) {
            return setRetMethod;
        }
        TableSwitchStmt switchStmt = Jimple.v().newTableSwitchStmt((Value)pcLocal, 0, targetList.size() - 1, targetList, (Unit)retStmt);
        setRetBody.getUnits().insertAfter((Unit)switchStmt, (Unit)tempLabel);
        return setRetMethod;
    }

    @Override
    protected void genFrameClassFields(SootMethod origMethod, SootClass frameClass, Map local2FieldMap, Map field2LocalMap) {
        Body methodBody = origMethod.retrieveActiveBody();
        for (Local local : methodBody.getLocals()) {
            if (!this.isLocalNeededInFrame(local) || !origMethod.isStatic() && methodBody.getThisLocal() == local) continue;
            SootField field = new SootField(local.getName(), local.getType());
            frameClass.addField(field);
            local2FieldMap.put(local, field);
            field2LocalMap.put(field, local);
        }
        for (Stmt stmt : methodBody.getUnits()) {
            Local retLocal;
            InvokeExpr invokeExpr;
            if (!(stmt instanceof AssignStmt) || !stmt.containsInvokeExpr() || (invokeExpr = stmt.getInvokeExpr()) instanceof HjDistHere || !methodNameMap.containsKey(invokeExpr.getMethodRef().resolve().toString()) || local2FieldMap.containsKey(retLocal = (Local)((AssignStmt)stmt).getLeftOp())) continue;
            SootField field = new SootField(retLocal.getName(), retLocal.getType());
            frameClass.addField(field);
            local2FieldMap.put(retLocal, field);
            field2LocalMap.put(field, retLocal);
        }
    }

    @Override
    public SootClass buildFrameClass(SootMethod origMethod, Map contMethodMap, HabAttrBox habBox, Map local2FieldMap, Map field2LocalMap) {
        SootClass declClass = origMethod.getDeclaringClass();
        SootMethod fcMethod = habBox.getFastClone();
        String frameClassName = declClass.getName() + "$" + origMethod.getName() + "frame";
        while (this.frameClassNameSet.contains(frameClassName)) {
            frameClassName = frameClassName + "_";
        }
        this.frameClassNameSet.add(frameClassName);
        SootClass frameClass = new SootClass(frameClassName, fcMethod.getModifiers());
        this.wsTool = new HjWSTool(origMethod.getActiveBody());
        frameClass.setOuterClass(declClass);
        frameClass.setSuperclass(this.habWFFrame);
        Scene.v().addClass(frameClass);
        frameClass.setApplicationClass();
        this.genFrameClassFields(origMethod, frameClass, local2FieldMap, field2LocalMap);
        SootField frameThisOuter = null;
        if (!origMethod.isStatic()) {
            frameThisOuter = new SootField("this$0", (Type)declClass.getType());
        }
        SootMethod frameConMethod = this.buildFrameConSC(frameClass, declClass, fcMethod, origMethod, frameThisOuter, habBox, local2FieldMap);
        habBox.setFrameCon(frameConMethod);
        this.genFastClone(origMethod, frameClass, frameConMethod, contMethodMap, habBox);
        SootMethod frameExecMethod = this.buildFrameExecSlow(frameClass, declClass, fcMethod, habBox.getSlowClone(), frameThisOuter);
        this.buildSetReturn(frameClass, local2FieldMap, habBox);
        return frameClass;
    }

    @Override
    public SootMethod buildFrameConSC(SootClass frameClass, SootClass declClass, SootMethod fcMethod, SootMethod origMethod, SootField frameThisOuter, HabAttrBox habBox, Map local2FieldMap) {
        ArrayList<RefType> paramTypeList = new ArrayList<RefType>();
        if (!origMethod.isStatic()) {
            paramTypeList.add(0, declClass.getType());
        }
        if (!habBox.isExecMethod()) {
            paramTypeList.addAll(origMethod.getParameterTypes());
        }
        SootMethod frameCon = new SootMethod("<init>", paramTypeList, (Type)VoidType.v(), 1);
        frameClass.addMethod(frameCon);
        JimpleBody conBody = Jimple.v().newBody(frameCon);
        frameCon.setActiveBody((Body)conBody);
        LocalGenerator lg = SootFactory.v().getLocalGenerator((Body)conBody);
        Local conThisLocal = lg.generateLocal("this", (Type)frameClass.getType());
        conBody.getUnits().add((Unit)Jimple.v().newIdentityStmt((Value)conThisLocal, (Value)Jimple.v().newThisRef(frameClass.getType())));
        SootMethod superConMethod = frameClass.getSuperclass().getMethodByName("<init>");
        InvokeStmt superConStmt = Jimple.v().newInvokeStmt((Value)Jimple.v().newSpecialInvokeExpr(conThisLocal, superConMethod.makeRef()));
        conBody.getUnits().add((Unit)superConStmt);
        int paramCounter = 0;
        InvokeStmt tempLabel = superConStmt;
        if (!origMethod.isStatic()) {
            frameClass.addField(frameThisOuter);
            Local outerThisLocal = lg.generateLocal((Type)declClass.getType());
            IdentityStmt identityStmt = Jimple.v().newIdentityStmt((Value)outerThisLocal, (Value)Jimple.v().newParameterRef((Type)declClass.getType(), paramCounter++));
            conBody.getUnits().insertBefore((Unit)identityStmt, (Unit)tempLabel);
            AssignStmt assignStmt = Jimple.v().newAssignStmt((Value)Jimple.v().newInstanceFieldRef((Value)conThisLocal, frameThisOuter.makeRef()), (Value)outerThisLocal);
            conBody.getUnits().insertAfter((Unit)assignStmt, (Unit)tempLabel);
        }
        if (!habBox.isExecMethod()) {
            for (int i = 0; i < origMethod.getParameterCount(); ++i) {
                Local paramLocal = origMethod.getActiveBody().getParameterLocal(i + 1);
                SootField paramField = (SootField)local2FieldMap.get(paramLocal);
                Local conParamLocal = lg.generateLocal(paramLocal.getType());
                IdentityStmt identityStmt = Jimple.v().newIdentityStmt((Value)conParamLocal, (Value)Jimple.v().newParameterRef(paramLocal.getType(), paramCounter++));
                conBody.getUnits().insertBefore((Unit)identityStmt, (Unit)tempLabel);
                AssignStmt assignStmt = Jimple.v().newAssignStmt((Value)Jimple.v().newInstanceFieldRef((Value)conThisLocal, paramField.makeRef()), (Value)conParamLocal);
                conBody.getUnits().insertAfter((Unit)assignStmt, (Unit)tempLabel);
            }
        }
        conBody.getUnits().add((Unit)Jimple.v().newReturnVoidStmt());
        return frameCon;
    }

    @Override
    public SootMethod buildFrameExecSlow(SootClass frameClass, SootClass declClass, SootMethod fcMethod, SootMethod scMethod, SootField frameThisOuter) {
        SootMethod frameExecSlow = new SootMethod("execute", Arrays.asList(this.habWFWorker.getType()), (Type)VoidType.v(), 1);
        frameClass.addMethod(frameExecSlow);
        JimpleBody execBody = Jimple.v().newBody(frameExecSlow);
        frameExecSlow.setActiveBody((Body)execBody);
        frameExecSlow.addException(this.habWFFrameStolenException);
        LocalGenerator lg = SootFactory.v().getLocalGenerator((Body)execBody);
        Local execThis = Jimple.v().newLocal("this", (Type)frameClass.getType());
        execBody.getLocals().add((Object)execThis);
        execBody.getUnits().add((Unit)Jimple.v().newIdentityStmt((Value)execThis, (Value)Jimple.v().newThisRef(frameClass.getType())));
        Local worker = Jimple.v().newLocal("worker", (Type)this.habWFWorker.getType());
        execBody.getLocals().add((Object)worker);
        execBody.getUnits().add((Unit)Jimple.v().newIdentityStmt((Value)worker, (Value)Jimple.v().newParameterRef((Type)this.habWFWorker.getType(), 0)));
        if (fcMethod.isStatic()) {
            InvokeStmt invokeStmt = Jimple.v().newInvokeStmt((Value)Jimple.v().newStaticInvokeExpr(scMethod.makeRef(), (Value)worker, (Value)execBody.getThisLocal()));
            execBody.getUnits().add((Unit)invokeStmt);
        } else {
            Local outerObject = lg.generateLocal((Type)declClass.getType());
            AssignStmt assignStmt = Jimple.v().newAssignStmt((Value)outerObject, (Value)Jimple.v().newInstanceFieldRef((Value)execThis, frameThisOuter.makeRef()));
            execBody.getUnits().add((Unit)assignStmt);
            InvokeStmt invokeStmt = Jimple.v().newInvokeStmt((Value)Jimple.v().newVirtualInvokeExpr(outerObject, scMethod.makeRef(), (Value)worker, (Value)execThis));
            execBody.getUnits().add((Unit)invokeStmt);
        }
        execBody.getUnits().add((Unit)Jimple.v().newReturnVoidStmt());
        return frameExecSlow;
    }

    @Override
    public Local addLocalParamRefStmt(Body body, String name, Type paramType, int paramID) {
        Local newLocal = Jimple.v().newLocal(name, paramType);
        body.getLocals().add((Object)newLocal);
        Stmt thisStmt = null;
        if (body.getUnits().size() > 0) {
            thisStmt = (Stmt)body.getUnits().getFirst();
        }
        if (thisStmt != null && thisStmt instanceof IdentityStmt && ((IdentityStmt)thisStmt).getRightOp() instanceof ThisRef) {
            body.getUnits().insertAfter((Unit)Jimple.v().newIdentityStmt((Value)newLocal, (Value)Jimple.v().newParameterRef(paramType, paramID)), (Unit)thisStmt);
        } else {
            body.getUnits().addFirst((Unit)Jimple.v().newIdentityStmt((Value)newLocal, (Value)Jimple.v().newParameterRef(paramType, paramID)));
        }
        return newLocal;
    }

    @Override
    protected void incParamRef(SootMethod method) {
        Body body = method.getActiveBody();
        int paramCount = method.getParameterCount();
        Iterator unitIter = body.getUnits().iterator();
        while (paramCount > 0) {
            IdentityStmt identityStmt;
            Value value;
            assert (unitIter.hasNext());
            Stmt stmt = (Stmt)unitIter.next();
            if (!(stmt instanceof IdentityStmt) || !((value = (identityStmt = (IdentityStmt)stmt).getRightOp()) instanceof ParameterRef)) continue;
            ParameterRef paramRef = (ParameterRef)value;
            paramRef.setIndex(paramRef.getIndex() + 1);
            --paramCount;
        }
    }

    @Override
    protected void incParamRef(SootMethod method, int fromParam) {
        Body body = method.getActiveBody();
        for (Stmt stmt : body.getUnits()) {
            ParameterRef paramRef;
            IdentityStmt identityStmt;
            Value value;
            if (!(stmt instanceof IdentityStmt) || !((value = (identityStmt = (IdentityStmt)stmt).getRightOp()) instanceof ParameterRef) || (paramRef = (ParameterRef)value).getIndex() < fromParam) continue;
            paramRef.setIndex(paramRef.getIndex() + 1);
        }
    }

    @Override
    public boolean isUserSpecifiedLocal(Local local) {
        return local.getName().charAt(0) != '$';
    }

    @Override
    public boolean isThisParameter(Local local) {
        return local.getName().equals("this");
    }

    @Override
    public boolean isThrowableObject(Local local) {
        return local.getType().equals(RefType.v((String)"java.lang.Throwable"));
    }

    @Override
    public boolean isLocalNeededInFrame(Local local) {
        if (this.isThisParameter(local)) {
            return false;
        }
        if (this.isThrowableObject(local)) {
            return false;
        }
        return local.getType() != this.habWFWorker.getType();
    }

    @Override
    public Local addLocalAndParamRefStmt(Body body, String name, Type paramType, int paramNum) {
        Local newLocal = this.addLocal(body, name, paramType);
        this.addParamRefStmt(body, newLocal, paramType, paramNum);
        return newLocal;
    }

    @Override
    public Local addLocalAndThisRefStmt(Body body, String name, RefType rType) {
        Local thisLocal = this.addLocal(body, name, (Type)rType);
        this.addThisRefStmt(body, thisLocal, rType);
        return thisLocal;
    }

    @Override
    public Local addLocal(Body body, String name, Type type) {
        Local newLocal = Jimple.v().newLocal(name, type);
        body.getLocals().add((Object)newLocal);
        return newLocal;
    }

    @Override
    public void addParamRefStmt(Body body, Local leftOp, Type paramType, int paramNum) {
        Stmt thisStmt = null;
        if (body.getUnits().size() > 0) {
            thisStmt = (Stmt)body.getUnits().getFirst();
        }
        if (thisStmt != null && thisStmt instanceof IdentityStmt && ((IdentityStmt)thisStmt).getRightOp() instanceof ThisRef) {
            body.getUnits().insertAfter((Unit)Jimple.v().newIdentityStmt((Value)leftOp, (Value)Jimple.v().newParameterRef(paramType, paramNum)), (Unit)thisStmt);
        } else {
            body.getUnits().addFirst((Unit)Jimple.v().newIdentityStmt((Value)leftOp, (Value)Jimple.v().newParameterRef(paramType, paramNum)));
        }
    }

    @Override
    public void addThisRefStmt(Body body, Local leftOp, RefType rType) {
        body.getUnits().addFirst((Unit)Jimple.v().newIdentityStmt((Value)leftOp, (Value)Jimple.v().newThisRef(rType)));
    }
}

