/*
 * Decompiled with CFR 0.152.
 */
package soot.hj.HjToJimple.jimple;

import java.util.ArrayList;
import java.util.List;
import soot.Local;
import soot.Type;
import soot.Value;
import soot.ValueBox;
import soot.factory.LocalGenerator;
import soot.hj.HjToJimple.jimple.HjAbstractArrayOper;
import soot.hj.HjToJimple.jimple.HjArrayOper;
import soot.hj.HjToJimple.jimple.factory.HjMethodFactory;
import soot.hj.HjToJimple.jimple.utils.ArrayViewUtils;
import soot.hj.HjToJimple.util.HjValueBox;
import soot.hj.HjToJimple.util.Point;
import soot.jimple.AssignStmt;
import soot.jimple.InvokeExpr;
import soot.jimple.Jimple;
import soot.jimple.Stmt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HjArrayAccess
extends HjAbstractArrayOper
implements HjArrayOper {
    protected ValueBox arrayLocalBox;
    protected ValueBox arrayValueBox;
    protected Point point;
    protected boolean isOptimizable;

    public HjArrayAccess(Local arrayLocal, Point point) {
        this.arrayLocalBox = new HjValueBox((Value)arrayLocal);
        this.point = point;
    }

    public boolean isOptimizable() {
        return false;
    }

    public Local getArrayRef() {
        return (Local)this.arrayLocalBox.getValue();
    }

    public void setArrayRef(Local arrayLocal) {
        this.arrayLocalBox.setValue((Value)arrayLocal);
    }

    public Point getArrayIndex() {
        return this.point;
    }

    public void setArrayIndex(Point point) {
        this.point = point;
    }

    public Value getArrayValue() {
        if (this.arrayValueBox != null) {
            return this.arrayValueBox.getValue();
        }
        return null;
    }

    public void setArrayValue(Value value) {
        if (this.arrayValueBox != null) {
            this.arrayValueBox.setValue(value);
        } else {
            this.arrayValueBox = new HjValueBox(value);
        }
    }

    @Override
    public List getUseBoxes() {
        ArrayList<ValueBox> useBoxes = new ArrayList<ValueBox>();
        useBoxes.add(this.arrayLocalBox);
        useBoxes.addAll(this.point.getUseBoxes());
        if (this.arrayValueBox != null) {
            List valueBoxes = this.arrayValueBox.getValue().getUseBoxes();
            if (valueBoxes.size() != 0) {
                useBoxes.addAll(valueBoxes);
            } else {
                useBoxes.add(this.arrayValueBox);
            }
        }
        return useBoxes;
    }

    @Override
    public List<Stmt> generateStmts(LocalGenerator lg) {
        return this.genArraySet(lg);
    }

    @Override
    public List<Stmt> generateStmts(Value retValue, LocalGenerator lg) {
        return this.genArrayGet(retValue, lg);
    }

    public List<Stmt> genArrayGet(Value retValue, LocalGenerator lg) {
        Local arrayLocal;
        ArrayList<Stmt> stmts = new ArrayList<Stmt>();
        if (retValue == null) {
            return stmts;
        }
        Value arrayValue = this.arrayLocalBox.getValue();
        if (arrayValue instanceof Local) {
            arrayLocal = (Local)arrayValue;
        } else {
            arrayLocal = lg.generateLocal(arrayValue.getType());
            stmts.add((Stmt)Jimple.v().newAssignStmt((Value)arrayLocal, arrayValue));
        }
        if (!this.isOptimizable()) {
            InvokeExpr invokeExpr = HjMethodFactory.getArrayValueMth(arrayLocal, this.point);
            AssignStmt assignStmt = Jimple.v().newAssignStmt(retValue, (Value)invokeExpr);
            stmts.add((Stmt)assignStmt);
        }
        return stmts;
    }

    public List<Stmt> genArraySet(LocalGenerator lg) {
        Local valLocal;
        Local arrayLocal;
        ArrayList<Stmt> stmts = new ArrayList<Stmt>();
        Value arrayValue = this.arrayLocalBox.getValue();
        if (arrayValue instanceof Local) {
            arrayLocal = (Local)arrayValue;
        } else {
            arrayLocal = lg.generateLocal(arrayValue.getType());
            stmts.add((Stmt)Jimple.v().newAssignStmt((Value)arrayLocal, arrayValue));
        }
        arrayValue = this.arrayValueBox.getValue();
        if (arrayValue instanceof Local) {
            valLocal = (Local)arrayValue;
        } else {
            valLocal = lg.generateLocal(arrayValue.getType());
            stmts.add((Stmt)Jimple.v().newAssignStmt((Value)valLocal, arrayValue));
        }
        if (!this.isOptimizable()) {
            InvokeExpr invokeExpr = HjMethodFactory.setArrayValueMth(arrayLocal, valLocal, this.point, valLocal.getType());
            stmts.add((Stmt)Jimple.v().newInvokeStmt((Value)invokeExpr));
        }
        return stmts;
    }

    @Override
    public Object clone() {
        return new HjArrayAccess((Local)this.arrayLocalBox.getValue(), (Point)this.point.clone());
    }

    public Type getType() {
        Type runtimeViewType = this.arrayLocalBox.getValue().getType();
        return ArrayViewUtils.getHjArrayViewPrimitiveType(runtimeViewType);
    }

    @Override
    public String toString() {
        return "HjArrayAccess: " + this.arrayLocalBox.getValue() + "[" + this.point + "]";
    }
}

